"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(require("react"));
const useRange_1 = __importDefault(require("./hooks/useRange"));
const Track_1 = __importDefault(require("./components/Track"));
const Thumb_1 = __importDefault(require("./components/Thumb"));
const ResponderView_1 = __importDefault(require("./components/ResponderView"));
const useDrag_1 = __importDefault(require("./hooks/useDrag"));
const Marks_1 = __importDefault(require("./components/Marks"));
const RangeSlider = react_1.default.forwardRef((props, forwardedRef) => {
    const { minimumValue = 0, step = 0, minimumRange = step, maximumValue = minimumValue + minimumRange, range: propRange, outboundColor = 'grey', inboundColor = 'blue', thumbTintColor = 'darkcyan', thumbStyle, trackStyle, minTrackStyle, midTrackStyle, maxTrackStyle, inverted = false, vertical = false, enabled = true, slideOnTap = true, trackHeight = 4, thumbSize = 15, thumbImage, crossingAllowed = false, onValueChange, onSlidingStart, onSlidingComplete, CustomThumb, CustomTrack, StepMarker, ...others } = props;
    const [minProp, maxProp] = propRange || [];
    const propValue = react_1.default.useMemo(() => {
        var _a, _b;
        return [
            (_a = minProp !== null && minProp !== void 0 ? minProp : props.minimumValue) !== null && _a !== void 0 ? _a : 0,
            maxProp !== null && maxProp !== void 0 ? maxProp : Math.max((_b = props.maximumValue) !== null && _b !== void 0 ? _b : 1, (props.minimumValue || 0) + (props.minimumRange || props.step || 0))
        ];
    }, [maxProp, minProp, props.maximumValue, props.minimumRange, props.minimumValue, props.step]);
    const { updateClosestValue, updateMaxValue, updateMinValue, range, canMove } = (0, useRange_1.default)({
        minimumRange,
        minimumValue,
        maximumValue,
        range: propValue,
        step,
        slideOnTap,
        crossingAllowed,
        onValueChange
    });
    const [min, max] = range;
    const { onPress, onMove, onRelease } = (0, useDrag_1.default)({ value: range, updateValue: updateClosestValue, onSlidingComplete, onSlidingStart, canMove });
    const minTrackPct = react_1.default.useMemo(() => (min - minimumValue) / ((maximumValue - minimumValue) || 1), [min, minimumValue, maximumValue]);
    const maxTrackPct = react_1.default.useMemo(() => (max - minimumValue) / ((maximumValue - minimumValue) || 1), [max, minimumValue, maximumValue]);
    const [minStyle, midStyle, maxStyle] = react_1.default.useMemo(() => [minTrackStyle, midTrackStyle, maxTrackStyle].map(style => (style && trackStyle) ? [style, trackStyle] : (style || trackStyle)), [trackStyle, minTrackStyle, midTrackStyle, maxTrackStyle]);
    const thumbProps = {
        color: thumbTintColor,
        style: thumbStyle,
        size: thumbSize,
        CustomThumb: CustomThumb,
        thumbImage,
        minimumValue,
        maximumValue,
        step
    };
    const trackProps = {
        thickness: trackHeight,
        CustomTrack,
        vertical
    };
    const marksProps = { StepMarker, step, minimumValue, maximumValue, activeValue: range, inverted, vertical };
    return (react_1.default.createElement(ResponderView_1.default, { ...others, ref: forwardedRef, maximumValue: maximumValue, minimumValue: minimumValue, step: step, onPress: onPress, onMove: onMove, onRelease: onRelease, enabled: enabled, vertical: vertical, inverted: inverted },
        react_1.default.createElement(Track_1.default, { ...trackProps, color: outboundColor, style: minStyle, length: minTrackPct * 100, track: 'min' }),
        react_1.default.createElement(Thumb_1.default, { key: 'min', ...thumbProps, updateValue: updateMinValue, value: min, thumb: 'min' }),
        react_1.default.createElement(Track_1.default, { ...trackProps, color: inboundColor, style: midStyle, length: (maxTrackPct - minTrackPct) * 100, track: 'mid' }),
        react_1.default.createElement(Thumb_1.default, { key: 'max', ...thumbProps, updateValue: updateMaxValue, value: max, thumb: 'max' }),
        react_1.default.createElement(Track_1.default, { ...trackProps, color: outboundColor, style: maxStyle, length: (1 - maxTrackPct) * 100, track: 'max' }),
        react_1.default.createElement(Marks_1.default, { type: 'range', ...marksProps })));
});
RangeSlider.displayName = 'RangeSlider';
exports.default = react_1.default.memo(RangeSlider);
