import React from 'react';
import * as RN from 'react-native';
import { CustomMarkType } from './components/Marks';
export type RangeSliderProps = RN.ViewProps & {
    range?: [number, number];
    minimumValue?: number;
    maximumValue?: number;
    minimumRange?: number;
    step?: number;
    outboundColor?: RN.ColorValue;
    inboundColor?: RN.ColorValue;
    thumbTintColor?: RN.ColorValue;
    thumbStyle?: RN.StyleProp<RN.ViewStyle>;
    trackStyle?: RN.StyleProp<RN.ViewStyle>;
    minTrackStyle?: RN.StyleProp<RN.ViewStyle>;
    midTrackStyle?: RN.StyleProp<RN.ViewStyle>;
    maxTrackStyle?: RN.StyleProp<RN.ViewStyle>;
    style?: RN.StyleProp<RN.ViewStyle>;
    inverted?: boolean;
    vertical?: boolean;
    enabled?: boolean;
    slideOnTap?: boolean;
    trackHeight?: number;
    thumbSize?: number;
    thumbImage?: RN.ImageURISource;
    crossingAllowed?: boolean;
    onValueChange?: (range: [number, number]) => boolean | void;
    onSlidingStart?: (range: [number, number]) => void;
    onSlidingComplete?: (range: [number, number]) => void;
    CustomThumb?: React.ComponentType<{
        value: number;
        thumb: 'min' | 'max';
    }>;
    StepMarker?: CustomMarkType<'range'>;
    CustomTrack?: React.ComponentType<{
        length: number;
        thickness: number;
        vertical: boolean;
        track: 'min' | 'mid' | 'max';
        style: RN.StyleProp<RN.ViewStyle>;
        color: RN.ColorValue;
    }>;
};
declare const _default: React.MemoExoticComponent<React.ForwardRefExoticComponent<RN.ViewProps & {
    range?: [number, number];
    minimumValue?: number;
    maximumValue?: number;
    minimumRange?: number;
    step?: number;
    outboundColor?: RN.ColorValue;
    inboundColor?: RN.ColorValue;
    thumbTintColor?: RN.ColorValue;
    thumbStyle?: RN.StyleProp<RN.ViewStyle>;
    trackStyle?: RN.StyleProp<RN.ViewStyle>;
    minTrackStyle?: RN.StyleProp<RN.ViewStyle>;
    midTrackStyle?: RN.StyleProp<RN.ViewStyle>;
    maxTrackStyle?: RN.StyleProp<RN.ViewStyle>;
    style?: RN.StyleProp<RN.ViewStyle>;
    inverted?: boolean;
    vertical?: boolean;
    enabled?: boolean;
    slideOnTap?: boolean;
    trackHeight?: number;
    thumbSize?: number;
    thumbImage?: RN.ImageURISource;
    crossingAllowed?: boolean;
    onValueChange?: (range: [number, number]) => boolean | void;
    onSlidingStart?: (range: [number, number]) => void;
    onSlidingComplete?: (range: [number, number]) => void;
    CustomThumb?: React.ComponentType<{
        value: number;
        thumb: "min" | "max";
    }>;
    StepMarker?: CustomMarkType<"range">;
    CustomTrack?: React.ComponentType<{
        length: number;
        thickness: number;
        vertical: boolean;
        track: "min" | "mid" | "max";
        style: RN.StyleProp<RN.ViewStyle>;
        color: RN.ColorValue;
    }>;
} & React.RefAttributes<RN.View>>>;
export default _default;
