import { a as attr_class, s as store_get, u as unsubscribe_stores, e as ensure_array_like, b as stringify } from "../../../chunks/index2.js";
import "clsx";
import "@sveltejs/kit/internal";
import "../../../chunks/exports.js";
import "../../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
import "../../../chunks/state.svelte.js";
import { p as page } from "../../../chunks/index4.js";
import { w as writable } from "../../../chunks/index.js";
import { i as isAndroidNative, s as showRelayStatusModal, c as connectionStats, a as currentUser } from "../../../chunks/AndroidTapSound.js";
import { $ as $format } from "../../../chunks/index3.js";
import { B as Button, A as Avatar } from "../../../chunks/Avatar.js";
import { V as escape_html } from "../../../chunks/context.js";
import "../../../chunks/AndroidLocalSecretKey.js";
import "dexie";
import "@capacitor/local-notifications";
import "@capacitor/haptics";
import { h as html } from "../../../chunks/html.js";
const showSettingsModal = writable(false);
const showManageContactsModal = writable(false);
const showUserQrModal = writable(false);
const contacts = writable([]);
function ConnectionStatus($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const isAndroidApp = isAndroidNative();
    $$renderer2.push(`<div${attr_class(`absolute bottom-0 left-0 right-0 z-20 p-2 p-2-safe-bottom border-t border-gray-200/50 dark:border-slate-700/70 bg-white/80 dark:bg-slate-900/80 backdrop-blur-xl flex ${isAndroidApp ? "justify-end" : "justify-center"}`)}>`);
    Button($$renderer2, {
      onclick: () => showRelayStatusModal.set(true),
      variant: "outlined-chip",
      size: "sm",
      class: `gap-2 ${isAndroidApp ? "mr-2" : ""}`,
      children: ($$renderer3) => {
        $$renderer3.push(`<div${attr_class(`w-2 h-2 rounded-full ${store_get($$store_subs ??= {}, "$connectionStats", connectionStats).connected === 0 || store_get($$store_subs ??= {}, "$connectionStats", connectionStats).authFailedConnected > 0 ? "bg-red-500" : store_get($$store_subs ??= {}, "$connectionStats", connectionStats).authPendingConnected > 0 ? "bg-yellow-500 shadow-[0_0_8px_rgba(234,179,8,0.6)]" : "bg-green-500 shadow-[0_0_8px_rgba(34,197,94,0.6)]"}`)}></div> <span class="typ-meta">${escape_html(store_get($$store_subs ??= {}, "$t", $format)("connection.relaysLabel"))} ${escape_html(store_get($$store_subs ??= {}, "$connectionStats", connectionStats).connected)}/${escape_html(store_get($$store_subs ??= {}, "$connectionStats", connectionStats).total)}</span>`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function ContactList($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const isAndroidApp = isAndroidNative();
    let myPicture = void 0;
    function parseMarkdownPreview(text) {
      text = text.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
      text = text.replace(/\*\*([^*]+)\*\*/g, "<strong>$1</strong>");
      text = text.replace(/\*([^*]+)\*/g, "<em>$1</em>");
      return text;
    }
    $$renderer2.push(`<div role="presentation"${attr_class(`relative flex flex-col h-full bg-white/50 dark:bg-slate-900/50 ${stringify(isAndroidApp ? "" : "backdrop-blur-sm")} border-r border-gray-200/50 dark:border-slate-700/70 overflow-hidden`, "svelte-r7m1hc", {
      "select-none": isAndroidApp,
      "androidNoCallout": isAndroidApp
    })}><div${attr_class(`absolute top-0 left-0 right-0 z-20 flex flex-col pt-safe bg-white/80 dark:bg-slate-900/80 ${stringify(isAndroidApp ? "" : "backdrop-blur-xl")} border-b border-gray-200/50 dark:border-slate-700/70 shadow-sm transition-all duration-200`)}><div class="p-2 h-16 flex items-center justify-between relative">`);
    if (store_get($$store_subs ??= {}, "$currentUser", currentUser)) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="flex items-center gap-2"><button class="flex items-center" aria-label="Open profile">`);
      Avatar($$renderer2, {
        npub: store_get($$store_subs ??= {}, "$currentUser", currentUser).npub,
        src: myPicture,
        size: "md",
        class: "!w-11 !h-11 transition-all duration-150 ease-out"
      });
      $$renderer2.push(`<!----></button> `);
      Button($$renderer2, {
        onclick: () => {
          showUserQrModal.set(true);
        },
        size: "icon",
        "aria-label": "Show nostr QR code",
        children: ($$renderer3) => {
          $$renderer3.push(`<svg class="w-6 h-6" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="6" height="6"></rect><rect x="15" y="3" width="6" height="6"></rect><rect x="3" y="15" width="6" height="6"></rect><path d="M15 15h2v2h-2z"></path><path d="M19 15h2v2h-2z"></path><path d="M15 19h2v2h-2z"></path></svg>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <span class="absolute left-1/2 -translate-x-1/2 typ-section text-gray-900 dark:text-white tracking-tight pointer-events-none">nospeak</span> `);
    Button($$renderer2, {
      onclick: () => {
        showSettingsModal.set(true);
      },
      size: "icon",
      "aria-label": "Open settings",
      children: ($$renderer3) => {
        $$renderer3.push(`<svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div> <div class="px-2 pb-3 flex justify-between items-center"><div class="typ-section dark:text-white">${escape_html(store_get($$store_subs ??= {}, "$t", $format)("contacts.title"))}</div> `);
    {
      $$renderer2.push("<!--[!-->");
      Button($$renderer2, {
        onclick: () => showManageContactsModal.set(true),
        children: ($$renderer3) => {
          $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", $format)("contacts.manage"))}`);
        },
        $$slots: { default: true }
      });
    }
    $$renderer2.push(`<!--]--></div></div> <div class="flex-1 overflow-y-auto custom-scrollbar native-scroll pt-[calc(120px+env(safe-area-inset-top))] pb-safe-offset-16">`);
    if (store_get($$store_subs ??= {}, "$contactsStore", contacts).length === 0) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="space-y-3 p-3 animate-pulse"><!--[-->`);
      const each_array = ensure_array_like(Array(5));
      for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
        each_array[$$index];
        $$renderer2.push(`<div class="flex items-center gap-3 p-3 rounded-full bg-[rgb(var(--color-lavender-rgb)/0.10)] dark:bg-[rgb(var(--color-lavender-rgb)/0.14)]"><div class="w-12 h-12 rounded-full bg-gray-200/50 dark:bg-slate-700/50"></div> <div class="flex-1 space-y-2"><div class="h-4 bg-gray-200/50 dark:bg-slate-700/50 rounded w-2/3"></div> <div class="h-3 bg-gray-200/50 dark:bg-slate-700/50 rounded w-1/3"></div></div></div>`);
      }
      $$renderer2.push(`<!--]--> <div class="text-center text-sm text-gray-700 dark:text-slate-400 mt-4">${escape_html(store_get($$store_subs ??= {}, "$t", $format)("contacts.emptyHint"))}</div></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <!--[-->`);
    const each_array_1 = ensure_array_like(store_get($$store_subs ??= {}, "$contactsStore", contacts));
    for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
      let contact = each_array_1[$$index_1];
      $$renderer2.push(`<div${attr_class(
        `p-3 mx-2 my-1.5 rounded-full cursor-pointer flex items-center gap-3 transition-all duration-200 ease-out group active:scale-[0.98] ${page.url.pathname.includes(contact.npub) ? "bg-[rgb(var(--color-lavender-rgb)/0.20)] dark:bg-[rgb(var(--color-lavender-rgb)/0.24)] text-gray-900 dark:text-[rgb(var(--color-text-rgb)/0.92)] shadow-sm hover:shadow hover:bg-[rgb(var(--color-lavender-rgb)/0.26)] dark:hover:bg-[rgb(var(--color-lavender-rgb)/0.30)] active:bg-[rgb(var(--color-lavender-rgb)/0.32)] dark:active:bg-[rgb(var(--color-lavender-rgb)/0.36)]" : "bg-transparent text-gray-700 dark:text-gray-400 hover:bg-[rgb(var(--color-lavender-rgb)/0.12)] dark:hover:bg-[rgb(var(--color-lavender-rgb)/0.16)] hover:text-gray-900 dark:hover:text-white"}`,
        "svelte-r7m1hc",
        { "select-none": isAndroidApp }
      )}>`);
      Avatar($$renderer2, {
        npub: contact.npub,
        src: contact.picture,
        size: "md",
        class: "!w-14 !h-14 md:!w-10 md:!h-10 transition-all duration-150 ease-out"
      });
      $$renderer2.push(`<!----> <div class="flex-1 min-w-0"><div class="flex items-center gap-1 min-w-0"><span class="font-bold text-gray-800 dark:text-slate-100 truncate text-[15px]">${escape_html(contact.name)}</span> `);
      if (contact.nip05Status === "valid") {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<svg class="shrink-0 text-green-500" xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path><path d="m9 12 2 2 4-4"></path></svg>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></div> `);
      if (contact.lastMessageText) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<div class="typ-body text-gray-800 dark:text-slate-300 truncate md:hidden">${html(parseMarkdownPreview(contact.lastMessageText))}</div>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></div> `);
      if (contact.hasUnread) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<div class="w-3 h-3 bg-green-500 rounded-full flex-shrink-0"></div>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></div>`);
    }
    $$renderer2.push(`<!--]--></div> `);
    ConnectionStatus($$renderer2);
    $$renderer2.push(`<!----></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function _layout($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { children } = $$props;
    let isChatOpen = page.url.pathname !== "/chat";
    $$renderer2.push(`<div class="flex h-full overflow-hidden bg-transparent"><div${attr_class(`${isChatOpen ? "hidden md:block" : "block"} w-full md:w-80 flex-shrink-0 border-r border-gray-200/50 dark:border-gray-800/50`)}>`);
    ContactList($$renderer2);
    $$renderer2.push(`<!----></div> <!---->`);
    {
      $$renderer2.push(`<div${attr_class(`${!isChatOpen ? "hidden md:flex" : "flex"} flex-1 flex-col min-w-0 h-full overflow-hidden`)}>`);
      children($$renderer2);
      $$renderer2.push(`<!----></div>`);
    }
    $$renderer2.push(`<!----></div>`);
  });
}
export {
  _layout as default
};
