function isAndroidCapacitorShell() {
  if (typeof window === "undefined") {
    return false;
  }
  const w = window;
  if (w.Capacitor && typeof w.Capacitor.getPlatform === "function") {
    try {
      return w.Capacitor.getPlatform() === "android";
    } catch {
      return false;
    }
  }
  return false;
}
function blur(level = "sm") {
  if (isAndroidCapacitorShell()) {
    return "";
  }
  return `backdrop-blur-${level}`;
}
export {
  blur as b,
  isAndroidCapacitorShell as i
};
