/**
 * Render a component into the document.
 *
 * @template {import('../types.js').Component} C
 *
 * @param {import('../types.js').ComponentImport<C>} Component - The component to render.
 * @param {import('../types.js').ComponentOptions<C>} componentOptions - Customize how Svelte renders the component.
 * @param {import('../types.js').SetupOptions} setupOptions - Customize how the document is set up.
 * @returns {import('../types.js').RenderResult<C>} The rendered component.
 */
export function render<C extends import("../types.js").Component>(Component: import("../types.js").ComponentImport<C>, componentOptions: import("../types.js").ComponentOptions<C>, setupOptions?: import("../types.js").SetupOptions): import("../types.js").RenderResult<C>;
//# sourceMappingURL=render.d.ts.map