## 1. Backend Setup
- [x] 1.1 Create `user_media` directory in static folder
- [x] 1.2 Configure Vite to serve user_media files
- [x] 1.3 Create media upload API endpoint
- [x] 1.4 Implement file validation (image/video types, size limits)
- [x] 1.5 Add UUID filename generation

## 2. Frontend Components
- [x] 2.1 Create MediaUploadButton component
- [x] 2.2 Create FileTypeDropdown component
- [x] 2.3 Implement file selection dialog
- [x] 2.4 Add upload progress indicator
- [x] 2.5 Handle upload errors gracefully

## 3. Chat Integration
- [x] 3.1 Remove user profile picture from ChatView message input
- [x] 3.2 Add MediaUploadButton to ChatView
- [x] 3.3 Insert file URLs into message input after upload
- [x] 3.4 Update MessageContent to render media URLs
- [x] 3.5 Add media preview in message bubbles

## 4. Final Polish
- [x] 4.1 Run linting and type checking
- [x] 4.2 Ensure UI responsiveness
- [x] 4.3 Add error handling for edge cases
