/**
 * Create a shallowly reactive props object.
 *
 * This allows us to update props on `rerender`
 * without turing `props` into a deep set of Proxy objects
 *
 * @template {Record<string, unknown>} Props
 * @param {Props} initialProps
 * @returns {[Props, (nextProps: Partial<Props>) => void]}
 */
export function createProps<Props extends Record<string, unknown>>(initialProps?: Props): [Props, (nextProps: Partial<Props>) => void];
//# sourceMappingURL=props.svelte.d.ts.map