import "clsx";
import { a as attr_class, b as attr, c as clsx, s as store_get, u as unsubscribe_stores, e as ensure_array_like, d as attr_style, h as head } from "../../../../chunks/index2.js";
import { a as currentUser } from "../../../../chunks/AndroidTapSound.js";
import "dexie";
import { w as writable, g as get } from "../../../../chunks/index.js";
import "@capacitor/local-notifications";
import { i as isAndroidNative, a as isMobileWeb, A as Avatar, B as Button } from "../../../../chunks/Avatar.js";
import { W as ssr_context, V as escape_html } from "../../../../chunks/context.js";
import { $ as $format } from "../../../../chunks/index3.js";
import { h as html } from "../../../../chunks/html.js";
import "@capacitor/haptics";
import { i as isAndroidCapacitorShell } from "../../../../chunks/platform.js";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
import "../../../../chunks/state.svelte.js";
import { Capacitor, registerPlugin } from "@capacitor/core";
import "@capacitor/dialog";
import "@capacitor/share";
import { p as page } from "../../../../chunks/index4.js";
function onDestroy(fn) {
  /** @type {SSRContext} */
  ssr_context.r.on_destroy(fn);
}
const lastRelaySendStatus = writable(null);
function MediaUploadButton($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      inline,
      variant: variantProp = "default"
    } = $$props;
    const variant = inline === true ? "chat" : inline === false ? "default" : variantProp;
    typeof window !== "undefined" && isAndroidNative();
    typeof window !== "undefined" && isMobileWeb();
    $$renderer2.push(`<div class="relative"><button type="button"${attr_class(clsx(variant === "chat" ? "flex-shrink-0 h-8 w-8 flex items-center justify-center text-gray-600 dark:text-gray-300 hover:text-gray-800 dark:hover:text-gray-100 disabled:opacity-50 disabled:cursor-not-allowed relative overflow-hidden active:scale-90 transition-transform duration-100 ease-out" : "flex-shrink-0 h-11 w-11 p-0 flex items-center justify-center rounded-full bg-[rgb(var(--color-lavender-rgb)/0.20)] dark:bg-[rgb(var(--color-lavender-rgb)/0.24)] text-[rgb(var(--color-text-rgb)/0.92)] shadow-sm hover:bg-[rgb(var(--color-lavender-rgb)/0.26)] dark:hover:bg-[rgb(var(--color-lavender-rgb)/0.30)] hover:shadow active:bg-[rgb(var(--color-lavender-rgb)/0.32)] dark:active:bg-[rgb(var(--color-lavender-rgb)/0.36)] disabled:opacity-50 disabled:pointer-events-none relative overflow-hidden transition-all duration-200 ease-out"))}${attr("title", store_get($$store_subs ??= {}, "$t", $format)("chat.mediaMenu.uploadMediaTooltip"))}><svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-gray-600 dark:text-gray-300"><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path><polyline points="17 8 12 3 7 8"></polyline><line x1="12" y1="3" x2="12" y2="15"></line></svg></button> `);
    {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
const imageViewerState = writable({
  url: null,
  originalUrl: null,
  fitToScreen: true
});
function openImageViewer(url, originalUrl) {
  imageViewerState.set({
    url,
    originalUrl: originalUrl ?? url,
    fitToScreen: true
  });
}
function AudioWaveformPlayer($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { url, isOwn = false } = $$props;
    const BAR_COUNT = 5;
    const progress = 0;
    const eqLevels = Array.from({ length: BAR_COUNT }, (_, i) => {
      {
        return 0.3 + 0.05 * i;
      }
    });
    function formatTime(seconds) {
      {
        return "0:00";
      }
    }
    $$renderer2.push(`<audio${attr("src", url)} class="hidden"></audio> <div${attr_class(`flex items-center gap-3 px-3 py-2 rounded-xl border text-[11px] min-w-[220px] max-w-full bg-white/20 dark:bg-slate-800/50 md:bg-white/10 md:dark:bg-slate-800/30 md:backdrop-blur-sm border-gray-200/50 dark:border-slate-700/50 transition-colors ${isOwn ? "text-blue-50" : "text-gray-900 dark:text-slate-100"}`)}><button type="button" class="flex-shrink-0 w-9 h-9 rounded-full flex items-center justify-center bg-blue-500 text-white shadow-sm hover:bg-blue-600 disabled:opacity-60"${attr("aria-label", "Play audio")}>`);
    {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="8 5 19 12 8 19 8 5"></polygon></svg>`);
    }
    $$renderer2.push(`<!--]--></button> <div class="flex-1 flex flex-col gap-1 min-w-0"><div class="text-[11px] font-semibold truncate tracking-wide">Audio</div> <div class="flex items-end gap-[4px] h-8 w-full"><!--[-->`);
    const each_array = ensure_array_like(eqLevels);
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let level = each_array[$$index];
      $$renderer2.push(`<div class="flex-1 max-w-[7px] rounded-full bg-blue-400/95 dark:bg-blue-300/95 transition-[height,opacity]"${attr_style(`height: ${4 + level * 24}px; opacity: ${0.7}`)}></div>`);
    }
    $$renderer2.push(`<!--]--></div> <div class="mt-1 h-[3px] w-full rounded-full bg-gray-200/80 dark:bg-slate-800/80 overflow-hidden"><div class="h-full rounded-full bg-blue-500/90 dark:bg-blue-400/90 transition-[width]"${attr_style(`width: ${progress * 100}%`)}></div></div></div> <div class="flex-shrink-0 text-[10px] tabular-nums text-right min-w-[56px]">${escape_html(formatTime())} / ${escape_html(formatTime())}</div></div>`);
  });
}
function extractYouTubeVideoId(url) {
  let parsed;
  try {
    parsed = new URL(url);
  } catch {
    return null;
  }
  const host = parsed.hostname.toLowerCase();
  const pathname = parsed.pathname;
  let candidate = null;
  if (host === "youtu.be" || host.endsWith(".youtu.be")) {
    const segments = pathname.split("/").filter(Boolean);
    candidate = segments[0] ?? null;
  } else if (host === "youtube.com" || host.endsWith(".youtube.com") || host === "m.youtube.com" || host === "music.youtube.com") {
    if (pathname === "/watch") {
      candidate = parsed.searchParams.get("v");
    } else if (pathname.startsWith("/shorts/")) {
      const parts = pathname.split("/").filter(Boolean);
      candidate = parts[1] ?? null;
    } else if (pathname.startsWith("/embed/")) {
      const parts = pathname.split("/").filter(Boolean);
      candidate = parts[1] ?? null;
    }
  }
  if (!candidate) {
    return null;
  }
  const cleaned = candidate.split("?")[0]?.split("&")[0]?.trim() ?? "";
  if (!/^[a-zA-Z0-9_-]{11}$/.test(cleaned)) {
    return null;
  }
  return cleaned;
}
function isYouTubeUrl(url) {
  return extractYouTubeVideoId(url) !== null;
}
function MessageContent($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      content,
      highlight = void 0,
      isOwn = false,
      onImageClick,
      fileUrl = void 0,
      fileType = void 0,
      fileEncryptionAlgorithm = void 0,
      fileKey = void 0,
      fileNonce = void 0,
      location = void 0
    } = $$props;
    const urlRegex = /(https?:\/\/[^\s]+)/g;
    function isImage(url) {
      try {
        const u = new URL(url);
        return /\.(jpg|jpeg|png|gif|webp|svg)$/i.test(u.pathname);
      } catch {
        return false;
      }
    }
    function isVideo(url) {
      try {
        const u = new URL(url);
        return /\.(mp4|webm|mov|ogg)$/i.test(u.pathname);
      } catch {
        return false;
      }
    }
    function isAudio(url) {
      try {
        const u = new URL(url);
        return /\.mp3$/i.test(u.pathname);
      } catch {
        return false;
      }
    }
    function isImageMime(mime) {
      return !!mime && mime.startsWith("image/");
    }
    function isVideoMime(mime) {
      return !!mime && mime.startsWith("video/");
    }
    function isAudioMime(mime) {
      return !!mime && mime.startsWith("audio/");
    }
    function parseMarkdown(text) {
      text = text.replace(/^> (.+)$/gm, '<div class="border-l-2 border-gray-300 pl-3 italic">$1</div>');
      text = text.replace(/~~([^~]+)~~/g, "<del>$1</del>");
      text = text.replace(/\*\*([^*]+)\*\*/g, "<strong>$1</strong>");
      text = text.replace(/__([^_]+)__/g, "<strong>$1</strong>");
      text = text.replace(/\*([^*]+)\*/g, "<em>$1</em>");
      text = text.replace(/_([^_]+)_/g, "<em>$1</em>");
      return text;
    }
    const highlightNeedle = (highlight ?? "").trim();
    function buildOsmEmbedUrl(point) {
      const padding = 0.01;
      const left = point.longitude - padding;
      const right = point.longitude + padding;
      const bottom = point.latitude - padding;
      const top = point.latitude + padding;
      return `https://www.openstreetmap.org/export/embed.html?bbox=${left},${bottom},${right},${top}&layer=mapnik&marker=${point.latitude},${point.longitude}`;
    }
    function buildOsmOpenUrl(point) {
      return `https://www.openstreetmap.org/?mlat=${point.latitude}&mlon=${point.longitude}&zoom=15`;
    }
    const mapUrl = location ? buildOsmEmbedUrl(location) : null;
    const openMapUrl = location ? buildOsmOpenUrl(location) : null;
    function escapeRegExp(value) {
      return value.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
    }
    function applyHighlightToHtml(html2, needle) {
      if (!needle) {
        return html2;
      }
      if (typeof window === "undefined") {
        return html2;
      }
      try {
        const regex = new RegExp(escapeRegExp(needle), "gi");
        const parser = new DOMParser();
        const doc = parser.parseFromString(`<div>${html2}</div>`, "text/html");
        const root = doc.body.firstElementChild;
        if (!root) {
          return html2;
        }
        const walker = doc.createTreeWalker(root, NodeFilter.SHOW_TEXT);
        const textNodes = [];
        for (let node = walker.nextNode(); node; node = walker.nextNode()) {
          if (node.nodeType === Node.TEXT_NODE) {
            textNodes.push(node);
          }
        }
        const markClass = "bg-yellow-200/70 dark:bg-yellow-400/20 rounded px-0.5";
        for (const textNode of textNodes) {
          const text = textNode.nodeValue ?? "";
          regex.lastIndex = 0;
          if (!regex.test(text)) {
            continue;
          }
          regex.lastIndex = 0;
          const fragment = doc.createDocumentFragment();
          let lastIndex = 0;
          let match;
          while ((match = regex.exec(text)) !== null) {
            const start = match.index;
            const end = start + match[0].length;
            if (start > lastIndex) {
              fragment.appendChild(doc.createTextNode(text.slice(lastIndex, start)));
            }
            const mark = doc.createElement("mark");
            mark.setAttribute("class", markClass);
            mark.textContent = text.slice(start, end);
            fragment.appendChild(mark);
            lastIndex = end;
          }
          if (lastIndex < text.length) {
            fragment.appendChild(doc.createTextNode(text.slice(lastIndex)));
          }
          textNode.parentNode?.replaceChild(fragment, textNode);
        }
        return root.innerHTML;
      } catch {
        return html2;
      }
    }
    function getFirstNonMediaUrl(text) {
      const matches = text.match(urlRegex) ?? [];
      for (const candidate of matches) {
        if (!isImage(candidate) && !isVideo(candidate) && !isAudio(candidate) && !isYouTubeUrl(candidate)) {
          return candidate;
        }
      }
      return null;
    }
    function getUrlPreviewsEnabled() {
      if (typeof window === "undefined") {
        return true;
      }
      try {
        const raw = localStorage.getItem("nospeak-settings");
        if (!raw) {
          return true;
        }
        const parsed = JSON.parse(raw);
        if (typeof parsed.urlPreviewsEnabled === "boolean") {
          return parsed.urlPreviewsEnabled;
        }
        return true;
      } catch {
        return true;
      }
    }
    let parts = content.split(urlRegex);
    (() => {
      for (let i = 0; i < parts.length; i++) {
        const part = parts[i];
        if (!part.match(/^https?:\/\//)) {
          continue;
        }
        const videoId = extractYouTubeVideoId(part);
        if (videoId) {
          return { partIndex: i, videoId };
        }
      }
      return null;
    })();
    const singleEmojiRegex = new RegExp("^(\\p{Emoji_Presentation}|\\p{Emoji}\\uFE0F)$", "u");
    let isSingleEmoji = singleEmojiRegex.test(content.trim());
    getFirstNonMediaUrl(content);
    let isVisible = false;
    typeof window !== "undefined" && getUrlPreviewsEnabled() && isVisible;
    const NOSPEAK_INTERNAL_MEDIA_ORIGIN = "https://nospeak.chat";
    function isLegacyNospeakUserMediaUrl(url) {
      try {
        const u = new URL(url);
        return u.origin === NOSPEAK_INTERNAL_MEDIA_ORIGIN && u.pathname.startsWith("/api/user_media/");
      } catch {
        return false;
      }
    }
    $$renderer2.push(`<div${attr_class(`whitespace-pre-wrap break-words leading-relaxed ${isSingleEmoji ? "text-4xl" : ""}`)}>`);
    if (location) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="my-1"><div class="flex items-center gap-2 typ-meta text-xs font-semibold text-gray-600 dark:text-slate-300 leading-none"><svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0118 0z"></path><circle cx="12" cy="10" r="3"></circle></svg> <span>${escape_html(store_get($$store_subs ??= {}, "$t", $format)("modals.locationPreview.title"))}</span></div> `);
      if (mapUrl) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<div class="rounded-xl overflow-hidden bg-gray-100/80 dark:bg-slate-800/80 border border-gray-200/60 dark:border-slate-700/60"><iframe${attr("src", mapUrl)} width="100%" height="220" frameborder="0" class="w-full" title="Location map"></iframe></div>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      if (openMapUrl) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<a${attr("href", openMapUrl)} target="_blank" rel="noopener noreferrer" class="typ-meta text-xs underline hover:opacity-80">${escape_html(store_get($$store_subs ??= {}, "$t", $format)("modals.locationPreview.openInOpenStreetMap"))}</a>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
      if (fileUrl && fileEncryptionAlgorithm === "aes-gcm" && fileKey && fileNonce) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<div class="space-y-2">`);
        if (isLegacyNospeakUserMediaUrl(fileUrl)) {
          $$renderer2.push("<!--[-->");
          $$renderer2.push(`<div class="my-1 px-3 py-2 rounded-xl bg-gray-100/70 dark:bg-slate-800/60 border border-gray-200/60 dark:border-slate-700/60"><div class="typ-meta text-xs text-gray-600 dark:text-slate-300">${escape_html(store_get($$store_subs ??= {}, "$t", $format)("chat.mediaUnavailable"))}</div></div>`);
        } else {
          $$renderer2.push("<!--[!-->");
          {
            $$renderer2.push("<!--[!-->");
            {
              $$renderer2.push("<!--[!-->");
              {
                $$renderer2.push("<!--[!-->");
              }
              $$renderer2.push(`<!--]-->`);
            }
            $$renderer2.push(`<!--]-->`);
          }
          $$renderer2.push(`<!--]-->`);
        }
        $$renderer2.push(`<!--]--></div>`);
      } else {
        $$renderer2.push("<!--[!-->");
        if (fileUrl) {
          $$renderer2.push("<!--[-->");
          $$renderer2.push(`<div class="space-y-2">`);
          if (isLegacyNospeakUserMediaUrl(fileUrl)) {
            $$renderer2.push("<!--[-->");
            $$renderer2.push(`<div class="my-1 px-3 py-2 rounded-xl bg-gray-100/70 dark:bg-slate-800/60 border border-gray-200/60 dark:border-slate-700/60"><div class="typ-meta text-xs text-gray-600 dark:text-slate-300">${escape_html(store_get($$store_subs ??= {}, "$t", $format)("chat.mediaUnavailable"))}</div></div>`);
          } else {
            $$renderer2.push("<!--[!-->");
            if (isImageMime(fileType) || isImage(fileUrl)) {
              $$renderer2.push("<!--[-->");
              if (onImageClick) {
                $$renderer2.push("<!--[-->");
                $$renderer2.push(`<button type="button" class="block my-1 cursor-zoom-in"><img${attr("src", fileUrl)} alt="Attachment" class="max-w-full rounded max-h-[300px] object-contain" loading="lazy" onload="this.__e=event"/></button>`);
              } else {
                $$renderer2.push("<!--[!-->");
                $$renderer2.push(`<a${attr("href", fileUrl)} target="_blank" rel="noopener noreferrer" class="block my-1"><img${attr("src", fileUrl)} alt="Attachment" class="max-w-full rounded max-h-[300px] object-contain" loading="lazy" onload="this.__e=event"/></a>`);
              }
              $$renderer2.push(`<!--]-->`);
            } else {
              $$renderer2.push("<!--[!-->");
              if (isVideoMime(fileType) || isVideo(fileUrl)) {
                $$renderer2.push("<!--[-->");
                $$renderer2.push(`<div class="my-1"><video controls${attr("src", fileUrl)} class="max-w-full rounded max-h-[300px]" preload="metadata"></video></div>`);
              } else {
                $$renderer2.push("<!--[!-->");
                if (isAudioMime(fileType) || isAudio(fileUrl)) {
                  $$renderer2.push("<!--[-->");
                  $$renderer2.push(`<div class="mt-2 mb-1">`);
                  AudioWaveformPlayer($$renderer2, { url: fileUrl, isOwn });
                  $$renderer2.push(`<!----></div>`);
                } else {
                  $$renderer2.push("<!--[!-->");
                  $$renderer2.push(`<a${attr("href", fileUrl)} target="_blank" rel="noopener noreferrer" class="underline hover:opacity-80 break-all">Download attachment</a>`);
                }
                $$renderer2.push(`<!--]-->`);
              }
              $$renderer2.push(`<!--]-->`);
            }
            $$renderer2.push(`<!--]-->`);
          }
          $$renderer2.push(`<!--]--></div>`);
        } else {
          $$renderer2.push("<!--[!-->");
          $$renderer2.push(`<!--[-->`);
          const each_array = ensure_array_like(parts);
          for (let i = 0, $$length = each_array.length; i < $$length; i++) {
            let part = each_array[i];
            if (part.match(/^https?:\/\//)) {
              $$renderer2.push("<!--[-->");
              {
                $$renderer2.push("<!--[!-->");
                if (isLegacyNospeakUserMediaUrl(part)) {
                  $$renderer2.push("<!--[-->");
                  $$renderer2.push(`<div class="my-1 px-3 py-2 rounded-xl bg-gray-100/70 dark:bg-slate-800/60 border border-gray-200/60 dark:border-slate-700/60"><div class="typ-meta text-xs text-gray-600 dark:text-slate-300">${escape_html(store_get($$store_subs ??= {}, "$t", $format)("chat.mediaUnavailable"))}</div></div>`);
                } else {
                  $$renderer2.push("<!--[!-->");
                  if (isImage(part)) {
                    $$renderer2.push("<!--[-->");
                    if (onImageClick) {
                      $$renderer2.push("<!--[-->");
                      $$renderer2.push(`<button type="button" class="block my-1 cursor-zoom-in"><img${attr("src", part)} alt="Attachment" class="max-w-full rounded max-h-[300px] object-contain" loading="lazy" onload="this.__e=event"/></button>`);
                    } else {
                      $$renderer2.push("<!--[!-->");
                      $$renderer2.push(`<a${attr("href", part)} target="_blank" rel="noopener noreferrer" class="block my-1"><img${attr("src", part)} alt="Attachment" class="max-w-full rounded max-h-[300px] object-contain" loading="lazy" onload="this.__e=event"/></a>`);
                    }
                    $$renderer2.push(`<!--]-->`);
                  } else {
                    $$renderer2.push("<!--[!-->");
                    if (isVideo(part)) {
                      $$renderer2.push("<!--[-->");
                      $$renderer2.push(`<div class="my-1"><video controls${attr("src", part)} class="max-w-full rounded max-h-[300px]" preload="metadata"></video></div>`);
                    } else {
                      $$renderer2.push("<!--[!-->");
                      if (isAudio(part)) {
                        $$renderer2.push("<!--[-->");
                        $$renderer2.push(`<div class="mt-2 mb-1">`);
                        AudioWaveformPlayer($$renderer2, { url: part, isOwn });
                        $$renderer2.push(`<!----></div>`);
                      } else {
                        $$renderer2.push("<!--[!-->");
                        $$renderer2.push(`<a${attr("href", part)} target="_blank" rel="noopener noreferrer" class="underline hover:opacity-80 break-all">${escape_html(part)}</a>`);
                      }
                      $$renderer2.push(`<!--]-->`);
                    }
                    $$renderer2.push(`<!--]-->`);
                  }
                  $$renderer2.push(`<!--]-->`);
                }
                $$renderer2.push(`<!--]-->`);
              }
              $$renderer2.push(`<!--]-->`);
            } else {
              $$renderer2.push("<!--[!-->");
              $$renderer2.push(`<span>${html(applyHighlightToHtml(parseMarkdown(part), highlightNeedle))}</span>`);
            }
            $$renderer2.push(`<!--]-->`);
          }
          $$renderer2.push(`<!--]--> `);
          {
            $$renderer2.push("<!--[!-->");
          }
          $$renderer2.push(`<!--]-->`);
        }
        $$renderer2.push(`<!--]-->`);
      }
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function ContextMenu($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      isOpen = false
    } = $$props;
    if (isOpen) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="context-menu fixed bg-white/80 dark:bg-slate-900/80 backdrop-blur-xl border border-gray-200 dark:border-slate-700 rounded-lg shadow-xl py-1 z-[9999] min-w-[140px] outline-none"><div class="flex px-2 pt-1 pb-1 gap-1 border-b border-gray-200/70 dark:border-slate-700/70"><!--[-->`);
      const each_array = ensure_array_like(["👍", "👎", "❤️", "😂"]);
      for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
        let emoji = each_array[$$index];
        $$renderer2.push(`<button type="button" class="flex-1 px-1 py-1 rounded-md hover:bg-gray-100/70 dark:hover:bg-slate-700/70 text-lg text-center">${escape_html(emoji)}</button>`);
      }
      $$renderer2.push(`<!--]--></div> `);
      {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> <button class="w-full text-left px-4 py-2 hover:bg-gray-100/50 dark:hover:bg-slate-700/50 text-sm dark:text-white transition-colors">${escape_html(store_get($$store_subs ??= {}, "$t", $format)("chat.contextMenu.cite"))}</button> <button class="w-full text-left px-4 py-2 hover:bg-gray-100/50 dark:hover:bg-slate-700/50 text-sm dark:text-white transition-colors">${escape_html(store_get($$store_subs ??= {}, "$t", $format)("chat.contextMenu.copy"))}</button></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function MessageReactions($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    $$renderer2.push(`<div class="w-full h-0">`);
    {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div>`);
  });
}
function isCaptionMessage(messages, index) {
  const msg = messages[index];
  if (!msg || msg.rumorKind !== 14 || !msg.parentRumorId) return false;
  const parentIndex = messages.findIndex(
    (m) => m.rumorId === msg.parentRumorId
  );
  if (parentIndex === -1) return false;
  const parent = messages[parentIndex];
  if (!parent || parent.rumorKind !== 15) return false;
  if (parent.direction !== msg.direction) return false;
  if (index !== parentIndex + 1) return false;
  return true;
}
function getCaptionForParent(messages, index) {
  const msg = messages[index];
  if (!msg || msg.rumorKind !== 15) return null;
  const nextIndex = index + 1;
  const next = messages[nextIndex];
  if (!next || next.rumorKind !== 14 || !next.parentRumorId) return null;
  if (next.parentRumorId !== msg.rumorId) return null;
  if (next.direction !== msg.direction) return null;
  return next;
}
Capacitor.getPlatform() === "android" ? registerPlugin("AndroidLocation") : null;
function ChatView($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      messages = [],
      partnerNpub,
      isFetchingHistory = false,
      canRequestNetworkHistory = false,
      networkHistoryStatus = "idle",
      networkHistorySummary = null
    } = $$props;
    let inputText = "";
    let isSearchOpen = false;
    let searchQuery = "";
    let searchResults = [];
    let isSearchingHistory = false;
    let isSearchActive = searchQuery.trim().length >= 3;
    function cancelPendingSearch() {
      isSearchingHistory = false;
    }
    function closeSearch() {
      cancelPendingSearch();
      isSearchOpen = false;
      searchQuery = "";
      searchResults = [];
    }
    function openSearch() {
      isSearchOpen = true;
      setTimeout(
        () => {
        },
        0
      );
    }
    function toggleSearch() {
      if (isSearchOpen) {
        closeSearch();
        return;
      }
      openSearch();
    }
    function escapeHtml(value) {
      return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll('"', "&quot;").replaceAll("'", "&#39;");
    }
    function escapeRegExp(value) {
      return value.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
    }
    function highlightPlainTextToHtml(text, query) {
      const needle = query.trim();
      if (!needle) {
        return escapeHtml(text);
      }
      const regex = new RegExp(escapeRegExp(needle), "gi");
      const markClass = "bg-yellow-200/70 dark:bg-yellow-400/20 rounded px-0.5";
      let result = "";
      let lastIndex = 0;
      let match;
      while ((match = regex.exec(text)) !== null) {
        const start = match.index;
        const end = start + match[0].length;
        result += escapeHtml(text.slice(lastIndex, start));
        result += `<mark class="${markClass}">${escapeHtml(text.slice(start, end))}</mark>`;
        lastIndex = end;
      }
      result += escapeHtml(text.slice(lastIndex));
      return result;
    }
    let partnerPicture = void 0;
    let myPicture = void 0;
    let isSending = false;
    let optimisticMessages = [];
    let displayMessages = isSearchActive ? searchResults : [...messages, ...optimisticMessages];
    function revokeOptimisticResources(msg) {
      if (typeof window === "undefined") {
        return;
      }
      if (msg.fileUrl && msg.fileUrl.startsWith("blob:")) {
        URL.revokeObjectURL(msg.fileUrl);
      }
    }
    onDestroy(() => {
      cancelPendingSearch();
      for (const optimistic of optimisticMessages) {
        revokeOptimisticResources(optimistic);
      }
    });
    let currentTime = Date.now();
    let unreadSnapshotMessageIds = [];
    let activeHighlightMessageIds = [];
    let unreadSnapshotMessageSet = new Set(unreadSnapshotMessageIds);
    let activeHighlightMessageSet = new Set(activeHighlightMessageIds);
    let contextMenu = { isOpen: false };
    const isAndroidShell = isAndroidCapacitorShell();
    const useFullWidthBubbles = isAndroidShell || isMobileWeb();
    const useSmallAvatars = useFullWidthBubbles;
    function getLastSentIndex(list) {
      let index = -1;
      for (let i = 0; i < list.length; i++) {
        if (list[i].direction === "sent") {
          index = i;
        }
      }
      return index;
    }
    function getRelativeTime(timestamp) {
      const now = currentTime;
      const diff = now - timestamp;
      const seconds = Math.floor(diff / 1e3);
      const minutes = Math.floor(seconds / 60);
      const hours = Math.floor(minutes / 60);
      const days = Math.floor(hours / 24);
      const weeks = Math.floor(days / 7);
      const months = Math.floor(days / 30);
      const years = Math.floor(days / 365);
      const translate = get($format);
      if (seconds < 60) return translate("chat.relative.justNow");
      if (minutes < 60) {
        const key2 = minutes === 1 ? "chat.relative.minutes" : "chat.relative.minutesPlural";
        return translate(key2, { values: { count: minutes } });
      }
      if (hours < 24) {
        const key2 = hours === 1 ? "chat.relative.hours" : "chat.relative.hoursPlural";
        return translate(key2, { values: { count: hours } });
      }
      if (days < 7) {
        const key2 = days === 1 ? "chat.relative.days" : "chat.relative.daysPlural";
        return translate(key2, { values: { count: days } });
      }
      if (weeks < 4) {
        const key2 = weeks === 1 ? "chat.relative.weeks" : "chat.relative.weeksPlural";
        return translate(key2, { values: { count: weeks } });
      }
      if (months < 12) {
        const key2 = months === 1 ? "chat.relative.months" : "chat.relative.monthsPlural";
        return translate(key2, { values: { count: months } });
      }
      const key = years === 1 ? "chat.relative.years" : "chat.relative.yearsPlural";
      return translate(key, { values: { count: years } });
    }
    function isSameDay(a, b) {
      const da = new Date(a);
      const db = new Date(b);
      return da.getFullYear() === db.getFullYear() && da.getMonth() === db.getMonth() && da.getDate() === db.getDate();
    }
    function formatDateLabel(timestamp) {
      const now = new Date(currentTime);
      const target = new Date(timestamp);
      const startOfToday = new Date(now.getFullYear(), now.getMonth(), now.getDate()).getTime();
      const startOfTarget = new Date(target.getFullYear(), target.getMonth(), target.getDate()).getTime();
      const diffDays = Math.round((startOfToday - startOfTarget) / (1e3 * 60 * 60 * 24));
      const translateDate = get($format);
      if (diffDays === 0) {
        return translateDate("chat.dateLabel.today");
      }
      if (diffDays === 1) {
        return translateDate("chat.dateLabel.yesterday");
      }
      return target.toLocaleDateString(void 0, { year: "numeric", month: "short", day: "numeric" });
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head("may7r9", $$renderer3, ($$renderer4) => {
        if (partnerNpub) {
          $$renderer4.push("<!--[-->");
          $$renderer4.title(($$renderer5) => {
            $$renderer5.push(`<title>nospeak: chat with ${escape_html(partnerNpub.slice(0, 10) + "...")}</title>`);
          });
        } else {
          $$renderer4.push("<!--[!-->");
        }
        $$renderer4.push(`<!--]-->`);
      });
      $$renderer3.push(`<div class="relative flex flex-col h-full overflow-hidden bg-white/30 dark:bg-slate-900/30 backdrop-blur-sm">`);
      {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (partnerNpub) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="absolute top-0 left-0 right-0 z-20 p-2 h-16 border-b border-gray-200/50 dark:border-slate-700/70 flex justify-between items-center bg-white/80 dark:bg-slate-900/80 backdrop-blur-xl shadow-sm transition-all duration-150 ease-out"><div class="flex items-center gap-3"><button class="md:hidden text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors duration-150 ease-out" aria-label="Back to contacts"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path></svg></button> `);
        if (partnerNpub) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<button class="hover:opacity-80 transition-opacity duration-150 ease-out cursor-pointer" aria-label="Open contact profile">`);
          Avatar($$renderer3, {
            npub: partnerNpub,
            src: partnerPicture,
            size: "sm",
            class: "!w-8 !h-8 md:!w-9 md:!h-9 transition-all duration-150 ease-out"
          });
          $$renderer3.push(`<!----></button>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> <button class="font-bold hover:underline dark:text-white text-left">${escape_html(partnerNpub.slice(0, 10) + "...")}</button></div> `);
        if (partnerNpub !== "ALL") {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div${attr_class(`md:hidden absolute top-2 bottom-2 left-24 right-16 z-30 transition-[opacity,transform] duration-200 ease-out ${isSearchOpen ? "opacity-100 translate-x-0 pointer-events-auto" : "opacity-0 translate-x-2 pointer-events-none"}`)}><input${attr("value", searchQuery)}${attr("placeholder", store_get($$store_subs ??= {}, "$t", $format)("chat.searchPlaceholder"))} class="w-full h-full px-4 border border-gray-200 dark:border-slate-700 rounded-full bg-white dark:bg-slate-800 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-blue-500/30 transition-all placeholder:text-gray-400 dark:placeholder:text-slate-500"${attr("aria-label", store_get($$store_subs ??= {}, "$t", $format)("chat.searchAriaLabel"))}/></div> <div class="flex items-center gap-2"><div${attr_class(`hidden md:block transition-[max-width,opacity] duration-200 ease-out ${isSearchOpen ? "max-w-56 opacity-100 overflow-visible" : "max-w-0 opacity-0 overflow-hidden pointer-events-none"}`)}><input${attr("value", searchQuery)}${attr("placeholder", store_get($$store_subs ??= {}, "$t", $format)("chat.searchPlaceholder"))} class="w-full px-4 h-11 border border-gray-200 dark:border-slate-700 rounded-full bg-white/90 dark:bg-slate-800/90 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-blue-500/30 transition-all placeholder:text-gray-400 dark:placeholder:text-slate-500"${attr("aria-label", store_get($$store_subs ??= {}, "$t", $format)("chat.searchAriaLabel"))}/></div> `);
          Button($$renderer3, {
            size: "icon",
            onclick: toggleSearch,
            class: "h-11 w-11 relative z-40",
            "aria-label": "Search chat",
            children: ($$renderer4) => {
              $$renderer4.push(`<svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-4.35-4.35m1.85-5.15a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <div tabindex="-1" class="flex-1 overflow-x-hidden overflow-y-auto px-4 pb-28 pt-20 space-y-4 custom-scrollbar focus:outline-none focus:ring-0">`);
      if (isSearchActive) {
        $$renderer3.push("<!--[-->");
        if (isSearchingHistory) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="flex justify-center p-2"><div class="animate-spin rounded-full h-6 w-6 border-b-2 border-blue-500"></div></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
          if (displayMessages.length === 0) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="flex justify-center mt-10"><div class="px-4 py-2 rounded-2xl bg-white/80 dark:bg-slate-900/80 border border-gray-200/70 dark:border-slate-700/70 shadow-md backdrop-blur-xl typ-body text-gray-600 dark:text-slate-200">${escape_html(store_get($$store_subs ??= {}, "$t", $format)("chat.searchNoMatches"))}</div></div>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]-->`);
        }
        $$renderer3.push(`<!--]-->`);
      } else {
        $$renderer3.push("<!--[!-->");
        if (canRequestNetworkHistory && displayMessages.length > 0) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="flex flex-col items-center p-2 gap-2"><button class="typ-meta px-4 py-1.5 rounded-full bg-white/70 dark:bg-slate-800/80 backdrop-blur-sm border border-gray-200/60 dark:border-slate-700/60 text-gray-700 dark:text-slate-200 hover:bg-white/90 dark:hover:bg-slate-700/90 transition-all shadow-sm" type="button">${escape_html(store_get($$store_subs ??= {}, "$t", $format)("chat.history.fetchOlder"))}</button> `);
          if (networkHistorySummary) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="px-3 py-1 rounded-full typ-meta bg-white/60 dark:bg-slate-800/60 border border-gray-200/60 dark:border-slate-700/60 text-gray-600 dark:text-slate-200 shadow-sm backdrop-blur-sm">${escape_html(get($format)("chat.history.summary", {
              values: {
                events: networkHistorySummary.eventsFetched,
                saved: networkHistorySummary.messagesSaved,
                chat: networkHistorySummary.messagesForChat
              }
            }))}</div>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
          if (networkHistoryStatus === "no-more" && displayMessages.length > 0) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="flex justify-center p-2"><div class="px-3 py-1 rounded-full typ-meta bg-white/70 dark:bg-slate-800/80 border border-gray-200/70 dark:border-slate-700/70 text-gray-500 dark:text-slate-300 shadow-sm backdrop-blur-sm">${escape_html(store_get($$store_subs ??= {}, "$t", $format)("chat.history.none"))}</div></div>`);
          } else {
            $$renderer3.push("<!--[!-->");
            if (networkHistoryStatus === "error" && displayMessages.length > 0) {
              $$renderer3.push("<!--[-->");
              $$renderer3.push(`<div class="flex justify-center p-2"><div class="px-3 py-1 rounded-full typ-meta bg-red-50/80 dark:bg-red-900/40 border border-red-200/80 dark:border-red-500/70 text-red-600 dark:text-red-200 shadow-sm backdrop-blur-sm">${escape_html(store_get($$store_subs ??= {}, "$t", $format)("chat.history.error"))}</div></div>`);
            } else {
              $$renderer3.push("<!--[!-->");
            }
            $$renderer3.push(`<!--]-->`);
          }
          $$renderer3.push(`<!--]-->`);
        }
        $$renderer3.push(`<!--]--> `);
        if (isFetchingHistory) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="flex justify-center p-2"><div class="animate-spin rounded-full h-6 w-6 border-b-2 border-blue-500"></div></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        if (displayMessages.length === 0 && !isFetchingHistory) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="flex justify-center mt-10"><div class="max-w-sm px-4 py-3 rounded-2xl bg-white/80 dark:bg-slate-900/80 border border-gray-200/70 dark:border-slate-700/70 shadow-md backdrop-blur-xl text-center space-y-1"><div class="typ-meta font-semibold uppercase text-gray-500 dark:text-slate-400">${escape_html(store_get($$store_subs ??= {}, "$t", $format)("chat.empty.noMessagesTitle"))}</div> <div class="typ-body text-gray-600 dark:text-slate-200">`);
          if (partnerNpub) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`${escape_html(get($format)("chat.empty.forContact", {
              values: { name: partnerNpub.slice(0, 10) + "..." }
            }))}`);
          } else {
            $$renderer3.push("<!--[!-->");
            $$renderer3.push(`${escape_html(store_get($$store_subs ??= {}, "$t", $format)("chat.empty.generic"))}`);
          }
          $$renderer3.push(`<!--]--></div></div></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]-->`);
      }
      $$renderer3.push(`<!--]--> <!--[-->`);
      const each_array = ensure_array_like(displayMessages);
      for (let i = 0, $$length = each_array.length; i < $$length; i++) {
        let msg = each_array[i];
        const caption = isCaptionMessage(displayMessages, i);
        const captionForThis = getCaptionForParent(displayMessages, i);
        const hasUnreadMarker = msg.direction === "received" && (unreadSnapshotMessageSet.has(msg.eventId) || captionForThis && unreadSnapshotMessageSet.has(captionForThis.eventId) || activeHighlightMessageSet.has(msg.eventId));
        const hasYouTubeLink = /https?:\/\/(www\.)?(youtube\.com|youtu\.be)\//.test(msg.message);
        const bubbleWidthClass = hasYouTubeLink ? "w-full max-w-full md:w-[560px] md:max-w-full" : useFullWidthBubbles ? "max-w-full" : "max-w-[70%]";
        if (i === 0 || !isSameDay(msg.sentAt, displayMessages[i - 1].sentAt)) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="flex justify-center my-2"><div class="px-3 py-1 rounded-full typ-meta bg-white/70 dark:bg-slate-800/80 border border-gray-200/70 dark:border-slate-700/70 text-gray-600 dark:text-slate-200 shadow-sm backdrop-blur-sm">${escape_html(formatDateLabel(msg.sentAt))}</div></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]-->   `);
        if (!caption) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div${attr_class(`flex ${msg.direction === "sent" ? "justify-end" : "justify-start"} items-end gap-2`)}>`);
          if (msg.direction === "received" && partnerNpub && !caption) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<button class="mb-1 hover:opacity-80 transition-opacity duration-150 ease-out cursor-pointer">`);
            Avatar($$renderer3, {
              npub: partnerNpub,
              src: partnerPicture,
              size: "md",
              class: `${useSmallAvatars ? "!w-10 !h-10" : "!w-14 !h-14"} md:!w-10 md:!h-10 transition-all duration-150 ease-out`
            });
            $$renderer3.push(`<!----></button>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> <div role="button" tabindex="0"${attr_class(`${bubbleWidthClass} p-3 shadow-sm cursor-pointer transition-all duration-150 ease-out relative ${isAndroidShell ? "select-none" : ""}
                          ${msg.direction === "sent" ? "bg-blue-50/10 dark:bg-blue-900/40 text-gray-900 dark:text-slate-100 border border-blue-500/10 dark:border-blue-400/10 rounded-2xl rounded-br-none hover:shadow-md" : "bg-white/95 dark:bg-slate-800/95 md:bg-white/80 md:dark:bg-slate-800/80 md:backdrop-blur-sm dark:text-white border border-gray-100 dark:border-slate-700/50 rounded-2xl rounded-bl-none hover:bg-white dark:hover:bg-slate-800"}`)}>`);
          if (hasUnreadMarker) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="absolute left-0 top-2 bottom-2 w-1 rounded-r bg-emerald-400/70"></div>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          MessageContent($$renderer3, {
            content: msg.message,
            highlight: isSearchActive ? searchQuery : void 0,
            isOwn: msg.direction === "sent",
            onImageClick: openImageViewer,
            fileUrl: msg.fileUrl,
            fileType: msg.fileType,
            fileEncryptionAlgorithm: msg.fileEncryptionAlgorithm,
            fileKey: msg.fileKey,
            fileNonce: msg.fileNonce,
            authorNpub: msg.direction === "sent" ? store_get($$store_subs ??= {}, "$currentUser", currentUser)?.npub : partnerNpub,
            location: msg.location
          });
          $$renderer3.push(`<!----> `);
          if (captionForThis) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="mt-2 text-sm text-gray-900 dark:text-slate-100">${html(highlightPlainTextToHtml(captionForThis.message, isSearchActive ? searchQuery : ""))}</div>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          MessageReactions($$renderer3, {
            targetEventId: msg.rumorId || "",
            isOwn: msg.direction === "sent"
          });
          $$renderer3.push(`<!----> <div${attr_class(`typ-meta mt-1 flex items-center justify-end gap-2 ${msg.direction === "sent" ? "text-blue-100" : "text-gray-400"}`)}><span class="cursor-help"${attr("title", new Date(msg.sentAt).toLocaleString())}>${escape_html(getRelativeTime(msg.sentAt))}</span> <button type="button" class="hidden md:inline-flex py-1 pr-0 pl-px rounded-l hover:bg-gray-100/50 dark:hover:bg-slate-700/50 transition-colors" aria-label="Message options"><svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor"><circle cx="12" cy="5" r="2"></circle><circle cx="12" cy="12" r="2"></circle><circle cx="12" cy="19" r="2"></circle></svg></button></div> `);
          if (msg.direction === "sent" && i === getLastSentIndex(displayMessages) && partnerNpub) {
            $$renderer3.push("<!--[-->");
            if (store_get($$store_subs ??= {}, "$lastRelaySendStatus", lastRelaySendStatus) && store_get($$store_subs ??= {}, "$lastRelaySendStatus", lastRelaySendStatus).recipientNpub === partnerNpub) {
              $$renderer3.push("<!--[-->");
              $$renderer3.push(`<div class="typ-meta mt-0.5 text-right text-blue-100">`);
              if (store_get($$store_subs ??= {}, "$lastRelaySendStatus", lastRelaySendStatus).successfulRelays === 0) {
                $$renderer3.push("<!--[-->");
                $$renderer3.push(`${escape_html(store_get($$store_subs ??= {}, "$t", $format)("chat.relayStatus.sending"))}`);
              } else {
                $$renderer3.push("<!--[!-->");
                $$renderer3.push(`${escape_html(get($format)("chat.relayStatus.sentToRelays", {
                  values: {
                    successful: store_get($$store_subs ??= {}, "$lastRelaySendStatus", lastRelaySendStatus).successfulRelays,
                    desired: store_get($$store_subs ??= {}, "$lastRelaySendStatus", lastRelaySendStatus).desiredRelays
                  }
                }))}`);
              }
              $$renderer3.push(`<!--]--></div>`);
            } else {
              $$renderer3.push("<!--[!-->");
              if (msg.eventId && msg.eventId.startsWith("optimistic:")) {
                $$renderer3.push("<!--[-->");
                $$renderer3.push(`<div class="typ-meta mt-0.5 text-right text-blue-100">${escape_html(store_get($$store_subs ??= {}, "$t", $format)("chat.relayStatus.sending"))}</div>`);
              } else {
                $$renderer3.push("<!--[!-->");
              }
              $$renderer3.push(`<!--]-->`);
            }
            $$renderer3.push(`<!--]-->`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--></div> `);
          if (msg.direction === "sent" && store_get($$store_subs ??= {}, "$currentUser", currentUser)) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<button class="mb-1 hover:opacity-80 transition-opacity duration-150 ease-out cursor-pointer">`);
            Avatar($$renderer3, {
              npub: store_get($$store_subs ??= {}, "$currentUser", currentUser).npub,
              src: myPicture,
              size: "md",
              class: `${useSmallAvatars ? "!w-10 !h-10" : "!w-14 !h-14"} md:!w-10 md:!h-10 transition-all duration-150 ease-out`
            });
            $$renderer3.push(`<!----></button>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]-->`);
      }
      $$renderer3.push(`<!--]--></div> <div class="absolute bottom-0 left-0 right-0 z-20 p-4 border-t border-gray-200/50 dark:border-slate-700/70 bg-white/80 dark:bg-slate-900/80 backdrop-blur-xl shadow-lg transition-all duration-150 ease-out"><form class="flex gap-3 items-end relative">`);
      {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <div class="flex-1 flex items-center bg-white/90 dark:bg-slate-800/90 border border-gray-200 dark:border-slate-700 rounded-3xl px-4 py-1.5 gap-2 shadow-inner focus-within:ring-2 focus-within:ring-blue-500/50 transition-all">`);
      MediaUploadButton($$renderer3, {
        variant: "chat"
      });
      $$renderer3.push(`<!----> <textarea${attr("disabled", isSending, true)} rows="1" class="flex-1 bg-transparent border-0 focus:outline-none focus:ring-0 text-sm md:text-base dark:text-white disabled:opacity-50 resize-none overflow-hidden placeholder:text-gray-400 dark:placeholder:text-slate-500 py-1"${attr("placeholder", store_get($$store_subs ??= {}, "$t", $format)("chat.inputPlaceholder"))}>`);
      const $$body = escape_html(inputText);
      if ($$body) {
        $$renderer3.push(`${$$body}`);
      }
      $$renderer3.push(`</textarea> `);
      if (inputText.trim().length > 0) {
        $$renderer3.push("<!--[-->");
        Button($$renderer3, {
          type: "submit",
          variant: "primary",
          size: "icon",
          class: "hidden md:inline-flex flex-shrink-0",
          disabled: isSending,
          "aria-label": "Send message",
          children: ($$renderer4) => {
            $$renderer4.push(`<svg viewBox="0 0 24 24" class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="9 6 15 12 9 18"></polyline></svg>`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div></form></div></div> `);
      ContextMenu($$renderer3, {
        isOpen: contextMenu.isOpen
      });
      $$renderer3.push(`<!---->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let messages = [];
    let currentPartner = page.params.npub;
    let isFetchingHistory = false;
    let cacheExhausted = false;
    let networkHistoryStatus = "idle";
    let networkHistorySummary = null;
    const canRequestNetworkHistory = cacheExhausted;
    $$renderer2.push(`<!---->`);
    {
      ChatView($$renderer2, {
        messages,
        partnerNpub: currentPartner,
        isFetchingHistory,
        canRequestNetworkHistory,
        networkHistoryStatus,
        networkHistorySummary
      });
    }
    $$renderer2.push(`<!---->`);
  });
}
export {
  _page as default
};
