import { Capacitor } from "@capacitor/core";
import "@capacitor/dialog";
import "@capacitor/share";
import { f as attributes, c as clsx, a as attr_class, b as attr } from "./index2.js";
import "@capacitor/haptics";
import "./AndroidTapSound.js";
function isAndroidNative() {
  if (typeof window === "undefined") {
    return false;
  }
  try {
    return Capacitor.getPlatform() === "android";
  } catch {
    return false;
  }
}
function isMobileWeb() {
  if (typeof window === "undefined") {
    return false;
  }
  const isSmallScreen = window.innerWidth <= 768;
  const ua = typeof navigator !== "undefined" ? navigator.userAgent || "" : "";
  const isMobileUa = /Android|iPhone|iPad|iPod/i.test(ua);
  return !isAndroidNative() && (isSmallScreen || isMobileUa);
}
function Button($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      variant = "filled-tonal",
      size = "md",
      disabled = false,
      loading = false,
      href = void 0,
      onclick = void 0,
      type = "button",
      class: className = "",
      children,
      $$slots,
      $$events,
      ...rest
    } = $$props;
    const baseStyles = "inline-flex items-center justify-center rounded-full font-semibold transition-all duration-200 ease-out disabled:opacity-50 disabled:pointer-events-none focus:outline-none focus-visible:ring-2 focus-visible:ring-[rgb(var(--color-lavender-rgb)/0.45)] focus-visible:ring-inset";
    const variants = {
      "filled-tonal": "bg-[rgb(var(--color-lavender-rgb)/0.20)] dark:bg-[rgb(var(--color-lavender-rgb)/0.24)] text-[rgb(var(--color-text-rgb)/0.92)] shadow-sm hover:shadow hover:bg-[rgb(var(--color-lavender-rgb)/0.26)] dark:hover:bg-[rgb(var(--color-lavender-rgb)/0.30)] active:bg-[rgb(var(--color-lavender-rgb)/0.32)] dark:active:bg-[rgb(var(--color-lavender-rgb)/0.36)]",
      primary: "bg-[rgb(var(--color-lavender-rgb))] text-white dark:text-[rgb(var(--color-crust-rgb))] shadow-md hover:bg-[rgb(var(--color-lavender-rgb)/0.9)] active:bg-[rgb(var(--color-lavender-rgb)/0.8)] hover:shadow-lg",
      ghost: "bg-transparent text-gray-500 dark:text-gray-400 hover:bg-blue-500/5 dark:hover:bg-blue-500/10 active:bg-blue-500/10 dark:active:bg-blue-500/20 hover:text-gray-900 dark:hover:text-white border border-transparent focus-visible:ring-[rgb(var(--color-lavender-rgb)/0.45)] focus-visible:ring-inset",
      danger: "bg-[rgb(var(--color-red-rgb))] text-white dark:text-[rgb(var(--color-crust-rgb))] shadow-md hover:bg-[rgb(var(--color-red-rgb)/0.9)] active:bg-[rgb(var(--color-red-rgb)/0.8)] hover:shadow-lg"
    };
    const sizes = {
      sm: "h-8 px-3 text-xs",
      md: "h-11 px-5 text-sm",
      lg: "h-12 px-6 text-base",
      icon: "h-11 w-11 p-0"
    };
    let classes = `${baseStyles} ${variants[variant]} ${sizes[size]} ${className}`;
    if (href) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<a${attributes({ href, class: clsx(classes), ...rest })}>`);
      if (loading) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<svg class="animate-spin -ml-1 mr-2 h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4z"></path></svg>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      children?.($$renderer2);
      $$renderer2.push(`<!----></a>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<button${attributes({ type, class: clsx(classes), disabled, ...rest })}>`);
      if (loading) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<svg class="animate-spin -ml-1 mr-2 h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4z"></path></svg>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      children?.($$renderer2);
      $$renderer2.push(`<!----></button>`);
    }
    $$renderer2.push(`<!--]-->`);
  });
}
function Avatar($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { src, npub, size = "md", class: className = "" } = $$props;
    const robotUrl = `https://robohash.org/${npub.slice(-10)}.png?set=set1&bgset=bg2`;
    const finalSrc = src ? src : robotUrl;
    const sizeClasses = {
      sm: "w-8 h-8",
      md: "w-10 h-10",
      lg: "w-16 h-16",
      xl: "w-24 h-24",
      "2xl": "w-32 h-32"
    };
    $$renderer2.push(`<div${attr_class(`${sizeClasses[size]} ${className} rounded-full ring-2 ring-white/50 dark:ring-white/10 overflow-hidden flex-shrink-0 bg-gray-200 dark:bg-slate-700 shadow-sm`)}><img${attr("src", finalSrc)} alt="Avatar" class="w-full h-full object-cover" onerror="this.__e=event"/></div>`);
  });
}
export {
  Avatar as A,
  Button as B,
  isMobileWeb as a,
  isAndroidNative as i
};
