package com.nononsenseapps.feeder.di

import com.nononsenseapps.feeder.archmodel.FeedItemStore
import com.nononsenseapps.feeder.archmodel.FeedStore
import com.nononsenseapps.feeder.archmodel.FontStore
import com.nononsenseapps.feeder.archmodel.OpenAISettings
import com.nononsenseapps.feeder.archmodel.Repository
import com.nononsenseapps.feeder.archmodel.SessionStore
import com.nononsenseapps.feeder.archmodel.SettingsStore
import com.nononsenseapps.feeder.archmodel.SyncRemoteStore
import com.nononsenseapps.feeder.base.bindWithActivityViewModelScope
import com.nononsenseapps.feeder.base.bindWithComposableViewModelScope
import com.nononsenseapps.feeder.model.OPMLParserHandler
import com.nononsenseapps.feeder.model.opml.OPMLImporter
import com.nononsenseapps.feeder.openai.OpenAIApi
import com.nononsenseapps.feeder.openai.OpenAIClient
import com.nononsenseapps.feeder.openai.OpenAIClientDefault
import com.nononsenseapps.feeder.ui.CommonActivityViewModel
import com.nononsenseapps.feeder.ui.MainActivityViewModel
import com.nononsenseapps.feeder.ui.NavigationDeepLinkViewModel
import com.nononsenseapps.feeder.ui.OpenLinkInDefaultActivityViewModel
import com.nononsenseapps.feeder.ui.compose.editfeed.CreateFeedScreenViewModel
import com.nononsenseapps.feeder.ui.compose.editfeed.EditFeedScreenViewModel
import com.nononsenseapps.feeder.ui.compose.feedarticle.ArticleViewModel
import com.nononsenseapps.feeder.ui.compose.feedarticle.FeedViewModel
import com.nononsenseapps.feeder.ui.compose.searchfeed.SearchFeedViewModel
import com.nononsenseapps.feeder.ui.compose.settings.SettingsViewModel
import com.nononsenseapps.feeder.ui.compose.settings.TextSettingsViewModel
import org.kodein.di.DI
import org.kodein.di.bind
import org.kodein.di.bindFactory
import org.kodein.di.factory
import org.kodein.di.instance
import org.kodein.di.singleton
import java.util.Locale

val archModelModule =
    DI.Module(name = "arch models") {
        bind<Repository>() with singleton { Repository(di) }
        bind<SessionStore>() with singleton { SessionStore() }
        bind<SettingsStore>() with singleton { SettingsStore(di) }
        bind<FeedStore>() with singleton { FeedStore(di) }
        bind<FontStore>() with singleton { FontStore(di) }
        bind<FeedItemStore>() with singleton { FeedItemStore(di) }
        bind<SyncRemoteStore>() with singleton { SyncRemoteStore(di) }
        bind<OPMLParserHandler>() with singleton { OPMLImporter(di) }
        bindFactory<OpenAISettings, OpenAIClient> { settings -> OpenAIClientDefault(settings) }
        bind<OpenAIApi>() with singleton { OpenAIApi(instance(), appLang = Locale.getDefault().getISO3Language(), factory()) }

        bindWithActivityViewModelScope<MainActivityViewModel>()
        bindWithActivityViewModelScope<OpenLinkInDefaultActivityViewModel>()
        bindWithActivityViewModelScope<CommonActivityViewModel>()

        bindWithComposableViewModelScope<SettingsViewModel>()
        bindWithComposableViewModelScope<EditFeedScreenViewModel>()
        bindWithComposableViewModelScope<CreateFeedScreenViewModel>()
        bindWithComposableViewModelScope<SearchFeedViewModel>()
        bindWithComposableViewModelScope<ArticleViewModel>()
        bindWithComposableViewModelScope<FeedViewModel>()
        bindWithComposableViewModelScope<NavigationDeepLinkViewModel>()
        bindWithComposableViewModelScope<TextSettingsViewModel>()
    }
