# Security Policy

This file contains some policies about the security reports on DoliDroid project, the mobile aplication of one of the popular Open Source ERP and CRM.

## Supported Versions for security reports

Security report are valid only on current stable version or on development version (branch "develop" on https://github.com/DoliCloud/DoliDroid).

## Reporting a Vulnerability

To report a vulnerability, for a private report, you can:

- Or if you have permissions, use GitHub security advisory at [https://github.com/DoliCloud/DoliDroid/security/advisories/new](https://github.com/DoliCloud/DoliDroid/security/advisories/new)
- Or send by email to security@dolicloud.com a clear textual description of the report along with steps to reproduce the issue, include attachments such as screenshots or proof of concept code as necessary

## Hunting vulnerabilities on Dolibarr

We believe that the future of software is online SaaS. This means software are more and more critical and no technology is perfect. Working with skilled security researchers is crucial in identifying weaknesses in our technology.

If you believe you've found a security bug in our service, we are happy to work with you to resolve the issue promptly and ensure you are fairly rewarded for your discovery.

Any type of denial-of-service attack is strictly forbidden, as well as any interference with network equipment and Dolibarr infrastructure.


### Account access

You can install the web application (needed for DoliDroid to connect to) yourself on your own platform/server so you get full access to application and sources. Download the zip of the files to put in your own web server virtual host from [https://www.dolibarr.org/download](https://www.dolibarr.org/download)

## Eligibility and Responsible Disclosure

We are happy to thank everyone who submits valid reports which help us improve the security of Dolibarr, however only those that meet the following eligibility requirements will be "validated reports" (if not, we may close the report without any answer):

You must be the first reporter of the vulnerability (duplicate reports are closed).

You must avoid tests that could cause degradation or interruption of our service (refrain from using automated tools, and limit yourself about requests per second), that's why we recommend to install software on your own platform.

You must not leak, manipulate, or destroy any user data of third parties to find your vulnerability.

Reports are processed around once a month.

