@file:Suppress("ktlint:filename")

package cash.z.ecc.sdk

import cash.z.ecc.android.sdk.Synchronizer
import cash.z.ecc.android.sdk.model.UnifiedSpendingKey
import cash.z.ecc.android.sdk.model.ZecSend

suspend fun Synchronizer.send(spendingKey: UnifiedSpendingKey, send: ZecSend) = createProposedTransactions(
    proposeTransfer(
        spendingKey.account,
        send.destination.address,
        send.amount,
        send.memo.value
    ),
    spendingKey
)
