package co.electriccoin.zcash.app

import co.electriccoin.zcash.spackle.StrictModeCompat
import co.electriccoin.zcash.spackle.Twig

@Suppress("unused")
class ZcashApplication : CoroutineApplication() {

    override fun onCreate() {
        super.onCreate()

        configureLogging()

        configureStrictMode()
    }

    private fun configureLogging() {
        Twig.initialize(applicationContext)
        Twig.debug { "Starting application…" }

        if (!BuildConfig.DEBUG) {
            // In release builds, logs should be stripped by R8 rules
            Twig.assertLoggingStripped()
        }
    }

    private fun configureStrictMode() {
        if (BuildConfig.DEBUG) {
            StrictModeCompat.enableStrictMode(BuildConfig.IS_STRICT_MODE_CRASH_ENABLED)
        }
    }
}
