/*
 * Nextcloud Talk - Android Client
 *
 * SPDX-FileCopyrightText: 2024 Daniel Calviño Sánchez <danxuliu@gmail.com>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package com.nextcloud.talk.models.json.signaling.settings

import android.os.Parcelable
import com.bluelinelabs.logansquare.annotation.JsonField
import com.bluelinelabs.logansquare.annotation.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.serialization.Serializable

@Parcelize
@JsonObject
@Serializable
data class FederationSettings(
    @JsonField(name = ["server"])
    var server: String? = null,
    @JsonField(name = ["nextcloudServer"])
    var nextcloudServer: String? = null,
    @JsonField(name = ["helloAuthParams"])
    var helloAuthParams: FederationHelloAuthParams? = null,
    @JsonField(name = ["roomId"])
    var roomId: String? = null
) : Parcelable {
    // This constructor is added to work with the 'com.bluelinelabs.logansquare.annotation.JsonObject'
    constructor() : this(null, null, null, null)
}
