/*
 * Nextcloud Talk - Android Client
 *
 * SPDX-FileCopyrightText: 2022 Andy Scherzinger <info@andy-scherzinger.de>
 * SPDX-FileCopyrightText: 2017 Mario Danic <mario@lovelyhq.com>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package com.nextcloud.talk.models.json.signaling

import android.os.Parcelable
import com.bluelinelabs.logansquare.annotation.JsonField
import com.bluelinelabs.logansquare.annotation.JsonObject
import com.nextcloud.talk.models.json.AnyParceler
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler

@Parcelize
@JsonObject
@TypeParceler<Any?, AnyParceler>
data class DataChannelMessage(
    @JsonField(name = ["type"])
    var type: String? = null,
    /** Can be String or Map<String, String>
     *  Use only for received messages */
    @JsonField(name = ["payload"])
    var payload: Any? = null,
    /** Use only to send messages */
    @JsonField(name = ["payload"])
    var payloadMap: Map<String, String>? = null
) : Parcelable {
    // This constructor is added to work with the 'com.bluelinelabs.logansquare.annotation.JsonObject'
    constructor() : this(null, null, null)
    constructor(type: String) : this(type, null)
}
