<!--
 ~ SPDX-FileCopyrightText: 2016-2024 Nextcloud GmbH and Nextcloud contributors
 ~ SPDX-License-Identifier: AGPL-3.0-or-later OR GPL-2.0-only
-->
# Security Policy

# 💡 TLDR: Report issues at [hackerone.com/nextcloud](https://hackerone.com/nextcloud)

# Security Policy

[Security](https://nextcloud.com/security/) is very important to us.

If you believe you have found a security vulnerability that meets our definition of a security
vulnerability, please report is as described below.

## Context

Please review our [threat model and accepted risks](https://nextcloud.com/security/threat-model) to learn what
is currently considered a security vulnerability versus expected behavior. And review what is considered
[in scope or bounty eligible](https://hackerone.com/nextcloud/policy_scopes).


## Reporting a Vulnerability

**⚠️ Please do _not_ report security vulnerabilities through public GitHub issues.**

If you have discovered a security matter with Nextcloud, please read our
[responsible disclosure guidelines](https://nextcloud.com/security/) and contact us at
[hackerone.com/nextcloud](https://hackerone.com/nextcloud).

Your report should include:

- Product version
- A vulnerability description
- Reproduction steps
- Any other details you think are likely to be important

### What to Expect

You should receive an initial acknowledgement within 24 hours in most cases.

A member of the security team will confirm the vulnerability, determine its impact, follow-up with any questions,
and coordinate the fix and publication.

The fix will be applied to all applicable and still supported stable branches, tested, and packaged in the next security release.
The vulnerability will be publicly announced after the release. Finally, your name will be added
to the [hall of fame](https://hackerone.com/nextcloud/thanks) as a thank you from the entire Nextcloud
community.

If the vulnerability involves an app that is not maintained by Nextcloud (i.e. hosted by the 
Nextcloud project but community maintained, or hosted elsewhere), the security team will try to coordinate with the
current maintainer and help to get the issue fixed in similar fashion.

### Bug Bounties

If you are reporting for a bug bounty, more complete reports can contribute to a higher bounty award. Details
on past bounty ranges can be found at [hackerone.com/nextcloud](https://hackerone.com/nextcloud).

## Existing Security Advisories

Published security advisories for the Nextcloud Server, Clients and Apps can be viewed at
[https://github.com/nextcloud/security-advisories/security/advisories](https://github.com/nextcloud/security-advisories/security/advisories).

## Supported Versions

Only the latest version is supported. We release every second month a feature release (currently 3.x) and inbetween a bug fix release (3.x.y).

## Additional Information

Please visit [https://nextcloud.com/security/](https://nextcloud.com/security/) for further information about Nextcloud security.
Please visit [https://nextcloud.com/security/threat-model](https://nextcloud.com/security/threat-model) for our threat model and accepted risks.
