## ☕ Cuppa

Cuppa is a small application to time your cup of tea as it steeps. Tired of leaving your tea too long, to become bitter and cold, or drinking it too soon and not appreciating its full potential? Then this utility is for you!

[![GitHub release (latest SemVer)](https://img.shields.io/github/v/release/ncosgray/cuppa_mobile?label=latest%20version&sort=semver)](https://github.com/ncosgray/cuppa_mobile/releases)
[![GitHub issues](https://img.shields.io/github/issues/ncosgray/cuppa_mobile?color=red)](https://github.com/ncosgray/cuppa_mobile/issues)
[![Weblate project translated](https://img.shields.io/weblate/progress/cuppa?color=green&server=https%3A%2F%2Fhosted.weblate.org)](https://hosted.weblate.org/engage/cuppa/)
[![GitHub license](https://img.shields.io/github/license/ncosgray/cuppa_mobile?color=lightgrey)](https://github.com/ncosgray/cuppa_mobile/blob/master/LICENSE.txt)

### Tea Timer App for iOS and Android

To make the app so quick and easy that you'll actually use it, we have built it with simplicity in mind. Just open the app and tap the button for the type of tea you're brewing. That's it. No need to navigate through complicated menus to find a particular tea, or fiddle with settings... unless you want to customize brew times or add your own favorite teas.

Once you tap, Cuppa will begin timing the brew and you'll see a teabag appear in the cup and gradually darken as the tea steeps. A countdown timer shows the steep time remaining. You can have up to two separate teas brewing at once, each with its own countdown timer. When the tea is done Cuppa will let you know with a notification -- depending on your device settings, this may be accompanied by a sound and/or vibration.

<img src="https://github.com/ncosgray/cuppa_mobile/blob/master/fastlane/metadata/android/en-US/images/phoneScreenshots/1.png" width="200"/>|<img src="https://github.com/ncosgray/cuppa_mobile/blob/master/fastlane/metadata/android/en-US/images/phoneScreenshots/2.png" width="200"/>|<img src="https://github.com/ncosgray/cuppa_mobile/blob/master/fastlane/metadata/android/en-US/images/phoneScreenshots/3.png" width="200"/>|<img src="https://github.com/ncosgray/cuppa_mobile/blob/master/fastlane/metadata/android/en-US/images/phoneScreenshots/4.png" width="200"/>|<img src="https://github.com/ncosgray/cuppa_mobile/blob/master/fastlane/metadata/android/en-US/images/phoneScreenshots/5.png" width="200"/>
-|-|-|-|-

### Install

| Android (5+) | iOS (16+) |
| :--: | :--: |
| <a href="https://play.google.com/store/apps/details?id=com.nathanatos.Cuppa"><img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png" alt="Get it on Google Play" width="206" height="80"/></a><br/><a href="https://f-droid.org/en/packages/com.nathanatos.Cuppa/"><img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" alt="Get it on F-Droid" width="206" height="80"/></a> | <a href="https://itunes.apple.com/us/app/cuppa-tea-timer/id1241458171"><img src="https://www.nathanatos.com/images/ios-app-store-badge.png" alt="Download on the App Store" width="168" height="50"/></a> |

### Join the Team

- Pull requests for new features or bugfixes are welcome.
- Chat in our [GitHub Discussions](https://github.com/ncosgray/cuppa_mobile/discussions) forum.
- Use [Weblate](https://hosted.weblate.org/engage/cuppa/) to contribute a translation for your language.

<a href="https://hosted.weblate.org/engage/cuppa/" target="_blank" rel="noopener"><img src="https://hosted.weblate.org/widgets/cuppa/-/open-graph.png" alt="Translation status" width="400"></a>

<details>
<summary>Translation status</summary>

#### Mobile app:

[![Mobile app](https://hosted.weblate.org/widgets/cuppa/-/cuppa-mobile-app/multi-auto.svg)](https://hosted.weblate.org/projects/cuppa/cuppa-mobile-app/)

#### Android app store description:

[![Android description](https://hosted.weblate.org/widgets/cuppa/-/cuppa-mobile-app-store-android/multi-auto.svg)](https://hosted.weblate.org/projects/cuppa/cuppa-mobile-app-store-android/)
</details>

### Support the Project

Buy us a cup of tea to support active development of Cuppa.

<a href="https://paypal.me/ncosgray"><img src="https://www.nathanatos.com/images/paypal-badge.png" alt="Donate with PayPal" width="185" height="50"/></a><br/>
<a href="https://venmo.com/nathancosgray"><img src="https://www.nathanatos.com/images/venmo-badge.png" alt="Donate with Venmo" width="185" height="50"/></a><br/>
<img src="https://www.nathanatos.com/images/ethereum-logo.png" alt="Ethereum Logo" width="15" height="25"/> <a href="ethereum:0xc5be97ea75ad15854ed09529139e672fae2f63c0">Ethereum: 0xc5be97ea75ad15854ed09529139e672fae2f63c0</a><br/>

### About

Cuppa Mobile is a free, open-source mobile app licensed under the terms of the BSD license and built on the [Flutter](https://flutter.dev) framework.

Author: [Nathan Cosgray](https://www.nathanatos.com)
