// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v25.5.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon

import Foundation

#if os(iOS)
  import Flutter
#elseif os(macOS)
  import FlutterMacOS
#else
  #error("Unsupported platform.")
#endif

/// Error class for passing custom error details to Dart side.
final class PigeonError: Error {
  let code: String
  let message: String?
  let details: Sendable?

  init(code: String, message: String?, details: Sendable?) {
    self.code = code
    self.message = message
    self.details = details
  }

  var localizedDescription: String {
    return
      "PigeonError(code: \(code), message: \(message ?? "<nil>"), details: \(details ?? "<nil>")"
  }
}

private func wrapResult(_ result: Any?) -> [Any?] {
  return [result]
}

private func wrapError(_ error: Any) -> [Any?] {
  if let pigeonError = error as? PigeonError {
    return [
      pigeonError.code,
      pigeonError.message,
      pigeonError.details,
    ]
  }
  if let flutterError = error as? FlutterError {
    return [
      flutterError.code,
      flutterError.message,
      flutterError.details,
    ]
  }
  return [
    "\(error)",
    "\(type(of: error))",
    "Stacktrace: \(Thread.callStackSymbols)",
  ]
}

private func createConnectionError(withChannelName channelName: String) -> PigeonError {
  return PigeonError(
    code: "channel-error", message: "Unable to establish connection on channel: '\(channelName)'.",
    details: "")
}

private func isNullish(_ value: Any?) -> Bool {
  return value is NSNull || value == nil
}

private func nilOrValue<T>(_ value: Any?) -> T? {
  if value is NSNull { return nil }
  return value as! T?
}

func deepEqualsmessages(_ lhs: Any?, _ rhs: Any?) -> Bool {
  let cleanLhs = nilOrValue(lhs) as Any?
  let cleanRhs = nilOrValue(rhs) as Any?
  switch (cleanLhs, cleanRhs) {
  case (nil, nil):
    return true

  case (nil, _), (_, nil):
    return false

  case is (Void, Void):
    return true

  case let (cleanLhsHashable, cleanRhsHashable) as (AnyHashable, AnyHashable):
    return cleanLhsHashable == cleanRhsHashable

  case let (cleanLhsArray, cleanRhsArray) as ([Any?], [Any?]):
    guard cleanLhsArray.count == cleanRhsArray.count else { return false }
    for (index, element) in cleanLhsArray.enumerated() {
      if !deepEqualsmessages(element, cleanRhsArray[index]) {
        return false
      }
    }
    return true

  case let (cleanLhsDictionary, cleanRhsDictionary) as ([AnyHashable: Any?], [AnyHashable: Any?]):
    guard cleanLhsDictionary.count == cleanRhsDictionary.count else { return false }
    for (key, cleanLhsValue) in cleanLhsDictionary {
      guard cleanRhsDictionary.index(forKey: key) != nil else { return false }
      if !deepEqualsmessages(cleanLhsValue, cleanRhsDictionary[key]!) {
        return false
      }
    }
    return true

  default:
    // Any other type shouldn't be able to be used with pigeon. File an issue if you find this to be untrue.
    return false
  }
}

func deepHashmessages(value: Any?, hasher: inout Hasher) {
  if let valueList = value as? [AnyHashable] {
    for item in valueList { deepHashmessages(value: item, hasher: &hasher) }
    return
  }

  if let valueDict = value as? [AnyHashable: AnyHashable] {
    for key in valueDict.keys {
      hasher.combine(key)
      deepHashmessages(value: valueDict[key]!, hasher: &hasher)
    }
    return
  }

  if let hashableValue = value as? AnyHashable {
    hasher.combine(hashableValue.hashValue)
  }

  return hasher.combine(String(describing: value))
}

/// Home screen quick-action shortcut item.
///
/// Generated class from Pigeon that represents data sent in messages.
struct ShortcutItemMessage: Hashable {
  /// The identifier of this item; should be unique within the app.
  var type: String
  /// Localized title of the item.
  var localizedTitle: String
  /// Localized subtitle of the item.
  var localizedSubtitle: String? = nil
  /// Name of native resource to be displayed as the icon for this item.
  var icon: String? = nil

  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> ShortcutItemMessage? {
    let type = pigeonVar_list[0] as! String
    let localizedTitle = pigeonVar_list[1] as! String
    let localizedSubtitle: String? = nilOrValue(pigeonVar_list[2])
    let icon: String? = nilOrValue(pigeonVar_list[3])

    return ShortcutItemMessage(
      type: type,
      localizedTitle: localizedTitle,
      localizedSubtitle: localizedSubtitle,
      icon: icon
    )
  }
  func toList() -> [Any?] {
    return [
      type,
      localizedTitle,
      localizedSubtitle,
      icon,
    ]
  }
  static func == (lhs: ShortcutItemMessage, rhs: ShortcutItemMessage) -> Bool {
    return deepEqualsmessages(lhs.toList(), rhs.toList())
  }
  func hash(into hasher: inout Hasher) {
    deepHashmessages(value: toList(), hasher: &hasher)
  }
}

private class MessagesPigeonCodecReader: FlutterStandardReader {
  override func readValue(ofType type: UInt8) -> Any? {
    switch type {
    case 129:
      return ShortcutItemMessage.fromList(self.readValue() as! [Any?])
    default:
      return super.readValue(ofType: type)
    }
  }
}

private class MessagesPigeonCodecWriter: FlutterStandardWriter {
  override func writeValue(_ value: Any) {
    if let value = value as? ShortcutItemMessage {
      super.writeByte(129)
      super.writeValue(value.toList())
    } else {
      super.writeValue(value)
    }
  }
}

private class MessagesPigeonCodecReaderWriter: FlutterStandardReaderWriter {
  override func reader(with data: Data) -> FlutterStandardReader {
    return MessagesPigeonCodecReader(data: data)
  }

  override func writer(with data: NSMutableData) -> FlutterStandardWriter {
    return MessagesPigeonCodecWriter(data: data)
  }
}

class MessagesPigeonCodec: FlutterStandardMessageCodec, @unchecked Sendable {
  static let shared = MessagesPigeonCodec(readerWriter: MessagesPigeonCodecReaderWriter())
}

/// Generated protocol from Pigeon that represents a handler of messages from Flutter.
protocol IOSQuickActionsApi {
  /// Sets the dynamic shortcuts for the app.
  func setShortcutItems(itemsList: [ShortcutItemMessage]) throws
  /// Removes all dynamic shortcuts.
  func clearShortcutItems() throws
}

/// Generated setup class from Pigeon to handle messages through the `binaryMessenger`.
class IOSQuickActionsApiSetup {
  static var codec: FlutterStandardMessageCodec { MessagesPigeonCodec.shared }
  /// Sets up an instance of `IOSQuickActionsApi` to handle messages through the `binaryMessenger`.
  static func setUp(
    binaryMessenger: FlutterBinaryMessenger, api: IOSQuickActionsApi?,
    messageChannelSuffix: String = ""
  ) {
    let channelSuffix = messageChannelSuffix.count > 0 ? ".\(messageChannelSuffix)" : ""
    /// Sets the dynamic shortcuts for the app.
    let setShortcutItemsChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.quick_actions_ios.IOSQuickActionsApi.setShortcutItems\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      setShortcutItemsChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let itemsListArg = args[0] as! [ShortcutItemMessage]
        do {
          try api.setShortcutItems(itemsList: itemsListArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      setShortcutItemsChannel.setMessageHandler(nil)
    }
    /// Removes all dynamic shortcuts.
    let clearShortcutItemsChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.quick_actions_ios.IOSQuickActionsApi.clearShortcutItems\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      clearShortcutItemsChannel.setMessageHandler { _, reply in
        do {
          try api.clearShortcutItems()
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      clearShortcutItemsChannel.setMessageHandler(nil)
    }
  }
}
/// Generated protocol from Pigeon that represents Flutter messages that can be called from Swift.
protocol IOSQuickActionsFlutterApiProtocol {
  /// Sends a string representing a shortcut from the native platform to the app.
  func launchAction(
    action actionArg: String, completion: @escaping (Result<Void, PigeonError>) -> Void)
}
class IOSQuickActionsFlutterApi: IOSQuickActionsFlutterApiProtocol {
  private let binaryMessenger: FlutterBinaryMessenger
  private let messageChannelSuffix: String
  init(binaryMessenger: FlutterBinaryMessenger, messageChannelSuffix: String = "") {
    self.binaryMessenger = binaryMessenger
    self.messageChannelSuffix = messageChannelSuffix.count > 0 ? ".\(messageChannelSuffix)" : ""
  }
  var codec: MessagesPigeonCodec {
    return MessagesPigeonCodec.shared
  }
  /// Sends a string representing a shortcut from the native platform to the app.
  func launchAction(
    action actionArg: String, completion: @escaping (Result<Void, PigeonError>) -> Void
  ) {
    let channelName: String =
      "dev.flutter.pigeon.quick_actions_ios.IOSQuickActionsFlutterApi.launchAction\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(
      name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([actionArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        completion(.success(()))
      }
    }
  }
}
