<p align="center">
  <img src="fastlane/metadata/android/en-US/images/icon.png" width="150" />
</p>

<h1 align="center"><b>🧭 MBCompass</b></h1>
<h3 align="center">Modern FOSS Compass and Navigation app for Android</h3>

<p align="center"> 
  <a href="https://www.gnu.org/licenses/gpl-3.0">
    <img src="https://img.shields.io/badge/license-GPL%20v3-2B6DBE.svg?style=for-the-badge" alt="GPLv3 License"/>
  </a>
  <a href="https://github.com/MubarakNative/MBCompass/releases">
    <img src="https://img.shields.io/github/v/release/MubarakNative/MBCompass?include_prereleases&color=4B95DE&style=for-the-badge" alt="Latest Release"/>
  </a>
  <a href="https://apilevels.com/">
    <img src="https://img.shields.io/badge/API-21%2B-1450A8?style=for-the-badge" alt="Min API"/>
  </a>
</p>

<h4 align="center">
  <a href="https://mubaraknative.github.io/">Author</a> | 
  <a href="https://github.com/MubarakNative/MBCompass/blob/main/LICENSE">License</a>
</h4>

<div align="center" style="display: flex; justify-content: center; align-items: flex-start; flex-wrap: wrap;">
  <a href="https://f-droid.org/app/com.mubarak.mbcompass">
    <img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" width="170" alt="Get it on F-Droid"/>
  </a>
  <a href="https://github.com/CompassMB/MBCompass/wiki/Installing-MBCompass-from-GitHub-using-Obtainium">
    <img src="https://raw.githubusercontent.com/MubarakNative/mb-icons-pack/refs/heads/main/obt_badge.png" width="170" alt="Get it on Obtainium" />
  </a>
  <a href="https://apt.izzysoft.de/fdroid/index/apk/com.mubarak.mbcompass">
    <img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png" height="64" alt="Get it on IzzyOnDroid" />
  </a>
</div>

## About

**MBCompass** is a modern, free, and open-source compass and navigation app without **ads**, **IAP**, or **tracking**. Built with **Jetpack Compose**, it supports compass and navigation features while being **lightweight** and simple.

> Not just a compass. Not a map app.
>
> MBCompass bridges the gap between a **compass** and a **full navigation app** - shows direction and live location without using hundreds of MBs of storage or privacy trade-offs.

---

<p align="center">
  <img width="400" src="fastlane/metadata/android/en-US/images/phoneScreenshots/1.png" />
  <img width="400" src="fastlane/metadata/android/en-US/images/phoneScreenshots/2.png" />
</p>
<p align="center">
  <img width="400" src="fastlane/metadata/android/en-US/images/phoneScreenshots/3.png" />
  <img width="400" src="fastlane/metadata/android/en-US/images/phoneScreenshots/4.png" />
</p>

## Features

- Shows clear cardinal direction and magnetic azimuths.
- Displays magnetic strength in µT.
- Live GPS location tracking on OpenStreetMap.
- Sensor fusion for improved accuracy (accelerometer, magnetometer, gyroscope).
- Light and dark theme support controlled via Settings.
- Keeps screen on during navigation.
- Landscape orientation support.
- Built with Jetpack Compose and Material Design.
- Runs on Android 5.0+
- No ads, no in-app purchases, no tracking.
- [Find more on the website](https://compassmb.github.io/MBCompass-site/#features)

## Recognition

MBCompass has gained recognition from the global developer community:

-  #13 Product of the Day on Product Hunt
-  Featured in two consecutive issues of Android Weekly
-  Reached the front page of Hacker News

[See full highlights](./Featured.md)


##  Permissions

- Location permission is only used to detect the current location on the map.

##  Contributing

Contributions are welcome! If you encounter bugs or have feature suggestions, please open an issue or submit a pull request. See [Contributing Guidelines](CONTRIBUTING.md) for details.

## Support

Open-source projects couldn't survive in the long run without donations or funding.

MBCompass is a fully open-source project - free of ads, trackers, or in-app purchases.
If you find it useful, consider supporting its continued development and maintenance:

Find more info on [MBCompass page](https://compassmb.github.io/MBCompass-site/donate.html)

Your support helps ensure the project stays sustainable and continues to improve for everyone. Thank you!

## License

[![GNU GPLv3 Image](https://www.gnu.org/graphics/gplv3-127x51.png)](http://www.gnu.org/licenses/gpl-3.0.en.html)

MBCompass is Free Software: you can use, study, share, and improve it at your will. You may use, modify, and redistribute this project only if your modifications remain open-source under the same license.

> Proprietary use, commercial redistribution, or publishing modified versions with ads or tracking is strictly prohibited under GPLv3 or later.

See more information [here](https://github.com/MubarakNative/MBCompass/blob/main/LICENSE).

###  Artwork License:
Compass rose : [MBCompass rose](https://github.com/MubarakNative/MBCompass/blob/main/app/src/main/res/drawable/mbcompass_rose.xml) © 2025 by [Mubarak Basha](https://mubaraknative.github.io) is licensed under CC BY-SA 4.0