#ifndef LIB_UTILS_HANNING_H_
#define LIB_UTILS_HANNING_H_

constexpr double HANNIG_MATRIX[] = {
    0.0000023508, 0.0000094032, 0.0000211571, 0.0000376123, 0.0000587689, 0.0000846264,
    0.0001151848, 0.0001504437, 0.0001904028, 0.0002350617, 0.0002844199, 0.0003384771,
    0.0003972327, 0.0004606862, 0.0005288369, 0.0006016843, 0.0006792276, 0.0007614661,
    0.0008483991, 0.0009400256, 0.0010363449, 0.0011373561, 0.0012430582, 0.0013534502,
    0.0014685311, 0.0015882997, 0.0017127550, 0.0018418958, 0.0019757209, 0.0021142290,
    0.0022574189, 0.0024052891, 0.0025578382, 0.0027150650, 0.0028769677, 0.0030435451,
    0.0032147954, 0.0033907171, 0.0035713085, 0.0037565679, 0.0039464936, 0.0041410837,
    0.0043403366, 0.0045442502, 0.0047528227, 0.0049660521, 0.0051839364, 0.0054064735,
    0.0056336614, 0.0058654980, 0.0061019809, 0.0063431081, 0.0065888773, 0.0068392860,
    0.0070943321, 0.0073540131, 0.0076183265, 0.0078872699, 0.0081608407, 0.0084390363,
    0.0087218542, 0.0090092917, 0.0093013461, 0.0095980146, 0.0098992944, 0.0102051828,
    0.0105156768, 0.0108307735, 0.0111504700, 0.0114747632, 0.0118036501, 0.0121371277,
    0.0124751927, 0.0128178420, 0.0131650723, 0.0135168805, 0.0138732631, 0.0142342169,
    0.0145997385, 0.0149698243, 0.0153444710, 0.0157236751, 0.0161074328, 0.0164957407,
    0.0168885951, 0.0172859922, 0.0176879285, 0.0180944000, 0.0185054029, 0.0189209335,
    0.0193409877, 0.0197655616, 0.0201946513, 0.0206282527, 0.0210663617, 0.0215089742,
    0.0219560861, 0.0224076931, 0.0228637910, 0.0233243755, 0.0237894423, 0.0242589870,
    0.0247330052, 0.0252114924, 0.0256944441, 0.0261818558, 0.0266737229, 0.0271700408,
    0.0276708049, 0.0281760103, 0.0286856523, 0.0291997263, 0.0297182272, 0.0302411503,
    0.0307684907, 0.0313002433, 0.0318364032, 0.0323769653, 0.0329219246, 0.0334712759,
    0.0340250141, 0.0345831339, 0.0351456301, 0.0357124975, 0.0362837306, 0.0368593242,
    0.0374392727, 0.0380235708, 0.0386122130, 0.0392051936, 0.0398025073, 0.0404041482,
    0.0410101108, 0.0416203894, 0.0422349782, 0.0428538715, 0.0434770634, 0.0441045481,
    0.0447363196, 0.0453723721, 0.0460126996, 0.0466572959, 0.0473061552, 0.0479592712,
    0.0486166378, 0.0492782489, 0.0499440982, 0.0506141795, 0.0512884865, 0.0519670127,
    0.0526497519, 0.0533366976, 0.0540278434, 0.0547231828, 0.0554227092, 0.0561264160,
    0.0568342966, 0.0575463445, 0.0582625528, 0.0589829148, 0.0597074238, 0.0604360730,
    0.0611688555, 0.0619057644, 0.0626467928, 0.0633919337, 0.0641411801, 0.0648945250,
    0.0656519612, 0.0664134817, 0.0671790793, 0.0679487469, 0.0687224770, 0.0695002626,
    0.0702820963, 0.0710679706, 0.0718578783, 0.0726518119, 0.0734497639, 0.0742517269,
    0.0750576933, 0.0758676555, 0.0766816058, 0.0774995368, 0.0783214406, 0.0791473095,
    0.0799771357, 0.0808109116, 0.0816486291, 0.0824902805, 0.0833358578, 0.0841853531,
    0.0850387583, 0.0858960656, 0.0867572667, 0.0876223536, 0.0884913182, 0.0893641523,
    0.0902408477, 0.0911213962, 0.0920057894, 0.0928940190, 0.0937860768, 0.0946819542,
    0.0955816430, 0.0964851345, 0.0973924204, 0.0983034921, 0.0992183410, 0.1001369586,
    0.1010593361, 0.1019854650, 0.1029153364, 0.1038489418, 0.1047862722, 0.1057273189,
    0.1066720730, 0.1076205257, 0.1085726679, 0.1095284909, 0.1104879855, 0.1114511428,
    0.1124179537, 0.1133884090, 0.1143624998, 0.1153402168, 0.1163215508, 0.1173064927,
    0.1182950331, 0.1192871627, 0.1202828722, 0.1212821523, 0.1222849936, 0.1232913866,
    0.1243013218, 0.1253147898, 0.1263317811, 0.1273522860, 0.1283762950, 0.1294037985,
    0.1304347867, 0.1314692500, 0.1325071788, 0.1335485631, 0.1345933932, 0.1356416593,
    0.1366933516, 0.1377484601, 0.1388069749, 0.1398688861, 0.1409341836, 0.1420028576,
    0.1430748978, 0.1441502943, 0.1452290369, 0.1463111155, 0.1473965199, 0.1484852399,
    0.1495772653, 0.1506725857, 0.1517711910, 0.1528730707, 0.1539782145, 0.1550866121,
    0.1561982529, 0.1573131265, 0.1584312225, 0.1595525304, 0.1606770395, 0.1618047394,
    0.1629356193, 0.1640696688, 0.1652068770, 0.1663472334, 0.1674907272, 0.1686373477,
    0.1697870840, 0.1709399254, 0.1720958610, 0.1732548799, 0.1744169713, 0.1755821242,
    0.1767503277, 0.1779215707, 0.1790958423, 0.1802731315, 0.1814534271, 0.1826367180,
    0.1838229932, 0.1850122415, 0.1862044516, 0.1873996124, 0.1885977127, 0.1897987412,
    0.1910026865, 0.1922095374, 0.1934192825, 0.1946319104, 0.1958474098, 0.1970657692,
    0.1982869772, 0.1995110222, 0.2007378927, 0.2019675773, 0.2032000643, 0.2044353422,
    0.2056733994, 0.2069142242, 0.2081578049, 0.2094041298, 0.2106531873, 0.2119049656,
    0.2131594529, 0.2144166374, 0.2156765073, 0.2169390508, 0.2182042559, 0.2194721108,
    0.2207426036, 0.2220157223, 0.2232914549, 0.2245697895, 0.2258507140, 0.2271342163,
    0.2284202845, 0.2297089064, 0.2310000699, 0.2322937629, 0.2335899731, 0.2348886885,
    0.2361898967, 0.2374935856, 0.2387997429, 0.2401083564, 0.2414194136, 0.2427329023,
    0.2440488102, 0.2453671248, 0.2466878338, 0.2480109247, 0.2493363851, 0.2506642026,
    0.2519943646, 0.2533268587, 0.2546616722, 0.2559987928, 0.2573382077, 0.2586799044,
    0.2600238703, 0.2613700928, 0.2627185591, 0.2640692567, 0.2654221727, 0.2667772945,
    0.2681346094, 0.2694941045, 0.2708557672, 0.2722195845, 0.2735855437, 0.2749536319,
    0.2763238362, 0.2776961439, 0.2790705418, 0.2804470173, 0.2818255572, 0.2832061487,
    0.2845887787, 0.2859734343, 0.2873601024, 0.2887487700, 0.2901394241, 0.2915320515,
    0.2929266392, 0.2943231740, 0.2957216428, 0.2971220325, 0.2985243300, 0.2999285219,
    0.3013345951, 0.3027425364, 0.3041523326, 0.3055639704, 0.3069774365, 0.3083927176,
    0.3098098005, 0.3112286717, 0.3126493180, 0.3140717260, 0.3154958823, 0.3169217735,
    0.3183493863, 0.3197787071, 0.3212097227, 0.3226424194, 0.3240767838, 0.3255128025,
    0.3269504619, 0.3283897485, 0.3298306489, 0.3312731493, 0.3327172363, 0.3341628964,
    0.3356101158, 0.3370588810, 0.3385091784, 0.3399609943, 0.3414143150, 0.3428691270,
    0.3443254166, 0.3457831699, 0.3472423734, 0.3487030133, 0.3501650759, 0.3516285474,
    0.3530934141, 0.3545596622, 0.3560272778, 0.3574962473, 0.3589665568, 0.3604381924,
    0.3619111404, 0.3633853868, 0.3648609179, 0.3663377196, 0.3678157783, 0.3692950799,
    0.3707756105, 0.3722573563, 0.3737403032, 0.3752244374, 0.3767097449, 0.3781962117,
    0.3796838239, 0.3811725674, 0.3826624282, 0.3841533924, 0.3856454460, 0.3871385748,
    0.3886327649, 0.3901280022, 0.3916242727, 0.3931215622, 0.3946198567, 0.3961191422,
    0.3976194044, 0.3991206294, 0.4006228029, 0.4021259109, 0.4036299393, 0.4051348738,
    0.4066407004, 0.4081474048, 0.4096549729, 0.4111633906, 0.4126726436, 0.4141827178,
    0.4156935990, 0.4172052728, 0.4187177253, 0.4202309420, 0.4217449088, 0.4232596115,
    0.4247750358, 0.4262911674, 0.4278079921, 0.4293254957, 0.4308436638, 0.4323624822,
    0.4338819366, 0.4354020128, 0.4369226964, 0.4384439731, 0.4399658286, 0.4414882486,
    0.4430112189, 0.4445347250, 0.4460587526, 0.4475832875, 0.4491083153, 0.4506338216,
    0.4521597921, 0.4536862125, 0.4552130684, 0.4567403454, 0.4582680291, 0.4597961053,
    0.4613245596, 0.4628533775, 0.4643825447, 0.4659120468, 0.4674418695, 0.4689719983,
    0.4705024189, 0.4720331168, 0.4735640778, 0.4750952873, 0.4766267310, 0.4781583944,
    0.4796902633, 0.4812223231, 0.4827545595, 0.4842869581, 0.4858195044, 0.4873521841,
    0.4888849827, 0.4904178858, 0.4919508790, 0.4934839479, 0.4950170780, 0.4965502551,
    0.4980834645, 0.4996166920, 0.5011499231, 0.5026831434, 0.5042163384, 0.5057494938,
    0.5072825951, 0.5088156280, 0.5103485780, 0.5118814306, 0.5134141715, 0.5149467863,
    0.5164792606, 0.5180115799, 0.5195437298, 0.5210756959, 0.5226074639, 0.5241390193,
    0.5256703477, 0.5272014347, 0.5287322659, 0.5302628270, 0.5317931035, 0.5333230810,
    0.5348527452, 0.5363820817, 0.5379110760, 0.5394397139, 0.5409679809, 0.5424958627,
    0.5440233449, 0.5455504131, 0.5470770530, 0.5486032503, 0.5501289905, 0.5516542593,
    0.5531790424, 0.5547033255, 0.5562270942, 0.5577503341, 0.5592730311, 0.5607951706,
    0.5623167385, 0.5638377205, 0.5653581021, 0.5668778692, 0.5683970074, 0.5699155024,
    0.5714333401, 0.5729505060, 0.5744669860, 0.5759827657, 0.5774978309, 0.5790121675,
    0.5805257610, 0.5820385974, 0.5835506623, 0.5850619416, 0.5865724210, 0.5880820864,
    0.5895909235, 0.5910989182, 0.5926060563, 0.5941123235, 0.5956177058, 0.5971221890,
    0.5986257590, 0.6001284015, 0.6016301025, 0.6031308479, 0.6046306235, 0.6061294153,
    0.6076272091, 0.6091239908, 0.6106197465, 0.6121144619, 0.6136081231, 0.6151007161,
    0.6165922267, 0.6180826410, 0.6195719449, 0.6210601245, 0.6225471657, 0.6240330546,
    0.6255177772, 0.6270013195, 0.6284836676, 0.6299648076, 0.6314447254, 0.6329234073,
    0.6344008392, 0.6358770074, 0.6373518979, 0.6388254968, 0.6402977903, 0.6417687646,
    0.6432384058, 0.6447067001, 0.6461736337, 0.6476391928, 0.6491033636, 0.6505661323,
    0.6520274853, 0.6534874087, 0.6549458889, 0.6564029120, 0.6578584645, 0.6593125326,
    0.6607651027, 0.6622161610, 0.6636656940, 0.6651136880, 0.6665601294, 0.6680050047,
    0.6694483001, 0.6708900022, 0.6723300973, 0.6737685721, 0.6752054128, 0.6766406060,
    0.6780741383, 0.6795059961, 0.6809361660, 0.6823646344, 0.6837913881, 0.6852164136,
    0.6866396974, 0.6880612262, 0.6894809866, 0.6908989653, 0.6923151490, 0.6937295243,
    0.6951420779, 0.6965527965, 0.6979616669, 0.6993686758, 0.7007738101, 0.7021770564,
    0.7035784016, 0.7049778325, 0.7063753360, 0.7077708989, 0.7091645081, 0.7105561504,
    0.7119458129, 0.7133334824, 0.7147191459, 0.7161027903, 0.7174844027, 0.7188639700,
    0.7202414793, 0.7216169176, 0.7229902721, 0.7243615297, 0.7257306776, 0.7270977029,
    0.7284625927, 0.7298253343, 0.7311859148, 0.7325443214, 0.7339005413, 0.7352545618,
    0.7366063702, 0.7379559537, 0.7393032997, 0.7406483955, 0.7419912284, 0.7433317858,
    0.7446700551, 0.7460060237, 0.7473396791, 0.7486710087, 0.7500000000, 0.7513266405,
    0.7526509177, 0.7539728192, 0.7552923326, 0.7566094454, 0.7579241452, 0.7592364197,
    0.7605462566, 0.7618536435, 0.7631585681, 0.7644610182, 0.7657609816, 0.7670584459,
    0.7683533990, 0.7696458288, 0.7709357230, 0.7722230696, 0.7735078563, 0.7747900713,
    0.7760697023, 0.7773467374, 0.7786211646, 0.7798929718, 0.7811621471, 0.7824286786,
    0.7836925544, 0.7849537626, 0.7862122913, 0.7874681286, 0.7887212629, 0.7899716822,
    0.7912193749, 0.7924643292, 0.7937065334, 0.7949459759, 0.7961826448, 0.7974165288,
    0.7986476160, 0.7998758950, 0.8011013543, 0.8023239822, 0.8035437673, 0.8047606981,
    0.8059747632, 0.8071859511, 0.8083942505, 0.8095996501, 0.8108021384, 0.8120017041,
    0.8131983361, 0.8143920230, 0.8155827536, 0.8167705167, 0.8179553012, 0.8191370958,
    0.8203158896, 0.8214916713, 0.8226644301, 0.8238341547, 0.8250008343, 0.8261644578,
    0.8273250143, 0.8284824929, 0.8296368828, 0.8307881730, 0.8319363527, 0.8330814112,
    0.8342233376, 0.8353621213, 0.8364977515, 0.8376302175, 0.8387595088, 0.8398856146,
    0.8410085244, 0.8421282276, 0.8432447138, 0.8443579723, 0.8454679928, 0.8465747647,
    0.8476782778, 0.8487785216, 0.8498754857, 0.8509691599, 0.8520595339, 0.8531465974,
    0.8542303401, 0.8553107520, 0.8563878228, 0.8574615425, 0.8585319008, 0.8595988878,
    0.8606624934, 0.8617227077, 0.8627795206, 0.8638329222, 0.8648829026, 0.8659294520,
    0.8669725604, 0.8680122182, 0.8690484154, 0.8700811424, 0.8711103895, 0.8721361469,
    0.8731584051, 0.8741771544, 0.8751923852, 0.8762040880, 0.8772122533, 0.8782168716,
    0.8792179335, 0.8802154295, 0.8812093502, 0.8821996864, 0.8831864286, 0.8841695677,
    0.8851490944, 0.8861249994, 0.8870972736, 0.8880659079, 0.8890308931, 0.8899922202,
    0.8909498801, 0.8919038639, 0.8928541624, 0.8938007669, 0.8947436684, 0.8956828581,
    0.8966183271, 0.8975500666, 0.8984780678, 0.8994023221, 0.9003228207, 0.9012395551,
    0.9021525164, 0.9030616963, 0.9039670861, 0.9048686773, 0.9057664615, 0.9066604301,
    0.9075505748, 0.9084368873, 0.9093193592, 0.9101979821, 0.9110727479, 0.9119436483,
    0.9128106750, 0.9136738201, 0.9145330753, 0.9153884325, 0.9162398838, 0.9170874211,
    0.9179310364, 0.9187707219, 0.9196064696, 0.9204382716, 0.9212661201, 0.9220900075,
    0.9229099258, 0.9237258674, 0.9245378246, 0.9253457899, 0.9261497555, 0.9269497139,
    0.9277456577, 0.9285375792, 0.9293254712, 0.9301093261, 0.9308891366, 0.9316648954,
    0.9324365952, 0.9332042287, 0.9339677886, 0.9347272679, 0.9354826594, 0.9362339559,
    0.9369811504, 0.9377242359, 0.9384632054, 0.9391980520, 0.9399287687, 0.9406553486,
    0.9413777850, 0.9420960710, 0.9428101999, 0.9435201650, 0.9442259596, 0.9449275770,
    0.9456250107, 0.9463182541, 0.9470073006, 0.9476921439, 0.9483727774, 0.9490491948,
    0.9497213897, 0.9503893558, 0.9510530868, 0.9517125764, 0.9523678185, 0.9530188069,
    0.9536655355, 0.9543079981, 0.9549461889, 0.9555801016, 0.9562097305, 0.9568350695,
    0.9574561128, 0.9580728546, 0.9586852890, 0.9592934103, 0.9598972128, 0.9604966908,
    0.9610918387, 0.9616826508, 0.9622691216, 0.9628512456, 0.9634290173, 0.9640024313,
    0.9645714822, 0.9651361647, 0.9656964734, 0.9662524030, 0.9668039484, 0.9673511043,
    0.9678938657, 0.9684322273, 0.9689661842, 0.9694957313, 0.9700208637, 0.9705415763,
    0.9710578644, 0.9715697230, 0.9720771473, 0.9725801326, 0.9730786742, 0.9735727673,
    0.9740624073, 0.9745475895, 0.9750283096, 0.9755045628, 0.9759763448, 0.9764436511,
    0.9769064773, 0.9773648190, 0.9778186720, 0.9782680320, 0.9787128947, 0.9791532560,
    0.9795891117, 0.9800204578, 0.9804472901, 0.9808696047, 0.9812873975, 0.9817006648,
    0.9821094025, 0.9825136068, 0.9829132740, 0.9833084002, 0.9836989818, 0.9840850151,
    0.9844664964, 0.9848434222, 0.9852157889, 0.9855835931, 0.9859468312, 0.9863054998,
    0.9866595956, 0.9870091153, 0.9873540555, 0.9876944131, 0.9880301847, 0.9883613673,
    0.9886879578, 0.9890099530, 0.9893273500, 0.9896401457, 0.9899483373, 0.9902519217,
    0.9905508963, 0.9908452580, 0.9911350043, 0.9914201323, 0.9917006395, 0.9919765230,
    0.9922477804, 0.9925144091, 0.9927764066, 0.9930337704, 0.9932864982, 0.9935345874,
    0.9937780359, 0.9940168412, 0.9942510013, 0.9944805137, 0.9947053765, 0.9949255875,
    0.9951411446, 0.9953520458, 0.9955582891, 0.9957598726, 0.9959567943, 0.9961490524,
    0.9963366452, 0.9965195708, 0.9966978276, 0.9968714138, 0.9970403278, 0.9972045681,
    0.9973641330, 0.9975190211, 0.9976692310, 0.9978147612, 0.9979556103, 0.9980917771,
    0.9982232602, 0.9983500584, 0.9984721705, 0.9985895954, 0.9987023320, 0.9988103791,
    0.9989137359, 0.9990124013, 0.9991063743, 0.9991956542, 0.9992802400, 0.9993601310,
    0.9994353264, 0.9995058256, 0.9995716277, 0.9996327323, 0.9996891388, 0.9997408466,
    0.9997878552, 0.9998301643, 0.9998677733, 0.9999006820, 0.9999288900, 0.9999523970,
    0.9999712030, 0.9999853076, 0.9999947107, 0.9999994123, 0.9999994123, 0.9999947107,
    0.9999853076, 0.9999712030, 0.9999523970, 0.9999288900, 0.9999006820, 0.9998677733,
    0.9998301643, 0.9997878552, 0.9997408466, 0.9996891388, 0.9996327323, 0.9995716277,
    0.9995058256, 0.9994353264, 0.9993601310, 0.9992802400, 0.9991956542, 0.9991063743,
    0.9990124013, 0.9989137359, 0.9988103791, 0.9987023320, 0.9985895954, 0.9984721705,
    0.9983500584, 0.9982232602, 0.9980917771, 0.9979556103, 0.9978147612, 0.9976692310,
    0.9975190211, 0.9973641330, 0.9972045681, 0.9970403278, 0.9968714138, 0.9966978276,
    0.9965195708, 0.9963366452, 0.9961490524, 0.9959567943, 0.9957598726, 0.9955582891,
    0.9953520458, 0.9951411446, 0.9949255875, 0.9947053765, 0.9944805137, 0.9942510013,
    0.9940168412, 0.9937780359, 0.9935345874, 0.9932864982, 0.9930337704, 0.9927764066,
    0.9925144091, 0.9922477804, 0.9919765230, 0.9917006395, 0.9914201323, 0.9911350043,
    0.9908452580, 0.9905508963, 0.9902519217, 0.9899483373, 0.9896401457, 0.9893273500,
    0.9890099530, 0.9886879578, 0.9883613673, 0.9880301847, 0.9876944131, 0.9873540555,
    0.9870091153, 0.9866595956, 0.9863054998, 0.9859468312, 0.9855835931, 0.9852157889,
    0.9848434222, 0.9844664964, 0.9840850151, 0.9836989818, 0.9833084002, 0.9829132740,
    0.9825136068, 0.9821094025, 0.9817006648, 0.9812873975, 0.9808696047, 0.9804472901,
    0.9800204578, 0.9795891117, 0.9791532560, 0.9787128947, 0.9782680320, 0.9778186720,
    0.9773648190, 0.9769064773, 0.9764436511, 0.9759763448, 0.9755045628, 0.9750283096,
    0.9745475895, 0.9740624073, 0.9735727673, 0.9730786742, 0.9725801326, 0.9720771473,
    0.9715697230, 0.9710578644, 0.9705415763, 0.9700208637, 0.9694957313, 0.9689661842,
    0.9684322273, 0.9678938657, 0.9673511043, 0.9668039484, 0.9662524030, 0.9656964734,
    0.9651361647, 0.9645714822, 0.9640024313, 0.9634290173, 0.9628512456, 0.9622691216,
    0.9616826508, 0.9610918387, 0.9604966908, 0.9598972128, 0.9592934103, 0.9586852890,
    0.9580728546, 0.9574561128, 0.9568350695, 0.9562097305, 0.9555801016, 0.9549461889,
    0.9543079981, 0.9536655355, 0.9530188069, 0.9523678185, 0.9517125764, 0.9510530868,
    0.9503893558, 0.9497213897, 0.9490491948, 0.9483727774, 0.9476921439, 0.9470073006,
    0.9463182541, 0.9456250107, 0.9449275770, 0.9442259596, 0.9435201650, 0.9428101999,
    0.9420960710, 0.9413777850, 0.9406553486, 0.9399287687, 0.9391980520, 0.9384632054,
    0.9377242359, 0.9369811504, 0.9362339559, 0.9354826594, 0.9347272679, 0.9339677886,
    0.9332042287, 0.9324365952, 0.9316648954, 0.9308891366, 0.9301093261, 0.9293254712,
    0.9285375792, 0.9277456577, 0.9269497139, 0.9261497555, 0.9253457899, 0.9245378246,
    0.9237258674, 0.9229099258, 0.9220900075, 0.9212661201, 0.9204382716, 0.9196064696,
    0.9187707219, 0.9179310364, 0.9170874211, 0.9162398838, 0.9153884325, 0.9145330753,
    0.9136738201, 0.9128106750, 0.9119436483, 0.9110727479, 0.9101979821, 0.9093193592,
    0.9084368873, 0.9075505748, 0.9066604301, 0.9057664615, 0.9048686773, 0.9039670861,
    0.9030616963, 0.9021525164, 0.9012395551, 0.9003228207, 0.8994023221, 0.8984780678,
    0.8975500666, 0.8966183271, 0.8956828581, 0.8947436684, 0.8938007669, 0.8928541624,
    0.8919038639, 0.8909498801, 0.8899922202, 0.8890308931, 0.8880659079, 0.8870972736,
    0.8861249994, 0.8851490944, 0.8841695677, 0.8831864286, 0.8821996864, 0.8812093502,
    0.8802154295, 0.8792179335, 0.8782168716, 0.8772122533, 0.8762040880, 0.8751923852,
    0.8741771544, 0.8731584051, 0.8721361469, 0.8711103895, 0.8700811424, 0.8690484154,
    0.8680122182, 0.8669725604, 0.8659294520, 0.8648829026, 0.8638329222, 0.8627795206,
    0.8617227077, 0.8606624934, 0.8595988878, 0.8585319008, 0.8574615425, 0.8563878228,
    0.8553107520, 0.8542303401, 0.8531465974, 0.8520595339, 0.8509691599, 0.8498754857,
    0.8487785216, 0.8476782778, 0.8465747647, 0.8454679928, 0.8443579723, 0.8432447138,
    0.8421282276, 0.8410085244, 0.8398856146, 0.8387595088, 0.8376302175, 0.8364977515,
    0.8353621213, 0.8342233376, 0.8330814112, 0.8319363527, 0.8307881730, 0.8296368828,
    0.8284824929, 0.8273250143, 0.8261644578, 0.8250008343, 0.8238341547, 0.8226644301,
    0.8214916713, 0.8203158896, 0.8191370958, 0.8179553012, 0.8167705167, 0.8155827536,
    0.8143920230, 0.8131983361, 0.8120017041, 0.8108021384, 0.8095996501, 0.8083942505,
    0.8071859511, 0.8059747632, 0.8047606981, 0.8035437673, 0.8023239822, 0.8011013543,
    0.7998758950, 0.7986476160, 0.7974165288, 0.7961826448, 0.7949459759, 0.7937065334,
    0.7924643292, 0.7912193749, 0.7899716822, 0.7887212629, 0.7874681286, 0.7862122913,
    0.7849537626, 0.7836925544, 0.7824286786, 0.7811621471, 0.7798929718, 0.7786211646,
    0.7773467374, 0.7760697023, 0.7747900713, 0.7735078563, 0.7722230696, 0.7709357230,
    0.7696458288, 0.7683533990, 0.7670584459, 0.7657609816, 0.7644610182, 0.7631585681,
    0.7618536435, 0.7605462566, 0.7592364197, 0.7579241452, 0.7566094454, 0.7552923326,
    0.7539728192, 0.7526509177, 0.7513266405, 0.7500000000, 0.7486710087, 0.7473396791,
    0.7460060237, 0.7446700551, 0.7433317858, 0.7419912284, 0.7406483955, 0.7393032997,
    0.7379559537, 0.7366063702, 0.7352545618, 0.7339005413, 0.7325443214, 0.7311859148,
    0.7298253343, 0.7284625927, 0.7270977029, 0.7257306776, 0.7243615297, 0.7229902721,
    0.7216169176, 0.7202414793, 0.7188639700, 0.7174844027, 0.7161027903, 0.7147191459,
    0.7133334824, 0.7119458129, 0.7105561504, 0.7091645081, 0.7077708989, 0.7063753360,
    0.7049778325, 0.7035784016, 0.7021770564, 0.7007738101, 0.6993686758, 0.6979616669,
    0.6965527965, 0.6951420779, 0.6937295243, 0.6923151490, 0.6908989653, 0.6894809866,
    0.6880612262, 0.6866396974, 0.6852164136, 0.6837913881, 0.6823646344, 0.6809361660,
    0.6795059961, 0.6780741383, 0.6766406060, 0.6752054128, 0.6737685721, 0.6723300973,
    0.6708900022, 0.6694483001, 0.6680050047, 0.6665601294, 0.6651136880, 0.6636656940,
    0.6622161610, 0.6607651027, 0.6593125326, 0.6578584645, 0.6564029120, 0.6549458889,
    0.6534874087, 0.6520274853, 0.6505661323, 0.6491033636, 0.6476391928, 0.6461736337,
    0.6447067001, 0.6432384058, 0.6417687646, 0.6402977903, 0.6388254968, 0.6373518979,
    0.6358770074, 0.6344008392, 0.6329234073, 0.6314447254, 0.6299648076, 0.6284836676,
    0.6270013195, 0.6255177772, 0.6240330546, 0.6225471657, 0.6210601245, 0.6195719449,
    0.6180826410, 0.6165922267, 0.6151007161, 0.6136081231, 0.6121144619, 0.6106197465,
    0.6091239908, 0.6076272091, 0.6061294153, 0.6046306235, 0.6031308479, 0.6016301025,
    0.6001284015, 0.5986257590, 0.5971221890, 0.5956177058, 0.5941123235, 0.5926060563,
    0.5910989182, 0.5895909235, 0.5880820864, 0.5865724210, 0.5850619416, 0.5835506623,
    0.5820385974, 0.5805257610, 0.5790121675, 0.5774978309, 0.5759827657, 0.5744669860,
    0.5729505060, 0.5714333401, 0.5699155024, 0.5683970074, 0.5668778692, 0.5653581021,
    0.5638377205, 0.5623167385, 0.5607951706, 0.5592730311, 0.5577503341, 0.5562270942,
    0.5547033255, 0.5531790424, 0.5516542593, 0.5501289905, 0.5486032503, 0.5470770530,
    0.5455504131, 0.5440233449, 0.5424958627, 0.5409679809, 0.5394397139, 0.5379110760,
    0.5363820817, 0.5348527452, 0.5333230810, 0.5317931035, 0.5302628270, 0.5287322659,
    0.5272014347, 0.5256703477, 0.5241390193, 0.5226074639, 0.5210756959, 0.5195437298,
    0.5180115799, 0.5164792606, 0.5149467863, 0.5134141715, 0.5118814306, 0.5103485780,
    0.5088156280, 0.5072825951, 0.5057494938, 0.5042163384, 0.5026831434, 0.5011499231,
    0.4996166920, 0.4980834645, 0.4965502551, 0.4950170780, 0.4934839479, 0.4919508790,
    0.4904178858, 0.4888849827, 0.4873521841, 0.4858195044, 0.4842869581, 0.4827545595,
    0.4812223231, 0.4796902633, 0.4781583944, 0.4766267310, 0.4750952873, 0.4735640778,
    0.4720331168, 0.4705024189, 0.4689719983, 0.4674418695, 0.4659120468, 0.4643825447,
    0.4628533775, 0.4613245596, 0.4597961053, 0.4582680291, 0.4567403454, 0.4552130684,
    0.4536862125, 0.4521597921, 0.4506338216, 0.4491083153, 0.4475832875, 0.4460587526,
    0.4445347250, 0.4430112189, 0.4414882486, 0.4399658286, 0.4384439731, 0.4369226964,
    0.4354020128, 0.4338819366, 0.4323624822, 0.4308436638, 0.4293254957, 0.4278079921,
    0.4262911674, 0.4247750358, 0.4232596115, 0.4217449088, 0.4202309420, 0.4187177253,
    0.4172052728, 0.4156935990, 0.4141827178, 0.4126726436, 0.4111633906, 0.4096549729,
    0.4081474048, 0.4066407004, 0.4051348738, 0.4036299393, 0.4021259109, 0.4006228029,
    0.3991206294, 0.3976194044, 0.3961191422, 0.3946198567, 0.3931215622, 0.3916242727,
    0.3901280022, 0.3886327649, 0.3871385748, 0.3856454460, 0.3841533924, 0.3826624282,
    0.3811725674, 0.3796838239, 0.3781962117, 0.3767097449, 0.3752244374, 0.3737403032,
    0.3722573563, 0.3707756105, 0.3692950799, 0.3678157783, 0.3663377196, 0.3648609179,
    0.3633853868, 0.3619111404, 0.3604381924, 0.3589665568, 0.3574962473, 0.3560272778,
    0.3545596622, 0.3530934141, 0.3516285474, 0.3501650759, 0.3487030133, 0.3472423734,
    0.3457831699, 0.3443254166, 0.3428691270, 0.3414143150, 0.3399609943, 0.3385091784,
    0.3370588810, 0.3356101158, 0.3341628964, 0.3327172363, 0.3312731493, 0.3298306489,
    0.3283897485, 0.3269504619, 0.3255128025, 0.3240767838, 0.3226424194, 0.3212097227,
    0.3197787071, 0.3183493863, 0.3169217735, 0.3154958823, 0.3140717260, 0.3126493180,
    0.3112286717, 0.3098098005, 0.3083927176, 0.3069774365, 0.3055639704, 0.3041523326,
    0.3027425364, 0.3013345951, 0.2999285219, 0.2985243300, 0.2971220325, 0.2957216428,
    0.2943231740, 0.2929266392, 0.2915320515, 0.2901394241, 0.2887487700, 0.2873601024,
    0.2859734343, 0.2845887787, 0.2832061487, 0.2818255572, 0.2804470173, 0.2790705418,
    0.2776961439, 0.2763238362, 0.2749536319, 0.2735855437, 0.2722195845, 0.2708557672,
    0.2694941045, 0.2681346094, 0.2667772945, 0.2654221727, 0.2640692567, 0.2627185591,
    0.2613700928, 0.2600238703, 0.2586799044, 0.2573382077, 0.2559987928, 0.2546616722,
    0.2533268587, 0.2519943646, 0.2506642026, 0.2493363851, 0.2480109247, 0.2466878338,
    0.2453671248, 0.2440488102, 0.2427329023, 0.2414194136, 0.2401083564, 0.2387997429,
    0.2374935856, 0.2361898967, 0.2348886885, 0.2335899731, 0.2322937629, 0.2310000699,
    0.2297089064, 0.2284202845, 0.2271342163, 0.2258507140, 0.2245697895, 0.2232914549,
    0.2220157223, 0.2207426036, 0.2194721108, 0.2182042559, 0.2169390508, 0.2156765073,
    0.2144166374, 0.2131594529, 0.2119049656, 0.2106531873, 0.2094041298, 0.2081578049,
    0.2069142242, 0.2056733994, 0.2044353422, 0.2032000643, 0.2019675773, 0.2007378927,
    0.1995110222, 0.1982869772, 0.1970657692, 0.1958474098, 0.1946319104, 0.1934192825,
    0.1922095374, 0.1910026865, 0.1897987412, 0.1885977127, 0.1873996124, 0.1862044516,
    0.1850122415, 0.1838229932, 0.1826367180, 0.1814534271, 0.1802731315, 0.1790958423,
    0.1779215707, 0.1767503277, 0.1755821242, 0.1744169713, 0.1732548799, 0.1720958610,
    0.1709399254, 0.1697870840, 0.1686373477, 0.1674907272, 0.1663472334, 0.1652068770,
    0.1640696688, 0.1629356193, 0.1618047394, 0.1606770395, 0.1595525304, 0.1584312225,
    0.1573131265, 0.1561982529, 0.1550866121, 0.1539782145, 0.1528730707, 0.1517711910,
    0.1506725857, 0.1495772653, 0.1484852399, 0.1473965199, 0.1463111155, 0.1452290369,
    0.1441502943, 0.1430748978, 0.1420028576, 0.1409341836, 0.1398688861, 0.1388069749,
    0.1377484601, 0.1366933516, 0.1356416593, 0.1345933932, 0.1335485631, 0.1325071788,
    0.1314692500, 0.1304347867, 0.1294037985, 0.1283762950, 0.1273522860, 0.1263317811,
    0.1253147898, 0.1243013218, 0.1232913866, 0.1222849936, 0.1212821523, 0.1202828722,
    0.1192871627, 0.1182950331, 0.1173064927, 0.1163215508, 0.1153402168, 0.1143624998,
    0.1133884090, 0.1124179537, 0.1114511428, 0.1104879855, 0.1095284909, 0.1085726679,
    0.1076205257, 0.1066720730, 0.1057273189, 0.1047862722, 0.1038489418, 0.1029153364,
    0.1019854650, 0.1010593361, 0.1001369586, 0.0992183410, 0.0983034921, 0.0973924204,
    0.0964851345, 0.0955816430, 0.0946819542, 0.0937860768, 0.0928940190, 0.0920057894,
    0.0911213962, 0.0902408477, 0.0893641523, 0.0884913182, 0.0876223536, 0.0867572667,
    0.0858960656, 0.0850387583, 0.0841853531, 0.0833358578, 0.0824902805, 0.0816486291,
    0.0808109116, 0.0799771357, 0.0791473095, 0.0783214406, 0.0774995368, 0.0766816058,
    0.0758676555, 0.0750576933, 0.0742517269, 0.0734497639, 0.0726518119, 0.0718578783,
    0.0710679706, 0.0702820963, 0.0695002626, 0.0687224770, 0.0679487469, 0.0671790793,
    0.0664134817, 0.0656519612, 0.0648945250, 0.0641411801, 0.0633919337, 0.0626467928,
    0.0619057644, 0.0611688555, 0.0604360730, 0.0597074238, 0.0589829148, 0.0582625528,
    0.0575463445, 0.0568342966, 0.0561264160, 0.0554227092, 0.0547231828, 0.0540278434,
    0.0533366976, 0.0526497519, 0.0519670127, 0.0512884865, 0.0506141795, 0.0499440982,
    0.0492782489, 0.0486166378, 0.0479592712, 0.0473061552, 0.0466572959, 0.0460126996,
    0.0453723721, 0.0447363196, 0.0441045481, 0.0434770634, 0.0428538715, 0.0422349782,
    0.0416203894, 0.0410101108, 0.0404041482, 0.0398025073, 0.0392051936, 0.0386122130,
    0.0380235708, 0.0374392727, 0.0368593242, 0.0362837306, 0.0357124975, 0.0351456301,
    0.0345831339, 0.0340250141, 0.0334712759, 0.0329219246, 0.0323769653, 0.0318364032,
    0.0313002433, 0.0307684907, 0.0302411503, 0.0297182272, 0.0291997263, 0.0286856523,
    0.0281760103, 0.0276708049, 0.0271700408, 0.0266737229, 0.0261818558, 0.0256944441,
    0.0252114924, 0.0247330052, 0.0242589870, 0.0237894423, 0.0233243755, 0.0228637910,
    0.0224076931, 0.0219560861, 0.0215089742, 0.0210663617, 0.0206282527, 0.0201946513,
    0.0197655616, 0.0193409877, 0.0189209335, 0.0185054029, 0.0180944000, 0.0176879285,
    0.0172859922, 0.0168885951, 0.0164957407, 0.0161074328, 0.0157236751, 0.0153444710,
    0.0149698243, 0.0145997385, 0.0142342169, 0.0138732631, 0.0135168805, 0.0131650723,
    0.0128178420, 0.0124751927, 0.0121371277, 0.0118036501, 0.0114747632, 0.0111504700,
    0.0108307735, 0.0105156768, 0.0102051828, 0.0098992944, 0.0095980146, 0.0093013461,
    0.0090092917, 0.0087218542, 0.0084390363, 0.0081608407, 0.0078872699, 0.0076183265,
    0.0073540131, 0.0070943321, 0.0068392860, 0.0065888773, 0.0063431081, 0.0061019809,
    0.0058654980, 0.0056336614, 0.0054064735, 0.0051839364, 0.0049660521, 0.0047528227,
    0.0045442502, 0.0043403366, 0.0041410837, 0.0039464936, 0.0037565679, 0.0035713085,
    0.0033907171, 0.0032147954, 0.0030435451, 0.0028769677, 0.0027150650, 0.0025578382,
    0.0024052891, 0.0022574189, 0.0021142290, 0.0019757209, 0.0018418958, 0.0017127550,
    0.0015882997, 0.0014685311, 0.0013534502, 0.0012430582, 0.0011373561, 0.0010363449,
    0.0009400256, 0.0008483991, 0.0007614661, 0.0006792276, 0.0006016843, 0.0005288369,
    0.0004606862, 0.0003972327, 0.0003384771, 0.0002844199, 0.0002350617, 0.0001904028,
    0.0001504437, 0.0001151848, 0.0000846264, 0.0000587689, 0.0000376123, 0.0000211571,
    0.0000094032, 0.0000023508};

#endif // LIB_UTILS_HANNING_H_
