
-- Tags
-- https://github.com/moneymanagerex/moneymanagerex/issues/5439
-- Describe TAG_V1
CREATE TABLE IF NOT EXISTS TAG_V1(
TAGID INTEGER PRIMARY KEY
, TAGNAME TEXT COLLATE NOCASE NOT NULL UNIQUE
, ACTIVE INTEGER
);
CREATE INDEX IF NOT EXISTS IDX_TAGNAME ON TAG_V1 (TAGNAME);

-- Describe TAGLINK_V1
CREATE TABLE IF NOT EXISTS TAGLINK_V1(
TAGLINKID INTEGER PRIMARY KEY
, REFTYPE TEXT NOT NULL
, REFID INTEGER NOT NULL
, TAGID INTEGER NOT NULL
, UNIQUE(REFTYPE, REFID, TAGID)
);
CREATE INDEX IF NOT EXISTS IDX_TAGLINK ON TAGLINK_V1 (REFTYPE, REFID, TAGID);

-- Migrate FOLLOWUPID to COLOR
ALTER TABLE CHECKINGACCOUNT_V1 ADD COLUMN COLOR INTEGER DEFAULT -1;
ALTER TABLE BILLSDEPOSITS_V1 ADD COLUMN COLOR INTEGER DEFAULT -1;

UPDATE CHECKINGACCOUNT_V1 SET COLOR = FOLLOWUPID;
UPDATE BILLSDEPOSITS_v1 SET COLOR = FOLLOWUPID;
