---
layout: splash
permalink: /
hidden: true
header:
  overlay_color: "#48a802"
  overlay_image: /assets/images/mm-background.png
  actions:
     - label: "<i class='fa-brands fa-github'></i> Fork me on GitHub"
       url: "https://github.com/moneymanagerex/android-money-manager-ex/"

excerpt: >
  A companion app for <a href="http://www.moneymanagerex.org/">Money Manager Ex</a>.<br />
  Perfect to manage your finance on-the-go.<br />
  <a href="https://github.com/moneymanagerex/android-money-manager-ex/releases/latest"><img src="https://img.shields.io/github/v/release/moneymanagerex/android-money-manager-ex?include_prereleases&label=github%20release"></a>&nbsp;
  <a href="https://play.google.com/store/apps/details?id=com.money.manager.ex.android"><img src="https://img.shields.io/endpoint?color=green&logo=google-play&logoColor=green&url=https%3A%2F%2Fplay.cuzi.workers.dev%2Fplay%3Fi%3Dcom.money.manager.ex.android%26gl%3DUS%26hl%3Den%26l%3DAndroid%26m%3D%24version"></a>&nbsp;
  <a href="https://f-droid.org/packages/com.money.manager.ex"><img src="https://img.shields.io/f-droid/v/com.money.manager.ex?include_prereleases&label=f-droid%20release"></a>
   

feature_row:
  - title: "Quick Start Guide"
    excerpt: "Quick guide for easy and fast setup, element concept and basic usage"
    url: "/quickstart/"
    btn_class: "btn--primary"
    btn_label: "Start read"
  - title: "User Manual"
    excerpt: "User manual with detail instruction."
    url: "/usermanual/"
    btn_class: "btn--primary"
    btn_label: "Start read"
  - title: "How to Contribute"
    excerpt: "Contribute to this project. Test, Translate, Beta and many others stuff"
    url: "/contribute/"
    btn_class: "btn--primary"
    btn_label: "Learn more"
---

{% include feature_row %}

# Money Manager Ex for Android

[Money Manager Ex](https://moneymanagerex.org/) is a free, open-source, cross-platform, easy-to-use personal finance software. It primarily helps organize one's finances and keeps track of where, when, and how the money flows

## Donate
Support our development teams with a coffee.
<table width="100%">
<tr>
  <td>
<center>    
**Buy Me a Coffe**<br>
<a href="https://www.buymeacoffee.com/wolfsolver" target="_blank">
<img src="https://cdn.buymeacoffee.com/buttons/v2/default-yellow.png" alt="Buy Me A Coffee" style="height: 60px !important;width: 217px !important;" >
</a>    
  </center>
  </td>
<td>
<center>
Donate via Paypal<br>
<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_top">
  <input type="hidden" name="cmd" value="_donations">
  <input type="hidden" name="business" value="moneymanagerex@gmail.com">
  <input type="hidden" name="lc" value="US">
  <input type="hidden" name="item_name" value="MoneyManagerEx">
  <input type="hidden" name="no_note" value="0">
  <input type="hidden" name="currency_code" value="USD">
  <input type="hidden" name="bn" value="PP-DonationsBF:btn_donateCC_LG.gif:NonHostedGuest">
  <input type="image" src="assets/images/paypal-donate.png" border="0" name="submit" alt="PayPal - The safer, easier way to pay online!" style="width: 160px; margin: 6px auto;">
  <img alt="" border="0" src="https://www.paypalobjects.com/en_US/i/scr/pixel.gif" width="1" height="1">
</form>
</center>
</td>
<td>
<center>
Donate via WeChat<br>
<img src="assets/images/wechat-donate.png" style="width: 120px; margin: 6px auto;">
</center>
</td>
<td>
<center>
Donate via bitcoin<br>
<img src="assets/images/bitcoin-donate.png" style="width: 120px; margin: 6px auto;">
</center>
</td>
</tr>
</table>


## Introduction

Money Manager Ex for Android is a port of the desktop personal finance application
[Money Manager Ex](https://moneymanagerex.org/), currently available for Windows, Mac OSX and Linux and iOS.
The Android version mirrors the best features of the desktop version while adding
mobility and database synchronization.

In Money Manager Ex project, we strive to develop good personal finance software that we use ourselves. 
We also do this for fun and the love of programming. We are a non-profit, informal organization although we do accept donations and use them towards the hosting fees.
Any leftovers for the Android version will also go towards acquiring a device for the app testing.

Money Manager Ex is a free, open-source, cross-platform, easy-to-use personal finance software. 
It primarily helps organize one's finances and keeps track of where, when, and how the money goes.
It is also a great tool to get a bird's eye view of your financial worth.

The Android version of Money Manager Ex is aimed at bringing these features to your mobile devices,
allowing you to manage your finances on the go.

## Features

- **Simple Interface:** The app provides an intuitive and user-friendly interface, making it easy for anyone to use.
- **Expense Tracking:** Keep track of your expenses and categorize them for better organization.
- **Income Management:** Monitor your income sources and manage them efficiently.
- **Budget Planning:** Set up budgets for different categories and track your spending to stay within your limits.
- **Reports:** Generate various reports to analyze your financial activities and make informed decisions.
- **Sync:** Synchronize your data across multiple devices using cloud services for seamless access.
- **Security:** Protect your financial data with passwords and encryption to ensure privacy and security.
- **Customization:** Customize categories, currencies, and other settings to suit your specific needs.

All the feature requests can be tracked at our [issue tracker](https://github.com/moneymanagerex/android-money-manager-ex/issues) on GitHub. .

## Download

[<img alt="Get it on F-Droid" src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" width="240">](https://f-droid.org/packages/com.money.manager.ex)
[<img alt="Get it on GitHub" src="https://raw.githubusercontent.com/Kunzisoft/Github-badge/main/get-it-on-github.png" width="240">](https://github.com/moneymanagerex/android-money-manager-ex/releases/latest)
[<img alt="Get it on Google Play" src="http://steverichey.github.io/google-play-badge-svg/img/en_get.svg" width="240">](https://play.google.com/store/apps/details?id=com.money.manager.ex.android)

If you like to contribute you can also enroll as [beta tester](https://play.google.com/apps/testing/com.money.manager.ex.android).

Check [here](supported_android_version.md) if your Android version is supported.

## Screenshot
![Splash screen](/assets/images/screenshoot/0.splash.jpg-th.png)
![Select Or Create Db](/assets/images/screenshoot/1.SelectOrCreateDb.jpg-th.png)
![Open Db](/assets/images/screenshoot/2.OpenDb.jpg-th.png)
![Create First Account](/assets/images/screenshoot/3.CreateFirstAccount.jpg-th.png)
![Create Account Detail](/assets/images/screenshoot/4.CreateAccountDetail.jpg-th.png)
![homepage](/assets/images/screenshoot/homepage.png-th.png)
![Payee Report](/assets/images/screenshoot/payee_report.png-th.png)
![schedule transaction](/assets/images/screenshoot/schedule_transaction.png-th.png)
![Budget](/assets/images/screenshoot/budget_standard.png-th.png)
![Budget All Column](/assets/images/screenshoot/budget_all_column.png-th.png)
![CashFlow](/assets/images/screenshoot/CashFlow.png-th.png)
![IncomeVsExpese](/assets/images/screenshoot/IncomeVsExpense.png-th.png)

## Contact
Discussions, questions, and useful advice can be found in the Android [forum](http://forum.moneymanagerex.org/viewforum.php?f=20&sid=e28426f96579a43121b1127cd887e186)

In special situations, you can reach us by email: [android@moneymanagerex.org](mailto:android@moneymanagerex.org). Please note that we do not provide support via email due to the voluntary nature of the project, a fairly small number of project members, and a large number of end users.

## Privacy Policy
Our [Privacy Policy](privacypolicy.md)

## License

Money Manager Ex for Android is released under the [GNU General Public License v3.0](https://www.gnu.org/licenses/gpl-3.0.en.html). You are free to use, modify, and distribute this software in accordance with the terms of the license.

{{ site.adsense.script }}
