# Money Manager Ex - Android User Manual

Welcome to the user manual for Money Manager Ex - Android, a free, open-source, cross-platform, and easy-to-use personal finance software.

## Table of Contents

1. [Introduction](#introduction)
2. [Getting Started](#getting-started)
3. [Features](#features)
    - [Expense Tracking](#expense-tracking)
    - [Budget Management](#budget-management)
    - [Account Management](#account-management)
    - [Reports](#reports)
    - [Data Sync](#data-sync)
    - [Security](#security)
    - [Recurring Transactions](#recurring-transactions)
    - [Nested Category](#nested-category)
4. [How to Use](#how-to-use)
    - [Adding Transactions](#adding-transactions)
    - [Creating Budgets](#creating-budgets)
    - [Managing Accounts](#managing-accounts)
5. [Troubleshooting](#troubleshooting)
6. [Contributing](#contributing)
7. [License](#license)

## Introduction

Money Manager Ex - Android is a mobile version of the popular personal finance software Money Manager Ex. It allows you to manage your finances on the go, making it easy to track expenses, create budgets, and stay on top of your financial goals.

## Getting Started

To start using Money Manager Ex - Android, simply download and install the app from the Google Play Store or F-Droid. Once installed, you can create an account and begin adding your financial information.

## Features

### Expense Tracking

Track your expenses on the go, categorize transactions, and view detailed reports to better understand your spending habits.

### Budget Management

Set up budgets for different categories and track your progress over time. Receive notifications when you're nearing your budget limits.

### Account Management

Manage multiple accounts, including checking, savings, credit cards, and more. Keep track of balances and reconcile transactions with your bank statements.

### Reports

Generate customizable reports to gain insights into your financial health. Analyze spending patterns, income trends, and more.

### Data Sync

Sync your financial data across multiple devices using cloud synchronization. Ensure that your information is always up to date, no matter where you are.

### Security

Protect your financial information with advanced security features, including password protection and data encryption.

### Recurring Transactions

Support for recurring and schedule transactions. Recurring can be Manual, Prompt (with notifications) or Automatic (controlled by setting switch).
> [!IMPORTANT]
> Expired Recurring Transaction require to have correct Type set into transaction
> AUTO: Means that transaction is auto posted when expired
> PROMPT: Means that transaction is show in a notification with action skip/enter for user decision
> MANUAL: Means that no action is taken on recurring transaction (no auto post, no notification)


### Nested Category

Money Manager Ex on Desktop can manage nested subcategory.
From 2024.08.25, nested category (means third level or more in category management) is available also on Android Version.

#### Avilability
Nested category is used in:
* Category list
* Transaction edit / insert
* Recurring Transaction edit / insert
* Transaction list
* Reporting


## How to Use

### Adding Transactions

To add a new transaction, simply navigate to the transactions tab and click on the add button. Then, enter the details of the transaction, including the date, amount, category, and any additional notes.

### Creating Budgets

To create a new budget, go to the budgets tab and click on the add button. Then, enter the details of the budget, including the category, amount, and timeframe.

### Managing Accounts

To manage your accounts, navigate to the accounts tab and click on the add button. Then, enter the details of the account, including the account type, name, and starting balance.

## Troubleshooting

If you encounter any issues while using Money Manager Ex - Android, please refer to the troubleshooting section of the user manual for assistance.

## Contributing

Money Manager Ex - Android is an open-source project, and we welcome contributions from the community. If you'd like to get involved, please visit our GitHub repository and submit a pull request.

## License

Money Manager Ex - Android is licensed under the GNU General Public License version 3.0. For more information, please refer to the [LICENSE](../../License) file in the root of the project repository.
