package com.module.notelycompose.resources.vectors

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import dev.sergiobelda.compose.vectorize.core.imageVector

public val Images.Icons.IcKeyboardHide: ImageVector
    get() {
        if (_icKeyboardHide != null) {
            return _icKeyboardHide!!
        }
        _icKeyboardHide = imageVector(
        	name = "IcKeyboardHide",
        	width = 28f,
        	height = 28f,
        	viewportWidth = 24.0f,
        	viewportHeight = 24.0f,
        	autoMirror = false
        ) {
            path(
            	fill = SolidColor(Color(0xFF0F0F0F))
            ) {
                moveTo(5.0f, 6.0f)
                curveTo(5.0f, 5.448f, 5.448f, 5.0f, 6.0f, 5.0f)
                curveTo(6.552f, 5.0f, 7.0f, 5.448f, 7.0f, 6.0f)
                curveTo(7.0f, 6.552f, 6.552f, 7.0f, 6.0f, 7.0f)
                curveTo(5.448f, 7.0f, 5.0f, 6.552f, 5.0f, 6.0f)
                close()
            }
            path(
            	fill = SolidColor(Color(0xFF0F0F0F))
            ) {
                moveTo(5.0f, 10.0f)
                curveTo(5.0f, 9.448f, 5.448f, 9.0f, 6.0f, 9.0f)
                curveTo(6.552f, 9.0f, 7.0f, 9.448f, 7.0f, 10.0f)
                curveTo(7.0f, 10.552f, 6.552f, 11.0f, 6.0f, 11.0f)
                curveTo(5.448f, 11.0f, 5.0f, 10.552f, 5.0f, 10.0f)
                close()
            }
            path(
            	fill = SolidColor(Color(0xFF0F0F0F))
            ) {
                moveTo(10.0f, 9.0f)
                curveTo(9.448f, 9.0f, 9.0f, 9.448f, 9.0f, 10.0f)
                curveTo(9.0f, 10.552f, 9.448f, 11.0f, 10.0f, 11.0f)
                horizontalLineTo(14.0f)
                curveTo(14.552f, 11.0f, 15.0f, 10.552f, 15.0f, 10.0f)
                curveTo(15.0f, 9.448f, 14.552f, 9.0f, 14.0f, 9.0f)
                horizontalLineTo(10.0f)
                close()
            }
            path(
            	fill = SolidColor(Color(0xFF0F0F0F))
            ) {
                moveTo(17.0f, 10.0f)
                curveTo(17.0f, 9.448f, 17.448f, 9.0f, 18.0f, 9.0f)
                curveTo(18.552f, 9.0f, 19.0f, 9.448f, 19.0f, 10.0f)
                curveTo(19.0f, 10.552f, 18.552f, 11.0f, 18.0f, 11.0f)
                curveTo(17.448f, 11.0f, 17.0f, 10.552f, 17.0f, 10.0f)
                close()
            }
            path(
            	fill = SolidColor(Color(0xFF0F0F0F))
            ) {
                moveTo(9.0f, 6.0f)
                curveTo(9.0f, 5.448f, 9.448f, 5.0f, 10.0f, 5.0f)
                curveTo(10.552f, 5.0f, 11.0f, 5.448f, 11.0f, 6.0f)
                curveTo(11.0f, 6.552f, 10.552f, 7.0f, 10.0f, 7.0f)
                curveTo(9.448f, 7.0f, 9.0f, 6.552f, 9.0f, 6.0f)
                close()
            }
            path(
            	fill = SolidColor(Color(0xFF0F0F0F))
            ) {
                moveTo(13.0f, 6.0f)
                curveTo(13.0f, 5.448f, 13.448f, 5.0f, 14.0f, 5.0f)
                curveTo(14.552f, 5.0f, 15.0f, 5.448f, 15.0f, 6.0f)
                curveTo(15.0f, 6.552f, 14.552f, 7.0f, 14.0f, 7.0f)
                curveTo(13.448f, 7.0f, 13.0f, 6.552f, 13.0f, 6.0f)
                close()
            }
            path(
            	fill = SolidColor(Color(0xFF0F0F0F))
            ) {
                moveTo(17.0f, 6.0f)
                curveTo(17.0f, 5.448f, 17.448f, 5.0f, 18.0f, 5.0f)
                curveTo(18.552f, 5.0f, 19.0f, 5.448f, 19.0f, 6.0f)
                curveTo(19.0f, 6.552f, 18.552f, 7.0f, 18.0f, 7.0f)
                curveTo(17.448f, 7.0f, 17.0f, 6.552f, 17.0f, 6.0f)
                close()
            }
            path(
            	fill = SolidColor(Color(0xFF0F0F0F)),
            	pathFillType = EvenOdd
            ) {
                moveTo(20.0f, 1.0f)
                curveTo(21.657f, 1.0f, 23.0f, 2.343f, 23.0f, 4.0f)
                verticalLineTo(12.0f)
                curveTo(23.0f, 13.657f, 21.657f, 15.0f, 20.0f, 15.0f)
                horizontalLineTo(4.0f)
                curveTo(2.343f, 15.0f, 1.0f, 13.657f, 1.0f, 12.0f)
                verticalLineTo(4.0f)
                curveTo(1.0f, 2.343f, 2.343f, 1.0f, 4.0f, 1.0f)
                horizontalLineTo(20.0f)
                close()
                moveTo(20.0f, 3.0f)
                curveTo(20.552f, 3.0f, 21.0f, 3.448f, 21.0f, 4.0f)
                verticalLineTo(12.0f)
                curveTo(21.0f, 12.552f, 20.552f, 13.0f, 20.0f, 13.0f)
                horizontalLineTo(4.0f)
                curveTo(3.448f, 13.0f, 3.0f, 12.552f, 3.0f, 12.0f)
                verticalLineTo(4.0f)
                curveTo(3.0f, 3.448f, 3.448f, 3.0f, 4.0f, 3.0f)
                horizontalLineTo(20.0f)
                close()
            }
            path(
            	fill = SolidColor(Color(0xFF0F0F0F))
            ) {
                moveTo(7.707f, 19.757f)
                curveTo(7.317f, 19.367f, 7.317f, 18.734f, 7.707f, 18.343f)
                curveTo(8.098f, 17.953f, 8.731f, 17.953f, 9.121f, 18.343f)
                lineTo(11.95f, 21.172f)
                lineTo(14.778f, 18.343f)
                curveTo(15.169f, 17.953f, 15.802f, 17.953f, 16.192f, 18.343f)
                curveTo(16.583f, 18.734f, 16.583f, 19.367f, 16.192f, 19.757f)
                lineTo(13.364f, 22.586f)
                curveTo(13.364f, 22.586f, 13.364f, 22.586f, 13.364f, 22.586f)
                curveTo(12.583f, 23.367f, 11.317f, 23.367f, 10.535f, 22.586f)
                lineTo(7.707f, 19.757f)
                close()
            }
        }
        return _icKeyboardHide!!
    }

private var _icKeyboardHide: ImageVector? = null
