#include "test.h"

TEST(test_player_hmn_extras)
{
	xmp_context opaque;
	struct xmp_frame_info info;
	struct xmp_channel_info *ci;
	int time, row, frame, chan, period, volume, ins, pan, smp;
	char line[200];
	char *ret;
	FILE *f;
	int i, j;

	f = fopen("data/hmn_extras.data", "r");

	opaque = xmp_create_context();
	xmp_load_module(opaque, "data/Gaffeltruck.mod");
	xmp_start_player(opaque, 44100, 0);

	for (i = 0; i < 500; i++) {
		xmp_play_frame(opaque);
		xmp_get_frame_info(opaque, &info);

		for (j = 0; j < 4; j++) {
			ci = &info.channel_info[j];
			ret = fgets(line, 200, f);
			fail_unless(ret == line, "read error");

			sscanf(line, "%d %d %d %d %d %d %d %d %d",
					&time, &row, &frame, &chan, &period,
					&volume, &ins, &pan, &smp);

			fail_unless(info.time  == time,  "time mismatch");
			fail_unless(info.row   == row,   "row mismatch");
			fail_unless(info.frame == frame, "frame mismatch");
			fail_unless(ci->sample == smp,   "sample mismatch");
		}
	}

	ret = fgets(line, 200, f);
	fail_unless(ret == NULL && feof(f), "not end of data file");

	xmp_end_player(opaque);
	xmp_release_module(opaque);
	xmp_free_context(opaque);
}
END_TEST
