#ifndef __MENUSTRINGS_H__
#define __MENUSTRINGS_H__

#include <stdexcept>

class Languages
{
public:
    static constexpr int16_t ENGLISH = 0;
    static constexpr int16_t FRENCH = 1;
    static constexpr int16_t GERMAN = 2;
    static constexpr int16_t ITALIAN = 3;
    static constexpr int16_t SPANISH = 4;
    static constexpr int16_t MAX = 5;
};

class Translations
{
public:
    static constexpr int16_t NAME = 0;
    static constexpr int16_t CODE = 1;
    static constexpr int16_t MAX = 2;
};

class BookStrings
{
public:
    static constexpr int16_t POLITICS_TITLE = 0;
    static constexpr int16_t POLITICS_TEXT = 1;
    static constexpr int16_t ROMANCE1_TITLE = 2;
    static constexpr int16_t ROMANCE1_TEXT = 3;
    static constexpr int16_t BEHAVIOR_TITLE = 4;
    static constexpr int16_t BEHAVIOR_TEXT = 5;
    static constexpr int16_t GENETICS_TITLE = 6;
    static constexpr int16_t GENETICS_TEXT = 7;
    static constexpr int16_t BRAWNY_TITLE = 8;
    static constexpr int16_t BRAWNY_TEXT = 9;
    static constexpr int16_t BEER_TITLE = 10;
    static constexpr int16_t BEER_TEXT = 11;
    static constexpr int16_t KNIFE_TITLE = 12;
    static constexpr int16_t KNIFE_TEXT = 13;
    static constexpr int16_t ROMANCE2_TITLE = 14;
    static constexpr int16_t ROMANCE2_TEXT = 15;
    static constexpr int16_t OCCULT_TITLE = 16;
    static constexpr int16_t OCCULT_TEXT = 17;
    static constexpr int16_t HUSBAND_TITLE = 18;
    static constexpr int16_t HUSBAND_TEXT = 19;
    static constexpr int16_t ROMANCE3_TITLE = 20;
    static constexpr int16_t ROMANCE3_TEXT = 21;
    static constexpr int16_t BREATHING_TITLE = 22;
    static constexpr int16_t BREATHING_TEXT = 23;
    static constexpr int16_t ROMANCE4_TITLE = 24;
    static constexpr int16_t ROMANCE4_TEXT = 25;
    static constexpr int16_t BODY_TITLE = 26;
    static constexpr int16_t BODY_TEXT = 27;
    static constexpr int16_t LEADERSHIP_TITLE = 28;
    static constexpr int16_t LEADERSHIP_TEXT = 29;
    static constexpr int16_t LEADERSHIP2_TITLE = 30;
    static constexpr int16_t LEADERSHIP2_TEXT = 31;
    static constexpr int16_t POULTRY_TITLE = 32;
    static constexpr int16_t POULTRY_TEXT = 33;
    static constexpr int16_t ROMANCE5_TITLE = 34;
    static constexpr int16_t ROMANCE5_TEXT = 35;
    static constexpr int16_t ROMANCE6_TITLE = 36;
    static constexpr int16_t ROMANCE6_TEXT = 37;
    static constexpr int16_t ROMANCE7_TITLE = 38;
    static constexpr int16_t ROMANCE7_TEXT = 39;
    static constexpr int16_t ROMANCE8_TITLE = 40;
    static constexpr int16_t ROMANCE8_TEXT = 41;
    static constexpr int16_t FALLING_TITLE = 42;
    static constexpr int16_t FALLING_TEXT = 43;
    static constexpr int16_t DEFENSE_TITLE = 44;
    static constexpr int16_t DEFENSE_TEXT = 45;
    static constexpr int16_t EVADE_TITLE = 46;
    static constexpr int16_t EVADE_TEXT = 47;
    static constexpr int16_t PICKING_TITLE = 48;
    static constexpr int16_t PICKING_TEXT = 49;
    static constexpr int16_t DUCKHUNT_TITLE = 50;
    static constexpr int16_t DUCKHUNT_TEXT = 51;
    static constexpr int16_t HAPPYNESS_TITLE = 52;
    static constexpr int16_t HAPPYNESS_TEXT = 53;
    static constexpr int16_t CHI_TITLE = 54;
    static constexpr int16_t CHI_TEXT = 55;
    static constexpr int16_t ELLI_TITLE = 56;
    static constexpr int16_t ELLI_TEXT = 57;
    static constexpr int16_t MAX = 58;
};

class CodeStrings
{
public:
    static constexpr int16_t GENHELP_NPC = 0;
    static constexpr int16_t GENHELP_LOCKEDOBJECT = 1;
    static constexpr int16_t GENHELP_BARRICADE = 2;
    static constexpr int16_t GENHELP_CRATE = 3;
    static constexpr int16_t GENHELP_MIXING_STATION = 4;
    static constexpr int16_t GENHELP_FOOD = 5;
    static constexpr int16_t GENHELP_JOURNAL = 6;
    static constexpr int16_t GENHELP_RUBBLE = 7;
    static constexpr int16_t GENHELP_DOORS = 8;
    static constexpr int16_t GENHELP_WEAPONS = 9;
    static constexpr int16_t GENHELP_BARRELS = 10;
    static constexpr int16_t GENHELP_PICKUP = 11;
    static constexpr int16_t GENHELP_AIR_BUBBLES = 12;
    static constexpr int16_t GENHELP_HEALTH_WARNING1 = 13;
    static constexpr int16_t GENHELP_HEALTH_WARNING2 = 14;
    static constexpr int16_t GENHELP_WATER_WEAPON = 15;
    static constexpr int16_t RANK0_NAME = 16;
    static constexpr int16_t RANK0_TEXT = 17;
    static constexpr int16_t RANK1_NAME = 18;
    static constexpr int16_t RANK1_TEXT = 19;
    static constexpr int16_t RANK2_NAME = 20;
    static constexpr int16_t RANK2_TEXT = 21;
    static constexpr int16_t RANK3_NAME = 22;
    static constexpr int16_t RANK3_TEXT = 23;
    static constexpr int16_t RANK4_NAME = 24;
    static constexpr int16_t RANK4_TEXT = 25;
    static constexpr int16_t DIALOG_EXIT = 26;
    static constexpr int16_t INTERROGATE_HIT = 27;
    static constexpr int16_t INTERROGATE_BRIBE = 28;
    static constexpr int16_t DIALOG_PLAY = 29;
    static constexpr int16_t SYRINGE_MENU_HELP = 30;
    static constexpr int16_t OTHER_MENU_HELP = 31;
    static constexpr int16_t JOURNAL_MENU_HELP = 32;
    static constexpr int16_t HEALTH_MENU_HELP = 33;
    static constexpr int16_t WEAPON_MENU_HELP = 34;
    static constexpr int16_t STATUE = 35;
    static constexpr int16_t ERROR_MSG = 36;
    static constexpr int16_t GAME_SAVED = 37;
    static constexpr int16_t GAME_LOADED = 38;
    static constexpr int16_t SKIP = 39;
    static constexpr int16_t LOADING = 40;
    static constexpr int16_t ENTER = 41;
    static constexpr int16_t CONTINUE = 42;
    static constexpr int16_t DOOR_IS_LOCKED = 43;
    static constexpr int16_t TURN_PASSED = 44;
    static constexpr int16_t HEALTH_AT_MAXIMUM = 45;
    static constexpr int16_t SORRY = 46;
    static constexpr int16_t STOP = 47;
    static constexpr int16_t SEND_MESSAGE = 48;
    static constexpr int16_t DETAILS = 49;
    static constexpr int16_t DOUBLE_SPACED = 50;
    static constexpr int16_t LOADING_GAME = 51;
    static constexpr int16_t MENU = 52;
    static constexpr int16_t LEAVE = 53;
    static constexpr int16_t HELP = 54;
    static constexpr int16_t MAP = 55;
    static constexpr int16_t MORE = 56;
    static constexpr int16_t PROCESSING = 57;
    static constexpr int16_t JUST_A_MOMENT = 58;
    static constexpr int16_t MONSTER_IS_IMMUNE = 59;
    static constexpr int16_t MONSTER_STUNNED = 60;
    static constexpr int16_t LAST_SHOT = 61;
    static constexpr int16_t ONE_SHOT_LEFT = 62;
    static constexpr int16_t X_SHOTS_LEFT = 63;
    static constexpr int16_t OUT_OF_RANGE = 64;
    static constexpr int16_t X_DODGED = 65;
    static constexpr int16_t X_BLOCKED = 66;
    static constexpr int16_t DODGED = 67;
    static constexpr int16_t MISSED = 68;
    static constexpr int16_t X_MISSED = 69;
    static constexpr int16_t BACK_ATTACK = 70;
    static constexpr int16_t BACK_ATTACK2 = 71;
    static constexpr int16_t CRIT = 72;
    static constexpr int16_t X_DAMAGE = 73;
    static constexpr int16_t DEFLECTED = 74;
    static constexpr int16_t WEAPON_DEFLECT = 75;
    static constexpr int16_t TOOK_DAMAGE_DEAD = 76;
    static constexpr int16_t TOOK_DAMAGE = 77;
    static constexpr int16_t WEAPON_AMMO = 78;
    static constexpr int16_t BASE_DAMAGE = 79;
    static constexpr int16_t IDEAL_RANGE1 = 80;
    static constexpr int16_t IDEAL_RANGE2 = 81;
    static constexpr int16_t DEFLECT_X = 82;
    static constexpr int16_t FOR_MORE_DETAILS = 83;
    static constexpr int16_t IT_BURNS = 84;
    static constexpr int16_t CANT_HOLD_MORE = 85;
    static constexpr int16_t GOT_KEY = 86;
    static constexpr int16_t GOT_X = 87;
    static constexpr int16_t GOT_X_Y = 88;
    static constexpr int16_t AMMO_AT_MAX = 89;
    static constexpr int16_t X_FLEES = 90;
    static constexpr int16_t X_DESTROYED = 91;
    static constexpr int16_t DASH_X_Y = 92;
    static constexpr int16_t DASH_X = 93;
    static constexpr int16_t X_RAISE_FAILED = 94;
    static constexpr int16_t X_RAISES_Y = 95;
    static constexpr int16_t X_HEALS_Y = 96;
    static constexpr int16_t X_FIRE_DAMAGE = 97;
    static constexpr int16_t X_CONSUMES_Y = 98;
    static constexpr int16_t HARBINGER_HEALS = 99;
    static constexpr int16_t PRESS_OK = 100;
    static constexpr int16_t AMMO = 101;
    static constexpr int16_t HEALTH = 102;
    static constexpr int16_t TARGET = 103;
    static constexpr int16_t STATUS = 104;
    static constexpr int16_t EFFECTS = 105;
    static constexpr int16_t CURRENT_GOLD = 106;
    static constexpr int16_t DISEASE_DEALS = 107;
    static constexpr int16_t LOST_X_XP = 108;
    static constexpr int16_t GAINED_X_XP = 109;
    static constexpr int16_t LEVEL_UP = 110;
    static constexpr int16_t MAX_HEALTH = 111;
    static constexpr int16_t DEFENSE = 112;
    static constexpr int16_t STRENGTH = 113;
    static constexpr int16_t ACCURACY = 114;
    static constexpr int16_t AGILITY = 115;
    static constexpr int16_t HEALTH_RESTORED = 116;
    static constexpr int16_t GAINED_HEALTH = 117;
    static constexpr int16_t X_DID_Y_DAMAGE = 118;
    static constexpr int16_t NEAR_DEATH = 119;
    static constexpr int16_t LOW_HEALTH = 120;
    static constexpr int16_t OUT_OF_AMMO = 121;
    static constexpr int16_t OUT_OF_ENERGY = 122;
    static constexpr int16_t OUT_OF_AIR = 123;
    static constexpr int16_t PAIN = 124;
    static constexpr int16_t FOUND_SECRET = 125;
    static constexpr int16_t CANCEL = 126;
    static constexpr int16_t SELECT = 127;
    static constexpr int16_t PLAYER_DRUNK = 128;
    static constexpr int16_t GAME_VERSION = 129;
    static constexpr int16_t GAME_BUILD = 130;
    static constexpr int16_t GAME_STATUS = 131;
    static constexpr int16_t PAGEUP = 132;
    static constexpr int16_t MIXING_TITLE = 133;
    static constexpr int16_t PRESS_OK_TO_MIX = 134;
    static constexpr int16_t PRESS_OK_TO_ADD = 135;
    static constexpr int16_t PRESS_OK_TO_EXIT = 136;
    static constexpr int16_t INGREDIENTS_TITLE = 137;
    static constexpr int16_t AMOUNT = 138;
    static constexpr int16_t UNDO = 139;
    static constexpr int16_t UNKNOWN_MIX = 140;
    static constexpr int16_t EMPTY_STATION = 141;
    static constexpr int16_t MUST_HAVE_EMPTY = 142;
    static constexpr int16_t CREATED_X = 143;
    static constexpr int16_t CONTAINS = 144;
    static constexpr int16_t YOU_RECEIVE = 145;
    static constexpr int16_t REFLECTED_X = 146;
    static constexpr int16_t YOU_LOST = 147;
    static constexpr int16_t YOU_WIN = 148;
    static constexpr int16_t WAR_NAME = 149;
    static constexpr int16_t GO_TO_WAR = 150;
    static constexpr int16_t CARDS_TOTAL_WIN = 151;
    static constexpr int16_t CARDS_TOTAL_LOSS = 152;
    static constexpr int16_t PLAYER_GOLD_ERR = 153;
    static constexpr int16_t POINTS = 154;
    static constexpr int16_t KICK_TURNS = 155;
    static constexpr int16_t OUT_OF_BOUNDS = 156;
    static constexpr int16_t HIGH_SCORE_TITLE = 157;
    static constexpr int16_t YOUR_SCORE = 158;
    static constexpr int16_t MOVE_CURSOR = 159;
    static constexpr int16_t RANK_TITLE = 160;
    static constexpr int16_t NAME_TITLE = 161;
    static constexpr int16_t SCORE_TITLE = 162;
    static constexpr int16_t FIRST_SCORE = 163;
    static constexpr int16_t SECOND_SCORE = 164;
    static constexpr int16_t THIRD_SCORE = 165;
    static constexpr int16_t FOURTH_SCORE = 166;
    static constexpr int16_t FIFTH_SCORE = 167;
    static constexpr int16_t CHICKEN_NAME = 168;
    static constexpr int16_t KICKING_DONE = 169;
    static constexpr int16_t SYRINGES_ITEM = 170;
    static constexpr int16_t PROLOGUE_SCROLLING_TXT = 171;
    static constexpr int16_t BRIEFING_TXT = 172;
    static constexpr int16_t EPILOGUE_SCROLLING_TXT = 173;
    static constexpr int16_t MEDAL_AWARDED = 174;
    static constexpr int16_t NO_LABEL = 175;
    static constexpr int16_t YES_LABEL = 176;
    static constexpr int16_t BOOK_LABEL = 177;
    static constexpr int16_t READ_OPTION = 178;
    static constexpr int16_t STAT_GAIN = 179;
    static constexpr int16_t RECIEVED_NOTHING = 180;
    static constexpr int16_t RECIEVED_STAT = 181;
    static constexpr int16_t GAME_PICK = 182;
    static constexpr int16_t WAR_PICK = 183;
    static constexpr int16_t WAR_TOSS = 184;
    static constexpr int16_t WAR_TOSS2 = 185;
    static constexpr int16_t DESTROYED_LOOT = 186;
    static constexpr int16_t MOVE_INSTRUCTION = 187;
    static constexpr int16_t DEALER_CHOOSING = 188;
    static constexpr int16_t EFFECT_NONE = 189;
    static constexpr int16_t EFFECT_REFLECT = 190;
    static constexpr int16_t EFFECT_PURIFY = 191;
    static constexpr int16_t EFFECT_AGILITY = 192;
    static constexpr int16_t EFFECT_REGEN = 193;
    static constexpr int16_t EFFECT_DEFENSE = 194;
    static constexpr int16_t EFFECT_ADRENALINE = 195;
    static constexpr int16_t EFFECT_EVADE = 196;
    static constexpr int16_t EFFECT_FOCUS = 197;
    static constexpr int16_t EFFECT_ANGER = 198;
    static constexpr int16_t EFFECT_ANTIFIRE = 199;
    static constexpr int16_t EFFECT_FORTITUDE = 200;
    static constexpr int16_t EFFECT_FEAR = 201;
    static constexpr int16_t EFFECT_AIR = 202;
    static constexpr int16_t EFFECT_FIRE = 203;
    static constexpr int16_t EFFECT_DISEASE = 204;
    static constexpr int16_t EFFECT_DRUNK = 205;
    static constexpr int16_t EFFECT_DIZZY = 206;
    static constexpr int16_t INSUFFICIENT_MSG = 207;
    static constexpr int16_t MAX = 208;
};

class FileStrings
{
public:
    static constexpr int16_t CREDITS = 0;
    static constexpr int16_t HELP_GENERAL = 1;
    static constexpr int16_t HELP_MOVE = 2;
    static constexpr int16_t HELP_ATTACK = 3;
    static constexpr int16_t HELP_HELMET = 4;
    static constexpr int16_t HELP_EFFECTS = 5;
    static constexpr int16_t HELP_ITEMS = 6;
    static constexpr int16_t HELP_SNIPER = 7;
    static constexpr int16_t HELP_WAR = 8;
    static constexpr int16_t HELP_KICKING = 9;
    static constexpr int16_t LEGALS = 10;
    static constexpr int16_t MAX = 11;
};

class MedalStrings
{
public:
    static constexpr int16_t EMPTY_STRING = 0;
    static constexpr int16_t MEDAL_LOOT = 1;
    static constexpr int16_t MEDAL_SECRETS = 2;
    static constexpr int16_t MEDAL_ENEMIES = 3;
    static constexpr int16_t MEDAL_DESTROYED = 4;
    static constexpr int16_t MEDAL_BOOKS = 5;
    static constexpr int16_t MEDAL_TOMB_RAIDER = 6;
    static constexpr int16_t MAX = 7;
};

class Strings
{
public:

    static constexpr int16_t FILE_BOOKSTRINGS = 0;
    static constexpr int16_t FILE_CODESTRINGS = 1;
    static constexpr int16_t FILE_ENTITYSTRINGS = 2;
    static constexpr int16_t FILE_FILESTRINGS = 3;
    static constexpr int16_t FILE_MEDALSTRINGS = 4;
    static constexpr int16_t FILE_MENUSTRINGS = 5;
    static constexpr int16_t FILE_M_01 = 6;
    static constexpr int16_t FILE_M_02 = 7;
    static constexpr int16_t FILE_M_03 = 8;
    static constexpr int16_t FILE_M_04 = 9;
    static constexpr int16_t FILE_M_05 = 10;
    static constexpr int16_t FILE_M_06 = 11;
    static constexpr int16_t FILE_M_07 = 12;
    static constexpr int16_t FILE_M_08 = 13;
    static constexpr int16_t FILE_M_09 = 14;
    static constexpr int16_t FILE_M_TEST = 15;
    static constexpr int16_t FILE_TRANSLATIONS = 16;
    static constexpr int16_t FILE_MAX = 17;
};

class MenuStrings
{
public:
    static constexpr int16_t EMPTY_STRING = 0;
    static constexpr int16_t EMPTY_INVENTORY = 1;
    static constexpr int16_t PLAYER_TITLE = 2;
    static constexpr int16_t HEALTH_LABEL = 3;
    static constexpr int16_t HEALTH_HELP = 4;
    static constexpr int16_t ARMOR_LABEL = 5;
    static constexpr int16_t ARMOR_HELP = 6;
    static constexpr int16_t RANK_LABEL = 7;
    static constexpr int16_t RANK_HELP = 8;
    static constexpr int16_t CUR_XP_LABEL = 9;
    static constexpr int16_t CUR_XP_HELP = 10;
    static constexpr int16_t NEXT_XP_LABEL = 11;
    static constexpr int16_t NEXT_XP_HELP = 12;
    static constexpr int16_t DEFENSE_LABEL = 13;
    static constexpr int16_t DEFENSE_HELP = 14;
    static constexpr int16_t STRENGTH_LABEL = 15;
    static constexpr int16_t STRENGTH_HELP = 16;
    static constexpr int16_t FOCUS_LABEL = 17;
    static constexpr int16_t FOCUS_HELP = 18;
    static constexpr int16_t EVADE_LABEL = 19;
    static constexpr int16_t EVADE_HELP = 20;
    static constexpr int16_t STATUS_TITLE = 21;
    static constexpr int16_t PLAYER_MENU = 22;
    static constexpr int16_t PLAYER_MENU_DESC = 23;
    static constexpr int16_t LEVEL_MENU = 24;
    static constexpr int16_t LEVEL_MENU_DESC = 25;
    static constexpr int16_t MEDALS_MENU = 26;
    static constexpr int16_t MEDALS_MENU_DESC = 27;
    static constexpr int16_t MEDALS_LVL_DESC = 28;
    static constexpr int16_t TOTAL_MEDALS = 29;
    static constexpr int16_t TOTAL_MEDALS_DESC = 30;
    static constexpr int16_t LEVELS_TITLE = 31;
    static constexpr int16_t TIME_LABEL = 32;
    static constexpr int16_t TIME_HELP = 33;
    static constexpr int16_t SECRETS_LABEL = 34;
    static constexpr int16_t SECRETS_HELP = 35;
    static constexpr int16_t MONSTERS_LABEL = 36;
    static constexpr int16_t MONSTERS_HELP = 37;
    static constexpr int16_t TOTAL_TURNS_LABEL = 38;
    static constexpr int16_t TURNS_LABEL = 38;
    static constexpr int16_t TURNS_HELP = 39;
    static constexpr int16_t LOOT_LABEL = 40;
    static constexpr int16_t LOOT_HELP = 41;
    static constexpr int16_t WORLD_LABEL = 42;
    static constexpr int16_t WORLD_HELP = 43;
    static constexpr int16_t BOOKS_LABEL = 44;
    static constexpr int16_t BOOKS_HELP = 45;
    static constexpr int16_t TOTAL_TIME_LABEL = 32;
    static constexpr int16_t TOTAL_TIME_HELP = 46;
    static constexpr int16_t TOTAL_TURNS_HELP = 47;
    static constexpr int16_t DEATHS_LABEL = 48;
    static constexpr int16_t DEATHS_HELP = 49;
    static constexpr int16_t TOTAL_TREASURE_LABEL = 50;
    static constexpr int16_t TOTAL_TREASURE_HELP = 51;
    static constexpr int16_t HEAVIEST_BLOW_LABEL = 52;
    static constexpr int16_t HEAVIEST_BLOW_HELP = 53;
    static constexpr int16_t SHOTS_FIRED = 54;
    static constexpr int16_t SHOTS_FIRED_HELP = 55;
    static constexpr int16_t SHOTS_MISSED = 56;
    static constexpr int16_t SHOTS_MISSED_HELP = 57;
    static constexpr int16_t TOTAL_DAMAGE_LABEL = 58;
    static constexpr int16_t TOTAL_DAMAGE_HELP = 59;
    static constexpr int16_t TURNS_DRUNK_LABEL = 60;
    static constexpr int16_t TURNS_DRUNK_HELP = 61;
    static constexpr int16_t WEAPON_TITLE = 62;
    static constexpr int16_t SYRINGE_LABEL = 63;
    static constexpr int16_t PERFECT_SECRETS_TITLE = 64;
    static constexpr int16_t LABEL_NONE2 = 65;
    static constexpr int16_t CONTINUE_ITEM = 66;
    static constexpr int16_t NEW_GAME_ITEM = 67;
    static constexpr int16_t OPTIONS_ITEM = 68;
    static constexpr int16_t MINI_GAME = 69;
    static constexpr int16_t HELP_ITEM = 70;
    static constexpr int16_t HELP_TITLE = 70;
    static constexpr int16_t ABOUT_ITEM = 71;
    static constexpr int16_t EXIT_ITEM = 72;
    static constexpr int16_t MORE_GAMES_ITEM = 73;
    static constexpr int16_t OPTIONS_ITEM_HELP = 74;
    static constexpr int16_t HELP_ITEM_HELP = 75;
    static constexpr int16_t BACK_ITEM = 76;
    static constexpr int16_t BACK_ITEM2 = 77;
    static constexpr int16_t BACK_ITEM3 = 77;
    static constexpr int16_t BACK_ITEM_HELP = 78;
    static constexpr int16_t HOW_TO_PLAY_ITEM = 79;
    static constexpr int16_t HOW_TO_PLAY_ITEM_HELP = 80;
    static constexpr int16_t HOW_TO_MOVE_ITEM = 81;
    static constexpr int16_t HOW_TO_MOVE_ITEM_HELP = 82;
    static constexpr int16_t HOW_TO_ATTACK_ITEM = 83;
    static constexpr int16_t HOW_TO_ATTACK_ITEM_HELP = 84;
    static constexpr int16_t SNIPER_RIFLE_ITEM = 85;
    static constexpr int16_t SNIPER_RIFLE_ITEM_HELP = 86;
    static constexpr int16_t ARMOR_HELP_ITEM = 87;
    static constexpr int16_t ARMOR_HELP_ITEM_HELP = 88;
    static constexpr int16_t ITEM_HELP_ITEM = 89;
    static constexpr int16_t ITEM_HELP_ITEM_HELP = 90;
    static constexpr int16_t CHICKEN_KICKING_TITLE1 = 91;
    static constexpr int16_t PLAY_CHICKEN = 91;
    static constexpr int16_t KICKING_HELP_ITEM = 91;
    static constexpr int16_t KICKING_HELP_ITEM_HELP = 92;
    static constexpr int16_t WAR_HELP_ITEM = 93;
    static constexpr int16_t WAR_HELP_ITEM_HELP = 94;
    static constexpr int16_t EFFECTS_HELP_ITEM = 95;
    static constexpr int16_t EFFECTS_HELP_ITEM_HELP = 96;
    static constexpr int16_t CREDITS_ITEM = 97;
    static constexpr int16_t CREDITS_ITEM2 = 98;
    static constexpr int16_t CREDITS_ITEM_HELP = 99;
    static constexpr int16_t EXIT_GAME_PROMPT = 100;
    static constexpr int16_t ERASE_CONFIRM_PROMPT = 101;
    static constexpr int16_t CONFIRM_PROMPT = 102;
    static constexpr int16_t RESUME_GAME_ITEM = 103;
    static constexpr int16_t RESUME_GAME_ITEM_HELP = 104;
    static constexpr int16_t ITEMS_TITLE = 105;
    static constexpr int16_t ITEMS_HEALTH_TITLE = 106;
    static constexpr int16_t ITEMS_ITEM = 107;
    static constexpr int16_t ITEMS_ITEM_HELP = 108;
    static constexpr int16_t JOURNAL_ITEM = 109;
    static constexpr int16_t JOURNAL_ITEM_HELP = 110;
    static constexpr int16_t SAVE_GAME_ITEM = 111;
    static constexpr int16_t SAVE_GAME_ITEM_HELP = 112;
    static constexpr int16_t LOAD_GAME_ITEM = 113;
    static constexpr int16_t LOAD_GAME_ITEM_HELP = 114;
    static constexpr int16_t VIEW_MAP_ITEM = 115;
    static constexpr int16_t VIEW_MAP_ITEM_HELP = 116;
    static constexpr int16_t STATUS_ITEM = 117;
    static constexpr int16_t STATUS_ITEM_HELP = 118;
    static constexpr int16_t RESTART_LEVEL_ITEM = 119;
    static constexpr int16_t RESTART_LEVEL_ITEM_HELP = 120;
    static constexpr int16_t SAVE_AND_QUIT_ITEM = 121;
    static constexpr int16_t SAVE_AND_QUIT_ITEM_HELP = 122;
    static constexpr int16_t MAIN_MENU_ITEM = 123;
    static constexpr int16_t MAIN_MENU_ITEM_HELP = 124;
    static constexpr int16_t MINIGAME_MENU_ITEM = 125;
    static constexpr int16_t MINIGAME_MENU_ITEM_HELP = 126;
    static constexpr int16_t RESTART_LEVEL_PROMPT = 127;
    static constexpr int16_t LOAD_GAME_PROMPT = 128;
    static constexpr int16_t EXIT_MAIN_PROMPT = 129;
    static constexpr int16_t NO_SAVED_GAME_LABEL = 130;
    static constexpr int16_t GAME_HELP_TITLE = 131;
    static constexpr int16_t PRESS_OK_TO_LABEL = 132;
    static constexpr int16_t WOLFENSTEIN_LABEL = 133;
    static constexpr int16_t ON_LABEL = 134;
    static constexpr int16_t OFF_LABEL = 135;
    static constexpr int16_t SOUND_LABEL = 136;
    static constexpr int16_t VIBRATE_LABEL = 137;
    static constexpr int16_t SOUND_FX_VOLUME = 138;
    static constexpr int16_t SOUND_MUSIC_VOLUME = 139;
    static constexpr int16_t LANGUAGE = 140;
    static constexpr int16_t GO_TO_MAIN_MENU_PROMPT = 141;
    static constexpr int16_t SAVE_GAME_ITEM2 = 142;
    static constexpr int16_t DONT_SAVE_LABEL = 143;
    static constexpr int16_t CANCEL_LABEL = 144;
    static constexpr int16_t PRISON_ITEM = 145;
    static constexpr int16_t CATACOMBS_ITEM = 146;
    static constexpr int16_t DARKNESS_ITEM = 147;
    static constexpr int16_t GRAVE_YARD_ITEM = 148;
    static constexpr int16_t BARRACKS_ITEM = 149;
    static constexpr int16_t TOWN_ITEM = 150;
    static constexpr int16_t SEWERS_ITEM = 151;
    static constexpr int16_t CASTLE_ITEM = 152;
    static constexpr int16_t CASTLE2_ITEM = 153;
    static constexpr int16_t TEST_MAP_ITEM = 154;
    static constexpr int16_t RECIPE_ITEM = 155;
    static constexpr int16_t RECIPE_TITLE = 156;
    static constexpr int16_t RECIPE_EMPTY = 157;
    static constexpr int16_t ENABLE_SOUNDS_PROMPT = 158;
    static constexpr int16_t TRY_AGAIN_PROMPT = 159;
    static constexpr int16_t TRY_AGAIN_LOAD_ITEM = 160;
    static constexpr int16_t TRY_AGAIN_RESTART_ITEM = 161;
    static constexpr int16_t TRY_AGAIN_MAINMENU_ITEM = 162;
    static constexpr int16_t YES_PLEASE_ITEM = 163;
    static constexpr int16_t NO_THANKS_ITEM = 164;
    static constexpr int16_t WEAPONS_ITEM = 165;
    static constexpr int16_t WEAPONS_ITEM_HELP = 166;
    static constexpr int16_t SYRINGES_TITLE = 167;
    static constexpr int16_t SYRINGES_ITEM = 168;
    static constexpr int16_t SYRINGES_ITEM_HELP = 169;
    static constexpr int16_t TREASURE_TITLE = 170;
    static constexpr int16_t TREASURE_ITEM = 171;
    static constexpr int16_t TREASURE_ITEM_HELP = 172;
    static constexpr int16_t OTHER_TITLE = 173;
    static constexpr int16_t OTHER_ITEM = 174;
    static constexpr int16_t OTHER_ITEM_HELP = 175;
    static constexpr int16_t USE_LABEL = 176;
    static constexpr int16_t YOUR_HEALTH_IS_LABEL = 177;
    static constexpr int16_t AT_ITS_MAXIMUM_LABEL = 178;
    static constexpr int16_t OK_LABEL = 179;
    static constexpr int16_t CANNOT_USE_SYRINGE_LABEL = 180;
    static constexpr int16_t CANNOT_USE_ALCOHOL_LABEL = 181;
    static constexpr int16_t EFFECT_AT_MAX_LABEL = 182;
    static constexpr int16_t X_LABEL = 183;
    static constexpr int16_t MENU_ITEM = 184;
    static constexpr int16_t LOADING_GAME_LABEL = 185;
    static constexpr int16_t GAME_LOADED_LABEL = 186;
    static constexpr int16_t SAVING_GAME_LABEL = 187;
    static constexpr int16_t YES_LABEL = 188;
    static constexpr int16_t NO_LABEL = 189;
    static constexpr int16_t VERSION_TITLE = 190;
    static constexpr int16_t RANKING_TITLE = 191;
    static constexpr int16_t DIFFICULT_RANK_TITLE = 192;
    static constexpr int16_t NIGHTMARE_RANK_TITLE = 193;
    static constexpr int16_t YOUR_SCORE_LABEL = 194;
    static constexpr int16_t YOUR_RANK_LABEL = 195;
    static constexpr int16_t CONTINUE_PLAYING_PROMPT = 196;
    static constexpr int16_t CHOOSE_DIFFICULTY = 197;
    static constexpr int16_t DIFFICULTY_NORMAL = 198;
    static constexpr int16_t DIFFICULTY_DIFFICULT = 199;
    static constexpr int16_t DIFFICULTY_NIGHTMARE = 200;
    static constexpr int16_t JOURNAL_ENTRY_FAILED = 201;
    static constexpr int16_t SAVING_CONFIG_LABEL = 202;
    static constexpr int16_t VERSION_LABEL = 203;
    static constexpr int16_t SAVE_GAME_PROMPT = 204;
    static constexpr int16_t PLAY_WAR = 205;
    static constexpr int16_t MEDALS_EARNED = 206;
    static constexpr int16_t BONUS_MEDALS = 207;
    static constexpr int16_t YOU_GOT = 208;
    static constexpr int16_t DETAIL_MENU = 209;
    static constexpr int16_t BOOKS_TITLE = 210;
    static constexpr int16_t BOOKS_ITEM_HELP = 211;
    static constexpr int16_t CHICKEN_KICKING_TITLE2 = 212;
    static constexpr int16_t CHICKEN_KICKING_HIGH_SCORES = 213;
    static constexpr int16_t CHICKEN_KICKING_INITIALS = 214;
    static constexpr int16_t CHICKEN_KICKING_SCORE = 215;
    static constexpr int16_t MORE_GAMES0 = 216;
    static constexpr int16_t MORE_GAMES1 = 217;
    static constexpr int16_t MORE_GAMES2 = 218;
    static constexpr int16_t ARGUMENT1 = 219;
    static constexpr int16_t ARGUMENT2 = 220;
    static constexpr int16_t ARGUMENT3 = 221;
    static constexpr int16_t ARGUMENT4 = 222;
    static constexpr int16_t ARGUMENT5 = 223;
    static constexpr int16_t ARGUMENT6 = 224;
    static constexpr int16_t ARGUMENT7 = 225;
    static constexpr int16_t ARGUMENT8 = 226;
    static constexpr int16_t ARGUMENT9 = 227;
    static constexpr int16_t ARGUMENT10 = 228;
    static constexpr int16_t ARGUMENT11 = 229;
    static constexpr int16_t ARGUMENT12 = 230;
    static constexpr int16_t ARGUMENT13 = 231;
    static constexpr int16_t ARGUMENT14 = 232;
    static constexpr int16_t ARGUMENT15 = 233;
    static constexpr int16_t ARGUMENT16 = 234;
    static constexpr int16_t ARGUMENT17 = 235;
    static constexpr int16_t ARGUMENT18 = 236;
    static constexpr int16_t ARGUMENT19 = 237;
    static constexpr int16_t ARGUMENT20 = 238;
    static constexpr int16_t ARGUMENT21 = 239;
    static constexpr int16_t ARGUMENT22 = 240;
    static constexpr int16_t ARGUMENT23 = 241;
    static constexpr int16_t ARGUMENT24 = 242;
    static constexpr int16_t ARGUMENT25 = 243;
    static constexpr int16_t ARGUMENT26 = 244;
    static constexpr int16_t ARGUMENT27 = 245;
    static constexpr int16_t ARGUMENT28 = 246;
    static constexpr int16_t ARGUMENT29 = 247;
    static constexpr int16_t ARGUMENT30 = 248;
    static constexpr int16_t ARGUMENT31 = 249;
    static constexpr int16_t ARGUMENT32 = 250;
    static constexpr int16_t ARGUMENT33 = 251;
    static constexpr int16_t ARGUMENT34 = 252;
    static constexpr int16_t ARGUMENT35 = 253;
    static constexpr int16_t ARGUMENT36 = 254;
    static constexpr int16_t ARGUMENT37 = 255;
    static constexpr int16_t ARGUMENT38 = 256;
    static constexpr int16_t ARGUMENT39 = 257;
    static constexpr int16_t ARGUMENT40 = 258;
    static constexpr int16_t ARGUMENT41 = 259;
    static constexpr int16_t ARGUMENT42 = 260;
    static constexpr int16_t ARGUMENT43 = 261;
    static constexpr int16_t ARGUMENT44 = 262;
    static constexpr int16_t ARGUMENT45 = 263;
    static constexpr int16_t ARGUMENT46 = 264;
    static constexpr int16_t ARGUMENT47 = 265;
    static constexpr int16_t ARGUMENT48 = 266;
    static constexpr int16_t ARGUMENT49 = 267;
    static constexpr int16_t ARGUMENT50 = 268;
    static constexpr int16_t R_SKIP_DECALS_ITEM = 269;
    static constexpr int16_t R_SKIP_2DSTRETCH_ITEM = 270;
    static constexpr int16_t DRIVING_MODE = 271;
    static constexpr int16_t DRIVING_MODE_SHOOT = 272;
    static constexpr int16_t DRIVING_MODE_AIM = 273;
    static constexpr int16_t DRIVING_MODE_TURN = 274;
    static constexpr int16_t RENDER_MODE = 275;
    static constexpr int16_t RENDER_OFF = 276;
    static constexpr int16_t RENDER_DEBUG = 277;
    static constexpr int16_t RENDER_DEFAULT = 278;
    static constexpr int16_t CHANGE_MAP_ITEM = 279;
    static constexpr int16_t DEBUG_SYS_ITEM = 280;
    static constexpr int16_t STATS_CHEAT_ITEM = 281;
    static constexpr int16_t SHOW_LOCATION_ITEM = 282;
    static constexpr int16_t R_FRAMES_ITEM = 283;
    static constexpr int16_t R_SPEEDS_ITEM = 284;
    static constexpr int16_t R_SKIP_CULL_ITEM = 285;
    static constexpr int16_t R_SKIP_BSP_ITEM = 286;
    static constexpr int16_t R_SKIP_FLATS_ITEM = 287;
    static constexpr int16_t R_SKIP_LINES_ITEM = 288;
    static constexpr int16_t R_SKIP_SPRITES_ITEM = 289;
    static constexpr int16_t R_ONLY_RENDER_ITEM = 290;
    static constexpr int16_t NO_CLIP_ITEM = 291;
    static constexpr int16_t ONE_SHOT_ITEM = 292;
    static constexpr int16_t DISABLE_AI_ITEM = 293;
    static constexpr int16_t EQUIP_FOR_MAP_ITEM = 294;
    static constexpr int16_t GOD_MODE_ITEM = 295;
    static constexpr int16_t GIVE_ALL_ITEM = 296;
    static constexpr int16_t GIVE_MAP_ITEM = 297;
    static constexpr int16_t IMAGE_LABEL = 298;
    static constexpr int16_t SPRITE_MEM = 299;
    static constexpr int16_t LINE_MEM = 300;
    static constexpr int16_t BSP_MEM = 301;
    static constexpr int16_t MEMORY_TOTAL = 302;
    static constexpr int16_t MEMORY_FREE = 303;
    static constexpr int16_t MEMORY_AVAIL = 304;
    static constexpr int16_t MEMORY_PEAK = 305;
    static constexpr int16_t MEMORY_USED = 306;
    static constexpr int16_t MEMORY_TEX = 307;
    static constexpr int16_t MEMORY_INIT = 308;
    static constexpr int16_t MAP_LABEL = 309;
    static constexpr int16_t SYS_LOOP = 310;
    static constexpr int16_t SYS_RECURSION = 311;
    static constexpr int16_t SYS_ERR = 312;
    static constexpr int16_t SYS_BLOCK = 313;
    static constexpr int16_t SYS_PAINT_BLOCK = 314;
    static constexpr int16_t SYS_SOUND_BLOCK = 315;
    static constexpr int16_t SYS_SOUND = 316;
    static constexpr int16_t SYS_SOUND_DELAY = 317;
    static constexpr int16_t SYS_BACK_LIGHT = 318;
    static constexpr int16_t SYS_MISC_SUPPORTER = 319;
    static constexpr int16_t SYS_ADV_TIME = 320;
    static constexpr int16_t FONT_TEST = 321;
    static constexpr int16_t DEBUG_FONT = 322;

    // IOS
    static constexpr int16_t BOOKS_ITEM = 323;
    static constexpr int16_t WAIT_ITEM = 324;
    static constexpr int16_t CONTROLS_ITEM = 325;
    static constexpr int16_t CONTROLS_LAYOUT_ITEM = 326;
    static constexpr int16_t CONTROLS_CLASSIC_ITEM = 327;
    static constexpr int16_t CONTROLS_CHEVRONS_ITEM = 328;
    static constexpr int16_t CONTROLS_ARROWS_ITEM = 329;
    static constexpr int16_t FLIP_CONTROLS_ITEM = 330;
    static constexpr int16_t BUTTON_TRANSPARENCY_ITEM = 331;

    static constexpr int16_t MAX = 332;

    
#define GETSTRINGID(i) MenuStrings::MAX + i;

    // [GEC]

    static constexpr int16_t OPTIONS_TITLE = GETSTRINGID(0);
    static constexpr int16_t LANGUAGE_ITEM = GETSTRINGID(1);
    static constexpr int16_t SOUND_ITEM = GETSTRINGID(2);
    static constexpr int16_t VIDEO_ITEM = GETSTRINGID(3);
    static constexpr int16_t INPUT_ITEM = GETSTRINGID(4);
    static constexpr int16_t SOUND_TITLE = GETSTRINGID(5);
    static constexpr int16_t SFX_VOLUME_ITEM = GETSTRINGID(6);
    static constexpr int16_t MUSIC_VOLUME_ITEM = GETSTRINGID(7);
    static constexpr int16_t VIDEO_TITLE = GETSTRINGID(8);
    static constexpr int16_t WINDOW_MODE_ITEM = GETSTRINGID(9);
    static constexpr int16_t WINDOW_WINDOWED = GETSTRINGID(10);
    static constexpr int16_t WINDOW_BORDERLESS = GETSTRINGID(11);
    static constexpr int16_t WINDOW_FULLSCREEN = GETSTRINGID(12);
    static constexpr int16_t VSYNC_ITEM = GETSTRINGID(13);
    static constexpr int16_t RESOLUTION_ITEM = GETSTRINGID(14);
    static constexpr int16_t TINYGL_ITEM = GETSTRINGID(15);
    static constexpr int16_t APPLY_CHANGES_ITEM = GETSTRINGID(16);
    static constexpr int16_t INPUT_TITLE = GETSTRINGID(17);
    static constexpr int16_t TOUCH_CONTROLS_ITEM = GETSTRINGID(18);
    static constexpr int16_t BINDINGS_ITEM = GETSTRINGID(19);
    static constexpr int16_t CONTROLLER_ITEM = GETSTRINGID(20);
    static constexpr int16_t TOUCH_CONTROLS_TITLE = GETSTRINGID(21);
    static constexpr int16_t TOUCH_BUTTON_TRANSPARENCY_ITEM = GETSTRINGID(22);
    static constexpr int16_t BINDINGS_ITEM_TITLE = GETSTRINGID(23);
    static constexpr int16_t BIND_UNBOUND = GETSTRINGID(24);
    static constexpr int16_t MOVEMENT_LABEL = GETSTRINGID(25);
    static constexpr int16_t MOVE_FORWARD_ITEM = GETSTRINGID(26);
    static constexpr int16_t MOVE_BACKWARD_ITEM = GETSTRINGID(27);
    static constexpr int16_t MOVE_LEFT_ITEM = GETSTRINGID(28);
    static constexpr int16_t MOVE_RIGHT_ITEM = GETSTRINGID(29);
    static constexpr int16_t TURN_LEFT_ITEM = GETSTRINGID(30);
    static constexpr int16_t TURN_RIGHT_ITEM = GETSTRINGID(31);
    static constexpr int16_t OTHER_LABEL = GETSTRINGID(32);
    static constexpr int16_t ATK_TALK_USE_ITEM = GETSTRINGID(33);
    static constexpr int16_t NEXT_WEAPON_ITEM = GETSTRINGID(34);
    static constexpr int16_t PREV_WEAPON_ITEM = GETSTRINGID(35);
    static constexpr int16_t PASS_TURN_ITEM = GETSTRINGID(36);
    static constexpr int16_t AUTOMAP_ITEM = GETSTRINGID(37);
    static constexpr int16_t OPEN_MENU_ITEM = GETSTRINGID(38);
    static constexpr int16_t ITEMS_INFO_ITEM = GETSTRINGID(39);
    static constexpr int16_t USE_SYRINGES_ITEM = GETSTRINGID(40);
    static constexpr int16_t USE_JOURNAL_ITEM = GETSTRINGID(41);
    static constexpr int16_t RESET_BINDS_ITEM = GETSTRINGID(42);
    static constexpr int16_t EMPTY_ITEM = GETSTRINGID(43);
    static constexpr int16_t CONTROLLER_TITLE = GETSTRINGID(44);
    static constexpr int16_t VIBRATION_ITEM = GETSTRINGID(45);
    static constexpr int16_t VIBRATION_INTENSITY_ITEM = GETSTRINGID(46);
    static constexpr int16_t DEADZONE_ITEM = GETSTRINGID(47);
    static constexpr int16_t CONTROL_LAYOUT_ITEM = GETSTRINGID(48);
};

#endif