#ifndef __ENUMS_H__
#define __ENUMS_H__

#include <stdexcept>

class Enums
{
public:
    static constexpr int MAX_ENTITY_DEFS = 200;
    static constexpr int ET_WORLD = 0;                      // 1
    static constexpr int ET_PLAYER = 1;                     // 2
    static constexpr int ET_MONSTER = 2;                    // 4
    static constexpr int ET_NPC = 3;                        // 8
    static constexpr int ET_PLAYERCLIP = 4;                 // 16
    static constexpr int ET_DOOR = 5;                       // 32
    static constexpr int ET_ITEM = 6;                       // 64
    static constexpr int ET_DECOR = 7;                      // 128
    static constexpr int ET_ENV_DAMAGE = 8;                 // 256
    static constexpr int ET_CORPSE = 9;                     // 512
    static constexpr int ET_ATTACK_INTERACTIVE = 10;        // 1024
    static constexpr int ET_MONSTERBLOCK_ITEM = 11;         // 2048
    static constexpr int ET_SPRITEWALL = 12;                // 4096
    static constexpr int ET_NONOBSTRUCTING_SPRITEWALL = 13; // 8192
    static constexpr int ET_DECOR_NOCLIP = 14;              // 16384  
    static constexpr int ET_MAX = 15;                       // 32768

    static constexpr int CONTENTS_ANY = -1;
    static constexpr int CONTENTS_PICKUP = (1 << ET_ITEM); // 64
    static constexpr int CONTENTS_INTERACTIVE = (1 << ET_MONSTER | 1 << ET_NPC | 1 << ET_DOOR | 1 << ET_ATTACK_INTERACTIVE); // 1068
    static constexpr int CONTENTS_PLAYERSOLID = (1 << ET_WORLD | 1 << ET_MONSTER | 1 << ET_NPC | 1 << ET_PLAYERCLIP | 1 << ET_DOOR | 1 << ET_DECOR | 1 << ET_ATTACK_INTERACTIVE | 1 << ET_SPRITEWALL | 1 << ET_NONOBSTRUCTING_SPRITEWALL); // 13501
    static constexpr int CONTENTS_MONSTERSOLID = (1 << ET_WORLD | 1 << ET_PLAYER | 1 << ET_MONSTER | 1 << ET_NPC | 1 << ET_DOOR | 1 << ET_DECOR | 1 << ET_ATTACK_INTERACTIVE | 1 << ET_MONSTERBLOCK_ITEM | 1 << ET_SPRITEWALL | 1 << ET_NONOBSTRUCTING_SPRITEWALL); // 15535
    static constexpr int CONTENTS_WEAPONSOLID = (1 << ET_WORLD | 1 << ET_MONSTER | 1 << ET_NPC | 1 << ET_DOOR | 1 << ET_DECOR | 1 << ET_CORPSE | 1 << ET_ATTACK_INTERACTIVE | 1 << ET_SPRITEWALL | 1 << ET_NONOBSTRUCTING_SPRITEWALL);  // 13997
    static constexpr int CONTENTS_VIEWSOLID = (1 << ET_WORLD | 1 << ET_MONSTER | 1 << ET_NPC | 1 << ET_DOOR | 1 << ET_DECOR | 1 << ET_ATTACK_INTERACTIVE | 1 << ET_SPRITEWALL);  // 5293
    static constexpr int CONTENTS_MONSTERWPSOLID = (1 << ET_WORLD | 1 << ET_PLAYER | 1 << ET_MONSTER | 1 << ET_NPC | 1 << ET_DOOR | 1 << ET_DECOR | 1 << ET_ATTACK_INTERACTIVE | 1 << ET_SPRITEWALL);  // 5295
    static constexpr int CONTENTS_WORLD = (1 << ET_WORLD); // 1
    static constexpr int CONTENTS_SPRITEWALL = (1 << ET_SPRITEWALL | 1 << ET_NONOBSTRUCTING_SPRITEWALL); // 12288
    static constexpr int CONTENTS_NOFLOAT = (1 << ET_NPC | 1 << ET_DECOR | 1 << ET_SPRITEWALL | 1 << ET_NONOBSTRUCTING_SPRITEWALL); // 12424
    static constexpr int CONTENTS_DYNAMITE_SOLID = (1 << ET_WORLD | 1 << ET_MONSTER | 1 << ET_DOOR | 1 << ET_ATTACK_INTERACTIVE | 1 << ET_SPRITEWALL | 1 << ET_NONOBSTRUCTING_SPRITEWALL); // 13349
    static constexpr int CONTENTS_ISEMPTY_SCRIPT = (1 << ET_ITEM | 1 << ET_CORPSE | 1 << ET_NONOBSTRUCTING_SPRITEWALL | 1 << ET_DECOR_NOCLIP); // 25152
    static constexpr int CONTENTS_SPLASH_SOLID = (1 << ET_WORLD | 1 << ET_DOOR | 1 << ET_SPRITEWALL); // 4129
    
    static constexpr int ENV_DAMAGE_SPIKES = 0;
    static constexpr int ENV_DAMAGE_FIRE = 1;

    static constexpr int DECOR_MISC = 0;
    static constexpr int DECOR_EXITHALL = 1;
    static constexpr int DECOR_MIXING = 2;
    static constexpr int DECOR_STATUE = 3;
    static constexpr int DECOR_BOOK_PICKUP = 4;
    static constexpr int DECOR_TOMBSTONE = 5;
    static constexpr int DECOR_DYNAMITE = 6;
    static constexpr int DECOR_PARAM_NONE = 0;
    static constexpr int DECOR_PARAM_USE = 1;
    static constexpr int DECOR_PARAM_USE_ONCE = 2;

    static constexpr int INTERACT_CHAIR = 0;        // 1
    static constexpr int INTERACT_BARRICADE = 1;    // 2
    static constexpr int INTERACT_BARREL = 2;       // 4
    static constexpr int INTERACT_STATUE = 3;       // 8
    static constexpr int INTERACT_CRATE = 5;        // 32
    static constexpr int INTERACT_PAINTING = 7;     // 128
    static constexpr int INTERACT_CHICKEN = 8;      // 256
    static constexpr int INTERACT_FLAG = 9;         // 512
    static constexpr int INTERACT_PICKUP = 10;      // 1024
    static constexpr int INTERACT_SINK = 11;        // 2048
    static constexpr int INTERACT_SHOOT_OVER = (1 << INTERACT_CHAIR | 1 << INTERACT_CRATE); // 33
    static constexpr int WORLD_COUNTER = (1 << INTERACT_CHAIR | 1 << INTERACT_BARRICADE | 1 << INTERACT_BARREL | 1 << INTERACT_STATUE | 1 << INTERACT_CRATE | 1 << INTERACT_FLAG | 1 << INTERACT_SINK); // 2607
    static constexpr int INTERACT_BARREL_DMG = 40;

    static constexpr int MONSTER_START = 0; 
    static constexpr int MONSTER_SOLDIER_DUMB = 0;  // 1
    static constexpr int MONSTER_SOLDIER = 1;       // 2
    static constexpr int MONSTER_WORKER = 2;        // 4
    static constexpr int MONSTER_OFFICER = 3;       // 8
    static constexpr int MONSTER_SKELETON = 4;      // 16
    static constexpr int MONSTER_SUPERS = 5;        // 32
    static constexpr int MONSTER_TROOPER = 6;       // 64
    static constexpr int MONSTER_ELITE_GUARD = 7;   // 128
    static constexpr int MONSTER_ZOMBIE = 8;        // 256
    static constexpr int MONSTER_TORMENTOR = 9;     // 512
    static constexpr int MONSTER_CHICKEN = 10;      // 1024
    static constexpr int FIRSTBOSS = 11;            
    static constexpr int BOSS_SPY = 11;             // 2048
    static constexpr int BOSS_OLARIC = 12;          // 4096
    static constexpr int BOSS_MARRIANNA = 13;       // 8192
    static constexpr int BOSS_HARBINGER = 14;       // 16384
    static constexpr int LASTBOSS = 14;
    static constexpr int CORPSE_SKELETON = 15;      // 32768
    static constexpr int MAX_MONSTER_TYPES = 15;
    static constexpr int MONSTER_END = 16;

    static constexpr int DYNAMITE_SCARED_MONSTERS = (1 << MONSTER_SOLDIER_DUMB | 1 << MONSTER_SOLDIER | 1 << MONSTER_WORKER | 1 << MONSTER_OFFICER | 1 << MONSTER_TROOPER | 1 << MONSTER_ELITE_GUARD); // 207
    static constexpr int EVADING_MONSTERS = (1 << MONSTER_SOLDIER | 1 << MONSTER_WORKER | 1 << MONSTER_OFFICER | 1 << MONSTER_ELITE_GUARD | 1 << BOSS_OLARIC | 1 << BOSS_MARRIANNA); // 12430
    static constexpr int FEAR_IMMUNE_MONSTERS = (1 << MONSTER_TORMENTOR | 1 << BOSS_OLARIC | 1 << BOSS_MARRIANNA | 1 << BOSS_HARBINGER); // 29184

    static constexpr int NPC_PLAYER = 0;
    static constexpr int NPC_SPY = 1;
    static constexpr int NPC_PRISONER = 2;
    static constexpr int NPC_CIVILIAN = 3;
    static constexpr int NPC_CRAZY_OFFICER = 4;

    static constexpr int MSCALE_TIER1 = 256;
    static constexpr int MSCALE_TIER2 = 320;
    static constexpr int MSCALE_TIER3 = 400;
    static constexpr short MSOUND_NONE = 255;
    static constexpr int MSOUND_ALERT1 = 0;
    static constexpr int MSOUND_ALERT2 = 1;
    static constexpr int MSOUND_ALERT3 = 2;
    static constexpr int MSOUND_NUM_ALERTS = 3;
    static constexpr int MSOUND_ATTACK1 = 3;
    static constexpr int MSOUND_ATTACK2 = 4;
    static constexpr int MSOUND_DEATH = 5;
    static constexpr int MSOUND_TYPES = 6;

    static constexpr int IT_INVENTORY = 0;
    static constexpr int IT_WEAPON = 1;
    static constexpr int IT_AMMO = 2;
    static constexpr int IT_MONEY = 3;
    static constexpr int IT_FOOD = 4;
    static constexpr int IT_SACK = 5;
    static constexpr int IT_ARMOR = 6;
    static constexpr int IT_C_NOTE = 7;
    static constexpr int IT_C_STRING = 8;
    static constexpr int IT_C_BOOK = 9;

    static constexpr int AMMO_NONE = 0;
    static constexpr int AMMO_9MM = 1;
    static constexpr int AMMO_12_7MM = 2;
    static constexpr int AMMO_30CAL = 3;
    static constexpr int AMMO_45CAL = 4;
    static constexpr int AMMO_FUEL = 5;
    static constexpr int AMMO_ROCKETS = 6;
    static constexpr int AMMO_DYNAMITE = 7;
    static constexpr int AMMO_CHARGE = 8;
    static constexpr int AMMO_ITEM = 9;
    static constexpr int MAX_AMMO = 10;
    static constexpr int AMMO_MAX_COUNT = 100;
    static constexpr int NIGHTMARE_AMMO = 274;

    static constexpr int WP_PROJ_NONE = -1;
    static constexpr int WP_PROJ_BULLET = 0;
    static constexpr int WP_PROJ_PANZER = 1;
    static constexpr int WP_PROJ_FIRE = 2;
    static constexpr int WP_PROJ_SKULL = 3;
    static constexpr int WP_PROJ_MELEE = 4;
    static constexpr int WP_PROJ_ITEM = 5;
    static constexpr int WP_PROJ_WRENCH = 6;
    static constexpr int WP_PROJ_FLAME = 7;
    static constexpr int WP_PROJ_LIGHTNING = 8;
    static constexpr int WP_PROJ_INSTANT = 17;
    static constexpr int WP_SHIFT = 1;

    static constexpr int WP_PLAYERMIN = 0;
    static constexpr int WP_PUNCH = 0;          // 1
    static constexpr int WP_BRASS_PUNCH = 1;    // 2
    static constexpr int WP_SPIKE_PUNCH = 2;    // 4
    static constexpr int WP_BOOT = 3;           // 8
    static constexpr int WP_PISTOL = 4;         // 16
    static constexpr int WP_DUAL_PISTOL = 5;    // 32
    static constexpr int WP_THOMPSON = 6;       // 64
    static constexpr int WP_STEN = 7;           // 128
    static constexpr int WP_VENOM = 8;          // 256
    static constexpr int WP_MAUSER = 9;         // 512
    static constexpr int WP_FG42 = 10;          // 1024
    static constexpr int WP_DYNAMITE = 11;      // 2048
    static constexpr int WP_PANZER = 12;        // 4096
    static constexpr int WP_FLAMETHROWER = 13;  // 8192
    static constexpr int WP_TESLA = 14;         // 16384
    static constexpr int WP_DESTINY_SPEAR = 15; // 32768
    static constexpr int WP_ITEM = 16;          // 65536
    static constexpr int WP_MOUNTED_GUN_TURRET = 17;   // 131072 iOS
    static constexpr int WP_PLAYERMAX = 17;

    // iOS STYLE
    static constexpr int WP_PLAYERMASK = 0;
    static constexpr int WP_PUNCH_MASK = 1;
    static constexpr int WP_FIREMASK = 2;
    static constexpr int WP_EXPLOSIONMASK = 3;
    static constexpr int WP_MELEEMASK = 4;
    static constexpr int WP_SNIPERMASK = 5;
    static constexpr int WP_SUBMACHINE_UPGRADE = 6;
    static constexpr int WP_SUBMACHINEMASK = 7;
    static constexpr int WP_MUZZLE_FLASH = 8;
    static constexpr int WP_RANGEMASK = 9;
    static constexpr int WP_BARRELMASK = 10;
    static constexpr int WP_STATUEMASK = 11;
    static constexpr int WP_NODISTANCECHK = 12;
    static constexpr int WP_STARTING_WEAPONS = 13;
    static constexpr int WP_NORECOIL = 14;
    static constexpr int WP_PAINTINGMASK = 15;
    static constexpr int WP_SPRITE_WALL = 16;

    /*
    // J2ME STYLE
    static constexpr uint64_t WP_PLAYERMASK = (1LL << WP_PUNCH | 1LL << WP_BRASS_PUNCH | 1LL << WP_SPIKE_PUNCH | 1LL << WP_BOOT | 1LL << WP_PISTOL | 1LL << WP_DUAL_PISTOL | 1LL << WP_THOMPSON | 1LL << WP_STEN | 1LL << WP_VENOM | 1LL << WP_MAUSER | 1LL << WP_FG42 | 1LL << WP_DYNAMITE | 1LL << WP_PANZER | 1LL << WP_FLAMETHROWER | 1LL << WP_TESLA | 1LL << WP_DESTINY_SPEAR | 1LL << WP_ITEM | 1LL << WP_MOUNTED_GUN); // 262143
    static constexpr uint64_t WP_PUNCH_MASK = (1LL << WP_PUNCH | 1LL << WP_BRASS_PUNCH | 1LL << WP_SPIKE_PUNCH); // 7
    static constexpr uint64_t WP_FIREMASK = (1LL << WP_FLAMETHROWER); // 8192
    static constexpr uint64_t WP_EXPLOSIONMASK = (1LL << WP_PANZER); // 4096
    static constexpr uint64_t WP_MELEEMASK = (1LL << WP_PUNCH | 1LL << WP_BRASS_PUNCH | 1LL << WP_SPIKE_PUNCH | 1LL << WP_BOOT | 1LL << WP_DESTINY_SPEAR); // 32783
    static constexpr uint64_t WP_SNIPERMASK = (1LL << WP_MAUSER | 1LL << WP_FG42); // 1536
    static constexpr uint64_t WP_SUBMACHINE_UPGRADE = (1LL << WP_STEN); // 128
    static constexpr uint64_t WP_SUBMACHINEMASK = (1LL << WP_THOMPSON | 1LL << WP_STEN); // 192
    static constexpr uint64_t WP_MUZZLE_FLASH = (1LL << WP_PISTOL | 1LL << WP_THOMPSON | 1LL << WP_STEN | 1LL << WP_VENOM); // 464
    static constexpr uint64_t WP_RANGEMASK = (1LL << WP_PISTOL | 1LL << WP_DUAL_PISTOL | 1LL << WP_THOMPSON | 1LL << WP_STEN | 1LL << WP_VENOM | 1LL << WP_MAUSER | 1LL << WP_FG42 | 1LL << WP_PANZER | 1LL << WP_ITEM | 1LL << WP_MOUNTED_GUN); // 202736
    static constexpr uint64_t WP_BARRELMASK = (1LL << WP_BOOT | 1LL << WP_PISTOL | 1LL << WP_DUAL_PISTOL | 1LL << WP_THOMPSON | 1LL << WP_STEN | 1LL << WP_VENOM | 1LL << WP_MAUSER | 1LL << WP_FG42 | 1LL << WP_DYNAMITE | 1LL << WP_PANZER | 1LL << WP_FLAMETHROWER | 1LL << WP_TESLA | 1LL << WP_ITEM | 1LL << WP_MOUNTED_GUN); // 229368
    static constexpr uint64_t WP_STATUEMASK = (1LL << WP_BOOT | 1LL << WP_PISTOL | 1LL << WP_DUAL_PISTOL | 1LL << WP_THOMPSON | 1LL << WP_STEN | 1LL << WP_VENOM | 1LL << WP_MAUSER | 1LL << WP_FG42 | 1LL << WP_DYNAMITE | 1LL << WP_PANZER | 1LL << WP_ITEM | 1LL << WP_MOUNTED_GUN); // 204792
    static constexpr uint64_t WP_NODISTANCECHK = (1LL << WP_PISTOL | 1LL << WP_DUAL_PISTOL | 1LL << WP_THOMPSON | 1LL << WP_STEN | 1LL << WP_VENOM | 1LL << WP_MAUSER | 1LL << WP_FG42); // 2032
    static constexpr uint64_t WP_STARTING_WEAPONS = (1LL << WP_PUNCH | 1LL << WP_BOOT); // 9
    static constexpr uint64_t WP_NORECOIL = (1LL << WP_PUNCH | 1LL << WP_BRASS_PUNCH | 1LL << WP_SPIKE_PUNCH | 1LL << WP_BOOT | 1LL << WP_FG42 | 1LL << WP_DYNAMITE | 1LL << WP_TESLA); // 19471
    static constexpr uint64_t WP_PAINTINGMASK = (1LL << WP_PISTOL | 1LL << WP_DUAL_PISTOL | 1LL << WP_THOMPSON | 1LL << WP_STEN | 1LL << WP_VENOM | 1LL << WP_MAUSER | 1LL << WP_FG42); // 2032
    static constexpr uint64_t WP_SPRITE_WALL = (1LL << WP_PUNCH | 1LL << WP_BRASS_PUNCH | 1LL << WP_SPIKE_PUNCH | 1LL << WP_BOOT | 1LL << WP_ITEM); // 65551
    */

    static constexpr int WP_MONSTERMIN = 18;
    static constexpr int WP_M_MP40 = 18;                // 262144
    static constexpr int WP_M_FG42 = 19;                // 524288
    static constexpr int WP_M_WORKER_THROW = 20;        // 1048576
    static constexpr int WP_M_WORKER = 21;              // 2097152
    static constexpr int WP_M_SCIENTIST = 22;           // 4194304
    static constexpr int WP_M_ENGINEER = 23;            // 8388608
    static constexpr int WP_M_OFFICER = 24;             // 16777216
    static constexpr int WP_M_PUNCH = 25;               // 33554432
    static constexpr int WP_M_SKELETON_FIRE = 26;       // 67108864
    static constexpr int WP_M_SKELETON_SKULL = 27;      // 134217728
    static constexpr int WP_M_ZOMBIE = 28;              // 268435456
    static constexpr int WP_M_ZOMBIE_SHIELD = 29;       // 536870912
    static constexpr int WP_M_STEN = 30;                // 1073741824
    static constexpr int WP_M_FLAME = 31;               // 2147483648
    static constexpr int WP_M_VENOM = 32;               // 4294967296
    static constexpr int WP_M_PANZER = 33;              // 8589934592
    static constexpr int WP_M_SCREAM = 34;              // 17179869184
    static constexpr int WP_M_SOUL_SUCK = 35;           // 34359738368
    static constexpr int WP_M_OLARIC_PUNCH = 36;        // 68719476736
    static constexpr int WP_M_OLARIC_JUMP = 37;         // 137438953472
    static constexpr int WP_M_BOSS_MARIANNA = 38;       // 274877906944
    static constexpr int WP_M_BOSS_HARBINGER_CLAW = 39; // 549755813888
    static constexpr int WP_M_BOSS_HARBINGER_SLAM = 40; // 1099511627776
    static constexpr int WP_M_BOSS_HARBINGER_FIRE = 41; // 2199023255552
    static constexpr int WP_M_BOSS_HARBINGER_SUCK = 42; // 4398046511104
    static constexpr int WP_M_TORMENTOR_ABSORB = 43;    // 8796093022208
    static constexpr int WP_M_KICK = 44;                // 17592186044416
    static constexpr int WP_M_FLYINGKICK = 45;          // 35184372088832
    static constexpr int WP_M_CLAW = 46;                // 70368744177664
    static constexpr int WP_MONSTERMAX = 47;

    static constexpr int WP_MAX = 47;

    // iOS STYLE
    static constexpr int WP_MONSTERMASK = 17;
    static constexpr int WP_ALL_EASY_DODGE = 18;
    static constexpr int WP_ANTI_FIRE = 19;
    static constexpr int WP_MONSTER_KNOCKBACK = 20;
    static constexpr int WP_AUTO_HIT = 21;
    static constexpr int WP_ALL_MELEE = 22;
    static constexpr int WP_INSTANT_ATTACK = 23; 
    static constexpr int WP_INSTANT_ATTACK_NO_FRAME = 24;
    static constexpr int WP_CHARGE_ATTACK = 25;
    static constexpr int WP_UNK_MASK = 26;

    /*
    // J2ME STYLE
    static constexpr uint64_t WP_MONSTERMASK = (1LL <<  WP_M_MP40 | 1LL << WP_M_FG42 | 1LL << WP_M_WORKER_THROW | 1LL << WP_M_WORKER | 1LL << WP_M_SCIENTIST | 1LL << WP_M_ENGINEER | 1LL << WP_M_OFFICER | 1LL << WP_M_PUNCH | 1LL << WP_M_SKELETON_FIRE | 1LL << WP_M_SKELETON_SKULL | 1LL << WP_M_ZOMBIE | 1LL << WP_M_ZOMBIE_SHIELD | 1LL << WP_M_STEN | 1LL << WP_M_FLAME | 1LL << WP_M_VENOM | 1LL << WP_M_PANZER | 1LL << WP_M_SCREAM | 1LL << WP_M_SOUL_SUCK | 1LL << WP_M_OLARIC_PUNCH | 1LL << WP_M_OLARIC_JUMP | 1LL << WP_M_BOSS_MARIANNA | 1LL << WP_M_BOSS_HARBINGER_CLAW | 1LL << WP_M_BOSS_HARBINGER_SLAM | 1LL << WP_M_BOSS_HARBINGER_FIRE | 1LL << WP_M_BOSS_HARBINGER_SUCK | 1LL << WP_M_TORMENTOR_ABSORB | 1LL << WP_M_KICK | 1LL << WP_M_FLYINGKICK | 1LL << WP_M_CLAW); // 140737488093184
    static constexpr uint64_t WP_ALL_EASY_DODGE = (1LL << WP_PUNCH | 1LL << WP_BOOT | 1LL << WP_PANZER | 1LL << WP_DESTINY_SPEAR); // 36873
    static constexpr uint64_t WP_ANTI_FIRE = (1LL << WP_M_SKELETON_FIRE | 1LL << WP_M_SKELETON_SKULL | 1LL << WP_M_FLAME | 1LL << WP_M_BOSS_HARBINGER_FIRE); // 2201372065792
    static constexpr uint64_t WP_MONSTER_KNOCKBACK = (1LL << WP_M_ZOMBIE_SHIELD | 1LL << WP_M_OLARIC_PUNCH | 1LL << WP_M_BOSS_HARBINGER_SLAM | 1LL << WP_M_KICK | 1LL << WP_M_FLYINGKICK); // 53945326108672
    static constexpr uint64_t WP_AUTO_HIT = (1LL << WP_M_ZOMBIE_SHIELD | 1LL << WP_M_OLARIC_JUMP | 1LL << WP_M_BOSS_HARBINGER_SLAM | 1LL << WP_M_KICK | 1LL << WP_M_FLYINGKICK); // 54014045585408
    static constexpr uint64_t WP_ALL_MELEE = (1LL << WP_PUNCH | 1LL << WP_BRASS_PUNCH | 1LL << WP_SPIKE_PUNCH | 1LL << WP_BOOT | 1LL << WP_DESTINY_SPEAR | 1LL << WP_M_WORKER | 1LL << WP_M_ENGINEER | 1LL << WP_M_PUNCH | 1LL << WP_M_ZOMBIE_SHIELD | 1LL << WP_M_OLARIC_JUMP | 1LL << WP_M_BOSS_HARBINGER_CLAW | 1LL << WP_M_KICK | 1LL << WP_M_FLYINGKICK | 1LL << WP_M_CLAW); // 123833078022159
    static constexpr uint64_t WP_INSTANT_ATTACK = (1LL << WP_M_ZOMBIE_SHIELD | 1LL << WP_M_FLAME | 1LL << WP_M_OLARIC_JUMP | 1LL << WP_M_KICK | 1LL << WP_M_FLYINGKICK); // 52916681441280
    static constexpr uint64_t WP_INSTANT_ATTACK_NO_FRAME = (1LL << WP_M_ZOMBIE_SHIELD | 1LL << WP_M_KICK | 1LL << WP_M_FLYINGKICK); // 52777095004160
    static constexpr uint64_t WP_CHARGE_ATTACK = (1LL << WP_M_ZOMBIE_SHIELD | 1LL << WP_M_OLARIC_JUMP | 1LL << WP_M_BOSS_HARBINGER_SLAM | 1LL << WP_M_FLYINGKICK); // 36421859540992
    static constexpr uint64_t WP_UNK_MASK = (1LL << WP_BOOT | 1LL << WP_MAUSER | 1LL << WP_PANZER | 1LL << WP_FLAMETHROWER | 1LL << WP_TESLA | 1LL << WP_DESTINY_SPEAR | 1LL << WP_ITEM | 1LL << WP_MOUNTED_GUN); // 258568
    */
    static constexpr int CMASK_NONE = 0;
    static constexpr int CMASK_DESTROYABLE_MELEE = 1;
    static constexpr int CMASK_DESTROYABLE_BARREL = 2;
    static constexpr int CMASK_DESTROYABLE_STATUE = 3;
    static constexpr int CMASK_DESTROYABLE_ALARM = 4;
    static constexpr int CMASK_DESTROYABLE_CHICKEN = 5;
    static constexpr int CMASK_DESTROYABLE_FLAG = 6;
    static constexpr int CMASK_DESTROYABLE_SINK = 7;
    static constexpr int CMASK_DESTROYABLE_TABLE = 8;
    static constexpr int ARMOR_NONE = 0;
    static constexpr int ARMOR_HELMET = 1;
    static constexpr int ARMOR_MAX = 2;
    static constexpr int PICK_LEVEL1 = 0;
    static constexpr int PICK_LEVEL2 = 1;
    static constexpr int PICK_LEVEL3 = 2;
    static constexpr int PICK_LEVEL4 = 3;
    static constexpr int PICK_LEVEL5 = 4;
    static constexpr int PICK_MAX = 5;
    static constexpr int RING_NONE = 0;
    static constexpr int RING_STRENGTH = 1;
    static constexpr int RING_ACCURACY = 2;
    static constexpr int RING_DEFENSE = 3;
    static constexpr int RING_REGEN = 4;
    static constexpr int RING_FORCE = 5;
    static constexpr int RING_FORTITUDE = 6;
    static constexpr int RING_INTIMIDATION = 7;
    static constexpr int RING_ETERNALBLISS = 8;
    static constexpr int RING_MAX = 9;
    static constexpr int RING_MASK = 511;

    static constexpr int INV_MIN = 0;
    static constexpr int INV_SYRINGE_MIN = 0;
    static constexpr int INV_SYRINGE_EVADE = 0;
    static constexpr int INV_SYRINGE_DEFENSE = 1;
    static constexpr int INV_SYRINGE_ADRENALINE = 2;
    static constexpr int INV_SYRINGE_FOCUS = 3;
    static constexpr int INV_SYRINGE_ANTIFIRE = 4;
    static constexpr int INV_FIRST_MIXABLE = 5;
    static constexpr int INV_SYRINGE_ENRAGE = 5;
    static constexpr int INV_SYRINGE_AGILITY = 6;
    static constexpr int INV_SYRINGE_FORTITUDE = 7;
    static constexpr int INV_SYRINGE_REGEN = 8;
    static constexpr int INV_SYRINGE_PURIFY = 9;
    static constexpr int INV_SYRINGE_REFLECT = 10;
    static constexpr int INV_SYRINGE_PROTO = 11;
    static constexpr int INV_SYRINGE_ELITE = 12;
    static constexpr int INV_SYRINGE_FEAR = 13;
    static constexpr int INV_SYRINGE_ANGER = 14;
    static constexpr int INV_SYRINGE_MAX = 15;
    static constexpr int INV_HEALTH_MIN = 16;
    static constexpr int INV_HEALTH_RATION_BAR = 16;
    static constexpr int INV_HEALTH_PACK = 17;
    static constexpr int INV_HEALTH_MAX = 18;
    static constexpr int INV_OTHER_MIN = 18;
    static constexpr int INV_OTHER_JOURNAL = 18;
    static constexpr int INV_OTHER_SILVER_KEY = 19;
    static constexpr int INV_OTHER_GOLD_KEY = 20;
    static constexpr int INV_EMPTY_SYRINGE = 21;
    static constexpr int INV_OTHER_SCOTCH = 22;
    static constexpr int INV_OTHER_PACK = 23;
    static constexpr int INV_OTHER_MAX = 24;
    static constexpr int INV_TREASURE_MIN = 25;
    static constexpr int INV_TREASURE_GOBLET = 25;
    static constexpr int INV_TREASURE_CROSS = 26;
    static constexpr int INV_TREASURE_CROWN = 27;
    static constexpr int INV_TREASURE_MAX = 28;
    static constexpr int INV_MAX = 29;
    static constexpr int INV_MAX_ITEM_COUNT = 999;

    static constexpr int DOOR_LOCKED = 1;
    static constexpr int DOOR_UNLOCKED = 2;
    static constexpr int DOOR_FLAG_SWING = 1;
    static constexpr int DOOR_FLAG_CENTER = 2;
    static constexpr int BACK_RIGHT = 0;
    static constexpr int RIGHT = 1;
    static constexpr int FRONT_RIGHT = 2;
    static constexpr int FRONT = 3;
    static constexpr int FRONT_LEFT = 4;
    static constexpr int LEFT = 5;
    static constexpr int BACK_LEFT = 6;
    static constexpr int BACK = 7;
    static constexpr int FRONT_FACING = 28;
    static constexpr int BACK_FACING = 193;
    static constexpr int ICON_NONE = 127;
    static constexpr int ICON_WEAPON_HAND = 0;
    static constexpr int ICON_WEAPON_BOOT = 1;
    static constexpr int ICON_WEAPON_SNOOPER = 2;
    static constexpr int ICON_WEAPON_PISTOL = 3;
    static constexpr int ICON_WEAPON_STEN = 5;
    static constexpr int ICON_WEAPON_VENOM = 6;
    static constexpr int ICON_WEAPON_MAUSER = 7;
    static constexpr int ICON_WEAPON_DYNAMITE = 8;
    static constexpr int ICON_WEAPON_PANZER = 9;
    static constexpr int ICON_WEAPON_FG42 = 10;
    static constexpr int ICON_WEAPON_THOMPSON = 11;
    static constexpr int ICON_WEAPON_FLAME = 12;
    static constexpr int ICON_WEAPON_TESLA = 13;
    static constexpr int ICON_WEAPON_SPEAR = 14;
    static constexpr int ICON_SYRINGE_EVADE = 19;
    static constexpr int ICON_SYRINGE_DEFENSE = 20;
    static constexpr int ICON_SYRINGE_ADRENALINE = 21;
    static constexpr int ICON_SYRINGE_FOCUS = 22;
    static constexpr int ICON_SYRINGE_ANGER = 23;
    static constexpr int ICON_SYRINGE_FIRE = 24;
    static constexpr int ICON_SYRINGE_ENRAGE = 25;
    static constexpr int ICON_SYRINGE_AGILITY = 26;
    static constexpr int ICON_SYRINGE_FORTITUDE = 27;
    static constexpr int ICON_SYRINGE_REGEN = 28;
    static constexpr int ICON_SYRINGE_PURIFY = 29;
    static constexpr int ICON_SYRINGE_REFLECT = 30;
    static constexpr int ICON_SYRINGE_PROTO = 31;
    static constexpr int ICON_SYRINGE_ELITE = 32;
    static constexpr int ICON_SYRINGE_FEAR = 33;
    static constexpr int ICON_SYRINGE_EMPTY = 34;
    static constexpr int ICON_OTHER_SCOTCH = 35;
    static constexpr int ICON_OTHER_HEALTH_PACK = 36;
    static constexpr int ICON_OTHER_MEAL = 37;
    static constexpr int ICON_OTHER_TORCH = 38;
    static constexpr int ICON_OTHER_PACK = 39;
    static constexpr int ICON_ARMOR_LEATHER = 41;
    static constexpr int ICON_ARMOR_ELVEN = 42;
    static constexpr int ICON_ARMOR_DIAMOND = 43;
    static constexpr int ICON_HELP = 44;
    static constexpr int ICON_LOCKPICK_LEVEL1 = 45;
    static constexpr int ICON_LOCKPICK_LEVEL2 = 46;
    static constexpr int ICON_LOCKPICK_LEVEL3 = 47;
    static constexpr int ICON_LOCKPICK_LEVEL4 = 48;
    static constexpr int ICON_LOCKPICK_LEVEL5 = 49;
    static constexpr int SCRIPT_LS_FLAG_ASYNC = 1;
    static constexpr int SCRIPT_LS_FLAG_BLOCK = 2;
    static constexpr int SCRIPT_LS_FLAG_ASYNC_BLOCK = 3;
    static constexpr int SCRIPT_LS_NO_TIME = 4;
    static constexpr int SCRIPT_LS_DEFAULT_Z = 8;
    static constexpr int SCRIPT_LS_FLAG_MAX = 16;
    static constexpr int LS_FLAG_ASYNC = 1;
    static constexpr int LS_FLAG_ANIMATING_EFFECT = 2;
    static constexpr int LS_FLAG_PARABOLA = 4;
    static constexpr int LS_FLAG_TRUNC = 8;
    static constexpr int LS_FLAG_ENT_NORELINK = 16;
    static constexpr int LS_FLAG_S_NORELINK = 32;
    static constexpr int LS_FLAG_DOOROPEN = 64;
    static constexpr int LS_FLAG_DOORCLOSE = 128;
    static constexpr int LS_FLAG_SECRET_OPEN = 256;
    static constexpr int LS_FLAG_SECRET_HIDE = 512;
    static constexpr int LS_FLAG_CHICKEN_KICK = 1024;
    static constexpr int LS_FLAG_AUTO_FACE = 2048;
    static constexpr int LS_MASK_CHICKEN_BOUNCE = 1032;
    static constexpr int STAT_HEALTH = 0;
    static constexpr int STAT_MAX_HEALTH = 1;
    static constexpr int STAT_ARMOR = 2;
    static constexpr int STAT_DEFENSE = 3;
    static constexpr int STAT_STRENGTH = 4;
    static constexpr int STAT_ACCURACY = 5;
    static constexpr int STAT_AGILITY = 6;
    static constexpr int STAT_DRUNKENNESS = 7;
    static constexpr int STAT_MAX = 8;
    static constexpr int MAX_ARMOR = 200;
    static constexpr int MFLAG_NONE = 0;
    static constexpr int MFLAG_ABILITY = 1;
    static constexpr int MFLAG_TRIGGERONACTIVATE = 2;
    static constexpr int MFLAG_NOKILL = 4;
    static constexpr int MFLAG_NOACTIVATE = 8;
    static constexpr int MFLAG_NORESPAWN = 16;
    static constexpr int MFLAG_NOTHINK = 32;
    static constexpr int MFLAG_NORAISE = 64;
    static constexpr int MFLAG_NOTRACK = 128;
    static constexpr int MFLAG_WEAPON_ALT = 256;
    static constexpr int MFLAG_SCALED = 512;
    static constexpr int MFLAG_ATTACKING = 1024;
    static constexpr int MFLAG_NPC_MONSTER = 2048;
    static constexpr int MFLAG_KNOCKBACK = 4096;
    static constexpr int MFLAG_NPC_CHAT = 8192;
    static constexpr int MFLAG_UNK = 16384; // iOS
    static constexpr int DIR_EAST = 0;
    static constexpr int DIR_NORTHEAST = 1;
    static constexpr int DIR_NORTH = 2;
    static constexpr int DIR_NORTHWEST = 3;
    static constexpr int DIR_WEST = 4;
    static constexpr int DIR_SOUTHWEST = 5;
    static constexpr int DIR_SOUTH = 6;
    static constexpr int DIR_SOUTHEAST = 7;
    static constexpr int DIR_MAX = 8;
    static constexpr int DIR_MASK = 7;
    static constexpr int DIR_HORIZONTAL = 8;
    static constexpr int DIR_VERTICAL = 9;
    static constexpr int INHERIT_PLAYER_DIR = -2;
    static constexpr int INHERIT_PLAYER_PITCH = -2;
    static constexpr int INHERIT_PLAYER_POS = -2;
    static constexpr int SIN_TABLE_SIZE_BITS = 10;
    static constexpr int SIN_TABLE_SIZE = 1024;
    static constexpr int ANGLE_EAST = 0;
    static constexpr int ANGLE_NORTHEAST = 128;
    static constexpr int ANGLE_NORTH = 256;
    static constexpr int ANGLE_NORTHWEST = 384;
    static constexpr int ANGLE_WEST = 512;
    static constexpr int ANGLE_SOUTHWEST = 640;
    static constexpr int ANGLE_SOUTH = 768;
    static constexpr int ANGLE_SOUTHEAST = 896;
    static constexpr int ANGLE_FULL = 1023;
    static constexpr int ANGLE_PI = 512;
    static constexpr int ANGLE_2PI = 1024;
    static constexpr int ANGLE_PI_HALF = 256;
    static constexpr int ANGLE_PI_FOURTH = 128;
    static constexpr int ANGLE_PI_EIGHTH = 64;
    static constexpr int ANGLE_DIR_SHIFT = 7;
    static constexpr int ANGLE_30_DEG = 85;
    static constexpr int ANGLE_MAX_PITCH = 64;
    static constexpr int PS_FOUNTAIN = 0;
    static constexpr int PS_FIREEXTINGUISHER = 1;
    static constexpr int PS_IMPLODE = 2;
    static constexpr int PS_FALLING = 3;
    static constexpr int PS_HUMANOID = 4;
    static constexpr int PS_WOOD = 5;
    static constexpr int PS_STONE = 6;
    static constexpr int PS_SKELETON = 7;
    static constexpr int PS_MAX = 8;
    static constexpr int QUEST_NONE = 0;
    static constexpr int QUEST_ONE = 1;
    static constexpr int QUEST_TWO = 2;
    static constexpr int QUEST_THREE = 4;
    static constexpr int QUEST_FOUR = 8;
    static constexpr int QUEST_FIVE = 16;
    static constexpr int QUEST_SIX = 32;
    static constexpr int QUEST_SEVEN = 64;
    static constexpr int QUEST_EIGHT = 128;
    static constexpr int FX_NONE = 0;
    static constexpr int FX_PANZER = 1;
    static constexpr int FX_FLAME = 2;
    static constexpr int FX_BOOT = 4;
    static constexpr int FX_SLAP = 5;
    static constexpr int EV_EVAL = 0;
    static constexpr int EV_JUMP = 1;
    static constexpr int EV_RETURN = 2;
    static constexpr int LAST_INTERNAL_CMD = 2;
    static constexpr int EV_END = -1;
    static constexpr int EV_FIRST_COMMAND = 3;
    static constexpr int EV_MESSAGE = 3;
    static constexpr int EV_LERPSPRITE = 4;
    static constexpr int EV_STARTCINEMATIC = 5;
    static constexpr int EV_SETSTATE = 6;
    static constexpr int EV_CALL_FUNC = 7;
    static constexpr int EV_ITEM_COUNT = 8;
    static constexpr int EV_TILE_EMPTY = 9;
    static constexpr int EV_WEAPON_EQUIPPED = 10;
    static constexpr int EV_CHANGE_MAP = 11;
    static constexpr int EV_CAMERA_STR = 12;
    static constexpr int EV_DIALOG = 13;
    static constexpr int EV_WAIT = 14;
    static constexpr int EV_GOTO = 15;
    static constexpr int EV_ABORT_MOVE = 16;
    static constexpr int EV_ENTITY_FRAME = 17;
    static constexpr int EV_ADV_CAMERAKEY = 18;
    static constexpr int EV_DAMAGEMONSTER = 19;
    static constexpr int EV_DAMAGEPLAYER = 20;
    static constexpr int EV_DOOROP = 21;
    static constexpr int EV_MONSTERFLAGOP = 22;
    static constexpr int EV_EVENTOP = 23;
    static constexpr int EV_HIDE = 24;
    static constexpr int EV_DROPITEM = 25;
    static constexpr int EV_PREVSTATE = 26;
    static constexpr int EV_NEXTSTATE = 27;
    static constexpr int EV_WAKEMONSTER = 28;
    static constexpr int EV_SHOW_PLAYERATTACK = 29;
    static constexpr int EV_MONSTER_PARTICLES = 30;
    static constexpr int EV_SPAWN_PARTICLES = 31;
    static constexpr int EV_FADEOP = 32;
    static constexpr int EV_GIVEITEM = 33;
    static constexpr int EV_NAMEENTITY = 34;
    static constexpr int EV_DROPMONSTERITEM = 35;
    static constexpr int EV_SETDEATHFUNC = 36;
    static constexpr int EV_PLAYSOUND = 37;
    static constexpr int EV_NPCCHAT = 38;
    static constexpr int EV_STOCKSTATION = 39;
    static constexpr int EV_LERPFLAT = 40;
    static constexpr int EV_GIVELOOT = 41;
    static constexpr int EV_MARKTILE = 42;
    static constexpr int EV_UPDATEJOURNAL = 43;
    static constexpr int EV_BRIBE_ENTITY = 44;
    static constexpr int EV_PLAYER_ADD_STAT = 45;
    static constexpr int EV_PLAYER_ADD_RECIPE = 46;
    static constexpr int EV_RESPAWN_MONSTER = 47;
    static constexpr int EV_SCREEN_SHAKE = 48;
    static constexpr int EV_SPEECHBUBBLE = 49;
    static constexpr int EV_AWARDSECRET = 50;
    static constexpr int EV_AIGOAL = 51;
    static constexpr int EV_ADVANCETURN = 52;
    static constexpr int EV_MINIGAME = 53;
    static constexpr int EV_ENDMINIGAME = 54;
    static constexpr int EV_ENDROUND = 55;
    static constexpr int EV_PLAYERATTACK = 56;
    static constexpr int EV_SET_FOG_COLOR = 57;
    static constexpr int EV_LERP_FOG = 58;
    static constexpr int EV_LERPSPRITEOFFSET = 59;
    static constexpr int EV_DISABLED_WEAPONS = 60;
    static constexpr int EV_LERPSCALE = 61;
    static constexpr int EV_GIVEAWARD = 62;
    static constexpr int EV_GIVEBOOK = 63;
    static constexpr int EV_OFFERBOOK = 64;
    static constexpr int EV_STARTMIXING = 65;
    static constexpr int EV_DEBUGPRINT = 66;
    static constexpr int EV_GOTO_MENU = 67;
    static constexpr int EV_START_DRIVING = 68;
    static constexpr int EV_TURN_PLAYER = 69;
    static constexpr int EV_STATUS_EFFECT = 70;
    static constexpr int EV_JOURNAL_TILE = 71;
    static constexpr int EV_MAKE_CORPSE = 72;
    static constexpr int EV_INVENTORY_OP = 73;
    static constexpr int EV_END_GAME = 74;
    static constexpr int EV_LERPSPRITEPARABOLA = 75;
    static constexpr int EV_STOPSOUND = 76;
    static constexpr int SCR_INIT_MAP = 0;
    static constexpr int SCR_END_GAME = 1;
    static constexpr int SCR_BOSS_75 = 2;
    static constexpr int SCR_BOSS_50 = 3;
    static constexpr int SCR_BOSS_25 = 4;
    static constexpr int SCR_BOSS_DEAD = 5;
    static constexpr int SCR_PER_TURN = 6;
    static constexpr int SCR_ATTACK_NPC = 7;
    static constexpr int SCR_MONSTER_DEATH = 8;
    static constexpr int SCR_MONSTER_ACTIVATE = 9;
    static constexpr int SCR_CHICKEN_KICKED = 10;
    static constexpr int SCR_ITEM_PICKUP = 11;
    static constexpr int MAX_BUILT_IN_CMD = 12;
    static constexpr int SCR_NOT_DEFINED = 65535;
    static constexpr int EVAL_VARFLAG = 128;
    static constexpr int EVAL_VARMASK = 127;
    static constexpr int EVAL_CONSTFLAG = 64;
    static constexpr int EVAL_CONSTMASK = 63;
    static constexpr int EVAL_AND = 0;
    static constexpr int EVAL_OR = 1;
    static constexpr int EVAL_LTE = 2;
    static constexpr int EVAL_LT = 3;
    static constexpr int EVAL_EQ = 4;
    static constexpr int EVAL_NEQ = 5;
    static constexpr int EVAL_NOT = 6;
    static constexpr int EVFL_EXEC_ENTER = 1;
    static constexpr int EVFL_EXEC_EXIT = 2;
    static constexpr int EVFL_EXEC_TRIGGER = 4;
    static constexpr int EVFL_EXEC_FACE = 8;
    static constexpr int EVFL_EXEC_MASK = 15;
    static constexpr int EVFL_MOD_SHIFT = 4;
    static constexpr int EVFL_MOD_EAST = 16;
    static constexpr int EVFL_MOD_NORTHEAST = 32;
    static constexpr int EVFL_MOD_NORTH = 64;
    static constexpr int EVFL_MOD_NORTHWEST = 128;
    static constexpr int EVFL_MOD_WEST = 256;
    static constexpr int EVFL_MOD_SOUTHWEST = 512;
    static constexpr int EVFL_MOD_SOUTH = 1024;
    static constexpr int EVFL_MOD_SOUTHEAST = 2048;
    static constexpr int EVFL_MOD_DIR_MASK = 4080;
    static constexpr int EVFL_MOD_MELEE = 4096;
    static constexpr int EVFL_MOD_RANGED = 8192;
    static constexpr int EVFL_MOD_EXPLOSION = 16384;
    static constexpr int EVFL_MOD_ATTACK_MASK = 28672;
    static constexpr int EVFL_FLAG_SHIFT = 16;
    static constexpr int EVFL_FLAG_BLOCKINPUT = 65536;
    static constexpr int EVFL_FLAG_EXIT_GOTO = 131072;
    static constexpr int EVFL_FLAG_SKIP_TURN = 262144;
    static constexpr int EVFL_DISABLE_SHIFT = 19;
    static constexpr int EVFL_FLAG_DISABLE = 524288;
    static constexpr int LERP_FLAG_ASYNC = 1;
    static constexpr int EVFL_OPENDOOR = 0;
    static constexpr int EVFL_CLOSEDOOR = 1;
    static constexpr int EVFL_LOCKDOOR = 2;
    static constexpr int EVFL_UNLOCKDOOR = 3;
    static constexpr int EVFL_MFLAG_ADD = 0;
    static constexpr int EVFL_MFLAG_REMOVE = 1;
    static constexpr int EVFL_MFLAG_SET = 2;
    static constexpr int CHANGEMAP_FADE_BIT = 128;
    static constexpr int CHANGEMAP_SHOWSTAT_SHIFT = 31;
    static constexpr int CHANGEMAP_SHOWSTATS_BIT = (1 << CHANGEMAP_SHOWSTAT_SHIFT);
    static constexpr int STATE_MAX = 8;
    static constexpr char HYPHEN = '-';
    static constexpr char NEWLINE = '|';
    static constexpr int TILENUM_MAX = 512;
    static constexpr int TILENUM_INVALID = -512;
    static constexpr int TILENUM_EMPTY = 0;
    static constexpr int MAP_VERSION = 3;
    static constexpr int MAP_FLAG_NOMONSTERALERTS = 1;

    static constexpr int MANIM_SHIFT = 4;
    static constexpr int MANIM_MASK = (15 << MANIM_SHIFT); // 240
    static constexpr int MANIM_IDLE = (0 << MANIM_SHIFT); // 0
    static constexpr int MANIM_IDLE_BACK = (1 << MANIM_SHIFT); // 16
    static constexpr int MANIM_WALK_FRONT = (2 << MANIM_SHIFT); // 32
    static constexpr int MANIM_WALK_BACK = (3 << MANIM_SHIFT); // 48
    static constexpr int MANIM_ATTACK1 = (4 << MANIM_SHIFT); // 64
    static constexpr int MANIM_ATTACK2 = (5 << MANIM_SHIFT); // 80
    static constexpr int MANIM_PAIN = (6 << MANIM_SHIFT); // 96
    static constexpr int MANIM_DEAD = (7 << MANIM_SHIFT); // 112
    static constexpr int MANIM_SLAP = (8 << MANIM_SHIFT); // 128
    static constexpr int MANIM_DODGE = (9 << MANIM_SHIFT); // 144
    static constexpr int MANIM_NPC_TALK = (10 << MANIM_SHIFT); // 160
    static constexpr int MANIM_NPC_BACK_ACTION = (11 << MANIM_SHIFT); // 176

    static constexpr int MFRAME_MASK = 15;
    static constexpr int MFRAME_FRONT_LEGS1 = 0;
    static constexpr int MFRAME_FRONT_LEGS2 = 1;
    static constexpr int MFRAME_FRONT_TORSO = 2;
    static constexpr int MFRAME_FRONT_HEAD = 3;
    static constexpr int MFRAME_FRONT_MAX = 4;
    static constexpr int MFRAME_BACK_LEGS1 = 4;
    static constexpr int MFRAME_BACK_LEGS2 = 5;
    static constexpr int MFRAME_BACK_TORSO = 6;
    static constexpr int MFRAME_BACK_HEAD = 7;
    static constexpr int MFRAME_IDLE_TO_ATTACK1 = 8;
    static constexpr int MFRAME_ATTACK1 = 9;
    static constexpr int MFRAME_IDLE_TO_ATTACK2 = 10;
    static constexpr int MFRAME_ATTACK2 = 11;
    static constexpr int MFRAME_ATTACKING = 12;
    static constexpr int MFRAME_PAIN = 12;
    static constexpr int MFRAME_DEAD = 13;
    static constexpr int MFRAME_SLAP_TORSO = 14;
    static constexpr int MFRAME_SLAP_HEAD1 = 15;
    static constexpr int MFRAME_SLAP_HEAD2 = 16;
    static constexpr int MFRAME_DODGE = 17;
    static constexpr int MFRAME_MAX = 18;
    static constexpr int MFRAME_AUTO = 255;
    static constexpr int NPCFRAME_FRONT_LEGS1 = 0;
    static constexpr int NPCFRAME_FRONT_LEGS2 = 1;
    static constexpr int NPCFRAME_FRONT_TORSO = 2;
    static constexpr int NPCFRAME_FRONT_HEAD = 3;
    static constexpr int NPCFRAME_FRONT_MAX = 4;
    static constexpr int NPCFRAME_BACK_LEGS1 = 4;
    static constexpr int NPCFRAME_BACK_LEGS2 = 5;
    static constexpr int NPCFRAME_BACK_TORSO = 6;
    static constexpr int NPCFRAME_BACK_HEAD = 7;
    static constexpr int NPCFRAME_MAX = 8;
    static constexpr int NPCFRAME_SLAP_TORSO = 9;
    static constexpr int NPCFRAME_SLAP_HEAD1 = 10;
    static constexpr int DLG_STYLE_NORMAL = 0;
    static constexpr int DLG_STYLE_NPC = 1;
    static constexpr int DLG_STYLE_HELP = 2;
    static constexpr int DLG_STYLE_SCROLL = 3;
    static constexpr int DLG_STYLE_CHEST = 4;
    static constexpr int DLG_STYLE_MONSTER = 5;
    static constexpr int DLG_STYLE_GHOST = 6;
    static constexpr int DLG_STYLE_YELL = 7;
    static constexpr int DLG_STYLE_PLAYER = 8;
    static constexpr int DLG_STYLE_SPECIAL = 9;
    static constexpr int DLG_FLAG_NONE = 0;
    static constexpr int DLG_FLAG_YESNO = 1;
    static constexpr int DLG_FLAG_INTERROGATE = 2;
    static constexpr int DLG_FLAG_GAME = 4;
    static constexpr int FOOD_LARGE = 0;
    static constexpr int FOOD_BURNT = 2;
    static constexpr int ANIM_FRAME_COUNT = 3;
    static constexpr int ANIM_FRAME_TIME = 200;
    static constexpr int ANIM_DURATION = 600;
    static constexpr int ANIM_FLAG_INUSE = 1;
    static constexpr int ANIM_FLAG_FINISHED = 2;
    static constexpr int ANIM_FLAG_NODAMAGE = 4;

    static constexpr int TILENUM_FIRST_SPRITE = 1;
    static constexpr int TILENUM_FIRST_VIEWWEAPON = 1;
    static constexpr int TILENUM_PUNCH = 1;
    static constexpr int TILENUM_BRASS_PUNCH = 2;
    static constexpr int TILENUM_SPIKE_PUNCH = 3;
    static constexpr int TILENUM_BOOT = 4;
    static constexpr int TILENUM_PISTOL = 5;
    static constexpr int TILENUM_DUAL_PISTOL = 6;
    static constexpr int TILENUM_THOMPSON = 7;
    static constexpr int TILENUM_STEN = 8;
    static constexpr int TILENUM_VENOM = 9;
    static constexpr int TILENUM_MAUSER = 10;
    static constexpr int TILENUM_FG42 = 11;
    static constexpr int TILENUM_DYNAMITE = 12;
    static constexpr int TILENUM_PANZER = 13;
    static constexpr int TILENUM_FLAMETHROWER = 14;
    static constexpr int TILENUM_TESLA = 15;
    static constexpr int TILENUM_DESTINY_SPEAR = 16;
    static constexpr int TILENUM_LAST_VIEWWEAPON = 16;
    static constexpr int TILENUM_WORLD_WEAPON = 17;
    static constexpr int TILENUM_TURRET = 18;

    static constexpr int TILENUM_FIRST_MONSTER = 19;
    static constexpr int TILENUM_MONSTER_SOLDIER_DUMB = 19;
    static constexpr int TILENUM_MONSTER_SOLDIER = 20;
    static constexpr int TILENUM_MONSTER_SOLDIER2 = 21;
    static constexpr int TILENUM_MONSTER_SOLDIER3 = 22;
    static constexpr int TILENUM_MONSTER_WORKER = 23;
    static constexpr int TILENUM_MONSTER_WORKER2 = 24;
    static constexpr int TILENUM_MONSTER_WORKER3 = 25;
    static constexpr int TILENUM_MONSTER_SKELETON = 26;
    static constexpr int TILENUM_MONSTER_SKELETON2 = 27;
    static constexpr int TILENUM_MONSTER_SKELETON3 = 28;
    static constexpr int TILENUM_MONSTER_TORMENTOR = 29;
    static constexpr int TILENUM_MONSTER_TORMENTOR2 = 30;
    static constexpr int TILENUM_MONSTER_OFFICER = 32;
    static constexpr int TILENUM_MONSTER_OFFICER2 = 33;
    static constexpr int TILENUM_MONSTER_OFFICER3 = 34;
    static constexpr int TILENUM_MONSTER_SUPERS = 38;
    static constexpr int TILENUM_MONSTER_SUPERS2 = 39;
    static constexpr int TILENUM_MONSTER_SUPERS3 = 40;
    static constexpr int TILENUM_MONSTER_TROOPER = 41;
    static constexpr int TILENUM_MONSTER_TROOPER2 = 42;
    static constexpr int TILENUM_MONSTER_TROOPER3 = 43;
    static constexpr int TILENUM_MONSTER_ELITE_GUARD = 44;
    static constexpr int TILENUM_MONSTER_ELITE_GUARD2 = 45;
    static constexpr int TILENUM_MONSTER_ELITE_GUARD3 = 46;
    static constexpr int TILENUM_MONSTER_ZOMBIE = 47;
    static constexpr int TILENUM_MONSTER_ZOMBIE2 = 48;
    static constexpr int TILENUM_MONSTER_ZOMBIE3 = 49;
    static constexpr int TILENUM_MONSTER_CHICKEN = 50;
    static constexpr int TILENUM_BOSS_SPY1 = 54;
    static constexpr int TILENUM_BOSS_SPY2 = 55;
    static constexpr int TILENUM_BOSS_OLARIC = 56;
    static constexpr int TILENUM_BOSS_MARRIANNA = 57;
    static constexpr int TILENUM_BOSS_HARBINGER = 58;
    static constexpr int TILENUM_LAST_MONSTER = 59;

    static constexpr int TILENUM_DUMMY_START = 60;
    static constexpr int TILENUM_DUMMY_PAIN = 60;
    static constexpr int TILENUM_ATTACK_DUMMY = 61;
    static constexpr int TILENUM_EXIT_DUMMY = 62;
    static constexpr int TILENUM_USE_DUMMY = 63;
    static constexpr int TILENUM_DUMMY_END = 63;

    static constexpr int TILENUM_FIRST_NPC = 65;
    static constexpr int TILENUM_NPC_CYPRIAN = 66;
    static constexpr int TILENUM_NPC_CRAZY_OFFICER = 68;
    static constexpr int TILENUM_NPC_POW = 69;
    static constexpr int TILENUM_NPC_PLAYER = 70;
    static constexpr int TILENUM_NPC_CIVILIAN = 71;
    static constexpr int TILENUM_NPC_SPY = 72;
    static constexpr int TILENUM_LAST_NPC = 80;

    static constexpr int TILENUM_FIRST_ITEM = 81;
    static constexpr int TILENUM_AMMO_9MM = 85;
    static constexpr int TILENUM_AMMO_12_7MM = 86;
    static constexpr int TILENUM_AMMO_30CAL = 88;
    static constexpr int TILENUM_AMMO_45CAL = 89;
    static constexpr int TILENUM_AMMO_FUEL = 90;
    static constexpr int TILENUM_AMMO_ROCKETS = 91;
    static constexpr int TILENUM_AMMO_DYNAMITE = 92;
    static constexpr int TILENUM_AMMO_TESLA = 93;
    static constexpr int TILENUM_OTHER_SCOTCH = 96;
    static constexpr int TILENUM_SYRINGE_AGILITY = 98;
    static constexpr int TILENUM_SYRINGE_DEFENSE = 99;
    static constexpr int TILENUM_SYRINGE_STRENGTH = 100;
    static constexpr int TILENUM_SYRINGE_FOCUS = 101;
    static constexpr int TILENUM_SYRINGE_ANGER = 102;
    static constexpr int TILENUM_SYRINGE_FIRE = 103;
    static constexpr int TILENUM_EMPTY_SYRINGE = 104;
    static constexpr int TILENUM_GOLD_GOBLET = 107;
    static constexpr int TILENUM_GOLD_CROSS = 108;
    static constexpr int TILENUM_GOLD_CROWN = 109;
    static constexpr int TILENUM_KEY_SILVER = 110;
    static constexpr int TILENUM_KEY_GOLD = 111;
    static constexpr int TILENUM_ARMOR_HELMET = 112;
    static constexpr int TILENUM_RATION_BAR = 113;
    static constexpr int TILENUM_PACK_ITEM = 114;
    static constexpr int TILENUM_WORKER_PACK = 115;
    static constexpr int TILENUM_HEALTH_PACK = 116;
    static constexpr int TILENUM_FOOD_PLATE = 117;
    static constexpr int TILENUM_BURNT_FOOD = 118;
    static constexpr int TILENUM_LAST_ITEM = 118;

    static constexpr int TILENUM_BEDS = 120;
    static constexpr int TILENUM_TOMB = 121;
    static constexpr int TILENUM_SM_HOLE = 122;
    static constexpr int TILENUM_TOILET = 123;
    static constexpr int TILENUM_DIRT_DECAL = 124;
    static constexpr int TILENUM_LADDER = 125;
    static constexpr int TILENUM_SINK = 127;
    static constexpr int TILENUM_SECRETCRACK = 126;
    static constexpr int TILENUM_WINDOW = 128;

    static constexpr int TILENUM_FIRST_DECOR = 130;
    static constexpr int TILENUM_OBJ_FIRE = 130;
    static constexpr int TILENUM_OBJ_PICTURE = 131;
    static constexpr int TILENUM_OBJ_TORTURE = 132;
    static constexpr int TILENUM_OBJ_ALARM = 133;
    static constexpr int TILENUM_OBJ_TABLE = 134;
    static constexpr int TILENUM_OBJ_CHAIR = 135;
    static constexpr int TILENUM_OBJ_TORCHIERE = 136;
    static constexpr int TILENUM_LIGHTING = 137;
    static constexpr int TILENUM_OBJ_SKELETON = 138;
    static constexpr int TILENUM_OBJ_JOURNAL = 139;
    static constexpr int TILENUM_OBJ_BARREL = 140;
    static constexpr int TILENUM_OBJ_DYNAMITE = 141;
    static constexpr int TILENUM_OBJ_BOOK = 142;
    static constexpr int TILENUM_OBJ_BLOODPOOL = 146;
    static constexpr int TILENUM_COCKTAILMIXER = 147;
    static constexpr int TILENUM_GENERATOR = 149;
    static constexpr int TILENUM_OBJ_WALLTORCH = 150;
    static constexpr int TILENUM_OBJ_CRATE = 152;
    static constexpr int TILENUM_OBJ_HANGING_SKELETON = 164;
    static constexpr int TILENUM_SEA_WEED = 170;
    static constexpr int TILENUM_GRATE = 172;
    static constexpr int TILENUM_WINDOW2 = 175;
    static constexpr int TILENUM_OBJ_FLAG = 177;
    static constexpr int TILENUM_STATUE_ARMORED = 148;
    static constexpr int TILENUM_SECRET_SCUFFS = 151;
    static constexpr int TILENUM_BOOKSHELF = 153;
    static constexpr int TILENUM_WOOD_BEAM = 154;
    static constexpr int TILENUM_RELIQUARY = 156;
    static constexpr int TILENUM_TOMBSTONE = 158;
    static constexpr int TILENUM_OBJ_CHEMICALPOOL = 159;
    static constexpr int TILENUM_LAST_DECOR = 160;

    static constexpr int TILENUM_BLOOD_DECAL = 161;
    static constexpr int TILENUM_DOORJAMB_DECAL = 162;
    static constexpr int TILENUM_NONOBSTRUCTING_SPRITEWALL = 166;
    static constexpr int TILENUM_NONOBSTRUCTING_SPRITEWALL2 = 168;
    static constexpr int TILENUM_FENCE = 168;
    static constexpr int TILENUM_PRISON_BARS = 194;
    static constexpr int TILENUM_CLIPBOARD = 180;
    static constexpr int TILENUM_WALL_LIGHT = 181;
    static constexpr int TILENUM_FLOWERS = 184;
    static constexpr int TILENUM_FADE = 302;
    static constexpr int TILENUM_CREEPER_VINE = 200;
    static constexpr int TILENUM_FOG_PURPLE = 206;
    static constexpr int TILENUM_BAR_RUMBLE = 209;
    static constexpr int TILENUM_BLOOD_DECAL2 = 210;
    static constexpr int TILENUM_SCORCH_MARK = 212;
    static constexpr int TILENUM_SWITCH = 173;
    static constexpr int TILENUM_SPIDERWEB = 176;
    static constexpr int TILENUM_BARRICADE = 178;
    static constexpr int TILENUM_BUSH = 187;
    static constexpr int TILENUM_TREE_TOP = 188;
    static constexpr int TILENUM_TREE_TRUNK = 189;
    static constexpr int TILENUM_MILITARY_CAR = 190;
    static constexpr int TILENUM_LAST_SPRITEWALL = 192;
    static constexpr int TILENUM_SFX_LIGHTGLOW1 = 193;
    static constexpr int TILENUM_AIR_BUBBLES = 203;
    static constexpr int TILENUM_FIRST_FX = 225;
    static constexpr int TILENUM_ANIM_WRENCH = 227;
    static constexpr int TILENUM_ANIM_SKULL = 230;
    static constexpr int TILENUM_LAST_SPRITE = 256;
    static constexpr int TILENUM_ANIM_FIRE = 234;
    static constexpr int TILENUM_ANIM_POISON = 251;
    static constexpr int TILENUM_LIGHTNING = 236;
    static constexpr int TILENUM_ANIM_SMOKE2 = 192;
    static constexpr int TILENUM_WINDOW3 = 197;
    static constexpr int TILENUM_CHICKEN = 252;
    static constexpr int TILENUM_TESLA_BOLT = 237;
    static constexpr int TILENUM_ANIM_START = 241;
    static constexpr int TILENUM_FIRE_STREAM = 241;
    static constexpr int TILENUM_ANIM_EXPLOSION = 242;
    static constexpr int TILENUM_ANIM_END = 242;
    static constexpr int TILENUM_MONSTER_CLAW = 245;
    static constexpr int TILENUM_MONSTER_KICK = 246;
    static constexpr int TILENUM_BLOOD_FOUNTAIN = 247;
    static constexpr int TILENUM_FOG_GRAY = 208;
    static constexpr int TILENUM_MONSTER_CHAT = 253;
    static constexpr int TILENUM_NPC_CHAT = 254;
    static constexpr int TILENUM_ALERT = 255;
    static constexpr int TILENUM_MISSILE_START = 225;
    static constexpr int TILENUM_MISSILE_PANZER = 226;
    static constexpr int TILENUM_MISSILE_END = 231;
    static constexpr int TILENUM_SHADOW = 232;
    static constexpr int TILENUM_FIRST_WALL = 257;
    static constexpr int TILENUM_DOORJAMB = 257;
    static constexpr int TILENUM_WALL_BARRICADE = 259;

    static constexpr int TILENUM_FIRST_DOOR = 271;
    static constexpr int TILENUM_SILVER_DOOR_LOCKED = 271;
    static constexpr int TILENUM_SILVER_DOOR_UNLOCKED = 272;
    static constexpr int TILENUM_GOLD_DOOR_LOCKED = 273;
    static constexpr int TILENUM_GOLD_DOOR_UNLOCKED = 274;
    static constexpr int TILENUM_DOOR_LOCKED = 275;
    static constexpr int TILENUM_DOOR_UNLOCKED = 276;
    static constexpr int TILENUM_LEVEL_DOOR_LOCKED = 277;
    static constexpr int TILENUM_LEVEL_DOOR_UNLOCKED = 278;
    static constexpr int TILENUM_TOWN_DOOR_LOCKED = 279;
    static constexpr int TILENUM_TOWN_DOOR_UNLOCKED = 280;
    static constexpr int TILENUM_LAST_DOOR = 281;

    static constexpr int TILENUM_SKY_BOX = 301;

    static constexpr int TILENUM_LAST_WALL = 449;
    static constexpr int TILENUM_FIRST_FLAT = 450;
    static constexpr int TILENUM_FLAT_WATER = 479;
    static constexpr int TILENUM_NO_SPRITE_BARS = 507;
    static constexpr int TILENUM_SPRITE_BARS2 = 508;
    static constexpr int TILENUM_LAST_FLAT = 512;

    static constexpr int TILENUM_FIRST_COMPILERONLY = 513;
    static constexpr int TILENUM_C_FILL = 513;
    static constexpr int TILENUM_C_SPAWN_NORTH = 514;
    static constexpr int TILENUM_C_SPAWN_EAST = 515;
    static constexpr int TILENUM_C_SPAWN_SOUTH = 516;
    static constexpr int TILENUM_C_SPAWN_WEST = 517;
    static constexpr int TILENUM_C_DOOR_HORZ = 529;
    static constexpr int TILENUM_C_DOOR_VERT = 530;
    static constexpr int TILENUM_C_FIRST_MOVINGBLOCK = 531;
    static constexpr int TILENUM_C_PUSHWALL_HORZ = 531;
    static constexpr int TILENUM_C_PUSHWALL_VERT = 532;
    static constexpr int TILENUM_C_PUSHBLOCK = 533;
    static constexpr int TILENUM_C_SECRETBLOCK_VERT = 534;
    static constexpr int TILENUM_C_SECRETBLOCK_HORZ = 535;
    static constexpr int TILENUM_C_LAST_MOVINGBLOCK = 535;
    static constexpr int TILENUM_C_TEXFLIP = 536;
    static constexpr int TILENUM_C_TRIBEVEL_NW = 545;
    static constexpr int TILENUM_C_TRIBEVEL_NE = 546;
    static constexpr int TILENUM_C_TRIBEVEL_SE = 547;
    static constexpr int TILENUM_C_TRIBEVEL_SW = 548;
    static constexpr int TILENUM_C_SHALLOWBEVEL_SE = 549;
    static constexpr int TILENUM_C_SHALLOWBEVEL_SW = 550;
    static constexpr int TILENUM_C_SHALLOWBEVEL_NW = 551;
    static constexpr int TILENUM_C_SHALLOWBEVEL_NE = 552;
    static constexpr int TILENUM_C_FIRST_DEEPBEVEL = 553;
    static constexpr int TILENUM_C_DEEPBEVEL_NW = 553;
    static constexpr int TILENUM_C_DEEPBEVEL_NE = 554;
    static constexpr int TILENUM_C_DEEPBEVEL_SE = 555;
    static constexpr int TILENUM_C_DEEPBEVEL_SW = 556;
    static constexpr int TILENUM_C_LAST_DEEPBEVEL = 556;
    static constexpr int TILENUM_C_COLUMN = 557;
    static constexpr int TILENUM_C_ENDCAP_N = 558;
    static constexpr int TILENUM_C_ENDCAP_E = 559;
    static constexpr int TILENUM_C_ENDCAP_S = 560;
    static constexpr int TILENUM_C_ENDCAP_W = 561;

    static constexpr int TILENUM_C_FIRST_POST = 562;
    static constexpr int TILENUM_C_CORNERPOST_NW = 562;
    static constexpr int TILENUM_C_CORNERPOST_NE = 563;
    static constexpr int TILENUM_C_CORNERPOST_SE = 564;
    static constexpr int TILENUM_C_CORNERPOST_SW = 565;
    static constexpr int TILENUM_C_LAST_POST = 565;

    static constexpr int TILENUM_C_COLLIDER = 566;
    static constexpr int TILENUM_C_SPWALL_SOUTH = 577;
    static constexpr int TILENUM_C_SPWALL_NORTH = 578;
    static constexpr int TILENUM_C_SPWALL_EAST = 579;
    static constexpr int TILENUM_C_SPWALL_WEST = 580;
    static constexpr int TILENUM_C_NSSPWALL_SOUTH = 581;
    static constexpr int TILENUM_C_NSSPWALL_NORTH = 582;
    static constexpr int TILENUM_C_NSSPWALL_EAST = 583;
    static constexpr int TILENUM_C_NSSPWALL_WEST = 584;
    static constexpr int TILENUM_C_SPWALL_HORIZONTAL = 585;
    static constexpr int TILENUM_C_SPWALL_VERTICAL = 586;
    static constexpr int TILENUM_C_NSSPWALL_HORIZONTAL = 587;
    static constexpr int TILENUM_C_NSSPWALL_VERTICAL = 588;
    static constexpr int TILENUM_OCCLUSION_LINE = 600;
    static constexpr int TILENUM_BSP_LINE = 601;
    static constexpr int TILENUM_CLIP_LINE = 602;
    static constexpr int TILENUM_VIS_LINE = 604;
    static constexpr int TILENUM_MOVE_LINE = 605;
    static constexpr int TILENUM_MAP_LINE = 606;
    static constexpr int TILENUM_CLIP_FACE_LINE = 607;

    static constexpr int EVT_INDEX_MASK = 1023;
    static constexpr int EVT_FUNCTION_SHIFT = 16;
    static constexpr int EVT_FUNCTION_MASK = -65536;
    static constexpr int EFL_NONINTERACTIVE = 1;
    static constexpr int MAX_SCRIPT_STACK = 8;
    static constexpr int SCRIPT_FAILURE = 0;
    static constexpr int SCRIPT_SUCCESS = 1;
    static constexpr int SCRIPT_PAUSED = 2;
    static constexpr int SCRIPT_ABORTED = 3;
    static constexpr int SCRIPT_FLAG_PLAYERFORCED = 1;
    static constexpr int SCRIPT_FLAG_PAUSED = 2;
    static constexpr int SCRIPT_FLAG_NOAUTOUNPAUSE = 4;
    static constexpr uint8_t TBL_COMBAT_MONSTERATTACKS = 0;
    static constexpr uint8_t TBL_COMBAT_WEAPONINFO = 1;
    static constexpr uint8_t TBL_COMBAT_WEAPONDATA = 2;
    static constexpr uint8_t TBL_COMBAT_MONSTERSTATS = 3;
    static constexpr uint8_t TBL_COMBAT_COMBATMASK = 4;
    static constexpr uint8_t TBL_CANVAS_KEYSNUMERIC = 5;
    static constexpr uint8_t TBL_ENUMS_OSC_CYCLE = 6;
    static constexpr uint8_t TBL_GAME_LEVELNAMES = 7;
    static constexpr uint8_t TBL_MONSTER_COLORS = 8;
    static constexpr uint8_t TBL_RENDER_SINETABLE = 9;
    static constexpr uint8_t TBL_COCKTAIL_RECIPES = 10;
    static constexpr uint8_t TBL_COCKTAIL_NAMES = 11;
    static constexpr uint8_t TBL_MONSTER_WEAKNESS = 12;
    static constexpr uint8_t TBL_MEDALS = 13;
    static constexpr uint8_t TBL_BOOKS = 14;
    static constexpr uint8_t TBL_SKYMAP1_PALETTE = 15;
    static constexpr uint8_t TBL_SKYMAP1_TEXELS = 16;
    static constexpr uint8_t TBL_TOTAL = 17;
    static constexpr int MAX_MOVING_LINES = 120;
    static constexpr int ML_NUM_FIELDS = 3;
    static constexpr int ML_NONE = 255;
    static constexpr int OFS_ML_LINE = 0;
    static constexpr int OFS_ML_PREV = 120;
    static constexpr int OFS_ML_NEXT = 240;
    static constexpr uint8_t OFS_SS_EVENT = 0;
    static constexpr uint8_t OFS_SS_TYPEMASK = 8;
    static constexpr uint8_t OFS_SS_CMDINDEX = 16;
    static constexpr uint8_t OFS_SS_FLAGS = 24;
    static constexpr uint8_t NUM_SCRIPT_STACK_FIELDS = 4;
    static constexpr int DEFAULT_VIEWZ = 36;
    static constexpr int DEFAULT_FOVX = 250;
    static constexpr int MIN_FOV_X = 64;
    static constexpr int SNIPER_MIN_FOVX = 80;
    static constexpr int SNIPER_DEFAULT_FOVX = 150;
    static constexpr uint8_t MAX_PARTICLES = 48;
    static constexpr short OFS_PARTICLE_ACTIVE = 0;
    static constexpr short OFS_PARTICLE_X = 48;
    static constexpr short OFS_PARTICLE_Y = 96;
    static constexpr short OFS_PARTICLE_VX = 144;
    static constexpr short OFS_PARTICLE_VY = 192;
    static constexpr short OFS_PARTICLE_SIZE = 240;
    static constexpr uint8_t NUM_PARTICLE_FIELDS = 6;

    static constexpr int CR_HIT = 1;
    static constexpr int CR_CRIT = 2;
    static constexpr int CR_WEAK_HIT = 4;
    static constexpr int CR_AVGDMG = 8;
    static constexpr int CR_IGNORERANGE = 16;
    static constexpr int CR_NOSTRBONUS = 32;
    static constexpr int CR_REQUIRERANGE = 64;
    static constexpr int CR_DODGE = 128;
    static constexpr int CR_IMMUNE = 256;
    static constexpr int CR_SHADOWED = 512;
    static constexpr int CR_OUTOFRANGE = 1024;
    static constexpr int CR_ABILITY = 2048;
    static constexpr int CR_BOMB_STUCK = 4096;
    static constexpr int CR_CRIT_DAMAGE = 8192;
    static constexpr int CR_HITMASK = (CR_HIT | CR_CRIT | CR_WEAK_HIT | CR_BOMB_STUCK); // 4103

    static constexpr int POS_X = 0;
    static constexpr int POS_Y = 1;
    static constexpr int POS_Z = 2;
    static constexpr int POS_START = 0;
    static constexpr int POS_SX = 0;
    static constexpr int POS_SY = 1;
    static constexpr int POS_SZ = 2;
    static constexpr int POS_DEST = 3;
    static constexpr int POS_DX = 3;
    static constexpr int POS_DY = 4;
    static constexpr int POS_DZ = 5;
    static constexpr int ACTION_BREW_BACK = -1;
    static constexpr int ACTION_NONE = 0;
    static constexpr int ACTION_UP = 1;
    static constexpr int ACTION_DOWN = 2;
    static constexpr int ACTION_LEFT = 3;
    static constexpr int ACTION_RIGHT = 4;
    static constexpr int ACTION_MENU = 5;
    static constexpr int ACTION_FIRE = 6;
    static constexpr int ACTION_AUTOMAP = 7;
    static constexpr int ACTION_STRAFELEFT = 9;
    static constexpr int ACTION_STRAFERIGHT = 10;
    static constexpr int ACTION_PREVWEAPON = 11;
    static constexpr int ACTION_NEXTWEAPON = 12;
    static constexpr int ACTION_PASSTURN = 14;
    static constexpr int ACTION_BACK = 15;
    static constexpr int ACTION_ITEMS_SYRINGES = 16; // [GEC]
    static constexpr int ACTION_ITEMS = 17; // [GEC]
    static constexpr int ACTION_QUESTLOG = 18; // [GEC]
    static constexpr int ACTION_MENU_ITEM_INFO = 19; // [GEC]
    static constexpr uint8_t ERR_DEQUEUEHELP = 0;
    static constexpr uint8_t ERR_ADDMOVINGBLOCK = 1;
    static constexpr uint8_t ERR_BADEVENT = 2;
    static constexpr uint8_t ERR_BADLINKWORLD = 3;
    static constexpr uint8_t ERR_BADUNLINKWORLD = 4;
    static constexpr uint8_t ERR_CLEANCORPSE = 5;
    static constexpr uint8_t ERR_DRAWSTRING = 6;
    static constexpr uint8_t ERR_DROPCHESTITEM = 7;
    static constexpr uint8_t ERR_EV_DAMAGEENTITY = 8;
    static constexpr uint8_t ERR_EV_DEACTIVATE = 9;
    static constexpr uint8_t ERR_INTRO_IMAGES = 10;
    static constexpr uint8_t ERR_EV_MONSTERFLAGS = 11;
    static constexpr uint8_t ERR_EV_MONSTERSTAT = 12;
    static constexpr uint8_t ERR_EV_NAMEENTITY = 13;
    static constexpr uint8_t ERR_EV_SHOWCHATBUBBLE = 14;
    static constexpr uint8_t ERR_EV_WAKEMONSTER = 15;
    static constexpr uint8_t ERR_GIVE_ITEM = 16;
    static constexpr uint8_t ERR_IO_CREDITS = 17;
    static constexpr uint8_t ERR_IO_ENTITYDEFS = 18;
    static constexpr uint8_t ERR_IO_LOADENTITYSTATES = 19;
    static constexpr uint8_t ERR_IO_LOADHELPRSRC = 20;
    static constexpr uint8_t ERR_IO_LOADMENUS = 21;
    static constexpr uint8_t ERR_IO_LOADMOVINGBLOCKS = 22;
    static constexpr uint8_t ERR_MISC_SCRIPT = 23;
    static constexpr uint8_t ERR_IO_STORY = 24;
    static constexpr uint8_t ERR_ISNAMEDENTITY = 25;
    static constexpr uint8_t ERR_LINKLINKEDENTITY = 26;
    static constexpr uint8_t ERR_LINKWORLD = 27;
    static constexpr uint8_t ERR_LOADCONFIG = 28;
    static constexpr uint8_t ERR_LOADMENUITEMS = 29;
    static constexpr uint8_t ERR_LOADMOVINGBLOCKS = 30;
    static constexpr uint8_t ERR_LOADPLAYERSTATE = 31;
    static constexpr uint8_t ERR_LOADSTATE = 32;
    static constexpr uint8_t ERR_LOADWORLDSTATE = 33;
    static constexpr uint8_t ERR_MAX_CUSTOMSPRITES = 34;
    static constexpr uint8_t ERR_MAX_ENTITIES = 35;
    static constexpr uint8_t ERR_MAX_LERPSPRITES = 36;
    static constexpr uint8_t ERR_MAX_MONSTERS = 37;
    static constexpr uint8_t ERR_MAX_MOVINGBLOCKS = 38;
    static constexpr uint8_t ERR_MAX_NOTEBOOKINDEXES = 39;
    static constexpr uint8_t ERR_MAX_SCRIPTTHREADS = 40;
    static constexpr uint8_t ERR_MAXHELP = 41;
    static constexpr uint8_t ERR_MOVEBLOCKTO = 42;
    static constexpr uint8_t ERR_SAVECONFIG = 43;
    static constexpr uint8_t ERR_SAVEENTITYSTATES = 44;
    static constexpr uint8_t ERR_SAVEMOVINGBLOCKS = 45;
    static constexpr uint8_t ERR_SAVEPLAYERSTATE = 46;
    static constexpr uint8_t ERR_SAVESNAPSHOT = 47;
    static constexpr uint8_t ERR_SAVESTATE = 48;
    static constexpr uint8_t ERR_SAVEWORLDSTATE = 49;
    static constexpr uint8_t ERR_SPAWNPARTICLES = 50;
    static constexpr uint8_t ERR_STATE = 51;
    static constexpr uint8_t ERR_UNLINKWORLD = 52;
    static constexpr uint8_t ERR_WRAPTEXT = 53;
    static constexpr uint8_t ERR_MAX_SCRIPTSTACK = 54;
    static constexpr uint8_t ERR_CLEARMOVINGBLOCKS = 55;
    static constexpr uint8_t ERR_LOADIMAGE = 56;
    static constexpr uint8_t ERR_STARTUP = 57;
    static constexpr uint8_t ERR_LOADMAPPINGS = 58;
    static constexpr uint8_t ERR_LOADPALETTES = 59;
    static constexpr uint8_t ERR_LOADSHAPES = 60;
    static constexpr uint8_t ERR_LOADSPRITETEXELS = 61;
    static constexpr uint8_t ERR_LOADWALLTEXELS = 62;
    static constexpr uint8_t ERR_INVALIDMEDIA = 63;
    static constexpr uint8_t ERR_MAX_MOVINGLINES = 64;
    static constexpr uint8_t ERR_MAX_TILEREFS = 65;
    static constexpr uint8_t ERR_UPDATEMLFLAGS = 66;
    static constexpr uint8_t ERR_BADMAPSTRINGS = 67;
    static constexpr uint8_t ERR_BADMAPVERSION = 68;
    static constexpr uint8_t ERR_INVALIDBITDEPTH = 69;
    static constexpr uint8_t ERR_MAX_SPRITEMAPPING = 70;
    static constexpr uint8_t ERR_MAX_SPRITEMEDIAMAPPING = 71;
    static constexpr uint8_t ERR_MAX_TEXMAPPING = 72;
    static constexpr uint8_t ERR_MAX_TEXMEDIAMAPPING = 73;
    static constexpr uint8_t ERR_NUMTEXELSOVERFLOW = 74;
    static constexpr uint8_t ERR_SHAPEDATAOVERFLOW = 75;
    static constexpr uint8_t ERR_EV_AIGOAL = 76;
    static constexpr uint8_t ERR_LOADTABLE = 77;
    static constexpr uint8_t ERR_MEMORY = 78;
    static constexpr uint8_t ERR_TEXEL_OVERFLOW = 79;
    static constexpr uint8_t ERR_SND_LOADFILEINDEX = 80;
    static constexpr uint8_t ERR_DELETERECORD = 81;
    static constexpr uint8_t ERR_CLOSERECORD = 82;
    static constexpr uint8_t ERR_SAVERECORD = 83;
    static constexpr uint8_t ERR_LOCALIZE_INVALID_STRING = 84;
    static constexpr uint8_t ERR_LOCALIZE_UNLOADED_TYPE = 85;
    static constexpr uint8_t ERR_LOCALIZE_BAD_ARG = 86;
    static constexpr uint8_t ERR_STRINGTABLE = 87;
    static constexpr uint8_t ERR_LOADSTRINGS = 88;
    static constexpr uint8_t ERR_LOADFILESTRING = 89;
    static constexpr uint8_t ERR_MISSINGLOOTPARAM = 90;
    static constexpr uint8_t ERR_PASSWORDLENGTH = 91;
    static constexpr uint8_t ERR_PASSWORDCHARS = 92;
    static constexpr uint8_t ERR_PASSWORDMISSING = 93;
    static constexpr uint8_t ERR_MAXCAMERAS = 94;
    static constexpr uint8_t ERR_NONSNAPPEDMONSTERS = 95;
    static constexpr uint8_t ERR_INVALIDSPRITENUMBER = 96;
    static constexpr uint8_t ERR_SPRITENUMBERBOUNDS = 97;
    static constexpr uint8_t ERR_NOSUCHSPRITE = 98;
    static constexpr uint8_t ERR_MAXFRAMES = 99;
    static constexpr uint8_t ERR_MAXMENUITEMS = 100;
    static constexpr uint8_t ERR_MAPPINGRANGE = 101;
    static constexpr uint8_t ERR_SCRIPTTHREAD_FREE = 102;
    static constexpr uint8_t ERR_IO_CAMERAS = 103;
    static constexpr uint8_t ERR_FLAT_OUT_OF_ORDER = 104;
    static constexpr uint8_t ERR_IO_TILE_TEXELS = 105;
    static constexpr uint8_t ERR_IO_SPRITE_TEXELS = 106;
    static constexpr uint8_t ERR_RENDER_STRETCH = 107;
    static constexpr uint8_t ERR_MAX_MISSILES = 108;
    static constexpr uint8_t ERR_EV_DROPITEM = 109;
    static constexpr uint8_t ERR_ASSERT = 110;
    static constexpr uint8_t ERR_MAX_DROPPED_DYNAMITE = 111;
    static constexpr uint8_t ERR_COCKTAILMIX = 112;
    static constexpr uint8_t ERR_INV_CARD = 113;
    static constexpr uint8_t ERR_MENU_SET = 114;
    static constexpr uint8_t ERR_CARD_BET = 115;
    static constexpr uint8_t ERR_CAM_KEYS = 116;
    static constexpr int HELP_NPC = 0;
    static constexpr int HELP_POTIONS = 1;
    static constexpr int HELP_RINGS = 2;
    static constexpr int HELP_RUNELOCKS = 3;
    static constexpr int HELP_BARRICADE = 4;
    static constexpr int HELP_FOOD = 8;
    static constexpr int HELP_MONEY = 9;
    static constexpr int HELP_NOTE = 10;
    static constexpr int HELP_RUBBLE = 11;
    static constexpr int HELP_DWARVENALE = 12;
    static constexpr int HELP_FIREPIT_ON = 13;
    static constexpr int HELP_FIREPIT_OFF = 14;
    static constexpr int HELP_DOORS = 18;
    static constexpr int HELP_CRYSTALS = 19;
    static constexpr int HELP_ARMOUR_LOW = 20;
    static constexpr int HELP_GAYA = 21;
    static constexpr int HELP_GAYA2 = 22;
    static constexpr int HELP_GAYA3 = 23;
    static constexpr int HELP_SECRETSFOUND = 24;
    static constexpr int HELP_MONSTERSKILLED = 25;
    static constexpr int STATUS_EFFECT_NONE = -1;
    static constexpr int STATUS_EFFECT_REFLECT = 0;
    static constexpr int STATUS_EFFECT_PURIFY = 1;
    static constexpr int STATUS_EFFECT_AGILITY = 2;
    static constexpr int STATUS_EFFECT_REGEN = 3;
    static constexpr int STATUS_EFFECT_DEFENSE = 4;
    static constexpr int STATUS_EFFECT_ADRENALINE = 5;
    static constexpr int STATUS_EFFECT_EVADE = 6;
    static constexpr int STATUS_EFFECT_FOCUS = 7;
    static constexpr int STATUS_EFFECT_ANGER = 8;
    static constexpr int STATUS_EFFECT_ANTIFIRE = 9;
    static constexpr int STATUS_EFFECT_FORTITUDE = 10;
    static constexpr int STATUS_EFFECT_FEAR = 11;
    static constexpr int STATUS_EFFECT_AIR = 12;
    static constexpr int STATUS_EFFECT_FIRE = 13;
    static constexpr int STATUS_EFFECT_DISEASE = 14;
    static constexpr int STATUS_EFFECT_DRUNK = 15;
    static constexpr int STATUS_EFFECT_DIZZY = 16;
    static constexpr int STATUS_EFFECT_COLD = 17;
    static constexpr int STATUS_EFFECT_ALL = 18;
    static constexpr int OFS_STATUSEFFECT_TURNS  = STATUS_EFFECT_ALL * 0;
    static constexpr int OFS_STATUSEFFECT_AMOUNT = STATUS_EFFECT_ALL * 1;
    static constexpr int OFS_STATUSEFFECT_COUNT  = STATUS_EFFECT_ALL * 2;
    static constexpr int MAX_STATUS_EFFECTS      = STATUS_EFFECT_ALL * 3;

    static constexpr int BUFF_AMT_NOT_DRAWN = 14855;
    static constexpr int BUFF_REFLECT = 0;
    static constexpr int BUFF_PURIFY = 1;
    static constexpr int BUFF_HASTE = 2;
    static constexpr int BUFF_REGEN = 3;
    static constexpr int BUFF_DEFENSE = 4;
    static constexpr int BUFF_STRENGTH = 5;
    static constexpr int BUFF_AGILITY = 6;
    static constexpr int BUFF_FOCUS = 7;
    static constexpr int BUFF_ANGER = 8;
    static constexpr int BUFF_ANTIFIRE = 9;
    static constexpr int BUFF_FORTITUDE = 10;
    static constexpr int BUFF_FEAR = 11;
    static constexpr int BUFF_AIR = 12;
    static constexpr int BUFF_FIRE = 13;
    static constexpr int BUFF_DISEASE = 14;
    static constexpr int BUFF_MAX = 15;
    static constexpr int BUFF_NO_AMOUNT = 6663;
    static constexpr int BUFF_WARNING_TIME = 10;
    static constexpr int OFS_BUFF_COUNT  = BUFF_MAX * 0;
    static constexpr int OFS_BUFF_AMOUNT = BUFF_MAX * 1;

    static constexpr int LINE_TYPE_LINE = 0;
    static constexpr int LINE_TYPE_BSP = 1;
    static constexpr int LINE_TYPE_CLIP = 2;
    static constexpr int LINE_TYPE_VIS = 4;
    static constexpr int LINE_TYPE_MOVE = 5;
    static constexpr int LINE_TYPE_MAP = 6;
    static constexpr int LINE_TYPE_CLIP_FACE = 7;
    static constexpr int LINE_TYPE_MASK = 7;
    static constexpr int LINE_FLAG_AUTOMAP = 8;
    static constexpr int NODE_OFFSET_LEAF = 0xFFFF;

    static constexpr int SPRITE_SHIFT_FRAMENUMBER = 8;
    static constexpr int SPRITE_SHIFT_FLAGS = 16;
    static constexpr int SPRITE_MASK_SPRITENUMBER = 255;
    static constexpr int SPRITE_MASK_FRAMENUMBER = 65280;
    static constexpr int SPRITE_MASK_GFX = 65535;
    static constexpr int SPRITE_MASK_LOFLAGS = 16711680;
    static constexpr int SPRITE_MASK_HIFLAGS = -16777216;

    static constexpr int SPRITE_SHIFT_HIDDEN = 16;
    static constexpr int SPRITE_SHIFT_FLIP_HORIZONTAL = 17;
    static constexpr int SPRITE_SHIFT_FLIP_VERTICAL = 18;
    static constexpr int SPRITE_SHIFT_AUTO_ANIMATE = 19;
    static constexpr int SPRITE_SHIFT_TWO_SIDED = 20;
    static constexpr int SPRITE_SHIFT_AUTOMAP_VISIBLE = 21;
    static constexpr int SPRITE_SHIFT_NOENTITY = SPRITE_SHIFT_AUTOMAP_VISIBLE;
    static constexpr int SPRITE_SHIFT_TILE = 22;
    static constexpr int SPRITE_SHIFT_SOLIDSIDE = 23;
    static constexpr int SPRITE_SHIFT_NORTH = 24;
    static constexpr int SPRITE_SHIFT_SOUTH = 25;
    static constexpr int SPRITE_SHIFT_EAST = 26;
    static constexpr int SPRITE_SHIFT_WEST = 27;
    static constexpr int SPRITE_SHIFT_DECAL = 28;
    static constexpr int SPRITE_SHIFT_FLAT = 29;
    static constexpr int SPRITE_SHIFT_CLIPZ = 30;
    static constexpr int SPRITE_SHIFT_DOORLERP = 31;

    static constexpr int SPRITE_FLAG_HIDDEN             = (1 << SPRITE_SHIFT_HIDDEN); // 0x10000
    static constexpr int SPRITE_FLAG_FLIP_HORIZONTAL    = (1 << SPRITE_SHIFT_FLIP_HORIZONTAL); // 0x20000
    static constexpr int SPRITE_FLAG_FLIP_VERTICAL      = (1 << SPRITE_SHIFT_FLIP_VERTICAL); // 0x40000
    static constexpr int SPRITE_FLAG_AUTO_ANIMATE       = (1 << SPRITE_SHIFT_AUTO_ANIMATE); // 0x80000
    static constexpr int SPRITE_FLAG_TWO_SIDED          = (1 << SPRITE_SHIFT_TWO_SIDED); // 0x100000
    static constexpr int SPRITE_FLAG_AUTOMAP_VISIBLE    = (1 << SPRITE_SHIFT_AUTOMAP_VISIBLE); // 0x200000
    static constexpr int SPRITE_FLAG_NOENTITY           = (1 << SPRITE_SHIFT_NOENTITY); // 0x200000
    static constexpr int SPRITE_FLAG_TILE               = (1 << SPRITE_SHIFT_TILE); // 0x400000
    static constexpr int SPRITE_FLAG_SOLIDSIDE          = (1 << SPRITE_SHIFT_SOLIDSIDE); // 0x800000
    static constexpr int SPRITE_FLAG_NORTH              = (1 << SPRITE_SHIFT_NORTH); // 0x1000000
    static constexpr int SPRITE_FLAG_SOUTH              = (1 << SPRITE_SHIFT_SOUTH); // 0x2000000
    static constexpr int SPRITE_FLAG_EAST               = (1 << SPRITE_SHIFT_EAST); // 0x4000000
    static constexpr int SPRITE_FLAG_WEST               = (1 << SPRITE_SHIFT_WEST); // 0x8000000
    static constexpr int SPRITE_FLAG_DECAL              = (1 << SPRITE_SHIFT_DECAL); // 0x10000000
    static constexpr int SPRITE_FLAG_FLAT               = (1 << SPRITE_SHIFT_FLAT); // 0x20000000
    static constexpr int SPRITE_FLAG_CLIPZ              = (1 << SPRITE_SHIFT_CLIPZ); // 0x40000000
    static constexpr int SPRITE_FLAG_DOORLERP           = (1 << SPRITE_SHIFT_DOORLERP); // 0x80000000
    static constexpr int SPRITE_FLAGS_ORIENTED          = (SPRITE_FLAG_NORTH | SPRITE_FLAG_SOUTH | SPRITE_FLAG_EAST | SPRITE_FLAG_WEST); // 0xF000000
    static constexpr int SPRITE_FLAGS_HORIZONTAL        = (SPRITE_FLAG_NORTH | SPRITE_FLAG_SOUTH); // 0x3000000
    static constexpr int SPRITE_FLAGS_VERTICAL          = (SPRITE_FLAG_EAST | SPRITE_FLAG_WEST); // 0xC000000

    static constexpr int COUNTER_TREASURE = 0;
    static constexpr int COUNTER_MAXDAMAGE = 1;
    static constexpr int COUNTER_TOTALDAMAGE = 2;
    static constexpr int COUNTER_TURNSDRUNK = 3;
    static constexpr int COUNTER_CORPSESGIBBED = 4;
    static constexpr int COUNTER_XP = 5;
    static constexpr int COUNTER_NUMSHOTS = 6;
    static constexpr int COUNTER_NUMMISSED = 7;
    static constexpr int COUNTERS_TOTAL = 8;
    static constexpr int BAR_HEIGHT = 25;
    static constexpr int SOFTKEY_HEIGHT = 26;
    static constexpr int MAP_NONE = 0;
    static constexpr int MAP_M01 = 1;
    static constexpr int MAP_M02 = 2;
    static constexpr int MAP_M03 = 3;
    static constexpr int MAP_M04 = 4;
    static constexpr int MAP_M05 = 5;
    static constexpr int MAP_M06 = 6;
    static constexpr int MAP_M07 = 7;
    static constexpr int MAP_M08 = 8;
    static constexpr int MAP_M09 = 9;
    static constexpr int MAP_M10 = 10;
    static constexpr int MAP_LAST_SAVE = 10;
    static constexpr int MAP_MAX = 11;

    static constexpr int CODEVAR_DRUNK = 0;
    static constexpr int CODEVAR_HEALTH = 1;
    static constexpr int CODEVAR_PLAYER_X = 2;
    static constexpr int CODEVAR_PLAYER_Y = 3;
    static constexpr int CODEVAR_DIALOG_CHOICE = 4;
    static constexpr int CODEVAR_DRAW_SKYMAP = 5;
    static constexpr int CODEVAR_OSCILLATE_FOV = 6;
    static constexpr int CODEVAR_COMMMAND_RETURN = 7;
    static constexpr int CODEVAR_PLAYER_GOLD = 8;
    static constexpr int CODEVAR_FOUND_BOOKS = 9;
    static constexpr int CODEVAR_TOTAL_BOOKS = 10;
    static constexpr int CODEVAR_PICKUP_ITEM_TILE = 11;
    static constexpr int CODEVAR_DIFFICULTY = 12;
    static constexpr int CODEVAR_KICKING_TURN = 13;
    static constexpr int NUM_CODEVARS = 14;

    static constexpr int MARKTILE_MONSTER_CLIP = 1024;
    static constexpr int MARKTILE_ENTRANCE = 2048;
    static constexpr int MARKTILE_EXIT = 4096;
    static constexpr int MARKTILE_LADDER = 8192;
    static constexpr int UNMARKTILE = 32768;
    static constexpr int MARKTILE_MASK = 48128;

    static constexpr int GIVE_ITEM_FAIL = 1;
    static constexpr int GIVE_ITEM_SUCCESS = 0;

    static constexpr int INTERROGATE_EXIT = 0;
    static constexpr int INTERROGATE_SLAP = 1;
    static constexpr int INTERROGATE_BRIBE = 2;
    static constexpr int INTERROGATE_MAX = 3;

    static constexpr int GAME_EXIT = 0;
    static constexpr int GAME_PLAY = 1;

    static constexpr int POLY_FLAG_VERTS_OFFSET = 2;
    static constexpr int POLY_FLAG_VERTS_MASK = 15;//7;
    static constexpr int POLY_MAX_VERTS = 9;
    static constexpr int POLY_FLAG_AXIS_SHIFT = 3;
    static constexpr int POLY_FLAG_AXIS_X = 0;
    static constexpr int POLY_FLAG_AXIS_Y = 16;
    static constexpr int POLY_FLAG_AXIS_Z = 32;
    static constexpr int POLY_FLAG_AXIS_NONE = 48; // 24;
    static constexpr int POLY_FLAG_AXIS_MASK = (POLY_FLAG_AXIS_X | POLY_FLAG_AXIS_Y | POLY_FLAG_AXIS_Z);
    //static constexpr int POLY_FLAG_WALL_TEXTURE = 32; // J2ME
    static constexpr int POLY_FLAG_SWAPXY = 64;
    static constexpr int POLY_FLAG_UV_DELTAX = 128;

    static constexpr int GAME_WAR = 0;
    static constexpr int GAME_CHICKEN = 1;
    static constexpr int PLAYER_LOST = 0;
    static constexpr int PLAYER_WON = 1;
    static constexpr int PLAYER_QUIT = 2;
    static constexpr int MEDAL_LOOT = 0;
    static constexpr int MEDAL_SECRETS = 1;
    static constexpr int MEDAL_ENEMIES = 2;
    static constexpr int MEDAL_DESTROYED = 3;
    static constexpr int MEDAL_BOOKS = 4;
    static constexpr int STANDARD_MEDAL_COUNT = 5;
    static constexpr int MEDAL_STANDARD_TOT = 50;
    static constexpr int BONUS_MEDAL_RAIDER1 = 50;
    static constexpr int BONUS_MEDAL_RAIDER2 = 51;
    static constexpr int BONUS_MEDAL_RAIDER3 = 52;
    static constexpr int BONUS_MEDAL_COUNT = 53;
    static constexpr int PLAYER_MEDAL_SIZE = 2;
    static constexpr int POLITICS = 0;
    static constexpr int ROMANCE1 = 1;
    static constexpr int BEHAVIOR = 2;
    static constexpr int GENETICS = 3;
    static constexpr int BRAWNY = 4;
    static constexpr int BEER = 5;
    static constexpr int KNIFE = 6;
    static constexpr int ROMANCE2 = 7;
    static constexpr int OCCULT = 8;
    static constexpr int HUSBAND = 9;
    static constexpr int ROMANCE3 = 10;
    static constexpr int BREATHING = 11;
    static constexpr int ROMANCE4 = 12;
    static constexpr int BODY = 13;
    static constexpr int LEADERSHIP = 14;
    static constexpr int LEADERSHIP2 = 15;
    static constexpr int POULTRY = 16;
    static constexpr int ROMANCE5 = 17;
    static constexpr int ROMANCE6 = 18;
    static constexpr int ROMANCE7 = 19;
    static constexpr int ROMANCE8 = 20;
    static constexpr int FALLING = 21;
    static constexpr int DEFENSE = 22;
    static constexpr int EVADE = 23;
    static constexpr int PICKING = 24;
    static constexpr int DUCKHUNT = 25;
    static constexpr int HAPPYNESS = 26;
    static constexpr int CHI = 27;
    static constexpr int NUM_BOOKS = 28;
    static constexpr int NUM_BOOK_BYTES = 4;
    static constexpr int DEBUG_PRINT_STR = 0;
    static constexpr int DEBUG_PRINT_STATE = 1;
    static constexpr int COLOR_WHITE = -1;
    static constexpr int COLOR_BLACK = -16777216;
    static constexpr int COLOR_MAP_LINE = -9147303;
    static constexpr int COLOR_MAP_ENTRANCE = -16711936;
    static constexpr int COLOR_MAP_EXIT = -65536;
    static constexpr int COLOR_MAP_LADDER = -256;
    static constexpr int COLOR_MAP_FLOOR = -2043984;
    static constexpr int COLOR_MAP_DOOR1 = -16727809;
    static constexpr int COLOR_MAP_DOOR2 = -31744;
    static constexpr int COLOR_MAP_DOOR3 = -11915240;
    static constexpr int COLOR_MAP_SPRWALL = -7503768;
    static constexpr int COLOR_MAP_NPC = -16776961;
    static constexpr int COLOR_MAP_INTER = -8388353;
    static constexpr int COLOR_MAP_MONSTER1 = -16776961;
    static constexpr int COLOR_MAP_MONSTER2 = -32768;
    static constexpr int COLOR_MAP_DECOR = -7503768;
    static constexpr int COLOR_MAP_BOOKS = -16711702;
    static constexpr int COLOR_MAP_FOOD = -16711702;
    static constexpr int COLOR_KICKING_GREEN = -15244544;
};

#endif