#ifndef __CANVAS_H__
#define __CANVAS_H__

#include "Graphics.h"

class Image;
class Text;
class Entity;
class EntityDef;
class ScriptThread;
class Graphics;

class fmButtonContainer;
class fmScrollButton;
class fmButton;
class fmSwipeArea;

struct TTFFontData{

};

class Canvas
{
private:
    void updateDialogLines(int dialogStyle, int dialogFlags);
    void updatePrologueLines();
    void updateScrolling();
public:
	static constexpr int KNOCKBACK_HEIGHT = 10;

	static constexpr int FALLDOWNDEATHTIME = 750;
	static constexpr int DEATHFADETIME = 2000;
	static constexpr int TOTALDEATHTIME = 2750;

	static constexpr int SPD_RENDER = 0;
	static constexpr int SPD_BSP = 1;
	static constexpr int SPD_HUD = 2;
	static constexpr int SPD_WEAPON = 3;
	static constexpr int SPD_BLIT = 4;
	static constexpr int SPD_FLUSH = 5;
	static constexpr int SPD_PAUSED = 6;
	static constexpr int SPD_LOOP = 7;
	static constexpr int SPD_TOTAL = 8;
	static constexpr int SPD_DEBUG = 9;
	static constexpr int SPD_NUM_FIELDS = 10;

	static constexpr int MAX_EVENTS = 4;
	static constexpr int MAX_STATE_VARS = 9;

	static constexpr int HELPMSG_TYPE_NONE = 0;
	static constexpr int HELPMSG_TYPE_ITEM = 1;
	static constexpr int HELPMSG_TYPE_CODESTRING = 2;
	static constexpr int HELPMSG_TYPE_MEDAL = 3;

	static constexpr int FADE_FLAG_NONE = 0;
	static constexpr int FADE_FLAG_FADEOUT = 1;
	static constexpr int FADE_FLAG_FADEIN = 2;

	static constexpr int KPHASE_FREE = 0;
	static constexpr int KPHASE_SETANGLE = 1;
	static constexpr int KPHASE_SETDIST = 2;
	static constexpr int KPHASE_KICKING = 3;
	static constexpr int KPHASE_SHOWGRID = 4;
	static constexpr int KPHASE_HIGHSCORE = 5;

	static constexpr int ST_MENU = 1;
	static constexpr int ST_INTRO_MOVIE = 2;
	static constexpr int ST_PLAYING = 3;
	static constexpr int ST_DRIVING = 4;
	static constexpr int ST_COMBAT = 5;
	static constexpr int ST_AUTOMAP = 6;
	static constexpr int ST_LOADING = 7;
	static constexpr int ST_DIALOG = 8;
	static constexpr int ST_INTRO = 9;
	static constexpr int ST_BENCHMARK = 10;
	static constexpr int ST_BENCHMARKDONE = 11;
	static constexpr int ST_MINI_GAME = 12;
	static constexpr int ST_DYING = 13;
	static constexpr int ST_EPILOGUE = 14;
	static constexpr int ST_CREDITS = 15;
	static constexpr int ST_SAVING = 16;
	static constexpr int ST_CAMERA = 18;
	static constexpr int ST_ERROR = 17;
	static constexpr int ST_TAF = 19;
	static constexpr int ST_MIXING = 20;
	static constexpr int ST_TRAVELMAP = 21;
	static constexpr int ST_LOGO = 22;
    static constexpr int TTF_FONTS_SIZE = 3;

	static constexpr int viewStepValues[] = { 64, 0, 64, -64, 0, -64, -64, -64, -64, 0, -64, 64, 0, 64, 64, 64 };

	static constexpr int CKPOINTS[20] = { 5, 20, 20, 20, 5,
										5, 20, 30, 20, 5,
										5, 20, 20, 20, 5,
										5, 5 , 5 , 5 , 5 };

	static constexpr uint32_t GRID_COLORS[20] = { 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333,
												0xFF333333, 0xFFD5A500, 0xFFD5A500, 0xFFD5A500, 0xFF333333,
												0xFF333333, 0xFFD5A500, 0xFFD50000, 0xFFD5A500, 0xFF333333,
												0xFF333333, 0xFFD5A500, 0xFFD5A500, 0xFFD5A500, 0xFF333333 };

	static constexpr char numCharTable[10][6] = { "0", "1", "ABC2", "DEF3", "GHI4", "JKL5", "MNO6", "PQRS7", "TUV8", "WXYZ9" };
	static constexpr int ARROW_DATA[16] = { 160, 60, 0, 2, 150, 80, 2, 1, 180, 170, 1, 0, 170, 190, 6, 2 };
	static constexpr int SELECTORPOS[18] = { -13, 25, -14, 70, -10, 98, -20, 10, -10, 43, 4/*-4?*/, 81, -18, 90, -13, 55, -12, 18 };
	static constexpr int MAG_DATA[15] = { 47, 26, 0, 56, 29, 110, 70, 4, 184, 73, 35, 60, 6, 44, 160 };

	static constexpr int NPC_DLG_COLOR = 0xFF002864;
	static constexpr int MONSTER_DLG_COLOR = 0xFF800000;
	static constexpr int PLAYER_DLG_COLOR = 0xFF4F5617;
	static constexpr int CHEST_DLG_COLOR = 0xFF005A00;
	static constexpr int CHEST_OFFER_DLG_COLOR = 0xFFB18A01;
	static constexpr int MEDAL_DLG_COLOR = 0xFF000066;

	static constexpr int REPAINT_CLEAR = 1;
	static constexpr int REPAINT_SOFTKEYS = 2;
	static constexpr int REPAINT_MENU = 4;
	static constexpr int REPAINT_STARTUP_LOGO = 8;
	static constexpr int REPAINT_HUD = 16;
	static constexpr int REPAINT_PARTICLES = 32;
	static constexpr int REPAINT_VIEW3D = 64;
	static constexpr int REPAINT_LOADING_BAR = 128;

	static constexpr int BIT_AM_WALL = 1;
	static constexpr int BIT_AM_SECRET = 2;
	static constexpr int BIT_AM_SECRET_DOOR = 4;
	static constexpr int BIT_AM_ENTRANCE = 8;
	static constexpr int BIT_AM_EXIT = 16;
	static constexpr int BIT_AM_LADDER = 32;
	static constexpr int BIT_AM_EVENTS = 64;
	static constexpr int BIT_AM_VISITED = 128;

	static bool isLoaded;

	int8_t* OSC_CYCLE;
	int sysSoundDelayTime;
	int sysSoundTime;
	int8_t* keys_numeric;
	int blockInputTime;
	bool changeMapStarted;
	int storyPage;
	int storyTotalPages;
	int fontRenderMode;
	Image* imgFonts[4];
    TTFFontItem* ttfFonts [TTF_FONTS_SIZE];
    TTFFontItem* ttfFont;
	Image* imgFont;
	Image* imgMapCursor;
	Image* imgChatHook_NPC;
	Image* imgChatHook_Player;
	Image* imgChatHook_Monster;
	Image* imgIcons_Buffs;
	Image* imgIcons_Buffs_Help;
	Image* imgFabricBG;
	Image* imgDialogScroll;
	Image* imgNotebookBg;
	Image* imgClipboardBG;
	Image* imgStartupLogo;
	Image* imgTravelBG;
	Image* imgProlog;
	Image* imgProlog_0_1;
	Image* imgProlog_1_0;
	Image* imgProlog_1_1;
	Image* imgProlog_2_0;
	Image* imgProlog_2_1;
	Image* imgMagGlass;
	Image* imgMagBG;
	Image* imgTMLevels;
	Image* imgTMArrow;
	Image* imgTMHighlight;
	Image* imgMixingBG;
	Image* imgMixingHeadingPlate;
	Image* imgMixingTTRedNormal;
	Image* imgMixingTTRedSelected;
	Image* imgMixingTTRedEmpty;
	Image* imgMixingTTGreenNormal;
	Image* imgMixingTTGreenSelected;
	Image* imgMixingTTGreenEmpty;
	Image* imgMixingTTBludeNormal;
	Image* imgMixingTTBludeSelected;
	Image* imgMixingTTBludeEmpty;
	Image* imgMixingSyringe;
	Image* imgMixingSyringeSelected;
	Image* imgMixingSyringeRed;
	Image* imgMixingSyringeGreen;
	Image* imgMixingSyringeBlue;
	Image* imgMixingNumbersPlate;
	Image* imgMixingSyringeNumbersPlate;
	bool m_controlButtonIsTouched;
	fmButton* m_controlButton;
	int m_controlButtonTime;
	bool abortMove;
	int SCR_CX;
	int SCR_CY;
	int saveX;
	int saveY;
	int saveZ; // Doom 2 rpg
	int saveAngle;
	int savePitch; // Doom 2 rpg
	short saveCeilingHeight;
	int viewX;
	int viewY;
	int viewZ;
	int viewAngle;
	int viewPitch;
	int viewRoll;
	int destX;
	int destY;
	int destZ;
	int destAngle;
	int destPitch;
	int destRoll;
	int zStep;
	int pitchStep;
	int prevX;
	int prevY;
	int viewSin;
	int viewCos;
	int viewStepX;
	int viewStepY;
	int viewRightStepX;
	int viewRightStepY;
	int knockbackX;
	int knockbackY;
	int knockbackDist;
	int knockbackStart;
	int knockbackWorldDist;
	int animFrames;
	int animPos;
	int animAngle;
	bool automapDrawn;
	int automapTime;
	int specialLootIcon;
	bool showSpeeds;
	bool showLocation;
	bool tellAFriend;
	bool combatDone;
	int scrollWithBarMaxChars;
	int scrollMaxChars;
	int dialogMaxChars;
	int dialogWithBarMaxChars;
	int menuHelpMaxChars;
	int subtitleMaxChars;
	int menuScrollWithBarMaxChars;
	int ingameScrollWithBarMaxChars;
	int state;
	int oldState;
	bool stateChanged;
	int ambientSoundsTime;
	int loadMapID;
	short loadMapStringID;
	int lastMapID;
	int startupMap;
	int loadType;
	int saveType;
	bool renderOnly;
	bool skipIntro;
	bool vibrateEnabled;
	int vibrateTime;
	bool recentBriefSave;
	int shakeTime;
	int shakeIntensity;
	int shakeX;
	int shakeY;
	short dialogIndexes[1024];
	Text* dialogBuffer;
	EntityDef* dialogItem;
	int dialogViewLines;
	int dialogLineStartTime;
	int dialogStartTime;
	int dialogTypeLineIdx;
	int dialogStyle;
	int dialogType;
	int dialogFlags;
	bool dialogResumeScriptAfterClosed;
	bool dialogResumeMenu;
	bool dialogClosing;
	ScriptThread* dialogThread;
	int numDialogLines;
	int currentDialogLine;
	bool showingLoot;
	ScriptThread* gotoThread;
	int beforeRender;
	int afterRender;
	int flushTime;
	int loopStart;
	int loopEnd;
	int pauseTime;
	int lastPacifierUpdate;
	int lastRenderTime;
	int lastFrameTime;
	int lastHudTime;
	int lastTotalTime;
	int debugTime;
	int deathTime;
	int scrollingTextStart;
	int scrollingTextEnd;
	int scrollingTextMSLine;
	int scrollingTextLines;
    int numLines;
	int scrollingTextSpacing;
	bool scrollingTextDone;
	int scrollingTextFontHeight;
	int scrollingTextSpacingHeight;
	int st_fields[Canvas::SPD_NUM_FIELDS];
	bool st_enabled;
	int st_count;
	bool field_0xacc_;
	bool field_0xacd_;
	int events[Canvas::MAX_EVENTS];
	int numEvents;
	int stateVars[Canvas::MAX_STATE_VARS];
	int pacifierX;
	int automapBlinkTime;
	bool automapBlinkState;
	bool endingGame;
	bool running;
	bool displaySoftKeys;
	int readyWeaponSound;
	int displayRect[4];
	int screenRect[4];
	int viewRect[4];
	int hudRect[4];
	int menuRect[4];
	int cinRect[4];
	int softKeyY;
	int softKeyLeftID;
	int softKeyRightID;
	int helpMessageTypes[16];
	int helpMessageInts[16];
	void* helpMessageObjs[16];
	char helpMessageThreads[16];
	int numHelpMessages;
	int renderSceneCount;
	int staleTime;
	bool staleView;
	int keyPressedTime;
	int lastKeyPressedTime;
	bool mixingMsg;
	bool msgSeen;
	int curStation;
	struct Text* cocktailName;
	struct Text* mixingInstructions;
	int8_t* cocktailRecipes;
	int16_t* cocktailNames;
	int chickenDestFwd;
	int chickenDestRight;
	bool isChickenKicking;
	int kickingPhase;
	int kickingDir;
	Image* hKickingBar;
	Image* vKickingBar;
	Image* imgChickenKicking_ScoreBG;
	Image* imgChickenKicking_05Highlight;
	Image* imgChickenKicking_20Highlight;
	Image* imgChickenKicking_30Highlight;
	int lastScore;
	int curScore;
	int gridTime;
	int gridIdx;
	int highScoreIndex;
	int kickHPos;
	int kickVPos;
	bool kickingFromMenu;
	bool pushedWall;
	int pushedTime;
	int lootSource;
	bool forceError;
	Graphics graphics;
	int repaintFlags;
	int totalFrameTime;
	int ignoreFrameInput;
	bool forcePump;
	bool updateFacingEntity;
	float blendSpecialAlpha;
	bool touched;
	int m_controlMode;
	bool m_controlFlip;
	int m_controlGraphic;
	int m_controlLayout;
	int m_controlAlpha;
	Image* imgDpad_default;
	Image* imgDpad_up_press;
	Image* imgDpad_down_press;
	Image* imgDpad_left_press;
	Image* imgDpad_right_press;
	Image* imgArrows[16];
	Image* imgPageUP_Icon;
	Image* imgPageDOWN_Icon;
	Image* imgPageOK_Icon;
	Image* imgSniperScope_Dial;
	fmButtonContainer* m_controlButtons[6];
	fmButtonContainer* m_sniperScopeButtons;
	fmScrollButton* m_sniperScopeDialScrollButton;
	fmButtonContainer* m_dialogButtons;
	fmButtonContainer* m_softKeyButtons;
	fmButtonContainer* m_mixingButtons;
	fmButtonContainer* m_storyButtons;
	fmSwipeArea* m_swipeArea[2];
	bool mediaLoading;
	bool areSoundsAllowed;
	bool inInitMap;
	int pacLogoTime;
	char pacLogoIndex;
	int dialogRect[4];
	int CAMERAVIEW_BAR_HEIGHT;
	int loadingFlags;
	short loadingStringID;
	short loadingStringType;
	bool isZoomedIn;
	int zoomFOV;
	int zoomDestFOV;
	int zoomMinFOVPercent;
	int zoomCurFOVPercent;
	int zoomTime;
	int zoomAngle;
	int zoomPitch;
	int zoomStateTime;
	int zoomAccuracy;
	int zoomMaxAngle;
	int zoomCollisionX;
	int zoomCollisionY;
	int zoomCollisionZ;
	int zoomTurn;
	int16_t highScores[5];
	char highScoreInitials[15];
	struct Image* imgFlak;
	struct Image* imgFire;
	int32_t* movieEffects;
	int* fadeRect;
	int fadeFlags;
	int fadeTime;
	int fadeDuration;
	int fadeColor;
	
	//[GEC]
	bool keyDown;
	bool keyDownCausedMove;
	// Constructor
	Canvas();
	// Destructor
	~Canvas();

	bool startup();
	void flushGraphics();
	void backPaint(Graphics* graphics);
	void run();
	void clearEvents(int ignoreFrameInput);
	void loadRuntimeData();
	void freeRuntimeData();
	void startShake(int i, int i2, int i3);
	void setState(int state);
	void setAnimFrames(int animFrames);
	void checkFacingEntity();
	void finishMovement();
	int flagForWeapon(int i);
	int flagForFacingDir(int i);
	void startRotation(bool b);
	void finishRotation(bool b);
	int getKeyAction(int state);
	void attemptMove(int n, int n2);
	void keyPressed(int event);
	void loadState(int loadType, short n, short n2);
	void saveState(int saveType, short n, short n2);
	void loadMap(int loadMapID, bool b, bool tm_NewGame);
	void loadPrologueText();
	void loadEpilogueText();
	void disposeIntro();
	void disposeEpilogue();
	void drawScroll(Graphics* graphics, int n, int n2, int n3, int n4, int n5);
	void initScrollingText(short i, short i2, bool dehyphenate, int spacingHeight, int numLines, int textMSLine);
	void drawCredits(Graphics* graphics);
	void drawScrollingText(Graphics* graphics);
	void handleDialogEvents(int key);
	bool handlePlayingEvents(int key, int action);
	bool shouldFakeCombat(int n, int n2, int n3);
	bool endOfHandlePlayingEvent(int action, bool b);
	bool handleEvent(int state);
	void runInputEvents();
	bool loadMedia();
	void combatState();
	void dialogState(Graphics* graphics);
	void automapState();
	void renderOnlyState();
	void playingState();
	void menuState();
	void dyingState();
	void logoState();
	void drawScrollBar(Graphics* graphics, int i, int i2, int i3, int i4, int i5, int i6, int i7);
	void uncoverAutomap();
	void drawAutomap(Graphics* graphics, bool b);
	void closeDialog(bool skipDialog);
	void prepareDialog(Text* text, int dialogStyle, int dialogFlags);
	void startDialog(ScriptThread* scriptThread, short n, int dialogStyle, int dialogFlags);
	void startDialog(ScriptThread* scriptThread, short n, short n2, int dialogStyle, int dialogFlags, bool b);
	void startDialog(ScriptThread* scriptThread, Text* text, int dialogStyle, int dialogFlags);
	void startDialog(ScriptThread* dialogThread, Text* text, int dialogStyle, int dialogFlags, bool dialogResumeScriptAfterClosed);
	void renderScene(int viewX, int viewY, int viewZ, int viewAngle, int viewPitch, int viewRoll, int viewFov);
	void startSpeedTest(bool b);
	void backToMain(bool b);
	void drawPlayingSoftKeys();
	void changeStoryPage(int i);
	void drawStory(Graphics* graphics);
	void dequeueHelpDialog();
	void dequeueHelpDialog(bool b);
	void enqueueHelpDialog(short n);
	bool enqueueHelpDialog(short n, short n2, uint8_t b);
	bool enqueueHelpDialog(Text* text);
	bool enqueueHelpDialog(Text* text, int n);
	void enqueueHelpDialog(EntityDef* entityDef);
	void updateView();
	void clearSoftKeys();
	void clearLeftSoftKey();
	void clearRightSoftKey();
	void setLeftSoftKey(short i, short i2);
	void setRightSoftKey(short i, short i2);
	void setSoftKeys(short n, short n2, short n3, short n4);
	void drawSoftKeys(Graphics* graphics);
	void setLoadingBarText(short loadingStringType, short loadingStringID);
	void updateLoadingBar(bool b);
	void drawLoadingBar(Graphics* graphics);
	void unloadMedia();
	void invalidateRect();
	int getRecentLoadType();
	void initZoom();
	void zoomOut();
	bool handleZoomEvents(int key, int action);
	bool handleZoomEvents(int key, int action, bool b);
	void mixingState(Graphics* graphics);
	void handleMixingEvents(int action);
	void nextMixingIngredient(int n);
	void pushIngredient(int n);
	void popIngredient();
	void updateMixingText();
	void mixCocktail();
	void recipeToString(int n, Text* text);
	void drawMixingNumbers2(Graphics* graphics, float x, int y, int num);
	void drawMixingNumbers3(Graphics* graphics, float x, int y, int num);
	void handleStoryInput(int key, int action);
	void drawKickingBars(Graphics* graphics);
	void startKicking(bool kickingFromMenu);
	void endKickingRound();
	void endKickingGame();
	int getKickPoint(int n, int n2);
	void drawHighScore(Graphics* graphics);
	void handleHighScoreInput(int action, int key);
	void drawKickingGrid(Graphics* graphics);
	char getNextChar(int n, int n2); // J2ME
	void drawTravelMap(Graphics* graphics);
	bool drawTMArrow(Graphics* graphics, int n, int n2);
	bool drawSelector(Graphics* graphics, int n, int n2);
	bool drawMagGlass(Graphics* graphics, int n, int n2);
	void initTravelMap();
	void disposeTravelMap();
	void handleTravelMapInput(int key, int action);
	void finishTravelMapAndLoadLevel();

	void playIntroMovie(Graphics* graphics);
	void drawMovieEffects(Graphics* graphics, int time, int x, int y);
	void exitIntroMovie(bool b);

	void setMenuDimentions(int x, int y, int w, int h);
	void setBlendSpecialAlpha(float alpha);
	void touchStart(int pressX, int pressY);
	void touchMove(int pressX, int pressY);
	void touchEnd(int pressX, int pressY);
	void touchEndUnhighlight();
	int touchToKey_Play(int pressX, int pressY);
	void drawTouchSoftkeyBar(Graphics* graphics, bool highlighted_Left, bool highlighted_Right);
	void touchSwipe(int swDir);
	void flipControls();
	void setControlLayout();
	void updateAmbientSounds();
};

#endif