#ifndef __APP_H__
#define __APP_H__

#include "IDIB.h"

class SDLGL;
class ZipFile;
class IDIB;
class Image;

class Localization;
class Resource;
class Render;
class TinyGL;
class Canvas;
class Game;
class MenuSystem;
class Player;
class Sound;
class Combat;
class Hud;
class EntityDefManager;
class ParticleSystem;
class HackingGame;
class SentryBotGame;
class VendingMachine;
class CardGames;
class DrivingGame;
class InputStream;

class Applet
{
private:

public:
	// Defines
	static constexpr int MAXMEMORY = 1000000000;
	static constexpr int IOS_WIDTH = 480;
	static constexpr int IOS_HEIGHT = 320;

	static constexpr int FONT_HEIGHT[4] = { 16, 16, 18, 25 };
	static constexpr int FONT_WIDTH[4] = { 12, 12, 13, 22 };
    static constexpr int TTF_CHAR_SPACING = 11;
	static constexpr int CHAR_SPACING[4] = { 11, 11, 12, 22 };

#ifdef __linux__
	static constexpr uint8_t gIcon_64_raw_rgb888[] = {
			0x72, 0x72, 0x72, 0x78, 0x78, 0x78, 0x7A, 0x7A, 0x7A, 0x7B, 0x7B, 0x7B,
			0x7E, 0x7E, 0x7E, 0x81, 0x81, 0x81, 0x84, 0x84, 0x84, 0x86, 0x86, 0x86,
			0x89, 0x89, 0x89, 0x8D, 0x8D, 0x8D, 0x91, 0x91, 0x91, 0x95, 0x95, 0x95,
			0x99, 0x99, 0x99, 0x9D, 0x9D, 0x9D, 0xA1, 0xA1, 0xA1, 0xA5, 0xA5, 0xA5,
			0xAA, 0xAA, 0xAA, 0xAE, 0xAE, 0xAE, 0xB3, 0xB3, 0xB3, 0xB8, 0xB8, 0xB8,
			0xBD, 0xBD, 0xBD, 0xC3, 0xC3, 0xC3, 0xC7, 0xC7, 0xC7, 0xCD, 0xCD, 0xCD,
			0xD2, 0xD2, 0xD2, 0xD7, 0xD7, 0xD7, 0xDD, 0xDD, 0xDD, 0xE2, 0xE2, 0xE2,
			0xE7, 0xE7, 0xE7, 0xED, 0xED, 0xED, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF,
			0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF,
			0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF,
			0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF,
			0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF,
			0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF,
			0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF,
			0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0xEE, 0xEE, 0xEE,
			0xEB, 0xEB, 0xEB, 0xE8, 0xE8, 0xE8, 0xE6, 0xE6, 0xE6, 0xE0, 0xE0, 0xE0,
			0x6D, 0x6D, 0x6D, 0x72, 0x72, 0x72, 0x74, 0x74, 0x74, 0x77, 0x77, 0x77,
			0x7A, 0x7A, 0x7A, 0x7D, 0x7D, 0x7D, 0x81, 0x81, 0x81, 0x85, 0x85, 0x85,
			0x89, 0x89, 0x89, 0x8D, 0x8D, 0x8D, 0x91, 0x91, 0x91, 0x96, 0x96, 0x96,
			0x9A, 0x9A, 0x9A, 0x9E, 0x9E, 0x9E, 0xA3, 0xA3, 0xA3, 0xA8, 0xA8, 0xA8,
			0xAD, 0xAD, 0xAD, 0xB3, 0xB3, 0xB3, 0xB9, 0xB9, 0xB9, 0xBE, 0xBE, 0xBE,
			0xC3, 0xC3, 0xC3, 0xC9, 0xC9, 0xC9, 0xCF, 0xCF, 0xCF, 0xD4, 0xD4, 0xD4,
			0xDA, 0xDA, 0xDA, 0xE0, 0xE0, 0xE0, 0xE6, 0xE6, 0xE6, 0xED, 0xED, 0xED,
			0xF3, 0xF3, 0xF3, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6,
			0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6,
			0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6,
			0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6,
			0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6,
			0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6,
			0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6,
			0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF4, 0xF4, 0xF4, 0xF2, 0xF2, 0xF2,
			0xEE, 0xEE, 0xEE, 0xEB, 0xEB, 0xEB, 0xE8, 0xE8, 0xE8, 0xE1, 0xE1, 0xE1,
			0x6E, 0x6E, 0x6E, 0x74, 0x74, 0x74, 0x77, 0x77, 0x77, 0x7A, 0x7A, 0x7A,
			0x7D, 0x7D, 0x7D, 0x81, 0x81, 0x81, 0x85, 0x85, 0x85, 0x89, 0x89, 0x89,
			0x8D, 0x8D, 0x8D, 0x91, 0x91, 0x91, 0x95, 0x95, 0x95, 0x9A, 0x9A, 0x9A,
			0x9E, 0x9E, 0x9E, 0xA2, 0xA2, 0xA2, 0xA7, 0xA7, 0xA7, 0xAC, 0xAC, 0xAC,
			0xB1, 0xB1, 0xB1, 0xB7, 0xB7, 0xB7, 0xBD, 0xBD, 0xBD, 0xC2, 0xC2, 0xC2,
			0xC8, 0xC8, 0xC8, 0xCE, 0xCE, 0xCE, 0xD3, 0xD3, 0xD3, 0xD9, 0xD9, 0xD9,
			0xDF, 0xDF, 0xDF, 0xE5, 0xE5, 0xE5, 0xEB, 0xEB, 0xEB, 0xF2, 0xF2, 0xF2,
			0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5,
			0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5,
			0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5,
			0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5,
			0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5,
			0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5,
			0xF5, 0xF5, 0xF5, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF7, 0xF7, 0xF7,
			0xF7, 0xF7, 0xF7, 0xF5, 0xF5, 0xF5, 0xF2, 0xF2, 0xF2, 0xEF, 0xEF, 0xEF,
			0xEC, 0xEC, 0xEC, 0xE9, 0xE9, 0xE9, 0xE6, 0xE6, 0xE6, 0xDF, 0xDF, 0xDF,
			0x70, 0x70, 0x70, 0x77, 0x77, 0x77, 0x7A, 0x7A, 0x7A, 0x7D, 0x7D, 0x7D,
			0x81, 0x81, 0x81, 0x85, 0x85, 0x85, 0x89, 0x89, 0x89, 0x8C, 0x8C, 0x8C,
			0x90, 0x90, 0x90, 0x92, 0x92, 0x92, 0x90, 0x90, 0x90, 0x84, 0x83, 0x83,
			0x7F, 0x7E, 0x7E, 0x7C, 0x7B, 0x7B, 0x82, 0x81, 0x81, 0x8A, 0x89, 0x89,
			0x8C, 0x8B, 0x8B, 0x94, 0x92, 0x92, 0x98, 0x97, 0x97, 0x9E, 0x9D, 0x9C,
			0x9B, 0x9A, 0x9A, 0x9F, 0x9F, 0x9E, 0xAB, 0xAA, 0xA9, 0xB1, 0xB0, 0xB0,
			0xB8, 0xB8, 0xB7, 0xBD, 0xBC, 0xBC, 0xC1, 0xBF, 0xBF, 0xB9, 0xB7, 0xB7,
			0xB8, 0xB7, 0xB7, 0xC0, 0xBF, 0xBE, 0xC5, 0xC4, 0xC4, 0xC4, 0xC3, 0xC3,
			0xC0, 0xBF, 0xBE, 0xC9, 0xC9, 0xC9, 0xC8, 0xC8, 0xC8, 0xC9, 0xC9, 0xC9,
			0xC8, 0xC8, 0xC8, 0xC8, 0xC8, 0xC8, 0xC6, 0xC6, 0xC6, 0xC7, 0xC7, 0xC7,
			0xC7, 0xC7, 0xC7, 0xC7, 0xC7, 0xC7, 0xC4, 0xC4, 0xC4, 0xC4, 0xC4, 0xC4,
			0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6,
			0xC5, 0xC5, 0xC5, 0xC6, 0xC6, 0xC6, 0xC3, 0xC3, 0xC3, 0xC1, 0xC1, 0xC1,
			0xCF, 0xCF, 0xCF, 0xE6, 0xE6, 0xE6, 0xF1, 0xF1, 0xF1, 0xF4, 0xF4, 0xF4,
			0xF5, 0xF5, 0xF5, 0xF3, 0xF3, 0xF3, 0xEF, 0xEF, 0xEF, 0xEC, 0xEC, 0xEC,
			0xE9, 0xE9, 0xE9, 0xE6, 0xE6, 0xE6, 0xE3, 0xE3, 0xE3, 0xDC, 0xDC, 0xDC,
			0x72, 0x72, 0x72, 0x7A, 0x7A, 0x7A, 0x7D, 0x7D, 0x7D, 0x81, 0x81, 0x81,
			0x84, 0x84, 0x84, 0x88, 0x88, 0x88, 0x8C, 0x8C, 0x8C, 0x8D, 0x8D, 0x8D,
			0x73, 0x72, 0x73, 0x4A, 0x48, 0x48, 0x37, 0x33, 0x32, 0x33, 0x2F, 0x2F,
			0x38, 0x34, 0x33, 0x2E, 0x29, 0x28, 0x29, 0x25, 0x23, 0x31, 0x2D, 0x2C,
			0x3D, 0x38, 0x36, 0x3E, 0x37, 0x36, 0x40, 0x3B, 0x38, 0x44, 0x40, 0x3D,
			0x3E, 0x38, 0x38, 0x2F, 0x2B, 0x2A, 0x32, 0x2E, 0x2D, 0x32, 0x30, 0x2E,
			0x3F, 0x3A, 0x39, 0x3C, 0x38, 0x37, 0x37, 0x33, 0x32, 0x2A, 0x26, 0x25,
			0x43, 0x40, 0x3F, 0x5F, 0x5D, 0x5B, 0x42, 0x3F, 0x3E, 0x41, 0x3D, 0x3C,
			0x4F, 0x4C, 0x4B, 0x70, 0x70, 0x70, 0x6F, 0x6F, 0x6F, 0x70, 0x70, 0x70,
			0x6E, 0x6E, 0x6E, 0x6C, 0x6C, 0x6C, 0x6A, 0x6A, 0x6A, 0x6D, 0x6D, 0x6D,
			0x6D, 0x6D, 0x6C, 0x6C, 0x6C, 0x6C, 0x69, 0x69, 0x69, 0x66, 0x66, 0x66,
			0x5E, 0x5E, 0x5E, 0x63, 0x63, 0x63, 0x62, 0x62, 0x62, 0x63, 0x63, 0x63,
			0x61, 0x61, 0x61, 0x60, 0x60, 0x60, 0x5E, 0x5E, 0x5E, 0x4E, 0x4E, 0x4E,
			0x57, 0x57, 0x57, 0x55, 0x55, 0x55, 0x83, 0x83, 0x83, 0xC1, 0xC1, 0xC1,
			0xEB, 0xEB, 0xEB, 0xEE, 0xEE, 0xEE, 0xEC, 0xEC, 0xEC, 0xE9, 0xE9, 0xE9,
			0xE6, 0xE6, 0xE6, 0xE4, 0xE4, 0xE4, 0xE1, 0xE1, 0xE1, 0xDA, 0xDA, 0xDA,
			0x75, 0x75, 0x75, 0x7D, 0x7D, 0x7D, 0x80, 0x80, 0x80, 0x84, 0x84, 0x84,
			0x88, 0x88, 0x88, 0x8B, 0x8B, 0x8B, 0x86, 0x86, 0x86, 0x4C, 0x4C, 0x4C,
			0x2F, 0x2F, 0x2D, 0x31, 0x30, 0x2E, 0x36, 0x35, 0x33, 0x28, 0x26, 0x24,
			0x28, 0x24, 0x23, 0x42, 0x3D, 0x3C, 0x33, 0x2F, 0x2E, 0x3F, 0x3C, 0x3B,
			0x4D, 0x49, 0x48, 0x41, 0x3D, 0x3C, 0x38, 0x34, 0x32, 0x38, 0x33, 0x32,
			0x54, 0x50, 0x4F, 0x57, 0x53, 0x52, 0x42, 0x3D, 0x3D, 0x52, 0x4F, 0x4E,
			0x6A, 0x68, 0x68, 0x8B, 0x8A, 0x89, 0x52, 0x4E, 0x4D, 0x69, 0x67, 0x67,
			0x7C, 0x7C, 0x7B, 0x79, 0x79, 0x78, 0x6C, 0x6B, 0x6A, 0x3E, 0x3C, 0x3B,
			0x32, 0x30, 0x2E, 0x78, 0x78, 0x78, 0x79, 0x79, 0x79, 0x76, 0x76, 0x76,
			0x75, 0x75, 0x75, 0x7A, 0x7A, 0x7A, 0x78, 0x78, 0x78, 0x76, 0x76, 0x76,
			0x76, 0x76, 0x76, 0x7A, 0x7A, 0x7A, 0x72, 0x72, 0x72, 0x6A, 0x6A, 0x6A,
			0x9A, 0x9A, 0x9A, 0x66, 0x66, 0x66, 0x67, 0x67, 0x67, 0x70, 0x70, 0x70,
			0x6D, 0x6D, 0x6D, 0x67, 0x67, 0x67, 0x60, 0x60, 0x60, 0x91, 0x91, 0x91,
			0x5C, 0x5C, 0x5C, 0x5D, 0x5D, 0x5D, 0x64, 0x64, 0x64, 0x5D, 0x5D, 0x5D,
			0x82, 0x82, 0x82, 0xDB, 0xDB, 0xDB, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7,
			0xE4, 0xE4, 0xE4, 0xE1, 0xE1, 0xE1, 0xDE, 0xDE, 0xDE, 0xD7, 0xD7, 0xD7,
			0x78, 0x78, 0x78, 0x80, 0x80, 0x80, 0x84, 0x84, 0x84, 0x88, 0x88, 0x88,
			0x8B, 0x8B, 0x8B, 0x87, 0x87, 0x87, 0x3B, 0x3B, 0x3B, 0x31, 0x31, 0x31,
			0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3D, 0x3D, 0x3D, 0x43, 0x42, 0x41,
			0x3A, 0x38, 0x36, 0x51, 0x4D, 0x4C, 0x3B, 0x36, 0x36, 0x26, 0x22, 0x22,
			0x4A, 0x46, 0x45, 0x54, 0x4F, 0x4E, 0x4C, 0x47, 0x46, 0x5A, 0x56, 0x55,
			0x5F, 0x5B, 0x5A, 0x56, 0x52, 0x51, 0x46, 0x42, 0x41, 0x60, 0x5E, 0x5D,
			0xD4, 0xAE, 0xA8, 0xA2, 0xA2, 0xA1, 0x9A, 0x93, 0x90, 0xE9, 0x95, 0x8E,
			0xDB, 0x75, 0x72, 0xD1, 0xC8, 0xC6, 0x70, 0x6E, 0x6E, 0x4A, 0x49, 0x47,
			0x4A, 0x4A, 0x49, 0x76, 0x76, 0x76, 0x7C, 0x7C, 0x7C, 0x81, 0x81, 0x81,
			0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x82, 0x82, 0x82, 0x7C, 0x7C, 0x7C,
			0x7A, 0x7A, 0x7A, 0x7A, 0x7A, 0x7A, 0x6E, 0x6E, 0x6E, 0xB6, 0xA3, 0xA1,
			0xC3, 0xB4, 0xB3, 0x70, 0x70, 0x70, 0x72, 0x72, 0x72, 0x6F, 0x6F, 0x6F,
			0x6F, 0x6F, 0x6F, 0x69, 0x69, 0x69, 0xC2, 0xAD, 0xAB, 0xBC, 0xB9, 0xB8,
			0x4A, 0x4A, 0x4A, 0x5D, 0x5D, 0x5D, 0x68, 0x68, 0x68, 0x5E, 0x5E, 0x5E,
			0x58, 0x58, 0x58, 0x6C, 0x6C, 0x6C, 0xD6, 0xD6, 0xD6, 0xE3, 0xE3, 0xE3,
			0xE1, 0xE1, 0xE1, 0xDE, 0xDE, 0xDE, 0xDB, 0xDB, 0xDB, 0xD5, 0xD5, 0xD5,
			0x7A, 0x7A, 0x7A, 0x83, 0x83, 0x83, 0x88, 0x88, 0x88, 0x8C, 0x8C, 0x8C,
			0x8E, 0x8E, 0x8E, 0x4D, 0x4D, 0x4D, 0x2B, 0x2B, 0x2B, 0x31, 0x30, 0x31,
			0x32, 0x32, 0x32, 0x34, 0x35, 0x35, 0x38, 0x38, 0x38, 0x40, 0x40, 0x3F,
			0x3C, 0x3B, 0x39, 0x4A, 0x47, 0x46, 0x46, 0x42, 0x41, 0x41, 0x40, 0x3F,
			0x43, 0x40, 0x40, 0x51, 0x4D, 0x4C, 0x51, 0x4D, 0x4C, 0x4A, 0x47, 0x45,
			0x54, 0x51, 0x51, 0x3C, 0x39, 0x38, 0x60, 0x5D, 0x5C, 0xE1, 0xA4, 0x9F,
			0xC1, 0x32, 0x34, 0xD1, 0xCB, 0xCA, 0xE3, 0x5A, 0x5B, 0xCB, 0x6A, 0x6B,
			0xBF, 0xA7, 0xA7, 0x7C, 0x7A, 0x7B, 0x4A, 0x49, 0x48, 0x5B, 0x5A, 0x59,
			0x70, 0x70, 0x70, 0x78, 0x78, 0x78, 0x7D, 0x7D, 0x7D, 0x85, 0x85, 0x85,
			0x84, 0x84, 0x84, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x7D, 0x7D, 0x7D,
			0x81, 0x81, 0x81, 0x76, 0x76, 0x76, 0xB6, 0x98, 0x98, 0xE2, 0x49, 0x4C,
			0xB5, 0xA0, 0xA0, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x77, 0x77, 0x77,
			0x68, 0x68, 0x68, 0xC2, 0xB9, 0xB7, 0xDD, 0x39, 0x3F, 0xB1, 0xAC, 0xAB,
			0x5D, 0x5D, 0x5D, 0x67, 0x67, 0x67, 0x69, 0x69, 0x69, 0x64, 0x64, 0x64,
			0x67, 0x67, 0x67, 0x64, 0x64, 0x64, 0x82, 0x82, 0x82, 0xDB, 0xDB, 0xDB,
			0xDE, 0xDE, 0xDE, 0xDC, 0xDC, 0xDC, 0xD9, 0xD9, 0xD9, 0xD2, 0xD2, 0xD2,
			0x7E, 0x7E, 0x7E, 0x87, 0x87, 0x87, 0x8C, 0x8C, 0x8C, 0x8F, 0x8F, 0x8F,
			0x75, 0x75, 0x75, 0x2D, 0x2D, 0x2D, 0x66, 0x66, 0x66, 0xC9, 0xC5, 0xC3,
			0xC7, 0x95, 0x92, 0xC6, 0x93, 0x8E, 0xC4, 0x86, 0x85, 0xC5, 0x8C, 0x87,
			0xC7, 0xB1, 0xAF, 0x53, 0x53, 0x52, 0x9A, 0x91, 0x8F, 0xE3, 0xD3, 0xD1,
			0xD0, 0x95, 0x94, 0xD2, 0x98, 0x95, 0xD0, 0x8E, 0x8B, 0xCF, 0x86, 0x83,
			0xCC, 0xB5, 0xB3, 0x7C, 0x7B, 0x7B, 0x84, 0x83, 0x83, 0xD8, 0x3F, 0x3C,
			0xC1, 0x31, 0x33, 0xF6, 0xDA, 0xD4, 0xD1, 0x0F, 0x19, 0xCE, 0x96, 0x99,
			0x63, 0x63, 0x63, 0x75, 0x75, 0x75, 0x66, 0x66, 0x66, 0x75, 0x75, 0x75,
			0x7A, 0x7A, 0x7A, 0x75, 0x75, 0x75, 0x79, 0x79, 0x7A, 0x7D, 0x7E, 0x7D,
			0x7F, 0x7F, 0x7F, 0x81, 0x81, 0x81, 0x7A, 0x7A, 0x7A, 0x76, 0x76, 0x76,
			0x7A, 0x7A, 0x7A, 0x6A, 0x6A, 0x6A, 0xDF, 0x86, 0x86, 0xD2, 0x0D, 0x16,
			0xB4, 0xA0, 0x9F, 0x6D, 0x6D, 0x6D, 0x6C, 0x6C, 0x6C, 0x6D, 0x6D, 0x6D,
			0x68, 0x68, 0x68, 0xEA, 0x9B, 0x98, 0xC6, 0x5C, 0x60, 0xC3, 0xC3, 0xC3,
			0x65, 0x64, 0x65, 0x62, 0x63, 0x63, 0x61, 0x61, 0x61, 0x63, 0x63, 0x63,
			0x64, 0x64, 0x64, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0xB2, 0xB2, 0xB2,
			0xDA, 0xDA, 0xDA, 0xD9, 0xD9, 0xD9, 0xD7, 0xD7, 0xD7, 0xD0, 0xD0, 0xD0,
			0x82, 0x82, 0x82, 0x8B, 0x8B, 0x8B, 0x8F, 0x8F, 0x8F, 0x93, 0x93, 0x93,
			0x41, 0x41, 0x41, 0x2A, 0x2A, 0x2A, 0x37, 0x37, 0x37, 0x67, 0x67, 0x67,
			0xD8, 0xA5, 0xA4, 0xC8, 0x3F, 0x3F, 0xCB, 0x34, 0x33, 0xCD, 0x19, 0x17,
			0xCC, 0x80, 0x7F, 0xB1, 0xA3, 0x9F, 0xD3, 0x4B, 0x48, 0xE7, 0xC5, 0xC1,
			0xD4, 0x09, 0x17, 0xD2, 0x20, 0x2E, 0xD2, 0x3C, 0x45, 0xCA, 0x5F, 0x63,
			0xE8, 0xD8, 0xD6, 0xBE, 0x91, 0x8C, 0xCF, 0xBD, 0xBA, 0xD4, 0x33, 0x2F,
			0xBF, 0x2F, 0x2F, 0xF2, 0xC5, 0xC2, 0xD1, 0x0B, 0x16, 0xD6, 0x8B, 0x8C,
			0xC4, 0xA8, 0xA6, 0xBE, 0xAF, 0xAF, 0xC3, 0xA0, 0x9E, 0xBF, 0xA1, 0xA0,
			0xA2, 0xA3, 0xA3, 0xC2, 0xA9, 0xA7, 0xC2, 0x9F, 0x9E, 0xC3, 0x9F, 0x9E,
			0xBF, 0xA8, 0xA7, 0x9C, 0x9C, 0x9C, 0xC3, 0xA0, 0x9D, 0xC1, 0x92, 0x91,
			0xC0, 0x93, 0x90, 0xBE, 0xB5, 0xB3, 0xE2, 0x7B, 0x78, 0xCF, 0x14, 0x16,
			0xCF, 0x92, 0x90, 0xBE, 0x96, 0x94, 0xC2, 0xC1, 0xC0, 0xC3, 0xA5, 0x9E,
			0xBE, 0x9C, 0x98, 0xE5, 0xCC, 0xCB, 0xEB, 0xAE, 0xAB, 0xB7, 0xB1, 0xB0,
			0xAE, 0xA7, 0xA5, 0xC2, 0xA9, 0xA8, 0xC1, 0x9D, 0x9C, 0xC0, 0x9A, 0x9A,
			0x9F, 0x9D, 0x9E, 0x84, 0x84, 0x84, 0x95, 0x95, 0x95, 0x7D, 0x7D, 0x7D,
			0xD4, 0xD4, 0xD4, 0xD7, 0xD7, 0xD7, 0xD4, 0xD4, 0xD4, 0xCD, 0xCD, 0xCD,
			0x85, 0x85, 0x85, 0x8F, 0x8F, 0x8F, 0x93, 0x93, 0x93, 0x95, 0x95, 0x95,
			0x25, 0x25, 0x25, 0x2E, 0x2E, 0x2E, 0x42, 0x42, 0x42, 0x4D, 0x4D, 0x4D,
			0x56, 0x56, 0x56, 0x7F, 0x7F, 0x7F, 0xD0, 0xA9, 0xA6, 0xCB, 0x13, 0x13,
			0xCB, 0x7E, 0x7E, 0xE1, 0x6A, 0x67, 0xC5, 0x1A, 0x1A, 0xE6, 0xC4, 0xBF,
			0xCD, 0x0C, 0x14, 0xCF, 0x76, 0x7B, 0x9B, 0x9A, 0x9A, 0xEC, 0xB5, 0xB4,
			0xDB, 0x7A, 0x78, 0xCC, 0x10, 0x14, 0xCE, 0x83, 0x84, 0xD6, 0x35, 0x32,
			0xBF, 0x32, 0x30, 0xDB, 0x61, 0x5F, 0xCD, 0x13, 0x14, 0xCC, 0x1F, 0x26,
			0xC7, 0x58, 0x5C, 0xE1, 0x8F, 0x8B, 0xD6, 0x23, 0x2C, 0xC5, 0x1E, 0x28,
			0xEE, 0xB8, 0xB2, 0xD4, 0x13, 0x1D, 0xD2, 0x24, 0x2D, 0xD8, 0x09, 0x19,
			0xC9, 0x48, 0x50, 0xF0, 0xBD, 0xB8, 0xD7, 0x17, 0x21, 0xCE, 0x23, 0x2E,
			0xC4, 0x54, 0x5A, 0xDF, 0x94, 0x90, 0xCE, 0x24, 0x24, 0xCD, 0x18, 0x16,
			0xC9, 0x2B, 0x2B, 0xC8, 0x89, 0x89, 0xE7, 0x86, 0x80, 0xD0, 0x34, 0x32,
			0xBE, 0x2E, 0x2E, 0xF6, 0xDC, 0xD7, 0xD0, 0x25, 0x24, 0xDF, 0xD0, 0xCE,
			0xDD, 0x48, 0x48, 0xD1, 0x20, 0x2B, 0xD5, 0x14, 0x20, 0xD1, 0x0A, 0x17,
			0xAA, 0xA5, 0xA4, 0x64, 0x64, 0x64, 0x6A, 0x6A, 0x6A, 0x5E, 0x5E, 0x5E,
			0xC9, 0xC9, 0xC9, 0xD4, 0xD4, 0xD4, 0xD1, 0xD1, 0xD1, 0xCB, 0xCB, 0xCB,
			0x89, 0x89, 0x89, 0x93, 0x93, 0x93, 0x97, 0x97, 0x97, 0x8B, 0x8B, 0x8B,
			0x1A, 0x1A, 0x1A, 0x2E, 0x2E, 0x2E, 0x3E, 0x3E, 0x3E, 0x44, 0x44, 0x44,
			0x2D, 0x2D, 0x2D, 0x41, 0x41, 0x41, 0xC2, 0xB1, 0xAE, 0xCB, 0x16, 0x15,
			0xCB, 0x80, 0x80, 0xDC, 0x59, 0x56, 0xC4, 0x1A, 0x1A, 0xE6, 0xC0, 0xBA,
			0xCB, 0x11, 0x12, 0xCD, 0x79, 0x7A, 0xE1, 0xB8, 0xB5, 0xCD, 0x2F, 0x35,
			0xE8, 0xAB, 0xAB, 0xCC, 0x10, 0x14, 0xCF, 0x84, 0x84, 0xD4, 0x2B, 0x2B,
			0xC0, 0x30, 0x2F, 0xF4, 0xC8, 0xC5, 0xCE, 0x12, 0x17, 0xD6, 0xA2, 0xA3,
			0xEE, 0x93, 0x8F, 0xD1, 0x44, 0x49, 0xE2, 0x5F, 0x5E, 0xCB, 0x9D, 0xA0,
			0xE9, 0x84, 0x85, 0xCF, 0x01, 0x11, 0xDF, 0xD3, 0xD2, 0xD5, 0x09, 0x16,
			0xC7, 0x46, 0x4F, 0xE8, 0x71, 0x70, 0xD9, 0x0D, 0x1B, 0xDE, 0x88, 0x8C,
			0xB9, 0xB9, 0xB9, 0x9B, 0x9C, 0x9C, 0xE4, 0x97, 0x95, 0xCD, 0x16, 0x14,
			0xD9, 0xC5, 0xC4, 0xED, 0x8A, 0x86, 0xCA, 0x4F, 0x4D, 0xDC, 0x67, 0x61,
			0xC4, 0x9F, 0x9E, 0xEC, 0xAC, 0xAA, 0xC8, 0x0F, 0x10, 0xDC, 0xAB, 0xA9,
			0xCC, 0x0F, 0x14, 0xD0, 0x84, 0x86, 0xE4, 0x6A, 0x6B, 0xD0, 0x0B, 0x18,
			0xA6, 0xA1, 0xA1, 0x67, 0x67, 0x67, 0x6A, 0x6A, 0x6A, 0x57, 0x57, 0x57,
			0xB2, 0xB2, 0xB2, 0xD1, 0xD1, 0xD1, 0xCF, 0xCF, 0xCF, 0xC9, 0xC9, 0xC9,
			0x8D, 0x8D, 0x8D, 0x98, 0x98, 0x98, 0x9C, 0x9C, 0x9C, 0x87, 0x87, 0x87,
			0x2E, 0x2E, 0x2E, 0x2C, 0x2C, 0x2C, 0x30, 0x30, 0x30, 0x3E, 0x3E, 0x3E,
			0x2F, 0x2F, 0x2F, 0x2A, 0x2A, 0x2A, 0xC1, 0xAF, 0xAA, 0xCC, 0x18, 0x17,
			0xCB, 0x80, 0x7F, 0xDD, 0x5F, 0x5E, 0xC4, 0x1A, 0x1A, 0xE7, 0xCB, 0xC6,
			0xCC, 0x13, 0x14, 0xCE, 0x7A, 0x7B, 0xDB, 0x4B, 0x47, 0xC4, 0x1F, 0x24,
			0xEB, 0xBF, 0xBE, 0xCB, 0x11, 0x13, 0xCF, 0x85, 0x85, 0xD7, 0x3C, 0x37,
			0xC0, 0x31, 0x30, 0xF6, 0xCE, 0xCA, 0xCE, 0x15, 0x17, 0xD6, 0x9D, 0x9B,
			0xD5, 0x26, 0x29, 0xCF, 0x12, 0x1C, 0xC5, 0x97, 0x99, 0x80, 0x7F, 0x7F,
			0xE9, 0x85, 0x86, 0xD2, 0x02, 0x14, 0xE1, 0xD3, 0xD2, 0xD0, 0x0E, 0x18,
			0xC6, 0x47, 0x4D, 0xEE, 0xBC, 0xBB, 0xD9, 0x18, 0x23, 0xD8, 0x08, 0x19,
			0xD6, 0x80, 0x85, 0x80, 0x7F, 0x7F, 0xDD, 0x84, 0x84, 0xCC, 0x14, 0x12,
			0xD9, 0xB7, 0xB4, 0xD0, 0x15, 0x17, 0xC8, 0x1B, 0x1B, 0xC0, 0x9A, 0x9A,
			0x70, 0x70, 0x70, 0xE9, 0x9E, 0x9D, 0xCA, 0x11, 0x11, 0xDC, 0xAF, 0xAC,
			0xCC, 0x14, 0x14, 0xCF, 0x84, 0x86, 0xDF, 0x61, 0x62, 0xCE, 0x0A, 0x16,
			0xA4, 0xA0, 0xA0, 0x67, 0x67, 0x67, 0x60, 0x60, 0x60, 0x53, 0x53, 0x53,
			0xAA, 0xAA, 0xAA, 0xCE, 0xCE, 0xCE, 0xCC, 0xCC, 0xCC, 0xC6, 0xC6, 0xC6,
			0x92, 0x92, 0x92, 0x9C, 0x9C, 0x9C, 0x9F, 0x9F, 0x9F, 0x8A, 0x8A, 0x8A,
			0x30, 0x30, 0x30, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x37, 0x37, 0x37,
			0x38, 0x38, 0x38, 0x34, 0x34, 0x34, 0xC0, 0xA1, 0x9E, 0xD1, 0x18, 0x1C,
			0xCE, 0x82, 0x83, 0xDF, 0x4B, 0x52, 0xC8, 0x0F, 0x1A, 0xE4, 0xB9, 0xB5,
			0xCB, 0x12, 0x12, 0xCE, 0x7D, 0x7C, 0xD7, 0x33, 0x31, 0xC2, 0x23, 0x23,
			0xEF, 0xCE, 0xCA, 0xCB, 0x11, 0x14, 0xD1, 0xA4, 0xA4, 0xDA, 0x51, 0x4C,
			0xC1, 0x33, 0x32, 0xF6, 0xD4, 0xCF, 0xCD, 0x14, 0x15, 0xD8, 0x9B, 0x99,
			0xCF, 0x13, 0x17, 0xC2, 0x4B, 0x4C, 0x8D, 0x8D, 0x8D, 0x6E, 0x6D, 0x6D,
			0xE7, 0x73, 0x78, 0xD1, 0x03, 0x14, 0xE1, 0xD6, 0xD4, 0xD1, 0x1D, 0x20,
			0xC4, 0x4B, 0x4D, 0x93, 0x93, 0x93, 0xD0, 0xAA, 0xA9, 0xD8, 0x1D, 0x28,
			0xD5, 0x04, 0x14, 0xD3, 0x85, 0x89, 0xE5, 0x8A, 0x88, 0xCC, 0x13, 0x13,
			0xD9, 0xB8, 0xB4, 0xCF, 0x19, 0x19, 0xC5, 0x57, 0x56, 0x86, 0x85, 0x85,
			0x68, 0x68, 0x68, 0xE9, 0x92, 0x92, 0xC9, 0x12, 0x12, 0xDC, 0xB5, 0xB2,
			0xCD, 0x19, 0x18, 0xCE, 0x82, 0x84, 0xDF, 0x65, 0x63, 0xCB, 0x0C, 0x14,
			0xA4, 0xA0, 0xA0, 0x67, 0x67, 0x67, 0x5D, 0x5D, 0x5D, 0x4B, 0x4B, 0x4B,
			0xA3, 0xA3, 0xA3, 0xCB, 0xCB, 0xCB, 0xCA, 0xCA, 0xCA, 0xC4, 0xC4, 0xC4,
			0x96, 0x96, 0x96, 0xA0, 0xA0, 0xA0, 0xA4, 0xA4, 0xA4, 0x8E, 0x8E, 0x8E,
			0x38, 0x38, 0x38, 0x3D, 0x3D, 0x3D, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0x40,
			0x43, 0x43, 0x43, 0x39, 0x39, 0x39, 0xBE, 0x91, 0x91, 0xD0, 0x1F, 0x1E,
			0xD0, 0x60, 0x61, 0xDC, 0x44, 0x47, 0xD1, 0x12, 0x1D, 0xE5, 0x8E, 0x8C,
			0xCE, 0x08, 0x12, 0xCE, 0x79, 0x7B, 0xD7, 0x31, 0x2F, 0xC3, 0x25, 0x24,
			0xE8, 0x9C, 0x91, 0xC2, 0x84, 0x84, 0xA8, 0xA7, 0xA7, 0xD7, 0x3B, 0x39,
			0xC0, 0x30, 0x30, 0xF6, 0xD8, 0xD2, 0xCD, 0x14, 0x14, 0xD7, 0x99, 0x97,
			0xD2, 0x2C, 0x28, 0xCB, 0x3C, 0x3E, 0xE4, 0xB6, 0xB3, 0xD3, 0x8F, 0x8F,
			0xE6, 0x74, 0x75, 0xCE, 0x06, 0x13, 0xE3, 0xD5, 0xD4, 0xD2, 0x27, 0x24,
			0xC3, 0x4C, 0x4E, 0xE4, 0xAF, 0xAD, 0xDD, 0x8D, 0x8E, 0xE5, 0x7C, 0x7C,
			0xD2, 0x0F, 0x1A, 0xC2, 0x4C, 0x50, 0xEB, 0x91, 0x8F, 0xCC, 0x14, 0x12,
			0xD9, 0xB9, 0xB5, 0xD0, 0x1F, 0x1D, 0xC9, 0x43, 0x40, 0xDE, 0x97, 0x97,
			0xD2, 0x91, 0x92, 0xE9, 0xA0, 0x9D, 0xC9, 0x12, 0x11, 0xDC, 0xB4, 0xB0,
			0xCB, 0x14, 0x13, 0xCC, 0x81, 0x81, 0xE0, 0x67, 0x64, 0xCA, 0x18, 0x17,
			0xA3, 0x9F, 0x9F, 0x68, 0x68, 0x68, 0x64, 0x64, 0x64, 0x3D, 0x3D, 0x3D,
			0xA7, 0xA7, 0xA7, 0xC9, 0xC9, 0xC9, 0xC7, 0xC7, 0xC7, 0xC2, 0xC2, 0xC2,
			0x9A, 0x9A, 0x9A, 0xA4, 0xA4, 0xA4, 0xA9, 0xA9, 0xA9, 0x91, 0x91, 0x91,
			0x34, 0x34, 0x34, 0x39, 0x39, 0x39, 0x2D, 0x2D, 0x2D, 0x44, 0x44, 0x44,
			0x4C, 0x4C, 0x4C, 0x3D, 0x3D, 0x3D, 0xBE, 0x97, 0x95, 0xD0, 0x1E, 0x1E,
			0xC6, 0x4C, 0x4C, 0xD3, 0x27, 0x2D, 0xC9, 0x1A, 0x25, 0xD6, 0x4A, 0x50,
			0xD4, 0x04, 0x13, 0xD3, 0x94, 0x95, 0xDE, 0x76, 0x75, 0xD6, 0x65, 0x65,
			0xCE, 0x9D, 0x9C, 0x83, 0x83, 0x83, 0x90, 0x8F, 0x8F, 0xD7, 0x38, 0x35,
			0xC3, 0x41, 0x43, 0xF7, 0xD6, 0xD2, 0xD0, 0x1F, 0x22, 0xD6, 0xA7, 0xA6,
			0xDA, 0x7F, 0x7C, 0xD8, 0x78, 0x78, 0xDA, 0x77, 0x78, 0xCC, 0x71, 0x70,
			0xE5, 0x7A, 0x7A, 0xCC, 0x16, 0x20, 0xE6, 0xDE, 0xDC, 0xDA, 0x7F, 0x7C,
			0xCE, 0x86, 0x85, 0xE3, 0x8F, 0x8D, 0xD6, 0x65, 0x65, 0xD3, 0x61, 0x61,
			0xD2, 0x6A, 0x6D, 0xB2, 0xA8, 0xA7, 0xE3, 0x93, 0x91, 0xCA, 0x1C, 0x1B,
			0xDE, 0xC9, 0xC7, 0xD8, 0x78, 0x76, 0xD5, 0x69, 0x68, 0xD4, 0x67, 0x67,
			0xCB, 0x76, 0x76, 0xEB, 0xC0, 0xBD, 0xD3, 0x6C, 0x6B, 0xE0, 0xB5, 0xB2,
			0xCA, 0x14, 0x13, 0xCB, 0x8F, 0x8F, 0xE1, 0x9C, 0x97, 0xCD, 0x62, 0x60,
			0xA8, 0xA6, 0xA6, 0x5B, 0x5C, 0x5C, 0x5C, 0x5C, 0x5C, 0x5E, 0x5E, 0x5E,
			0xA6, 0xA6, 0xA6, 0xC6, 0xC6, 0xC6, 0xC5, 0xC5, 0xC5, 0xBF, 0xBF, 0xBF,
			0x9E, 0x9E, 0x9E, 0xA9, 0xA9, 0xA9, 0xAD, 0xAD, 0xAD, 0x92, 0x92, 0x92,
			0x2D, 0x2D, 0x2D, 0x35, 0x35, 0x35, 0x45, 0x45, 0x45, 0x4C, 0x4C, 0x4C,
			0x43, 0x43, 0x43, 0x42, 0x42, 0x42, 0xBF, 0x98, 0x96, 0xC1, 0x69, 0x68,
			0xA4, 0xA4, 0xA4, 0xD8, 0x6C, 0x69, 0xB3, 0x9E, 0x9E, 0xCC, 0xAB, 0xAA,
			0xCD, 0x7D, 0x7D, 0x9A, 0x99, 0x99, 0x78, 0x78, 0x78, 0x7C, 0x7C, 0x7C,
			0x77, 0x77, 0x77, 0x7F, 0x7F, 0x7F, 0x97, 0x97, 0x97, 0xD6, 0x77, 0x71,
			0xAF, 0xA3, 0xA3, 0xC8, 0xAF, 0xAA, 0xC8, 0x89, 0x88, 0x92, 0x92, 0x92,
			0x7D, 0x7C, 0x7C, 0x80, 0x80, 0x80, 0x7E, 0x7D, 0x7D, 0x87, 0x85, 0x86,
			0xE6, 0x9A, 0x93, 0xC3, 0xA3, 0xA2, 0x90, 0x90, 0x90, 0x8C, 0x8B, 0x8B,
			0x8C, 0x8B, 0x8B, 0x8C, 0x8B, 0x8B, 0x8A, 0x89, 0x89, 0x88, 0x87, 0x87,
			0x8E, 0x8E, 0x8E, 0x6A, 0x6A, 0x6A, 0xDF, 0xA5, 0xA1, 0xC0, 0x95, 0x96,
			0x8E, 0x8E, 0x8E, 0x7C, 0x7C, 0x7C, 0x7F, 0x7F, 0x7E, 0x82, 0x81, 0x81,
			0x85, 0x84, 0x85, 0x7D, 0x7C, 0x7C, 0x76, 0x76, 0x76, 0xC8, 0xA0, 0x9E,
			0xC0, 0x68, 0x68, 0x93, 0x94, 0x94, 0x7E, 0x7E, 0x7D, 0x7E, 0x7D, 0x7D,
			0x66, 0x66, 0x66, 0x5B, 0x5B, 0x5B, 0x61, 0x61, 0x61, 0x5B, 0x5B, 0x5B,
			0xA3, 0xA3, 0xA3, 0xC4, 0xC4, 0xC4, 0xC2, 0xC2, 0xC2, 0xBD, 0xBD, 0xBD,
			0xA3, 0xA3, 0xA3, 0xAE, 0xAE, 0xAE, 0xB3, 0xB3, 0xB3, 0x98, 0x98, 0x98,
			0x23, 0x23, 0x23, 0x2F, 0x2F, 0x2F, 0x3D, 0x3D, 0x3D, 0x57, 0x57, 0x57,
			0x54, 0x54, 0x54, 0x4A, 0x4A, 0x4A, 0xB6, 0xB0, 0xB0, 0x80, 0x81, 0x81,
			0x6B, 0x6B, 0x6B, 0xC7, 0xC3, 0xC2, 0x62, 0x62, 0x62, 0xBA, 0xB5, 0xB5,
			0x91, 0x92, 0x91, 0x74, 0x74, 0x74, 0x7A, 0x7A, 0x7A, 0x7A, 0x7A, 0x7A,
			0x70, 0x70, 0x70, 0x7E, 0x7E, 0x7E, 0x90, 0x90, 0x90, 0xBC, 0xB7, 0xB6,
			0x73, 0x74, 0x74, 0xBB, 0xB9, 0xBA, 0x81, 0x82, 0x82, 0x7E, 0x7E, 0x7E,
			0x79, 0x79, 0x79, 0x8F, 0x8F, 0x8F, 0x84, 0x84, 0x84, 0x7D, 0x7D, 0x7D,
			0xD6, 0xD1, 0xCF, 0x87, 0x87, 0x87, 0x87, 0x87, 0x87, 0x8B, 0x8B, 0x8B,
			0x84, 0x84, 0x84, 0x96, 0x96, 0x96, 0x98, 0x98, 0x98, 0x89, 0x89, 0x89,
			0x8C, 0x8C, 0x8C, 0x7B, 0x7A, 0x7A, 0xD4, 0xD0, 0xCF, 0x89, 0x89, 0x89,
			0x7B, 0x7B, 0x7B, 0x77, 0x77, 0x77, 0x7E, 0x7E, 0x7E, 0x85, 0x85, 0x85,
			0x89, 0x89, 0x89, 0x78, 0x78, 0x78, 0x70, 0x70, 0x70, 0xBA, 0xB6, 0xB5,
			0x93, 0x93, 0x93, 0x76, 0x76, 0x76, 0x7C, 0x7C, 0x7C, 0x78, 0x78, 0x78,
			0x70, 0x70, 0x70, 0x69, 0x69, 0x69, 0x5F, 0x5F, 0x5F, 0x61, 0x61, 0x61,
			0xA1, 0xA1, 0xA1, 0xC2, 0xC2, 0xC2, 0xC0, 0xC0, 0xC0, 0xBB, 0xBB, 0xBB,
			0xA7, 0xA7, 0xA7, 0xB3, 0xB3, 0xB3, 0xB8, 0xB8, 0xB8, 0x9D, 0x9D, 0x9D,
			0x39, 0x39, 0x39, 0x32, 0x32, 0x32, 0x41, 0x41, 0x41, 0x58, 0x58, 0x58,
			0x4E, 0x4E, 0x4E, 0x48, 0x48, 0x48, 0x61, 0x61, 0x62, 0x5F, 0x5F, 0x5F,
			0x5D, 0x5D, 0x5D, 0x54, 0x53, 0x54, 0x58, 0x58, 0x58, 0x5F, 0x60, 0x60,
			0x62, 0x62, 0x62, 0x5E, 0x5E, 0x5E, 0x68, 0x68, 0x68, 0x69, 0x69, 0x69,
			0x79, 0x79, 0x79, 0x7F, 0x7F, 0x7F, 0x79, 0x79, 0x79, 0x7D, 0x7D, 0x7D,
			0x86, 0x86, 0x86, 0x7E, 0x7E, 0x7E, 0x86, 0x86, 0x86, 0x8A, 0x8A, 0x8A,
			0x73, 0x73, 0x73, 0x68, 0x68, 0x68, 0x73, 0x73, 0x73, 0x67, 0x67, 0x67,
			0x72, 0x72, 0x72, 0x6B, 0x6B, 0x6B, 0x71, 0x71, 0x71, 0x6D, 0x6D, 0x6D,
			0x71, 0x71, 0x71, 0x8A, 0x8A, 0x8A, 0x87, 0x87, 0x87, 0x7C, 0x7C, 0x7C,
			0x78, 0x78, 0x78, 0x7E, 0x7E, 0x7E, 0x82, 0x82, 0x82, 0x7C, 0x7C, 0x7C,
			0x68, 0x68, 0x68, 0x6B, 0x6B, 0x6B, 0x6A, 0x6A, 0x6A, 0x6D, 0x6D, 0x6D,
			0x6B, 0x6B, 0x6B, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x75, 0x75, 0x75,
			0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x78, 0x78, 0x78, 0x74, 0x74, 0x74,
			0x77, 0x77, 0x77, 0x6E, 0x6E, 0x6E, 0x63, 0x63, 0x63, 0x62, 0x62, 0x62,
			0xA1, 0xA1, 0xA1, 0xBF, 0xBF, 0xBF, 0xBD, 0xBD, 0xBD, 0xB8, 0xB8, 0xB8,
			0xAC, 0xAC, 0xAC, 0xB9, 0xB9, 0xB9, 0xBD, 0xBD, 0xBD, 0xA0, 0xA0, 0xA0,
			0x35, 0x35, 0x35, 0x2E, 0x2E, 0x2E, 0x3D, 0x3D, 0x3D, 0x54, 0x54, 0x54,
			0x4D, 0x4D, 0x4D, 0x48, 0x48, 0x48, 0x4A, 0x4A, 0x4A, 0x64, 0x64, 0x64,
			0x61, 0x61, 0x61, 0xF1, 0xF1, 0xF1, 0xF2, 0xF2, 0xF2, 0xE3, 0xE3, 0xE3,
			0xD4, 0xD3, 0xD4, 0xEE, 0xEE, 0xEE, 0xF5, 0xF5, 0xF5, 0xD5, 0xD5, 0xD5,
			0x6B, 0x6B, 0x6B, 0x7A, 0x7A, 0x7A, 0x7A, 0x7A, 0x7A, 0x71, 0x71, 0x71,
			0x84, 0x84, 0x84, 0x8C, 0x8C, 0x8C, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91,
			0x89, 0x89, 0x89, 0xA0, 0xA0, 0xA0, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5,
			0xDE, 0xDE, 0xDE, 0xDF, 0xDF, 0xDF, 0xF5, 0xF5, 0xF5, 0xF3, 0xF3, 0xF3,
			0xAE, 0xAE, 0xAE, 0x8E, 0x8E, 0x8E, 0x6C, 0x6C, 0x6C, 0x75, 0x75, 0x75,
			0x6B, 0x6B, 0x6B, 0x86, 0x86, 0x86, 0x71, 0x71, 0x71, 0x6F, 0x6F, 0x6F,
			0xA3, 0xA3, 0xA3, 0xEE, 0xEE, 0xEE, 0xEF, 0xEF, 0xEF, 0xD4, 0xD4, 0xD4,
			0xD2, 0xD2, 0xD2, 0xD2, 0xD2, 0xD2, 0xCF, 0xCF, 0xCF, 0x92, 0x92, 0x92,
			0x7B, 0x7B, 0x7B, 0x7C, 0x7C, 0x7C, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
			0x7A, 0x7A, 0x7A, 0x70, 0x70, 0x70, 0x63, 0x63, 0x63, 0x60, 0x60, 0x60,
			0x9F, 0x9F, 0x9F, 0xBD, 0xBD, 0xBD, 0xBB, 0xBB, 0xBB, 0xB6, 0xB6, 0xB6,
			0xB1, 0xB1, 0xB1, 0xBE, 0xBE, 0xBE, 0xC3, 0xC3, 0xC3, 0xA1, 0xA1, 0xA1,
			0x29, 0x29, 0x29, 0x3F, 0x3F, 0x3F, 0x52, 0x52, 0x52, 0x5B, 0x5B, 0x5B,
			0x4A, 0x4A, 0x4A, 0x50, 0x50, 0x50, 0x59, 0x59, 0x59, 0x5F, 0x5F, 0x5F,
			0x68, 0x68, 0x68, 0xF8, 0xF8, 0xF8, 0xFA, 0xFA, 0xFA, 0x9D, 0x9D, 0x9D,
			0x5D, 0x5D, 0x5D, 0xD4, 0xD4, 0xD4, 0xFC, 0xFC, 0xFC, 0xDC, 0xDC, 0xDC,
			0x74, 0x74, 0x74, 0x7C, 0x7C, 0x7C, 0x7B, 0x7B, 0x7B, 0x78, 0x78, 0x78,
			0x80, 0x80, 0x80, 0x8B, 0x8B, 0x8B, 0x86, 0x86, 0x86, 0x6D, 0x6D, 0x6D,
			0x76, 0x76, 0x76, 0x9F, 0x9F, 0x9F, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD,
			0x91, 0x91, 0x91, 0x77, 0x77, 0x77, 0xFB, 0xFB, 0xFB, 0xFA, 0xFA, 0xFA,
			0xB0, 0xB0, 0xB0, 0x93, 0x93, 0x93, 0x7E, 0x7E, 0x7E, 0x80, 0x80, 0x80,
			0x89, 0x89, 0x89, 0x84, 0x84, 0x84, 0x77, 0x77, 0x77, 0x71, 0x71, 0x71,
			0xA8, 0xA8, 0xA8, 0xF4, 0xF4, 0xF4, 0xF7, 0xF7, 0xF7, 0x6E, 0x6E, 0x6E,
			0x7A, 0x7A, 0x7A, 0x6F, 0x6F, 0x6F, 0x7A, 0x7A, 0x7A, 0x80, 0x80, 0x80,
			0x79, 0x79, 0x79, 0x7C, 0x7C, 0x7C, 0x7E, 0x7E, 0x7E, 0x78, 0x78, 0x78,
			0x74, 0x74, 0x74, 0x73, 0x73, 0x73, 0x6D, 0x6D, 0x6D, 0x55, 0x55, 0x55,
			0x97, 0x97, 0x97, 0xBA, 0xBA, 0xBA, 0xB9, 0xB9, 0xB9, 0xB3, 0xB3, 0xB3,
			0xB6, 0xB6, 0xB6, 0xC3, 0xC3, 0xC3, 0xC8, 0xC8, 0xC8, 0xA5, 0xA5, 0xA5,
			0x23, 0x23, 0x23, 0x41, 0x41, 0x41, 0x48, 0x48, 0x48, 0x4B, 0x4B, 0x4B,
			0x53, 0x53, 0x53, 0x5C, 0x5C, 0x5C, 0x5D, 0x5D, 0x5D, 0x66, 0x66, 0x66,
			0x66, 0x66, 0x66, 0xF9, 0xF9, 0xF9, 0xF7, 0xF7, 0xF7, 0x9F, 0x9F, 0x9F,
			0x6B, 0x6B, 0x6B, 0xD4, 0xD4, 0xD4, 0xFB, 0xFB, 0xFB, 0xDB, 0xDB, 0xDB,
			0x77, 0x77, 0x77, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7C, 0x7C, 0x7C,
			0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x90, 0x90, 0x90, 0x87, 0x87, 0x87,
			0x82, 0x82, 0x82, 0xA2, 0xA2, 0xA2, 0xFC, 0xFC, 0xFC, 0xFD, 0xFD, 0xFD,
			0x84, 0x84, 0x84, 0x61, 0x61, 0x61, 0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 0xFA,
			0xB3, 0xB3, 0xB3, 0x8F, 0x8F, 0x8F, 0x94, 0x94, 0x94, 0x87, 0x87, 0x87,
			0x86, 0x86, 0x86, 0x7A, 0x7A, 0x7A, 0x7D, 0x7D, 0x7D, 0x6A, 0x6A, 0x6A,
			0xA4, 0xA4, 0xA4, 0xF2, 0xF2, 0xF2, 0xF3, 0xF3, 0xF3, 0x73, 0x73, 0x73,
			0x82, 0x82, 0x82, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x78, 0x78, 0x78,
			0x62, 0x62, 0x62, 0x82, 0x82, 0x82, 0x7B, 0x7B, 0x7B, 0x78, 0x78, 0x78,
			0x78, 0x78, 0x78, 0x6D, 0x6D, 0x6D, 0x6B, 0x6B, 0x6B, 0x4C, 0x4C, 0x4C,
			0x92, 0x92, 0x92, 0xB8, 0xB8, 0xB8, 0xB6, 0xB6, 0xB6, 0xB1, 0xB1, 0xB1,
			0xBB, 0xBB, 0xBB, 0xC8, 0xC8, 0xC8, 0xCD, 0xCD, 0xCD, 0xA2, 0xA2, 0xA2,
			0x1F, 0x1F, 0x1F, 0x2C, 0x2C, 0x2C, 0x4F, 0x4F, 0x4F, 0x4D, 0x4D, 0x4D,
			0x56, 0x56, 0x56, 0x5E, 0x5E, 0x5E, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
			0x68, 0x68, 0x68, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0x95, 0x95, 0x95,
			0x5D, 0x5D, 0x5D, 0xD2, 0xD2, 0xD2, 0xFA, 0xFA, 0xFA, 0xDB, 0xDB, 0xDB,
			0x78, 0x78, 0x78, 0x74, 0x74, 0x74, 0x87, 0x87, 0x87, 0x7E, 0x7E, 0x7E,
			0x7C, 0x7C, 0x7C, 0x87, 0x87, 0x87, 0x7F, 0x7F, 0x7F, 0x78, 0x78, 0x78,
			0x76, 0x76, 0x76, 0xA1, 0xA1, 0xA1, 0xFC, 0xFC, 0xFC, 0xFD, 0xFD, 0xFD,
			0x87, 0x87, 0x87, 0x7C, 0x7C, 0x7C, 0xFA, 0xFA, 0xFA, 0xF8, 0xF8, 0xF8,
			0xB1, 0xB1, 0xB1, 0x98, 0x98, 0x98, 0x91, 0x91, 0x91, 0x8C, 0x8C, 0x8C,
			0x78, 0x78, 0x78, 0x87, 0x87, 0x87, 0x85, 0x85, 0x85, 0x73, 0x73, 0x73,
			0xA6, 0xA6, 0xA6, 0xEE, 0xEE, 0xEE, 0xF0, 0xF0, 0xF0, 0x7D, 0x7D, 0x7D,
			0x87, 0x87, 0x87, 0x73, 0x73, 0x73, 0x77, 0x77, 0x77, 0x6B, 0x6B, 0x6B,
			0x76, 0x76, 0x76, 0x7D, 0x7D, 0x7D, 0x6A, 0x6A, 0x6A, 0x75, 0x75, 0x75,
			0x74, 0x74, 0x74, 0x75, 0x75, 0x75, 0x69, 0x69, 0x69, 0x62, 0x62, 0x62,
			0x9A, 0x9A, 0x9A, 0xB6, 0xB6, 0xB6, 0xB4, 0xB4, 0xB4, 0xAF, 0xAF, 0xAF,
			0xC0, 0xC0, 0xC0, 0xCE, 0xCE, 0xCE, 0xD2, 0xD2, 0xD2, 0xA7, 0xA7, 0xA7,
			0x28, 0x28, 0x28, 0x38, 0x38, 0x38, 0x45, 0x45, 0x45, 0x49, 0x49, 0x49,
			0x50, 0x50, 0x50, 0x4F, 0x4F, 0x4F, 0x52, 0x52, 0x52, 0x5F, 0x5F, 0x5F,
			0x67, 0x67, 0x67, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xDE, 0xDE, 0xDE,
			0xC7, 0xC7, 0xC7, 0xEE, 0xEE, 0xEE, 0xE1, 0xE1, 0xE1, 0x91, 0x91, 0x91,
			0x78, 0x78, 0x78, 0x80, 0x80, 0x80, 0x88, 0x88, 0x88, 0x84, 0x84, 0x84,
			0x88, 0x88, 0x88, 0x91, 0x91, 0x91, 0x8E, 0x8E, 0x8E, 0x7B, 0x7B, 0x7B,
			0x73, 0x73, 0x73, 0x9D, 0x9D, 0x9D, 0xFC, 0xFC, 0xFC, 0xFA, 0xFA, 0xFA,
			0xD1, 0xD1, 0xD1, 0xCD, 0xCD, 0xCD, 0xE1, 0xE1, 0xE1, 0xBB, 0xBB, 0xBB,
			0x95, 0x95, 0x95, 0x9A, 0x9A, 0x9A, 0x95, 0x95, 0x95, 0x8F, 0x8F, 0x8F,
			0x83, 0x83, 0x83, 0x7B, 0x7B, 0x7B, 0x82, 0x82, 0x82, 0x7C, 0x7C, 0x7C,
			0xA6, 0xA6, 0xA6, 0xEB, 0xEB, 0xEB, 0xEF, 0xEF, 0xEF, 0x75, 0x75, 0x75,
			0x98, 0x98, 0x98, 0xB8, 0xB8, 0xB8, 0xB6, 0xB6, 0xB6, 0x81, 0x81, 0x81,
			0x7D, 0x7D, 0x7D, 0x6B, 0x6B, 0x6B, 0x6D, 0x6D, 0x6D, 0x73, 0x73, 0x73,
			0x6E, 0x6E, 0x6E, 0x4D, 0x4D, 0x4D, 0x64, 0x64, 0x64, 0x57, 0x57, 0x57,
			0x93, 0x93, 0x93, 0xB2, 0xB2, 0xB2, 0xB1, 0xB1, 0xB1, 0xAC, 0xAC, 0xAC,
			0xC6, 0xC6, 0xC6, 0xD3, 0xD3, 0xD3, 0xD8, 0xD8, 0xD8, 0xA7, 0xA7, 0xA7,
			0x27, 0x27, 0x27, 0x44, 0x44, 0x44, 0x38, 0x38, 0x38, 0x33, 0x33, 0x33,
			0x4D, 0x4D, 0x4D, 0x51, 0x51, 0x51, 0x59, 0x59, 0x59, 0x5B, 0x5B, 0x5B,
			0x66, 0x66, 0x66, 0xF5, 0xF5, 0xF5, 0xF7, 0xF7, 0xF7, 0xA0, 0xA0, 0xA0,
			0x62, 0x63, 0x62, 0xD6, 0xD6, 0xD6, 0x9D, 0x9D, 0x9D, 0x74, 0x74, 0x74,
			0x7E, 0x7E, 0x7E, 0x84, 0x84, 0x84, 0x73, 0x73, 0x73, 0x78, 0x78, 0x78,
			0x85, 0x85, 0x85, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x89, 0x89, 0x89,
			0x7F, 0x7F, 0x7F, 0x9A, 0x9A, 0x9A, 0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 0xF9,
			0x82, 0x82, 0x82, 0x78, 0x78, 0x77, 0x7C, 0x7C, 0x7C, 0x81, 0x81, 0x81,
			0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x83, 0x83, 0x83, 0x7C, 0x7C, 0x7C,
			0x83, 0x83, 0x83, 0x7D, 0x7D, 0x7D, 0x80, 0x80, 0x80, 0x6A, 0x6A, 0x6A,
			0xA4, 0xA4, 0xA4, 0xEA, 0xEA, 0xEA, 0xEB, 0xEB, 0xEB, 0x77, 0x77, 0x77,
			0x80, 0x80, 0x80, 0xE0, 0xE0, 0xE0, 0xDE, 0xDE, 0xDE, 0x99, 0x99, 0x99,
			0x80, 0x80, 0x80, 0x72, 0x72, 0x72, 0x6C, 0x6C, 0x6C, 0x5A, 0x5A, 0x5A,
			0x5E, 0x5E, 0x5E, 0x57, 0x57, 0x57, 0x42, 0x42, 0x42, 0x54, 0x54, 0x54,
			0x8E, 0x8E, 0x8E, 0xB0, 0xB0, 0xB0, 0xAE, 0xAE, 0xAE, 0xAB, 0xAB, 0xAB,
			0xCB, 0xCB, 0xCB, 0xD8, 0xD8, 0xD8, 0xDE, 0xDE, 0xDE, 0xAD, 0xAD, 0xAD,
			0x2C, 0x2C, 0x2C, 0x36, 0x36, 0x36, 0x3B, 0x3B, 0x3B, 0x45, 0x45, 0x45,
			0x3E, 0x3E, 0x3E, 0x50, 0x50, 0x50, 0x60, 0x60, 0x60, 0x5C, 0x5C, 0x5C,
			0x63, 0x63, 0x63, 0xF7, 0xF7, 0xF7, 0xF4, 0xF4, 0xF4, 0x97, 0x97, 0x97,
			0x62, 0x62, 0x62, 0xD2, 0xD2, 0xD2, 0xFB, 0xFB, 0xFB, 0x9D, 0x9D, 0x9D,
			0x7D, 0x7D, 0x7D, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x84, 0x84, 0x84,
			0x71, 0x71, 0x71, 0x64, 0x64, 0x64, 0x84, 0x84, 0x84, 0x8E, 0x8E, 0x8E,
			0x82, 0x82, 0x82, 0x9A, 0x9A, 0x9A, 0xF7, 0xF7, 0xF7, 0xF9, 0xF9, 0xF9,
			0x7F, 0x7F, 0x7F, 0x8F, 0x8F, 0x8F, 0x85, 0x85, 0x85, 0x93, 0x93, 0x93,
			0x93, 0x93, 0x93, 0x94, 0x94, 0x94, 0x7D, 0x7D, 0x7D, 0x7C, 0x7C, 0x7C,
			0x83, 0x83, 0x83, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x73, 0x73, 0x73,
			0xA3, 0xA3, 0xA3, 0xE5, 0xE5, 0xE5, 0xE8, 0xE8, 0xE8, 0x71, 0x71, 0x71,
			0x7B, 0x7B, 0x7B, 0xDF, 0xDF, 0xDF, 0xDB, 0xDB, 0xDB, 0x96, 0x96, 0x96,
			0x89, 0x89, 0x89, 0x7C, 0x7C, 0x7C, 0x75, 0x75, 0x75, 0x7A, 0x7A, 0x7A,
			0x69, 0x69, 0x69, 0x55, 0x55, 0x55, 0x37, 0x37, 0x37, 0x57, 0x57, 0x57,
			0x91, 0x91, 0x91, 0xAE, 0xAE, 0xAE, 0xAC, 0xAC, 0xAC, 0xA8, 0xA8, 0xA8,
			0xD0, 0xD0, 0xD0, 0xDE, 0xDE, 0xDE, 0xE3, 0xE3, 0xE3, 0xB6, 0xB6, 0xB6,
			0x19, 0x19, 0x19, 0x34, 0x34, 0x34, 0x3B, 0x3B, 0x3B, 0x48, 0x48, 0x48,
			0x45, 0x45, 0x45, 0x57, 0x57, 0x57, 0x5A, 0x5A, 0x5A, 0x56, 0x56, 0x56,
			0x5E, 0x5E, 0x5E, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0x9C, 0x9C, 0x9C,
			0x64, 0x64, 0x64, 0xD3, 0xD3, 0xD3, 0xFA, 0xFA, 0xFA, 0xD8, 0xD8, 0xD8,
			0x73, 0x73, 0x73, 0x82, 0x82, 0x82, 0x7F, 0x7F, 0x7F, 0x57, 0x57, 0x57,
			0x6F, 0x6F, 0x6F, 0x7C, 0x7C, 0x7C, 0x85, 0x85, 0x85, 0x91, 0x91, 0x91,
			0x7E, 0x7E, 0x7E, 0x9D, 0x9D, 0x9D, 0xF7, 0xF7, 0xF7, 0xF7, 0xF7, 0xF7,
			0x7E, 0x7E, 0x7E, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x7B, 0x7B, 0x7B,
			0x8D, 0x8D, 0x8D, 0x92, 0x92, 0x92, 0x87, 0x87, 0x87, 0x7D, 0x7D, 0x7D,
			0x81, 0x81, 0x81, 0x79, 0x79, 0x79, 0x69, 0x69, 0x69, 0x6F, 0x6F, 0x6F,
			0x9F, 0x9F, 0x9F, 0xE2, 0xE2, 0xE2, 0xE8, 0xE8, 0xE8, 0x5D, 0x5D, 0x5D,
			0x70, 0x70, 0x70, 0xDC, 0xDC, 0xDC, 0xD6, 0xD6, 0xD6, 0x95, 0x95, 0x95,
			0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x76, 0x76, 0x76, 0x5D, 0x5D, 0x5D,
			0x62, 0x62, 0x62, 0x59, 0x59, 0x59, 0x2B, 0x2B, 0x2B, 0x4C, 0x4C, 0x4C,
			0x8A, 0x8A, 0x8A, 0xAC, 0xAC, 0xAC, 0xAA, 0xAA, 0xAA, 0xA6, 0xA6, 0xA6,
			0xD6, 0xD6, 0xD6, 0xE4, 0xE4, 0xE4, 0xE9, 0xE9, 0xE9, 0xBC, 0xBC, 0xBC,
			0x2B, 0x2B, 0x2B, 0x44, 0x44, 0x44, 0x42, 0x42, 0x42, 0x40, 0x40, 0x40,
			0x40, 0x40, 0x40, 0x59, 0x59, 0x59, 0x5C, 0x5C, 0x5C, 0x65, 0x65, 0x65,
			0x68, 0x68, 0x68, 0xF5, 0xF5, 0xF5, 0xF7, 0xF7, 0xF7, 0x9D, 0x9D, 0x9D,
			0x62, 0x62, 0x62, 0xD2, 0xD2, 0xD2, 0xFA, 0xFA, 0xFA, 0xC7, 0xC7, 0xC7,
			0x5C, 0x5C, 0x5C, 0x73, 0x73, 0x73, 0x75, 0x75, 0x75, 0x78, 0x78, 0x78,
			0x70, 0x70, 0x70, 0x88, 0x88, 0x88, 0x8E, 0x8E, 0x8E, 0x94, 0x94, 0x94,
			0x92, 0x92, 0x92, 0xA3, 0xA3, 0xA3, 0xF4, 0xF4, 0xF4, 0xF6, 0xF6, 0xF6,
			0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7C, 0x7C, 0x7C, 0x90, 0x90, 0x90,
			0x7C, 0x7C, 0x7C, 0x7A, 0x7A, 0x7A, 0x7E, 0x7E, 0x7E, 0x6F, 0x6F, 0x6F,
			0x7A, 0x7A, 0x7A, 0x77, 0x77, 0x77, 0x6A, 0x6A, 0x6A, 0x66, 0x66, 0x66,
			0x99, 0x99, 0x99, 0xE2, 0xE2, 0xE2, 0xDF, 0xDF, 0xDF, 0x99, 0x99, 0x99,
			0xA0, 0xA0, 0xA0, 0xD7, 0xD7, 0xD7, 0xD5, 0xD5, 0xD5, 0x87, 0x87, 0x87,
			0x78, 0x78, 0x78, 0x7E, 0x7E, 0x7E, 0x7C, 0x7C, 0x7C, 0x6F, 0x6F, 0x6F,
			0x63, 0x63, 0x63, 0x40, 0x40, 0x40, 0x36, 0x36, 0x36, 0x5E, 0x5E, 0x5E,
			0x8C, 0x8C, 0x8C, 0xAA, 0xAA, 0xAA, 0xA8, 0xA8, 0xA8, 0xA4, 0xA4, 0xA4,
			0xDB, 0xDB, 0xDB, 0xEA, 0xEA, 0xEA, 0xEF, 0xEF, 0xEF, 0xC0, 0xC0, 0xC0,
			0x32, 0x32, 0x32, 0x3F, 0x3F, 0x3F, 0x33, 0x33, 0x33, 0x37, 0x37, 0x37,
			0x3D, 0x3D, 0x3D, 0x52, 0x52, 0x52, 0x60, 0x60, 0x60, 0x5D, 0x5D, 0x5D,
			0x58, 0x58, 0x58, 0x8B, 0x8B, 0x8B, 0x80, 0x80, 0x80, 0x79, 0x79, 0x79,
			0x52, 0x51, 0x52, 0xD1, 0xD1, 0xD1, 0xE9, 0xE9, 0xE9, 0x77, 0x77, 0x77,
			0x6A, 0x68, 0x69, 0x7F, 0x7E, 0x7F, 0x76, 0x76, 0x76, 0x78, 0x78, 0x78,
			0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x84, 0x84, 0x84, 0x89, 0x89, 0x89,
			0x92, 0x92, 0x92, 0x8F, 0x8F, 0x8F, 0xA0, 0xA0, 0xA0, 0x9D, 0x9D, 0x9D,
			0x72, 0x72, 0x72, 0x7E, 0x7E, 0x7E, 0x82, 0x82, 0x82, 0x93, 0x93, 0x93,
			0x8D, 0x8D, 0x8D, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x85, 0x85, 0x85,
			0x7A, 0x7A, 0x7A, 0x79, 0x79, 0x79, 0x7F, 0x7F, 0x7F, 0x5F, 0x5F, 0x5F,
			0x69, 0x69, 0x69, 0x88, 0x88, 0x88, 0x83, 0x83, 0x83, 0x81, 0x81, 0x81,
			0x92, 0x92, 0x92, 0xD3, 0xD3, 0xD3, 0xAC, 0xAC, 0xAC, 0x7E, 0x7E, 0x7E,
			0x7A, 0x7A, 0x7A, 0x71, 0x71, 0x71, 0x68, 0x68, 0x68, 0x6F, 0x6F, 0x6F,
			0x69, 0x69, 0x69, 0x55, 0x55, 0x55, 0x50, 0x50, 0x50, 0x43, 0x43, 0x43,
			0x90, 0x90, 0x90, 0xA7, 0xA7, 0xA7, 0xA6, 0xA6, 0xA6, 0xA2, 0xA2, 0xA2,
			0xE0, 0xE0, 0xE0, 0xF0, 0xF0, 0xF0, 0xF5, 0xF5, 0xF5, 0xC0, 0xC0, 0xC0,
			0x39, 0x39, 0x39, 0x3E, 0x3E, 0x3E, 0x35, 0x35, 0x35, 0x53, 0x53, 0x53,
			0x53, 0x53, 0x53, 0x4B, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x47, 0x47, 0x47,
			0x62, 0x62, 0x62, 0x61, 0x61, 0x61, 0x62, 0x61, 0x61, 0x67, 0x67, 0x67,
			0x5B, 0x5B, 0x5B, 0xCE, 0xCE, 0xCE, 0x84, 0x84, 0x84, 0x76, 0x76, 0x76,
			0x75, 0x75, 0x75, 0x7E, 0x7E, 0x7E, 0x78, 0x78, 0x78, 0x7B, 0x7B, 0x7B,
			0x7B, 0x7B, 0x7B, 0x87, 0x87, 0x87, 0x95, 0x95, 0x95, 0x81, 0x81, 0x81,
			0x96, 0x96, 0x96, 0x8B, 0x8B, 0x8B, 0x85, 0x85, 0x85, 0x88, 0x88, 0x88,
			0x71, 0x71, 0x71, 0x81, 0x81, 0x81, 0x7B, 0x7B, 0x7B, 0x92, 0x92, 0x92,
			0x96, 0x96, 0x96, 0x7F, 0x7F, 0x7F, 0x7A, 0x7A, 0x7A, 0x73, 0x73, 0x73,
			0x78, 0x78, 0x78, 0x73, 0x73, 0x73, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F,
			0x6C, 0x6C, 0x6C, 0x6E, 0x6E, 0x6E, 0x66, 0x66, 0x66, 0x6C, 0x6C, 0x6C,
			0x73, 0x73, 0x73, 0xC2, 0xC2, 0xC2, 0x7C, 0x7C, 0x7C, 0x7F, 0x7F, 0x7F,
			0x72, 0x72, 0x72, 0x54, 0x54, 0x54, 0x41, 0x41, 0x41, 0x63, 0x63, 0x63,
			0x55, 0x55, 0x55, 0x3B, 0x3B, 0x3B, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
			0x88, 0x88, 0x88, 0xA5, 0xA5, 0xA5, 0xA3, 0xA3, 0xA3, 0xA0, 0xA0, 0xA0,
			0xE6, 0xE6, 0xE6, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5, 0xBD, 0xBD, 0xBD,
			0x2E, 0x2E, 0x2E, 0x43, 0x43, 0x43, 0x41, 0x41, 0x41, 0x57, 0x57, 0x57,
			0x53, 0x53, 0x53, 0x4D, 0x4D, 0x4D, 0x5D, 0x5D, 0x5C, 0x66, 0x66, 0x66,
			0x63, 0x63, 0x63, 0x5E, 0x5D, 0x5B, 0x54, 0x53, 0x51, 0x58, 0x57, 0x55,
			0x56, 0x54, 0x55, 0x7B, 0x7B, 0x7B, 0x67, 0x67, 0x66, 0x75, 0x75, 0x75,
			0x74, 0x72, 0x73, 0x80, 0x80, 0x80, 0x70, 0x70, 0x70, 0x6E, 0x6E, 0x6E,
			0x78, 0x78, 0x78, 0x72, 0x72, 0x72, 0x8A, 0x8A, 0x8A, 0x91, 0x91, 0x91,
			0x81, 0x81, 0x81, 0x6B, 0x6B, 0x6B, 0x7C, 0x7C, 0x7C, 0x84, 0x84, 0x84,
			0x8D, 0x8D, 0x8D, 0x89, 0x89, 0x89, 0x86, 0x86, 0x86, 0x7D, 0x7D, 0x7D,
			0x8A, 0x8A, 0x8A, 0x82, 0x82, 0x82, 0x7A, 0x7A, 0x7A, 0x6F, 0x6F, 0x6F,
			0x7D, 0x7D, 0x7D, 0x75, 0x75, 0x75, 0x7B, 0x7B, 0x7B, 0x6D, 0x6D, 0x6D,
			0x57, 0x57, 0x57, 0x6C, 0x6C, 0x6C, 0x5A, 0x5A, 0x5A, 0x5C, 0x5C, 0x5C,
			0x71, 0x71, 0x71, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x79, 0x79, 0x79,
			0x67, 0x67, 0x67, 0x54, 0x54, 0x54, 0x4E, 0x4E, 0x4E, 0x45, 0x45, 0x45,
			0x4B, 0x4B, 0x4B, 0x38, 0x38, 0x37, 0x3A, 0x3A, 0x3A, 0x39, 0x38, 0x38,
			0x86, 0x86, 0x86, 0xA3, 0xA3, 0xA3, 0xA1, 0xA1, 0xA1, 0x9E, 0x9E, 0x9E,
			0xEB, 0xEB, 0xEB, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xBD, 0xBD, 0xBD,
			0x20, 0x20, 0x20, 0x3D, 0x3D, 0x3D, 0x48, 0x48, 0x48, 0x4C, 0x4B, 0x4A,
			0x51, 0x51, 0x51, 0x58, 0x58, 0x58, 0x5C, 0x5B, 0x59, 0x5D, 0x5B, 0x5C,
			0x53, 0x52, 0x50, 0x4B, 0x4A, 0x48, 0x36, 0x35, 0x34, 0x3C, 0x3B, 0x39,
			0x49, 0x48, 0x46, 0x4D, 0x4D, 0x4C, 0x68, 0x67, 0x65, 0x66, 0x64, 0x65,
			0x6A, 0x69, 0x68, 0x6F, 0x6D, 0x6D, 0x5F, 0x5E, 0x5C, 0x6F, 0x6E, 0x6E,
			0x62, 0x62, 0x62, 0xA5, 0xA5, 0xA5, 0x9C, 0x9C, 0x9C, 0x87, 0x87, 0x88,
			0x7B, 0x7B, 0x7B, 0x62, 0x62, 0x62, 0x54, 0x52, 0x53, 0x8D, 0x8D, 0x8D,
			0x79, 0x79, 0x79, 0x7F, 0x7F, 0x7F, 0x6B, 0x6B, 0x6B, 0x75, 0x75, 0x75,
			0x8A, 0x8A, 0x8A, 0x98, 0x98, 0x98, 0xAC, 0xAC, 0xAC, 0x63, 0x63, 0x63,
			0x85, 0x85, 0x85, 0x68, 0x68, 0x68, 0x67, 0x67, 0x67, 0x5D, 0x5D, 0x5D,
			0x60, 0x60, 0x60, 0x58, 0x58, 0x57, 0x65, 0x65, 0x65, 0x55, 0x55, 0x55,
			0x5A, 0x5A, 0x5A, 0x7A, 0x7A, 0x7A, 0x7B, 0x7B, 0x7B, 0x5D, 0x5D, 0x5D,
			0x56, 0x56, 0x56, 0x5B, 0x5B, 0x5B, 0x5D, 0x5D, 0x5D, 0x40, 0x40, 0x3F,
			0x4B, 0x4B, 0x49, 0x2D, 0x2C, 0x2A, 0x29, 0x28, 0x26, 0x48, 0x48, 0x48,
			0x7E, 0x7E, 0x7D, 0xA1, 0xA1, 0xA1, 0x9F, 0x9F, 0x9F, 0x9D, 0x9D, 0x9D,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xC1, 0xC1, 0xC1,
			0x3F, 0x3F, 0x3D, 0x76, 0x76, 0x76, 0x64, 0x62, 0x62, 0x42, 0x41, 0x3F,
			0x39, 0x38, 0x36, 0x3B, 0x3A, 0x38, 0x4A, 0x49, 0x47, 0x46, 0x46, 0x44,
			0x48, 0x47, 0x45, 0x4B, 0x4A, 0x48, 0x42, 0x41, 0x3F, 0x2D, 0x2C, 0x2B,
			0x49, 0x48, 0x46, 0x51, 0x50, 0x4E, 0x5F, 0x5E, 0x5C, 0x55, 0x54, 0x52,
			0x5A, 0x59, 0x57, 0x62, 0x61, 0x5F, 0x6A, 0x69, 0x67, 0x79, 0x78, 0x76,
			0x5B, 0x5A, 0x5B, 0xDF, 0xE0, 0xE0, 0xF0, 0xCE, 0xCB, 0xEF, 0xD3, 0xD0,
			0xF0, 0xE7, 0xE7, 0xE9, 0xEA, 0xEA, 0xC2, 0xC2, 0xC2, 0x74, 0x74, 0x74,
			0x7A, 0x7A, 0x7A, 0xB9, 0xB9, 0xB9, 0xE2, 0xE3, 0xE3, 0xE8, 0xE3, 0xE1,
			0xE7, 0xC7, 0xC3, 0xDE, 0xAC, 0xAA, 0xE2, 0xE3, 0xE3, 0x63, 0x63, 0x63,
			0x75, 0x75, 0x75, 0x80, 0x80, 0x80, 0x60, 0x5E, 0x5F, 0x69, 0x69, 0x69,
			0x77, 0x77, 0x77, 0x6E, 0x6C, 0x6D, 0x60, 0x60, 0x60, 0x56, 0x55, 0x55,
			0x80, 0x80, 0x80, 0x71, 0x71, 0x71, 0x77, 0x77, 0x77, 0x61, 0x61, 0x61,
			0x66, 0x66, 0x66, 0x4F, 0x4F, 0x4F, 0x53, 0x53, 0x51, 0x4C, 0x4C, 0x4A,
			0x40, 0x40, 0x3E, 0x32, 0x31, 0x30, 0x37, 0x36, 0x34, 0x41, 0x41, 0x41,
			0x82, 0x81, 0x81, 0x9F, 0x9F, 0x9F, 0x9E, 0x9E, 0x9E, 0x9B, 0x9B, 0x9B,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xBD, 0xBD, 0xBC,
			0x55, 0x55, 0x55, 0x60, 0x5E, 0x5E, 0x5B, 0x5A, 0x58, 0x2D, 0x2C, 0x2B,
			0x39, 0x38, 0x36, 0x35, 0x34, 0x32, 0x35, 0x34, 0x33, 0x4A, 0x49, 0x47,
			0x3F, 0x3D, 0x3B, 0x43, 0x41, 0x3F, 0x48, 0x46, 0x45, 0x30, 0x2E, 0x2E,
			0x39, 0x38, 0x36, 0x37, 0x36, 0x34, 0x48, 0x47, 0x45, 0x43, 0x42, 0x41,
			0x58, 0x57, 0x54, 0x55, 0x54, 0x52, 0x62, 0x61, 0x5F, 0x75, 0x74, 0x72,
			0x6A, 0x68, 0x69, 0xE0, 0xE1, 0xE1, 0xDD, 0x42, 0x45, 0xD2, 0x0E, 0x17,
			0xD2, 0x18, 0x1C, 0xD5, 0x39, 0x36, 0xD8, 0x9E, 0x9D, 0xC3, 0xC3, 0xC3,
			0xAE, 0xAE, 0xAE, 0xEB, 0xB4, 0xAF, 0xDC, 0x50, 0x4A, 0xD3, 0x32, 0x2B,
			0xCB, 0x13, 0x11, 0xBF, 0x22, 0x25, 0xD9, 0xDB, 0xDB, 0x6A, 0x6A, 0x6A,
			0x83, 0x83, 0x83, 0x7E, 0x7E, 0x7E, 0x7A, 0x7A, 0x7A, 0x68, 0x68, 0x66,
			0x64, 0x64, 0x62, 0x7B, 0x7B, 0x7B, 0x61, 0x61, 0x61, 0x63, 0x63, 0x63,
			0x74, 0x74, 0x74, 0x78, 0x78, 0x78, 0x74, 0x74, 0x74, 0x6A, 0x6A, 0x6A,
			0x48, 0x48, 0x48, 0x44, 0x44, 0x44, 0x42, 0x42, 0x40, 0x47, 0x47, 0x45,
			0x56, 0x55, 0x53, 0x56, 0x55, 0x53, 0x55, 0x55, 0x53, 0x39, 0x38, 0x38,
			0x81, 0x81, 0x81, 0x9D, 0x9D, 0x9D, 0x9C, 0x9C, 0x9C, 0x99, 0x99, 0x99,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xC0, 0xC0, 0xC0,
			0x3A, 0x39, 0x37, 0x2E, 0x2D, 0x2C, 0x39, 0x38, 0x37, 0x47, 0x47, 0x47,
			0x40, 0x40, 0x3F, 0x43, 0x43, 0x42, 0x40, 0x40, 0x40, 0x53, 0x52, 0x51,
			0x50, 0x4F, 0x4E, 0x4D, 0x4B, 0x4B, 0x4D, 0x4C, 0x4A, 0x3D, 0x3D, 0x3D,
			0x4C, 0x4B, 0x4A, 0x4B, 0x4B, 0x4A, 0x45, 0x44, 0x44, 0x5B, 0x5A, 0x59,
			0x59, 0x58, 0x56, 0x4D, 0x4C, 0x4C, 0x5F, 0x5D, 0x5C, 0x6B, 0x6B, 0x6A,
			0x66, 0x66, 0x66, 0xE1, 0xE3, 0xE3, 0xDA, 0x43, 0x41, 0xCF, 0x0C, 0x15,
			0xCD, 0x0C, 0x13, 0xC1, 0x37, 0x37, 0xCE, 0xAE, 0xAD, 0xDE, 0xDE, 0xDE,
			0xC4, 0xC4, 0xC4, 0xDD, 0xB9, 0xB8, 0xD5, 0x45, 0x44, 0xCC, 0x16, 0x15,
			0xCB, 0x14, 0x12, 0xBD, 0x25, 0x26, 0xD9, 0xDA, 0xDB, 0x68, 0x68, 0x68,
			0x65, 0x65, 0x64, 0x6B, 0x6B, 0x6A, 0x5D, 0x5D, 0x5D, 0x55, 0x55, 0x55,
			0x6D, 0x6D, 0x6C, 0x68, 0x68, 0x67, 0x55, 0x55, 0x55, 0x6A, 0x6A, 0x69,
			0x4D, 0x4D, 0x4D, 0x64, 0x64, 0x64, 0x56, 0x56, 0x56, 0x49, 0x49, 0x48,
			0x46, 0x46, 0x46, 0x4D, 0x4D, 0x4D, 0x43, 0x43, 0x42, 0x48, 0x48, 0x47,
			0x51, 0x51, 0x50, 0x4A, 0x49, 0x47, 0x4C, 0x4C, 0x4A, 0x2F, 0x2F, 0x2D,
			0x7B, 0x7B, 0x7B, 0x9B, 0x9B, 0x9B, 0x9A, 0x9A, 0x9A, 0x97, 0x97, 0x97,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xBD, 0xBD, 0xBD,
			0x2A, 0x29, 0x27, 0x1A, 0x19, 0x1A, 0x26, 0x24, 0x25, 0x82, 0x82, 0x82,
			0xFD, 0xFD, 0xFD, 0xFE, 0xFC, 0xFB, 0xFE, 0xFC, 0xFB, 0xFD, 0xFB, 0xFA,
			0xFC, 0xF8, 0xF8, 0xFC, 0xFA, 0xF8, 0xFB, 0xFB, 0xFA, 0xFA, 0xF9, 0xF8,
			0xF9, 0xF7, 0xF6, 0xF8, 0xF5, 0xF5, 0xF6, 0xF4, 0xF3, 0xF7, 0xF4, 0xF4,
			0xF7, 0xF4, 0xF3, 0xF4, 0xF2, 0xF1, 0xF3, 0xF1, 0xF0, 0xF2, 0xEF, 0xEE,
			0xF1, 0xF0, 0xEF, 0xEF, 0xF1, 0xF1, 0xD9, 0x3D, 0x3A, 0xCD, 0x0E, 0x12,
			0xCC, 0x11, 0x13, 0xC6, 0x87, 0x88, 0xB6, 0xB6, 0xB5, 0x95, 0x95, 0x95,
			0x8C, 0x8C, 0x8C, 0xAC, 0xAC, 0xAC, 0xE3, 0xA0, 0x9E, 0xCB, 0x14, 0x14,
			0xCB, 0x13, 0x13, 0xBD, 0x27, 0x27, 0xCF, 0xD0, 0xD0, 0xD8, 0xD7, 0xD6,
			0xD9, 0xD6, 0xD5, 0xD6, 0xD4, 0xD4, 0xD4, 0xD3, 0xD2, 0xD2, 0xD0, 0xCF,
			0xCD, 0xCB, 0xCA, 0xCC, 0xCA, 0xCA, 0xCB, 0xCA, 0xC9, 0xC8, 0xC6, 0xC5,
			0xC5, 0xC2, 0xC2, 0xC2, 0xBF, 0xBF, 0xC1, 0xBE, 0xBD, 0xBE, 0xBA, 0xBA,
			0xBD, 0xBA, 0xB9, 0xBB, 0xB7, 0xB7, 0xB3, 0xB1, 0xB1, 0xAE, 0xAE, 0xAE,
			0x88, 0x88, 0x88, 0x53, 0x52, 0x50, 0x4E, 0x4E, 0x4E, 0x3A, 0x3A, 0x38,
			0x7E, 0x7E, 0x7E, 0x99, 0x99, 0x99, 0x98, 0x98, 0x98, 0x95, 0x95, 0x95,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xBD, 0xBD, 0xBC,
			0x2C, 0x2B, 0x29, 0x18, 0x18, 0x18, 0x1D, 0x1D, 0x1D, 0x24, 0x22, 0x23,
			0x88, 0x88, 0x88, 0xF9, 0xEE, 0xED, 0xDA, 0x4D, 0x4B, 0xD0, 0x21, 0x1E,
			0xD1, 0x25, 0x20, 0xD1, 0x23, 0x1F, 0xD1, 0x25, 0x22, 0xD1, 0x20, 0x1D,
			0xD4, 0x28, 0x25, 0xD3, 0x1E, 0x1F, 0xD4, 0x1B, 0x1F, 0xD6, 0x0F, 0x1A,
			0xD4, 0x17, 0x1E, 0xD3, 0x1C, 0x20, 0xD1, 0x18, 0x19, 0xC8, 0x33, 0x30,
			0xD6, 0xC3, 0xC3, 0xED, 0xEF, 0xEF, 0xD8, 0x3C, 0x3A, 0xCB, 0x14, 0x13,
			0xCC, 0x16, 0x13, 0xC5, 0x8F, 0x8D, 0xA0, 0xA0, 0xA0, 0x75, 0x75, 0x73,
			0x83, 0x83, 0x83, 0x91, 0x90, 0x90, 0xE7, 0xAC, 0xA4, 0xCB, 0x14, 0x14,
			0xCC, 0x15, 0x14, 0xBE, 0x28, 0x28, 0xCE, 0xD0, 0xD0, 0xD9, 0xC1, 0xC1,
			0xD7, 0x38, 0x38, 0xD7, 0x2A, 0x2F, 0xD9, 0x19, 0x23, 0xDC, 0x1D, 0x28,
			0xD9, 0x22, 0x2B, 0xD4, 0x1A, 0x1F, 0xD1, 0x23, 0x20, 0xD3, 0x27, 0x22,
			0xD1, 0x23, 0x1F, 0xCF, 0x19, 0x17, 0xD0, 0x16, 0x17, 0xD1, 0x1D, 0x1B,
			0xD0, 0x17, 0x16, 0xBF, 0x2E, 0x2E, 0xA2, 0x96, 0x96, 0x88, 0x88, 0x88,
			0x4D, 0x4D, 0x4B, 0x46, 0x46, 0x44, 0x43, 0x43, 0x41, 0x3D, 0x3D, 0x3C,
			0x7A, 0x7A, 0x7A, 0x97, 0x97, 0x97, 0x96, 0x96, 0x96, 0x93, 0x93, 0x93,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xB8, 0xB8, 0xB8,
			0x22, 0x22, 0x21, 0x1E, 0x1E, 0x1E, 0x1F, 0x1F, 0x1F, 0x22, 0x22, 0x22,
			0x0F, 0x0F, 0x0F, 0x7F, 0x7F, 0x7F, 0xF7, 0xE4, 0xE3, 0xD9, 0x76, 0x76,
			0xD5, 0x70, 0x6F, 0xD4, 0x71, 0x71, 0xD3, 0x6F, 0x6F, 0xD4, 0x73, 0x72,
			0xD3, 0x73, 0x72, 0xD1, 0x6E, 0x6E, 0xD5, 0x6C, 0x71, 0xD6, 0x6B, 0x71,
			0xD9, 0x47, 0x4D, 0xD4, 0x03, 0x13, 0xCA, 0x1C, 0x27, 0xD6, 0xC4, 0xC3,
			0xEE, 0xEC, 0xEB, 0xEE, 0xED, 0xEB, 0xDB, 0x52, 0x4F, 0xCB, 0x15, 0x14,
			0xCC, 0x18, 0x16, 0xC3, 0x8E, 0x8C, 0xA3, 0xA3, 0xA3, 0x7C, 0x7C, 0x79,
			0x7B, 0x7A, 0x79, 0x91, 0x91, 0x91, 0xE3, 0x9D, 0x9A, 0xCC, 0x14, 0x15,
			0xCD, 0x19, 0x18, 0xBE, 0x27, 0x25, 0xD0, 0xD2, 0xD1, 0xD5, 0xD3, 0xD1,
			0xD9, 0xC4, 0xC0, 0xD5, 0x40, 0x40, 0xCE, 0x0B, 0x13, 0xC2, 0x35, 0x3E,
			0xC0, 0x58, 0x5E, 0xBF, 0x57, 0x5B, 0xBB, 0x59, 0x59, 0xB9, 0x5B, 0x5B,
			0xB8, 0x5B, 0x5A, 0xB8, 0x5B, 0x5A, 0xB7, 0x5A, 0x5A, 0xB7, 0x59, 0x59,
			0xB2, 0x57, 0x57, 0x9F, 0x97, 0x97, 0x86, 0x85, 0x85, 0x54, 0x54, 0x52,
			0x51, 0x51, 0x4F, 0x3A, 0x3A, 0x38, 0x2B, 0x2B, 0x2A, 0x19, 0x19, 0x19,
			0x73, 0x73, 0x73, 0x95, 0x95, 0x95, 0x94, 0x94, 0x94, 0x91, 0x91, 0x91,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xBB, 0xBB, 0xBB,
			0x1A, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x15, 0x15, 0x15, 0x20, 0x20, 0x20,
			0x1E, 0x1E, 0x1E, 0x0E, 0x0E, 0x0E, 0x78, 0x78, 0x78, 0xFC, 0xFB, 0xFB,
			0xEF, 0xB2, 0xB0, 0xE6, 0x8C, 0x89, 0xE6, 0x8A, 0x88, 0xE6, 0x8D, 0x8A,
			0xE6, 0x96, 0x90, 0xE4, 0x84, 0x82, 0xE2, 0x80, 0x7F, 0xE3, 0x80, 0x7E,
			0xD9, 0x25, 0x2B, 0xD7, 0x08, 0x17, 0xD7, 0x11, 0x1E, 0xD9, 0x17, 0x21,
			0xD5, 0x0E, 0x17, 0xD3, 0x1F, 0x1C, 0xCD, 0x1B, 0x1A, 0xCB, 0x15, 0x12,
			0xCB, 0x15, 0x13, 0xC2, 0x8C, 0x8B, 0xA0, 0x9F, 0x9F, 0x6A, 0x69, 0x67,
			0x77, 0x76, 0x73, 0x8B, 0x8B, 0x8B, 0xE3, 0xA3, 0xA0, 0xCE, 0x19, 0x19,
			0xCD, 0x17, 0x15, 0xCC, 0x17, 0x16, 0xD3, 0x28, 0x26, 0xD1, 0x1D, 0x19,
			0xD1, 0x1D, 0x1A, 0xD0, 0x25, 0x21, 0xCB, 0x12, 0x12, 0xCA, 0x19, 0x1B,
			0xCD, 0x65, 0x68, 0xD0, 0x74, 0x71, 0xCE, 0x75, 0x71, 0xCC, 0x6F, 0x6C,
			0xCA, 0x6F, 0x6C, 0xCA, 0x6D, 0x6B, 0xC8, 0x69, 0x67, 0xB3, 0x76, 0x75,
			0xAC, 0xAC, 0xAC, 0x86, 0x86, 0x86, 0x50, 0x50, 0x4F, 0x4D, 0x4D, 0x4B,
			0x57, 0x57, 0x55, 0x30, 0x30, 0x30, 0x1E, 0x1E, 0x1E, 0x1B, 0x1B, 0x1B,
			0x72, 0x72, 0x72, 0x93, 0x93, 0x93, 0x92, 0x92, 0x92, 0x90, 0x90, 0x90,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xB9, 0xB9, 0xB9,
			0x1A, 0x1A, 0x19, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1B, 0x1B, 0x1B,
			0x19, 0x19, 0x19, 0x1E, 0x1E, 0x1E, 0x11, 0x11, 0x11, 0x7B, 0x7B, 0x7B,
			0xF9, 0xF1, 0xEF, 0xD5, 0x45, 0x42, 0xCA, 0x1C, 0x1B, 0xC9, 0x17, 0x16,
			0xCB, 0x18, 0x18, 0xC9, 0x1A, 0x19, 0xC9, 0x17, 0x17, 0xCA, 0x19, 0x19,
			0xCE, 0x17, 0x1E, 0xCF, 0x16, 0x1E, 0xD3, 0x15, 0x20, 0xD4, 0x15, 0x21,
			0xD1, 0x11, 0x1C, 0xCC, 0x16, 0x1C, 0xC9, 0x1D, 0x1D, 0xC8, 0x1E, 0x1E,
			0xCD, 0x2C, 0x2A, 0xC4, 0x9E, 0x9B, 0x9F, 0x9F, 0x9F, 0x59, 0x59, 0x57,
			0x5A, 0x59, 0x58, 0x8A, 0x8A, 0x89, 0xE4, 0xC6, 0xBF, 0xCC, 0x2B, 0x29,
			0xCA, 0x1F, 0x1F, 0xC9, 0x1E, 0x1E, 0xC9, 0x1D, 0x1F, 0xC9, 0x1F, 0x1E,
			0xC8, 0x1F, 0x1F, 0xC8, 0x1E, 0x1E, 0xC9, 0x1E, 0x1D, 0xCA, 0x1D, 0x1D,
			0xCB, 0x10, 0x16, 0xCB, 0x15, 0x17, 0xC9, 0x17, 0x16, 0xC8, 0x17, 0x16,
			0xC8, 0x17, 0x16, 0xC9, 0x1B, 0x19, 0xB7, 0x28, 0x27, 0xA0, 0x96, 0x96,
			0x7C, 0x7C, 0x7C, 0x30, 0x30, 0x30, 0x59, 0x59, 0x57, 0x44, 0x44, 0x42,
			0x3E, 0x3E, 0x3D, 0x25, 0x25, 0x25, 0x19, 0x19, 0x19, 0x18, 0x18, 0x18,
			0x70, 0x70, 0x70, 0x91, 0x91, 0x91, 0x90, 0x90, 0x90, 0x8E, 0x8E, 0x8E,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xB8, 0xB8, 0xB8,
			0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F,
			0x21, 0x21, 0x21, 0x24, 0x24, 0x24, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
			0x78, 0x78, 0x78, 0xF7, 0xF8, 0xF8, 0xF3, 0xF3, 0xF2, 0xF0, 0xEF, 0xEF,
			0xEF, 0xEF, 0xEE, 0xEE, 0xEE, 0xEE, 0xED, 0xED, 0xEC, 0xEC, 0xEC, 0xEB,
			0xEB, 0xEC, 0xEB, 0xE8, 0xEB, 0xEA, 0xE5, 0xE8, 0xE7, 0xE5, 0xE7, 0xE6,
			0xE2, 0xE4, 0xE3, 0xE1, 0xE3, 0xE2, 0xDD, 0xDF, 0xDE, 0xDC, 0xDE, 0xDD,
			0xDB, 0xDD, 0xDC, 0xD9, 0xD9, 0xD9, 0xDE, 0xDE, 0xDE, 0xDC, 0xDC, 0xDC,
			0xDB, 0xDC, 0xDC, 0xD7, 0xD7, 0xD7, 0xD6, 0xD6, 0xD6, 0xCF, 0xD1, 0xD0,
			0xCD, 0xD0, 0xCF, 0xCB, 0xCD, 0xCC, 0xC9, 0xCC, 0xCA, 0xC5, 0xC7, 0xC6,
			0xC1, 0xC3, 0xC3, 0xBF, 0xC1, 0xC1, 0xBB, 0xBD, 0xBC, 0xBA, 0xBC, 0xBB,
			0xB3, 0xB3, 0xB2, 0xB1, 0xB1, 0xB0, 0xAE, 0xAE, 0xAD, 0xAB, 0xAA, 0xA9,
			0xAA, 0xAA, 0xA9, 0xA8, 0xA8, 0xA8, 0xAA, 0xAA, 0xAA, 0x76, 0x76, 0x76,
			0x2D, 0x2D, 0x2D, 0x3C, 0x3C, 0x3B, 0x3E, 0x3E, 0x3C, 0x27, 0x27, 0x26,
			0x1F, 0x1F, 0x1F, 0x23, 0x23, 0x23, 0x2A, 0x2A, 0x28, 0x22, 0x22, 0x22,
			0x70, 0x70, 0x70, 0x90, 0x90, 0x90, 0x8E, 0x8E, 0x8E, 0x8C, 0x8C, 0x8C,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xB8, 0xB8, 0xB8,
			0x12, 0x12, 0x12, 0x18, 0x18, 0x18, 0x1D, 0x1D, 0x1D, 0x21, 0x21, 0x21,
			0x21, 0x21, 0x21, 0x26, 0x26, 0x26, 0x1C, 0x1C, 0x1C, 0x0E, 0x0E, 0x0E,
			0x15, 0x15, 0x15, 0x74, 0x74, 0x74, 0xF9, 0xF2, 0xF1, 0xDF, 0x5F, 0x5B,
			0xD3, 0x26, 0x27, 0xD6, 0x2D, 0x30, 0xD2, 0x23, 0x23, 0xD4, 0x28, 0x28,
			0xD5, 0x23, 0x28, 0xD3, 0x23, 0x24, 0xD2, 0x1D, 0x21, 0xD5, 0x16, 0x20,
			0xD6, 0x1B, 0x24, 0xD5, 0x1F, 0x26, 0xD2, 0x24, 0x24, 0xD0, 0x25, 0x23,
			0xD2, 0x26, 0x25, 0xC4, 0x8E, 0x8C, 0xE5, 0xAA, 0xA7, 0xD6, 0x3A, 0x36,
			0xD1, 0x25, 0x23, 0xC0, 0x7C, 0x7B, 0xE4, 0xB5, 0xB0, 0xD2, 0x28, 0x26,
			0xD0, 0x23, 0x21, 0xD1, 0x25, 0x23, 0xCF, 0x23, 0x20, 0xD1, 0x26, 0x23,
			0xD3, 0x34, 0x30, 0xD3, 0x36, 0x30, 0xD2, 0x28, 0x25, 0xD2, 0x2D, 0x29,
			0xD3, 0x32, 0x2D, 0xD4, 0x33, 0x2F, 0xD3, 0x29, 0x27, 0xD5, 0x2E, 0x2B,
			0xC1, 0x3C, 0x3A, 0xA6, 0x9C, 0x9C, 0x75, 0x75, 0x75, 0x13, 0x13, 0x13,
			0x2D, 0x2D, 0x2D, 0x1D, 0x1D, 0x1E, 0x22, 0x22, 0x22, 0x2C, 0x2C, 0x2B,
			0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x26, 0x26, 0x26, 0x20, 0x20, 0x20,
			0x6E, 0x6E, 0x6E, 0x8D, 0x8D, 0x8D, 0x8C, 0x8C, 0x8C, 0x8A, 0x8A, 0x8A,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xB9, 0xB9, 0xB9,
			0x16, 0x16, 0x16, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x10, 0x10, 0x10,
			0x20, 0x20, 0x20, 0x1A, 0x1A, 0x1A, 0x1F, 0x1F, 0x1F, 0x0B, 0x0B, 0x0B,
			0x1C, 0x1C, 0x1C, 0x10, 0x10, 0x10, 0x71, 0x71, 0x71, 0xF5, 0xE3, 0xE3,
			0xD5, 0x51, 0x52, 0xCE, 0x46, 0x47, 0xCD, 0x43, 0x45, 0xCB, 0x3F, 0x44,
			0xCC, 0x3C, 0x43, 0xCC, 0x3D, 0x43, 0xC9, 0x38, 0x3D, 0xC9, 0x3B, 0x3F,
			0xCB, 0x39, 0x3F, 0xC8, 0x35, 0x3C, 0xCE, 0x2D, 0x2C, 0xCB, 0x14, 0x14,
			0xCB, 0x14, 0x13, 0xBF, 0x86, 0x84, 0xE1, 0x98, 0x97, 0xCE, 0x1D, 0x1B,
			0xCB, 0x14, 0x14, 0xBB, 0x73, 0x74, 0xE2, 0xAD, 0xA8, 0xCB, 0x13, 0x11,
			0xCB, 0x15, 0x14, 0xC5, 0x25, 0x25, 0xC0, 0x36, 0x35, 0xBF, 0x36, 0x35,
			0xC0, 0x36, 0x35, 0xBE, 0x35, 0x34, 0xBD, 0x35, 0x33, 0xBD, 0x34, 0x35,
			0xBD, 0x32, 0x34, 0xBE, 0x34, 0x38, 0xBE, 0x33, 0x37, 0xB7, 0x3A, 0x3D,
			0xA1, 0x97, 0x97, 0x6C, 0x6C, 0x6C, 0x2F, 0x2F, 0x2F, 0x18, 0x18, 0x18,
			0x16, 0x16, 0x16, 0x1E, 0x1E, 0x1E, 0x21, 0x21, 0x21, 0x16, 0x16, 0x16,
			0x25, 0x25, 0x25, 0x28, 0x28, 0x28, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21,
			0x6D, 0x6D, 0x6D, 0x8C, 0x8C, 0x8C, 0x8B, 0x8B, 0x8B, 0x89, 0x89, 0x89,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xB8, 0xB8, 0xB8,
			0x11, 0x11, 0x11, 0x16, 0x16, 0x16, 0x14, 0x14, 0x14, 0x1A, 0x1A, 0x1A,
			0x1D, 0x1D, 0x1D, 0x19, 0x19, 0x19, 0x21, 0x21, 0x21, 0x18, 0x18, 0x18,
			0x10, 0x10, 0x10, 0x13, 0x13, 0x13, 0x10, 0x10, 0x10, 0x6D, 0x6D, 0x6D,
			0xC9, 0xC8, 0xC9, 0xC8, 0xC8, 0xC8, 0xC7, 0xC7, 0xC7, 0xC4, 0xC3, 0xC4,
			0xC2, 0xC2, 0xC2, 0xC1, 0xC0, 0xC1, 0xC0, 0xC0, 0xC0, 0xBE, 0xBE, 0xBE,
			0xBC, 0xBC, 0xBC, 0xD6, 0xD6, 0xD6, 0xE1, 0x84, 0x83, 0xCC, 0x17, 0x15,
			0xCC, 0x13, 0x14, 0xC1, 0x85, 0x87, 0xE4, 0xA5, 0xA4, 0xD0, 0x18, 0x1C,
			0xCE, 0x0B, 0x14, 0xBB, 0x71, 0x74, 0xE0, 0xA6, 0xA0, 0xCA, 0x13, 0x13,
			0xCB, 0x12, 0x12, 0xB3, 0x5A, 0x5A, 0xC2, 0xC3, 0xC3, 0xA7, 0xA7, 0xA7,
			0xA5, 0xA5, 0xA5, 0xA4, 0xA4, 0xA4, 0xA2, 0xA2, 0xA2, 0x9E, 0x9F, 0x9F,
			0x9C, 0x9C, 0x9C, 0x9A, 0x9A, 0x9A, 0x99, 0x99, 0x99, 0x97, 0x96, 0x97,
			0x7B, 0x7B, 0x7A, 0x17, 0x17, 0x17, 0x0C, 0x0C, 0x0C, 0x2B, 0x2B, 0x2B,
			0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x20, 0x20, 0x20,
			0x20, 0x20, 0x20, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x1E, 0x1E, 0x1E,
			0x6C, 0x6C, 0x6C, 0x8A, 0x8A, 0x8A, 0x89, 0x89, 0x89, 0x87, 0x87, 0x87,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xB8, 0xB8, 0xB8,
			0x10, 0x10, 0x10, 0x15, 0x15, 0x15, 0x16, 0x16, 0x16, 0x1C, 0x1C, 0x1C,
			0x1C, 0x1C, 0x1C, 0x17, 0x17, 0x17, 0x1D, 0x1D, 0x1D, 0x21, 0x21, 0x21,
			0x11, 0x11, 0x11, 0x10, 0x10, 0x10, 0x1C, 0x1C, 0x1C, 0x20, 0x20, 0x20,
			0x1D, 0x1D, 0x1D, 0x1A, 0x1A, 0x1A, 0x24, 0x24, 0x24, 0x26, 0x26, 0x26,
			0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x2D, 0x2D, 0x2D, 0x35, 0x35, 0x35,
			0x31, 0x31, 0x31, 0x98, 0x97, 0x98, 0xE2, 0x84, 0x84, 0xCD, 0x14, 0x14,
			0xCD, 0x16, 0x14, 0xC0, 0x86, 0x85, 0xE6, 0xB2, 0xB0, 0xCD, 0x08, 0x12,
			0xCF, 0x0A, 0x16, 0xBD, 0x72, 0x76, 0xDF, 0x9B, 0x97, 0xCD, 0x0B, 0x14,
			0xCD, 0x0D, 0x13, 0xB5, 0x59, 0x5B, 0x96, 0x96, 0x96, 0x2A, 0x2A, 0x2A,
			0x31, 0x31, 0x31, 0x3D, 0x3E, 0x3A, 0x39, 0x39, 0x37, 0x38, 0x39, 0x36,
			0x37, 0x37, 0x36, 0x38, 0x38, 0x36, 0x43, 0x43, 0x42, 0x38, 0x38, 0x36,
			0x42, 0x42, 0x40, 0x37, 0x37, 0x36, 0x11, 0x11, 0x11, 0x15, 0x15, 0x15,
			0x1E, 0x1E, 0x1E, 0x16, 0x16, 0x16, 0x27, 0x27, 0x27, 0x15, 0x15, 0x15,
			0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x20, 0x20, 0x20, 0x1B, 0x1B, 0x1B,
			0x6A, 0x6A, 0x6A, 0x88, 0x88, 0x88, 0x87, 0x87, 0x87, 0x85, 0x85, 0x85,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xB9, 0xB9, 0xB9,
			0x11, 0x11, 0x11, 0x16, 0x16, 0x16, 0x17, 0x17, 0x17, 0x1A, 0x1A, 0x1A,
			0x1A, 0x1A, 0x1A, 0x1D, 0x1D, 0x1D, 0x20, 0x20, 0x20, 0x1D, 0x1D, 0x1D,
			0x12, 0x12, 0x12, 0x0D, 0x0D, 0x0D, 0x18, 0x18, 0x18, 0x20, 0x20, 0x20,
			0x25, 0x25, 0x25, 0x1F, 0x1F, 0x1F, 0x2A, 0x2A, 0x2A, 0x24, 0x24, 0x24,
			0x2C, 0x2C, 0x2C, 0x2B, 0x2B, 0x2B, 0x31, 0x31, 0x31, 0x32, 0x32, 0x32,
			0x32, 0x32, 0x32, 0x98, 0x97, 0x97, 0xE3, 0x7C, 0x82, 0xCE, 0x0C, 0x14,
			0xCB, 0x13, 0x12, 0xBE, 0x86, 0x84, 0xE2, 0x9D, 0x9A, 0xCC, 0x0F, 0x13,
			0xCF, 0x0C, 0x15, 0xBD, 0x72, 0x76, 0xE0, 0x96, 0x95, 0xD5, 0x06, 0x15,
			0xD2, 0x03, 0x13, 0xB6, 0x53, 0x5B, 0x97, 0x97, 0x97, 0x31, 0x31, 0x31,
			0x29, 0x29, 0x29, 0x38, 0x38, 0x36, 0x37, 0x37, 0x35, 0x33, 0x32, 0x32,
			0x34, 0x34, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x30, 0x2A, 0x2A, 0x2A,
			0x3C, 0x3C, 0x3B, 0x4B, 0x4B, 0x4A, 0x2D, 0x2D, 0x2D, 0x16, 0x16, 0x16,
			0x10, 0x10, 0x10, 0x15, 0x15, 0x15, 0x14, 0x14, 0x14, 0x1D, 0x1D, 0x1D,
			0x12, 0x12, 0x12, 0x1F, 0x1F, 0x1F, 0x20, 0x20, 0x20, 0x1C, 0x1C, 0x1C,
			0x68, 0x68, 0x68, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x83, 0x83, 0x83,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xB6, 0xB6, 0xB6,
			0x0F, 0x0F, 0x0F, 0x17, 0x17, 0x17, 0x13, 0x13, 0x13, 0x0C, 0x0C, 0x0C,
			0x1C, 0x1C, 0x1C, 0x1F, 0x1F, 0x1F, 0x22, 0x22, 0x22, 0x1D, 0x1D, 0x1D,
			0x17, 0x17, 0x17, 0x07, 0x07, 0x07, 0x0A, 0x0A, 0x0A, 0x11, 0x11, 0x11,
			0x28, 0x28, 0x28, 0x26, 0x26, 0x26, 0x29, 0x29, 0x29, 0x22, 0x22, 0x22,
			0x2B, 0x2B, 0x2B, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x33, 0x33, 0x33,
			0x2E, 0x2E, 0x2E, 0x96, 0x96, 0x96, 0xE8, 0x9B, 0x9B, 0xD2, 0x05, 0x13,
			0xCC, 0x12, 0x12, 0xBE, 0x84, 0x83, 0xE2, 0xA1, 0x9D, 0xCB, 0x11, 0x12,
			0xCA, 0x14, 0x14, 0xBA, 0x70, 0x72, 0xDE, 0x98, 0x97, 0xD7, 0x08, 0x18,
			0xD6, 0x05, 0x17, 0xB9, 0x56, 0x5E, 0x96, 0x96, 0x96, 0x32, 0x32, 0x32,
			0x2F, 0x2F, 0x2F, 0x2C, 0x2C, 0x2C, 0x34, 0x34, 0x34, 0x2F, 0x2F, 0x2F,
			0x30, 0x30, 0x30, 0x28, 0x28, 0x28, 0x29, 0x29, 0x29, 0x2F, 0x2F, 0x2F,
			0x40, 0x40, 0x3F, 0x42, 0x42, 0x42, 0x37, 0x37, 0x37, 0x24, 0x24, 0x24,
			0x0C, 0x0C, 0x0C, 0x19, 0x19, 0x19, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
			0x18, 0x18, 0x18, 0x1C, 0x1C, 0x1C, 0x22, 0x22, 0x22, 0x1E, 0x1E, 0x1E,
			0x67, 0x67, 0x67, 0x85, 0x85, 0x85, 0x84, 0x84, 0x84, 0x82, 0x82, 0x82,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xB7, 0xB7, 0xB7,
			0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x10, 0x10, 0x10, 0x0F, 0x0F, 0x0F,
			0x17, 0x17, 0x17, 0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x18, 0x1B, 0x1B, 0x1B,
			0x1D, 0x1D, 0x1D, 0x12, 0x12, 0x12, 0x05, 0x05, 0x05, 0x0B, 0x0B, 0x0B,
			0x13, 0x13, 0x13, 0x24, 0x24, 0x24, 0x26, 0x26, 0x26, 0x1D, 0x1D, 0x1D,
			0x2D, 0x2D, 0x2D, 0x1C, 0x1C, 0x1C, 0x2B, 0x2B, 0x2B, 0x2F, 0x2F, 0x2F,
			0x2E, 0x2E, 0x2E, 0x96, 0x96, 0x96, 0xE7, 0x8C, 0x8E, 0xD5, 0x01, 0x14,
			0xCF, 0x05, 0x13, 0xBE, 0x82, 0x83, 0xE1, 0x9F, 0x9B, 0xCB, 0x12, 0x11,
			0xCA, 0x14, 0x13, 0xB8, 0x70, 0x72, 0xDE, 0x99, 0x96, 0xD4, 0x01, 0x13,
			0xD8, 0x09, 0x19, 0xBB, 0x62, 0x65, 0x95, 0x94, 0x95, 0x32, 0x32, 0x32,
			0x2D, 0x2D, 0x2D, 0x30, 0x30, 0x30, 0x28, 0x28, 0x28, 0x2B, 0x2B, 0x2B,
			0x28, 0x28, 0x28, 0x2B, 0x2B, 0x2B, 0x35, 0x35, 0x35, 0x30, 0x30, 0x30,
			0x35, 0x35, 0x35, 0x36, 0x36, 0x36, 0x32, 0x32, 0x32, 0x2C, 0x2C, 0x2C,
			0x17, 0x17, 0x17, 0x0A, 0x0A, 0x0A, 0x15, 0x15, 0x15, 0x13, 0x13, 0x13,
			0x1D, 0x1D, 0x1D, 0x21, 0x21, 0x21, 0x1F, 0x1F, 0x1F, 0x1C, 0x1C, 0x1C,
			0x66, 0x66, 0x66, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xB7, 0xB7, 0xB7,
			0x0F, 0x0F, 0x0F, 0x12, 0x12, 0x12, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
			0x17, 0x17, 0x17, 0x15, 0x15, 0x15, 0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x18,
			0x1C, 0x1C, 0x1C, 0x15, 0x15, 0x15, 0x07, 0x07, 0x07, 0x06, 0x06, 0x06,
			0x15, 0x15, 0x15, 0x22, 0x22, 0x22, 0x25, 0x25, 0x25, 0x1F, 0x1F, 0x1F,
			0x2A, 0x2A, 0x2A, 0x25, 0x25, 0x25, 0x2C, 0x2C, 0x2C, 0x26, 0x26, 0x26,
			0x19, 0x19, 0x19, 0x94, 0x94, 0x93, 0xE7, 0x8F, 0x90, 0xD8, 0x0B, 0x1A,
			0xD4, 0x03, 0x14, 0xBD, 0x7D, 0x81, 0xDE, 0x90, 0x8F, 0xCC, 0x13, 0x13,
			0xCA, 0x15, 0x12, 0xB8, 0x71, 0x72, 0xDF, 0x99, 0x96, 0xD0, 0x07, 0x14,
			0xD7, 0x07, 0x19, 0xB9, 0x60, 0x64, 0x93, 0x93, 0x93, 0x2C, 0x2C, 0x2C,
			0x2D, 0x2D, 0x2D, 0x30, 0x30, 0x30, 0x1E, 0x1E, 0x1E, 0x20, 0x20, 0x20,
			0x2C, 0x2C, 0x2C, 0x2D, 0x2D, 0x2D, 0x2F, 0x2F, 0x2F, 0x30, 0x30, 0x30,
			0x2F, 0x2F, 0x2F, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x16, 0x16, 0x16,
			0x18, 0x18, 0x18, 0x0E, 0x0E, 0x0E, 0x15, 0x15, 0x15, 0x17, 0x17, 0x17,
			0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1A, 0x1A, 0x1A, 0x19, 0x19, 0x19,
			0x63, 0x63, 0x63, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x7F, 0x7F, 0x7F,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xB7, 0xB7, 0xB7,
			0x0A, 0x0A, 0x0A, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x15, 0x15, 0x15,
			0x17, 0x17, 0x17, 0x18, 0x18, 0x18, 0x17, 0x17, 0x17, 0x19, 0x19, 0x19,
			0x18, 0x18, 0x18, 0x16, 0x16, 0x16, 0x17, 0x17, 0x17, 0x06, 0x06, 0x06,
			0x11, 0x11, 0x11, 0x1E, 0x1E, 0x1E, 0x23, 0x23, 0x23, 0x1C, 0x1C, 0x1C,
			0x23, 0x23, 0x23, 0x21, 0x21, 0x21, 0x2C, 0x2C, 0x2C, 0x17, 0x17, 0x17,
			0x17, 0x17, 0x17, 0x91, 0x91, 0x91, 0xE6, 0x86, 0x88, 0xD9, 0x0E, 0x1D,
			0xD8, 0x06, 0x17, 0xC1, 0x81, 0x84, 0xDF, 0x6A, 0x66, 0xCB, 0x14, 0x13,
			0xCB, 0x14, 0x12, 0xB9, 0x72, 0x73, 0xDD, 0x7C, 0x77, 0xCB, 0x11, 0x13,
			0xCF, 0x06, 0x13, 0xB7, 0x59, 0x5F, 0x90, 0x90, 0x90, 0x27, 0x27, 0x27,
			0x2D, 0x2D, 0x2D, 0x25, 0x25, 0x25, 0x27, 0x27, 0x27, 0x28, 0x28, 0x28,
			0x26, 0x26, 0x26, 0x2B, 0x2B, 0x2B, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
			0x2C, 0x2C, 0x2C, 0x28, 0x28, 0x28, 0x29, 0x29, 0x29, 0x23, 0x23, 0x23,
			0x1B, 0x1B, 0x1B, 0x1C, 0x1C, 0x1C, 0x10, 0x10, 0x10, 0x0E, 0x0E, 0x0E,
			0x14, 0x14, 0x14, 0x16, 0x16, 0x16, 0x11, 0x11, 0x11, 0x0E, 0x0E, 0x0E,
			0x61, 0x61, 0x61, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xB3, 0xB3, 0xB3,
			0x0C, 0x0C, 0x0C, 0x0E, 0x0E, 0x0E, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11,
			0x12, 0x12, 0x12, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x16, 0x16, 0x16,
			0x17, 0x17, 0x17, 0x18, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x0F, 0x0F, 0x0F,
			0x0D, 0x0D, 0x0D, 0x1B, 0x1B, 0x1B, 0x20, 0x20, 0x20, 0x1A, 0x1A, 0x1A,
			0x1A, 0x1A, 0x1A, 0x21, 0x21, 0x21, 0x28, 0x28, 0x28, 0x29, 0x29, 0x29,
			0x2B, 0x2B, 0x2B, 0x93, 0x93, 0x93, 0xE4, 0x8B, 0x8C, 0xD4, 0x03, 0x15,
			0xD6, 0x04, 0x15, 0xD2, 0x27, 0x30, 0xCD, 0x0D, 0x13, 0xCB, 0x14, 0x12,
			0xCB, 0x14, 0x14, 0xCF, 0x3D, 0x3A, 0xCD, 0x14, 0x13, 0xCC, 0x11, 0x13,
			0xCE, 0x0F, 0x15, 0xB4, 0x5B, 0x5E, 0x8F, 0x8F, 0x8F, 0x1B, 0x1B, 0x1B,
			0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
			0x27, 0x27, 0x27, 0x28, 0x28, 0x28, 0x2A, 0x2A, 0x2A, 0x29, 0x29, 0x29,
			0x29, 0x29, 0x29, 0x2A, 0x2A, 0x2A, 0x2E, 0x2E, 0x2E, 0x28, 0x28, 0x28,
			0x21, 0x21, 0x21, 0x1F, 0x1F, 0x1F, 0x1C, 0x1C, 0x1C, 0x18, 0x18, 0x18,
			0x18, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x0D, 0x0D, 0x0D, 0x06, 0x06, 0x06,
			0x5D, 0x5D, 0x5D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xB5, 0xB5, 0xB5,
			0x0A, 0x0A, 0x0A, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14,
			0x14, 0x14, 0x14, 0x13, 0x13, 0x13, 0x16, 0x16, 0x16, 0x12, 0x12, 0x12,
			0x16, 0x16, 0x16, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x16, 0x16, 0x16,
			0x0F, 0x0F, 0x0F, 0x19, 0x19, 0x19, 0x1A, 0x1A, 0x1A, 0x1F, 0x1F, 0x1F,
			0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29,
			0x27, 0x27, 0x27, 0x92, 0x92, 0x92, 0xE2, 0x84, 0x85, 0xCD, 0x0B, 0x12,
			0xD1, 0x0A, 0x15, 0xCC, 0x0E, 0x1A, 0xC8, 0x4A, 0x4B, 0xCB, 0x15, 0x13,
			0xCB, 0x12, 0x13, 0xCD, 0x20, 0x1F, 0xC8, 0x54, 0x51, 0xCC, 0x14, 0x14,
			0xCD, 0x12, 0x14, 0xB3, 0x59, 0x5C, 0x8F, 0x8F, 0x8F, 0x23, 0x23, 0x23,
			0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x27, 0x27, 0x27,
			0x28, 0x28, 0x28, 0x24, 0x24, 0x24, 0x28, 0x28, 0x28, 0x27, 0x27, 0x27,
			0x28, 0x28, 0x28, 0x2A, 0x2A, 0x2A, 0x2C, 0x2C, 0x2C, 0x24, 0x24, 0x24,
			0x20, 0x20, 0x20, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x19, 0x19, 0x19,
			0x0C, 0x0C, 0x0C, 0x15, 0x15, 0x15, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
			0x5F, 0x5F, 0x5F, 0x7D, 0x7D, 0x7D, 0x7C, 0x7C, 0x7C, 0x7B, 0x7B, 0x7B,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF5, 0xF5, 0xF5, 0xC6, 0xC6, 0xC6,
			0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x12, 0x12, 0x12,
			0x13, 0x13, 0x13, 0x0E, 0x0E, 0x0E, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
			0x14, 0x14, 0x14, 0x0A, 0x0A, 0x0A, 0x0F, 0x0F, 0x0F, 0x17, 0x17, 0x17,
			0x14, 0x14, 0x14, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x1D, 0x1D, 0x1D,
			0x20, 0x20, 0x20, 0x22, 0x22, 0x22, 0x1C, 0x1C, 0x1C, 0x27, 0x27, 0x27,
			0x27, 0x27, 0x27, 0x91, 0x91, 0x91, 0xE2, 0x8A, 0x89, 0xCC, 0x12, 0x12,
			0xCC, 0x1E, 0x22, 0xB5, 0x8F, 0x8E, 0xDD, 0x8E, 0x8E, 0xCB, 0x16, 0x13,
			0xCB, 0x15, 0x14, 0xB3, 0x69, 0x69, 0xDD, 0x9B, 0x99, 0xCB, 0x15, 0x13,
			0xCD, 0x12, 0x14, 0xAE, 0x6A, 0x6C, 0x8C, 0x8B, 0x8B, 0x10, 0x10, 0x10,
			0x16, 0x16, 0x16, 0x18, 0x18, 0x18, 0x19, 0x19, 0x19, 0x26, 0x26, 0x26,
			0x25, 0x25, 0x25, 0x23, 0x23, 0x23, 0x25, 0x25, 0x25, 0x26, 0x26, 0x26,
			0x27, 0x27, 0x27, 0x23, 0x23, 0x23, 0x27, 0x27, 0x27, 0x1C, 0x1C, 0x1C,
			0x1E, 0x1E, 0x1E, 0x1D, 0x1D, 0x1D, 0x1E, 0x1E, 0x1E, 0x1C, 0x1C, 0x1C,
			0x0B, 0x0B, 0x0B, 0x0F, 0x0F, 0x0F, 0x17, 0x17, 0x17, 0x14, 0x14, 0x14,
			0x65, 0x65, 0x65, 0x7C, 0x7C, 0x7C, 0x7B, 0x7B, 0x7B, 0x7A, 0x7A, 0x7A,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xE8, 0xE8, 0xE8,
			0x11, 0x11, 0x11, 0x0C, 0x0C, 0x0C, 0x0E, 0x0E, 0x0E, 0x12, 0x12, 0x12,
			0x14, 0x14, 0x14, 0x10, 0x10, 0x10, 0x0C, 0x0C, 0x0C, 0x12, 0x12, 0x12,
			0x12, 0x12, 0x12, 0x0E, 0x0E, 0x0E, 0x0C, 0x0C, 0x0C, 0x0F, 0x0F, 0x0F,
			0x0D, 0x0D, 0x0D, 0x13, 0x13, 0x13, 0x14, 0x14, 0x14, 0x17, 0x17, 0x17,
			0x1E, 0x1E, 0x1E, 0x1C, 0x1C, 0x1C, 0x21, 0x21, 0x21, 0x1F, 0x1F, 0x1F,
			0x20, 0x20, 0x20, 0x92, 0x92, 0x92, 0xE1, 0x8A, 0x88, 0xCA, 0x1A, 0x1B,
			0xB6, 0x8F, 0x8E, 0xD6, 0xD5, 0xD5, 0xDC, 0x8A, 0x8A, 0xCC, 0x17, 0x14,
			0xCB, 0x14, 0x14, 0xB7, 0x6F, 0x71, 0xDD, 0x9E, 0x9A, 0xCD, 0x19, 0x17,
			0xAF, 0x56, 0x55, 0xB6, 0xB6, 0xB6, 0x33, 0x33, 0x33, 0x16, 0x16, 0x16,
			0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0D, 0x0D, 0x0D, 0x1D, 0x1D, 0x1D,
			0x1D, 0x1D, 0x1D, 0x20, 0x20, 0x20, 0x25, 0x25, 0x25, 0x26, 0x26, 0x26,
			0x25, 0x25, 0x25, 0x24, 0x24, 0x24, 0x22, 0x22, 0x22, 0x1F, 0x1F, 0x1F,
			0x21, 0x21, 0x21, 0x1C, 0x1C, 0x1C, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B,
			0x0F, 0x0F, 0x0F, 0x05, 0x05, 0x05, 0x10, 0x10, 0x10, 0x14, 0x14, 0x14,
			0x73, 0x73, 0x73, 0x7B, 0x7B, 0x7B, 0x7A, 0x7A, 0x7A, 0x79, 0x79, 0x79,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF7, 0xF7, 0xF7, 0xF2, 0xF2, 0xF2,
			0x4A, 0x4A, 0x4A, 0x09, 0x09, 0x09, 0x0C, 0x0C, 0x0C, 0x0F, 0x0F, 0x0F,
			0x0B, 0x0B, 0x0B, 0x12, 0x12, 0x12, 0x0F, 0x0F, 0x0F, 0x0E, 0x0E, 0x0E,
			0x0C, 0x0C, 0x0C, 0x0E, 0x0E, 0x0E, 0x0D, 0x0D, 0x0D, 0x0B, 0x0B, 0x0B,
			0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x16, 0x16, 0x16, 0x1A, 0x1A, 0x1A,
			0x18, 0x18, 0x18, 0x1D, 0x1D, 0x1D, 0x1F, 0x1F, 0x1F, 0x21, 0x21, 0x21,
			0x21, 0x21, 0x21, 0x92, 0x92, 0x92, 0xE2, 0xA8, 0xA3, 0xB8, 0x9D, 0x9B,
			0xA7, 0xA7, 0xA7, 0x7D, 0x7D, 0x7D, 0xDB, 0x8D, 0x8C, 0xCD, 0x1C, 0x18,
			0xC5, 0x1B, 0x1C, 0xB7, 0x9D, 0x9D, 0xE3, 0xBC, 0xB7, 0xB2, 0x66, 0x63,
			0xB7, 0xB7, 0xB8, 0x30, 0x30, 0x30, 0x1A, 0x1A, 0x1A, 0x1C, 0x1C, 0x1C,
			0x17, 0x17, 0x17, 0x0F, 0x0F, 0x0F, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
			0x18, 0x18, 0x18, 0x1E, 0x1E, 0x1E, 0x1D, 0x1D, 0x1D, 0x26, 0x26, 0x26,
			0x25, 0x25, 0x25, 0x21, 0x21, 0x21, 0x22, 0x22, 0x22, 0x23, 0x23, 0x23,
			0x1C, 0x1C, 0x1C, 0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
			0x10, 0x10, 0x10, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x2B, 0x2B, 0x2B,
			0x79, 0x79, 0x79, 0x7A, 0x7A, 0x7A, 0x79, 0x79, 0x79, 0x78, 0x78, 0x78,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF7, 0xF7, 0xF7, 0xF5, 0xF5, 0xF5,
			0xB1, 0xB1, 0xB1, 0x08, 0x08, 0x08, 0x0C, 0x0C, 0x0C, 0x09, 0x09, 0x09,
			0x06, 0x06, 0x06, 0x0E, 0x0E, 0x0E, 0x0C, 0x0C, 0x0C, 0x12, 0x12, 0x12,
			0x0B, 0x0B, 0x0B, 0x05, 0x05, 0x05, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A,
			0x0E, 0x0E, 0x0E, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x0A, 0x0A, 0x0A,
			0x16, 0x16, 0x16, 0x19, 0x19, 0x19, 0x1D, 0x1D, 0x1D, 0x24, 0x24, 0x24,
			0x21, 0x21, 0x21, 0x91, 0x91, 0x91, 0xCE, 0xCC, 0xCB, 0xA7, 0xA7, 0xA7,
			0x21, 0x21, 0x21, 0x7A, 0x7A, 0x7A, 0xDE, 0x98, 0x95, 0xCA, 0x2C, 0x2A,
			0xB4, 0x9A, 0x9A, 0xC4, 0xC4, 0xC3, 0xC7, 0xBA, 0xB8, 0xB7, 0xB8, 0xB8,
			0x30, 0x30, 0x30, 0x18, 0x18, 0x18, 0x11, 0x11, 0x11, 0x15, 0x15, 0x15,
			0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x0F, 0x0F, 0x0F, 0x13, 0x13, 0x13,
			0x1C, 0x1C, 0x1C, 0x13, 0x13, 0x13, 0x21, 0x21, 0x21, 0x24, 0x24, 0x24,
			0x1D, 0x1D, 0x1D, 0x15, 0x15, 0x15, 0x1C, 0x1C, 0x1C, 0x21, 0x21, 0x21,
			0x1E, 0x1E, 0x1E, 0x18, 0x18, 0x18, 0x12, 0x12, 0x12, 0x14, 0x14, 0x14,
			0x12, 0x12, 0x12, 0x0A, 0x0A, 0x0A, 0x03, 0x03, 0x03, 0x57, 0x57, 0x57,
			0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x78, 0x78, 0x78, 0x77, 0x77, 0x77,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF7, 0xF7, 0xF7, 0xF6, 0xF6, 0xF6,
			0xF2, 0xF2, 0xF2, 0x54, 0x54, 0x54, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
			0x07, 0x07, 0x07, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x07, 0x07, 0x07,
			0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x08, 0x08,
			0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x0E, 0x0E, 0x0E,
			0x0C, 0x0C, 0x0C, 0x16, 0x16, 0x16, 0x1D, 0x1D, 0x1D, 0x21, 0x21, 0x21,
			0x1E, 0x1E, 0x1E, 0x8D, 0x8D, 0x8D, 0xA5, 0xA5, 0xA5, 0x1D, 0x1D, 0x1D,
			0x24, 0x24, 0x24, 0x7B, 0x7B, 0x7B, 0xD7, 0xA9, 0xA4, 0xB4, 0x9A, 0x99,
			0x8F, 0x8F, 0x8F, 0x67, 0x67, 0x67, 0xBE, 0xBE, 0xBE, 0x2D, 0x2D, 0x2D,
			0x0E, 0x0E, 0x0E, 0x0B, 0x0B, 0x0B, 0x0C, 0x0C, 0x0C, 0x13, 0x13, 0x13,
			0x10, 0x10, 0x10, 0x15, 0x15, 0x15, 0x10, 0x10, 0x10, 0x07, 0x07, 0x07,
			0x07, 0x07, 0x07, 0x11, 0x11, 0x11, 0x0F, 0x0F, 0x0F, 0x1E, 0x1E, 0x1E,
			0x15, 0x15, 0x15, 0x17, 0x17, 0x17, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E,
			0x19, 0x19, 0x19, 0x13, 0x13, 0x13, 0x10, 0x10, 0x10, 0x0E, 0x0E, 0x0E,
			0x15, 0x15, 0x15, 0x0A, 0x0A, 0x0A, 0x29, 0x29, 0x29, 0x77, 0x77, 0x77,
			0x79, 0x79, 0x79, 0x78, 0x78, 0x78, 0x77, 0x77, 0x77, 0x76, 0x76, 0x76,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF7, 0xF7, 0xF7, 0xF7, 0xF7, 0xF7,
			0xF5, 0xF5, 0xF5, 0xE4, 0xE4, 0xE4, 0x35, 0x35, 0x35, 0x09, 0x09, 0x09,
			0x04, 0x04, 0x04, 0x0A, 0x0A, 0x0A, 0x0E, 0x0E, 0x0E, 0x06, 0x06, 0x06,
			0x08, 0x08, 0x08, 0x07, 0x07, 0x07, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04,
			0x08, 0x08, 0x08, 0x0B, 0x0B, 0x0B, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
			0x0C, 0x0C, 0x0C, 0x12, 0x12, 0x12, 0x1C, 0x1C, 0x1C, 0x1D, 0x1D, 0x1D,
			0x1B, 0x1B, 0x1B, 0x5B, 0x5B, 0x5B, 0x20, 0x20, 0x20, 0x1B, 0x1B, 0x1B,
			0x25, 0x25, 0x25, 0x79, 0x79, 0x79, 0xCB, 0xCB, 0xCB, 0x90, 0x90, 0x90,
			0x16, 0x16, 0x16, 0x57, 0x57, 0x57, 0x2D, 0x2D, 0x2D, 0x0F, 0x0F, 0x0F,
			0x0F, 0x0F, 0x0F, 0x0B, 0x0B, 0x0B, 0x12, 0x12, 0x12, 0x17, 0x17, 0x17,
			0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0B, 0x0B, 0x0B, 0x0A, 0x0A, 0x0A,
			0x0D, 0x0D, 0x0D, 0x07, 0x07, 0x07, 0x0D, 0x0D, 0x0D, 0x10, 0x10, 0x10,
			0x12, 0x12, 0x12, 0x15, 0x15, 0x15, 0x18, 0x18, 0x18, 0x19, 0x19, 0x19,
			0x16, 0x16, 0x16, 0x0E, 0x0E, 0x0E, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
			0x0F, 0x0F, 0x0F, 0x20, 0x20, 0x20, 0x70, 0x70, 0x70, 0x78, 0x78, 0x78,
			0x78, 0x78, 0x78, 0x77, 0x77, 0x77, 0x76, 0x76, 0x76, 0x75, 0x75, 0x75,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF7, 0xF7, 0xF7, 0xF7, 0xF7, 0xF7,
			0xF5, 0xF5, 0xF5, 0xF0, 0xF0, 0xF0, 0xDF, 0xDF, 0xDF, 0x52, 0x52, 0x52,
			0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x09, 0x09, 0x09, 0x06, 0x06, 0x06,
			0x06, 0x06, 0x06, 0x07, 0x07, 0x07, 0x09, 0x09, 0x09, 0x02, 0x02, 0x02,
			0x04, 0x04, 0x04, 0x08, 0x08, 0x08, 0x0B, 0x0B, 0x0B, 0x06, 0x06, 0x06,
			0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x1E, 0x1E, 0x1E, 0x18, 0x18, 0x18,
			0x18, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B,
			0x1B, 0x1B, 0x1B, 0x78, 0x78, 0x78, 0x92, 0x92, 0x92, 0x16, 0x16, 0x16,
			0x12, 0x12, 0x12, 0x0E, 0x0E, 0x0E, 0x17, 0x17, 0x17, 0x12, 0x12, 0x12,
			0x13, 0x13, 0x13, 0x0B, 0x0B, 0x0B, 0x0E, 0x0E, 0x0E, 0x18, 0x18, 0x18,
			0x23, 0x23, 0x23, 0x10, 0x10, 0x10, 0x16, 0x16, 0x16, 0x10, 0x10, 0x10,
			0x09, 0x09, 0x09, 0x0A, 0x0A, 0x0A, 0x06, 0x06, 0x06, 0x0D, 0x0D, 0x0D,
			0x10, 0x10, 0x10, 0x16, 0x16, 0x16, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
			0x12, 0x12, 0x12, 0x09, 0x09, 0x09, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05,
			0x2E, 0x2E, 0x2E, 0x71, 0x71, 0x71, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
			0x77, 0x77, 0x77, 0x76, 0x76, 0x76, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF7, 0xF7, 0xF7, 0xF5, 0xF5, 0xF5,
			0xF3, 0xF3, 0xF3, 0xEF, 0xEF, 0xEF, 0xEB, 0xEB, 0xEB, 0xE6, 0xE6, 0xE6,
			0xA8, 0xA8, 0xA8, 0x46, 0x46, 0x46, 0x0B, 0x0B, 0x0B, 0x07, 0x07, 0x07,
			0x09, 0x09, 0x09, 0x08, 0x08, 0x08, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03,
			0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
			0x07, 0x07, 0x07, 0x0B, 0x0B, 0x0B, 0x12, 0x12, 0x12, 0x18, 0x18, 0x18,
			0x14, 0x14, 0x14, 0x1A, 0x1A, 0x1A, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
			0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x0F, 0x0F, 0x0F,
			0x0D, 0x0D, 0x0D, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x10,
			0x0C, 0x0C, 0x0C, 0x08, 0x08, 0x08, 0x0E, 0x0E, 0x0E, 0x0B, 0x0B, 0x0B,
			0x0F, 0x0F, 0x0F, 0x09, 0x09, 0x09, 0x0D, 0x0D, 0x0D, 0x09, 0x09, 0x09,
			0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0B, 0x0B, 0x0B, 0x11, 0x11, 0x11,
			0x0C, 0x0C, 0x0C, 0x0B, 0x0B, 0x0B, 0x14, 0x14, 0x14, 0x12, 0x12, 0x12,
			0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x2B, 0x2B, 0x2B, 0x59, 0x59, 0x59,
			0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x77, 0x77, 0x77,
			0x76, 0x76, 0x76, 0x75, 0x75, 0x75, 0x73, 0x73, 0x73, 0x72, 0x72, 0x72,
			0xEC, 0xEC, 0xEC, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF6, 0xF3, 0xF3, 0xF3,
			0xF0, 0xF0, 0xF0, 0xEC, 0xEC, 0xEC, 0xE9, 0xE9, 0xE9, 0xE6, 0xE6, 0xE6,
			0xE1, 0xE1, 0xE1, 0xDE, 0xDE, 0xDE, 0xD4, 0xD4, 0xD4, 0xB2, 0xB2, 0xB2,
			0xA3, 0xA3, 0xA3, 0x9F, 0x9F, 0x9F, 0x9E, 0x9E, 0x9E, 0x9B, 0x9B, 0x9B,
			0x99, 0x99, 0x99, 0x98, 0x98, 0x98, 0x96, 0x96, 0x96, 0x94, 0x94, 0x94,
			0x94, 0x94, 0x94, 0x93, 0x93, 0x93, 0x93, 0x93, 0x93, 0x92, 0x92, 0x92,
			0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x8F, 0x8F, 0x8F, 0x8B, 0x8B, 0x8B,
			0x8B, 0x8B, 0x8B, 0x88, 0x88, 0x88, 0x87, 0x87, 0x87, 0x85, 0x85, 0x85,
			0x83, 0x83, 0x83, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x7F, 0x7F, 0x7F,
			0x7D, 0x7D, 0x7D, 0x7A, 0x7A, 0x7A, 0x79, 0x79, 0x79, 0x78, 0x78, 0x78,
			0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x75, 0x75, 0x75, 0x73, 0x73, 0x73,
			0x73, 0x73, 0x73, 0x71, 0x71, 0x71, 0x71, 0x71, 0x71, 0x6F, 0x6F, 0x6F,
			0x6E, 0x6E, 0x6E, 0x6B, 0x6B, 0x6B, 0x6D, 0x6D, 0x6D, 0x6C, 0x6C, 0x6C,
			0x70, 0x70, 0x70, 0x7C, 0x7C, 0x7C, 0x7B, 0x7B, 0x7B, 0x79, 0x79, 0x79,
			0x79, 0x79, 0x79, 0x78, 0x78, 0x78, 0x77, 0x77, 0x77, 0x76, 0x76, 0x76,
			0x75, 0x75, 0x75, 0x73, 0x73, 0x73, 0x72, 0x72, 0x72, 0x71, 0x71, 0x71,
			0xEC, 0xEC, 0xEC, 0xF5, 0xF5, 0xF5, 0xF3, 0xF3, 0xF3, 0xEF, 0xEF, 0xEF,
			0xEC, 0xEC, 0xEC, 0xE9, 0xE9, 0xE9, 0xE7, 0xE7, 0xE7, 0xE4, 0xE4, 0xE4,
			0xE1, 0xE1, 0xE1, 0xDE, 0xDE, 0xDE, 0xDB, 0xDB, 0xDB, 0xD8, 0xD8, 0xD8,
			0xD5, 0xD5, 0xD5, 0xD2, 0xD2, 0xD2, 0xCF, 0xCF, 0xCF, 0xCD, 0xCD, 0xCD,
			0xCB, 0xCB, 0xCB, 0xC8, 0xC8, 0xC8, 0xC5, 0xC5, 0xC5, 0xC3, 0xC3, 0xC3,
			0xC0, 0xC0, 0xC0, 0xBD, 0xBD, 0xBD, 0xBB, 0xBB, 0xBB, 0xB9, 0xB9, 0xB9,
			0xB6, 0xB6, 0xB6, 0xB3, 0xB3, 0xB3, 0xB0, 0xB0, 0xB0, 0xAE, 0xAE, 0xAE,
			0xAB, 0xAB, 0xAB, 0xA9, 0xA9, 0xA9, 0xA7, 0xA7, 0xA7, 0xA4, 0xA4, 0xA4,
			0xA2, 0xA2, 0xA2, 0xA0, 0xA0, 0xA0, 0x9E, 0x9E, 0x9E, 0x9D, 0x9D, 0x9D,
			0x9A, 0x9A, 0x9A, 0x98, 0x98, 0x98, 0x96, 0x96, 0x96, 0x94, 0x94, 0x94,
			0x92, 0x92, 0x92, 0x90, 0x90, 0x90, 0x8E, 0x8E, 0x8E, 0x8C, 0x8C, 0x8C,
			0x8A, 0x8A, 0x8A, 0x88, 0x88, 0x88, 0x86, 0x86, 0x86, 0x84, 0x84, 0x84,
			0x83, 0x83, 0x83, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7E, 0x7E, 0x7E,
			0x7D, 0x7D, 0x7D, 0x7B, 0x7B, 0x7B, 0x7A, 0x7A, 0x7A, 0x79, 0x79, 0x79,
			0x78, 0x78, 0x78, 0x77, 0x77, 0x77, 0x76, 0x76, 0x76, 0x75, 0x75, 0x75,
			0x73, 0x73, 0x73, 0x72, 0x72, 0x72, 0x70, 0x70, 0x70, 0x6F, 0x6F, 0x6F,
			0xEB, 0xEB, 0xEB, 0xF2, 0xF2, 0xF2, 0xF0, 0xF0, 0xF0, 0xEC, 0xEC, 0xEC,
			0xE9, 0xE9, 0xE9, 0xE6, 0xE6, 0xE6, 0xE3, 0xE3, 0xE3, 0xE1, 0xE1, 0xE1,
			0xDE, 0xDE, 0xDE, 0xDB, 0xDB, 0xDB, 0xD8, 0xD8, 0xD8, 0xD6, 0xD6, 0xD6,
			0xD3, 0xD3, 0xD3, 0xD1, 0xD1, 0xD1, 0xCE, 0xCE, 0xCE, 0xCB, 0xCB, 0xCB,
			0xC8, 0xC8, 0xC8, 0xC6, 0xC6, 0xC6, 0xC3, 0xC3, 0xC3, 0xC1, 0xC1, 0xC1,
			0xBE, 0xBE, 0xBE, 0xBC, 0xBC, 0xBC, 0xB9, 0xB9, 0xB9, 0xB7, 0xB7, 0xB7,
			0xB4, 0xB4, 0xB4, 0xB1, 0xB1, 0xB1, 0xAE, 0xAE, 0xAE, 0xAC, 0xAC, 0xAC,
			0xAA, 0xAA, 0xAA, 0xA8, 0xA8, 0xA8, 0xA5, 0xA5, 0xA5, 0xA3, 0xA3, 0xA3,
			0xA1, 0xA1, 0xA1, 0x9F, 0x9F, 0x9F, 0x9D, 0x9D, 0x9D, 0x9B, 0x9B, 0x9B,
			0x99, 0x99, 0x99, 0x97, 0x97, 0x97, 0x95, 0x95, 0x95, 0x93, 0x93, 0x93,
			0x90, 0x90, 0x90, 0x8E, 0x8E, 0x8E, 0x8D, 0x8D, 0x8D, 0x8B, 0x8B, 0x8B,
			0x89, 0x89, 0x89, 0x87, 0x87, 0x87, 0x85, 0x85, 0x85, 0x83, 0x83, 0x83,
			0x82, 0x82, 0x82, 0x80, 0x80, 0x80, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D,
			0x7C, 0x7C, 0x7C, 0x7A, 0x7A, 0x7A, 0x79, 0x79, 0x79, 0x78, 0x78, 0x78,
			0x77, 0x77, 0x77, 0x76, 0x76, 0x76, 0x75, 0x75, 0x75, 0x73, 0x73, 0x73,
			0x72, 0x72, 0x72, 0x70, 0x70, 0x70, 0x6F, 0x6F, 0x6F, 0x6E, 0x6E, 0x6E,
			0xE2, 0xE2, 0xE2, 0xE5, 0xE5, 0xE5, 0xE3, 0xE3, 0xE3, 0xE1, 0xE1, 0xE1,
			0xDE, 0xDE, 0xDE, 0xDB, 0xDB, 0xDB, 0xD8, 0xD8, 0xD8, 0xD6, 0xD6, 0xD6,
			0xD3, 0xD3, 0xD3, 0xD1, 0xD1, 0xD1, 0xCE, 0xCE, 0xCE, 0xCB, 0xCB, 0xCB,
			0xC9, 0xC9, 0xC9, 0xC6, 0xC6, 0xC6, 0xC4, 0xC4, 0xC4, 0xC1, 0xC1, 0xC1,
			0xBE, 0xBE, 0xBE, 0xBC, 0xBC, 0xBC, 0xB9, 0xB9, 0xB9, 0xB7, 0xB7, 0xB7,
			0xB4, 0xB4, 0xB4, 0xB2, 0xB2, 0xB2, 0xAF, 0xAF, 0xAF, 0xAD, 0xAD, 0xAD,
			0xAA, 0xAA, 0xAA, 0xA8, 0xA8, 0xA8, 0xA6, 0xA6, 0xA6, 0xA4, 0xA4, 0xA4,
			0xA1, 0xA1, 0xA1, 0x9F, 0x9F, 0x9F, 0x9D, 0x9D, 0x9D, 0x9B, 0x9B, 0x9B,
			0x99, 0x99, 0x99, 0x97, 0x97, 0x97, 0x95, 0x95, 0x95, 0x93, 0x93, 0x93,
			0x91, 0x91, 0x91, 0x8F, 0x8F, 0x8F, 0x8D, 0x8D, 0x8D, 0x8B, 0x8B, 0x8B,
			0x89, 0x89, 0x89, 0x87, 0x87, 0x87, 0x86, 0x86, 0x86, 0x84, 0x84, 0x84,
			0x82, 0x82, 0x82, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7D, 0x7D, 0x7D,
			0x7B, 0x7B, 0x7B, 0x7A, 0x7A, 0x7A, 0x79, 0x79, 0x79, 0x77, 0x77, 0x77,
			0x76, 0x76, 0x76, 0x75, 0x75, 0x75, 0x74, 0x74, 0x74, 0x73, 0x73, 0x73,
			0x72, 0x72, 0x72, 0x71, 0x71, 0x71, 0x6F, 0x6F, 0x6F, 0x6E, 0x6E, 0x6E,
			0x6C, 0x6C, 0x6C, 0x6B, 0x6B, 0x6B, 0x6A, 0x6A, 0x6A, 0x69, 0x69, 0x69
	};
#endif

	//------------------
	IDIB* backBuffer;
	int upTimeMs;
	int lastTime;
	int time;
	int gameTime;
	int startupMemory;
	int imageMemory;
	char* peakMemoryDesc;
	int peakMemoryUsage;
	int idError;
	bool initLoadImages;

	int sysAdvTime;
	int osTime[8];
	int codeTime[8];
	int field_0x26c;
	int field_0x270;
	int field_0x278;
	int field_0x27c;
	int fontType;
	int accelerationIndex;
	bool field_0x290;
	bool field_0x291;
	int field_0x7c;
	int field_0x80;

	// Iphone Only
	float accelerationX[32];
	float accelerationY[32];
	float accelerationZ[32];

	float field_0x414;
	float field_0x418;
	float field_0x41c;
	float field_0x420;
	float field_0x424;
	float field_0x428;
	bool closeApplet;

	//-------------------------
	Localization* localization;
	Resource* resource;
	Render* render;
	TinyGL* tinyGL;
	Canvas* canvas;
	Game* game;
	MenuSystem* menuSystem;
	Player* player;
	Sound* sound;
	Combat* combat;
	Hud* hud;
	EntityDefManager* entityDefManager;
	ParticleSystem* particleSystem;
	CardGames* cardGames;
	DrivingGame* drivingGame;
	//-------------------------
	Image* testImg;
	int seed;

	// Constructor
	Applet();
	// Destructor
	~Applet();

	bool startup();
	void loadConfig();

	Image* createImage(InputStream* inputStream, bool isTransparentMask);
	Image* loadImage(char* fileName, bool isTransparentMask);

	void beginImageLoading();
	void finishImageLoading();

	void Error(const char* fmt, ...);
	void Error(int id);
	void loadTables();

	void loadRuntimeImages();
	void freeStaticImages();
	void setFont(int fontType);
	void shutdown();
	uint32_t nextInt();
	uint32_t nextByte();
	void setFontRenderMode(int fontRenderMode);

	void AccelerometerUpdated(float x, float y, float z);
	void StartAccelerometer();
	void StopAccelerometer();
	void CalcAccelerometerAngles();
    [[nodiscard]] bool warFontActive () const{
        return fontType >= 3;
    }
};


#endif