#include <stdexcept>
#include <stdio.h>
#include <stdlib.h>
#include <md5.h>

#include "Utils.h"
#include "CAppContainer.h"
#include "App.h"
#include "Canvas.h"
#include "Graphics.h"

bool getFileMD5Hash(const void* data, uint64_t numBytes, uint64_t& hashWord1, uint64_t& hashWord2) {

    if((data == nullptr) || (numBytes == 0))
        return false;

    // Hash the data and turn the hash into 2 64-bit words
    MD5 md5Hasher;
    md5Hasher.reset();
    md5Hasher.add(data, numBytes);

    uint8_t md5[16] = {};
    md5Hasher.getHash(md5);

    hashWord1 = (
        ((uint64_t)md5[0] << 56) | ((uint64_t)md5[1] << 48) | ((uint64_t)md5[2] << 40) | ((uint64_t)md5[3] << 32) |
        ((uint64_t)md5[4] << 24) | ((uint64_t)md5[5] << 16) | ((uint64_t)md5[6] << 8) | ((uint64_t)md5[7] << 0)
        );

    hashWord2 = (
        ((uint64_t)md5[8] << 56) | ((uint64_t)md5[9] << 48) | ((uint64_t)md5[10] << 40) | ((uint64_t)md5[11] << 32) |
        ((uint64_t)md5[12] << 24) | ((uint64_t)md5[13] << 16) | ((uint64_t)md5[14] << 8) | ((uint64_t)md5[15] << 0)
        );

	return true;
}

bool checkFileMD5Hash(const void* data, uint64_t numBytes, uint64_t checkHashWord1, uint64_t checkHashWord2) {
    uint64_t actualHashWord1 = {};
    uint64_t actualHashWord2 = {};

    if (getFileMD5Hash(data, numBytes, actualHashWord1, actualHashWord2)) {
        printf("actualHashWord1 %I64X\n", actualHashWord1);
        printf("actualHashWord2 %I64X\n", actualHashWord2);
        return ((actualHashWord1 == checkHashWord1) && (actualHashWord2 == checkHashWord2));
    }
    else {
        return false;
    }
}

bool pointInRectangle(int x, int y, int rectX, int rectY, int rectW, int rectH) {
    return x >= rectX && x < rectX + rectW && y >= rectY && y < rectY + rectH;
}

/*
 ==================
 AxisHit

 Returns a -1 to 1 range

 If activeFraction is less than 1.0, the range will clamp
 to the limits before the edge of the box is hit.
 ==================
 */
float stickDeadBand = 0.0f;
float AxisHit(int aX, int aY, int x, int y, int w, int h, bool isXaxis, float activeFraction) {
    if(pointInRectangle(aX, aY, x, y, w, h)) {
        float scale = 1.0f;
        int centerX = x + w / 2;
        int centerY = y + w / 2;
        float pw = (float)(w) * 0.5f * scale;
        float ph = (float)(w) * 0.5f * scale;
        int pX = aX - centerX;
        int pY = aY - centerY;

        float	f;
        if (isXaxis) {
            f = (float)pX / pw;
        }
        else {
            f = (float)pY / ph;
        }
        float	deadBand = stickDeadBand;
        if (f > deadBand) {
            f -= deadBand;
        }
        else if (f < -deadBand) {
            f += deadBand;
        }
        else {
            // inside the deadband
            return 0.0f;
        }

        // adjust so you can hit the limit even if the control is drawn at the very edge
        // of the screen
        f /= (activeFraction - deadBand);
        if (f > 1.0f) {
            f = 1.0f;
        }
        else if (f < -1.0f) {
            f = -1.0f;
        }

        return f;
    }
    return 0.0f;
}

void fixImage(Image* img) {
    IDIB* piDIB = img->piDIB;
    int w = piDIB->width;
    int h = piDIB->height;
    int size = w * h;

    if (checkFileMD5Hash(piDIB->pBmp, size, 0x40CCEBD45EFC0C67, 0xE9D6E9571FB7B0A9)) { // "blockGameColors.bmp"
        int newW = piDIB->width + 2;
        uint8_t* data = (uint8_t*)std::malloc(newW * h);
        std::memset(data, 0, newW * h);

        for (int i = 0; i < h; i++) { // Copy all image data
            std::memcpy(data + (i * newW), piDIB->pBmp + (i * w), w);
        }

        int fixW = 54, fixH = 18;
        static const uint8_t fixData[54 * 18] = {
            0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x23, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23,
            0x88, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x88, 0x24, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x24,
            0x23, 0x22, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x23, 0x88, 0x89, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x88,
            0x24, 0x3C, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x24, 0x23, 0x22, 0x0A, 0x15, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x15, 0x0A, 0x23,
            0x88, 0x89, 0x83, 0x83, 0x83, 0x84, 0xC6, 0xC6, 0x84, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x88, 0x24, 0x3C, 0x2B, 0x2B, 0x2B, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x36, 0x2B, 0x2B, 0x2B, 0x2B, 0x24,
            0x23, 0x22, 0x0A, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x0A, 0x23, 0x88, 0x89, 0x83, 0x83, 0x83, 0xC6, 0xC6, 0xC6, 0xC6, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x88,
            0x24, 0x3C, 0x2B, 0x2B, 0x2B, 0x36, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x2B, 0x2B, 0x2B, 0x2B, 0x24, 0x23, 0x22, 0x0A, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x0A, 0x23,
            0x88, 0x89, 0x83, 0x83, 0x83, 0xC6, 0xC6, 0xC6, 0xC6, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x88, 0x24, 0x3C, 0x2B, 0x2B, 0x2B, 0x2B, 0x36, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x2B, 0x2B, 0x2B, 0x2B, 0x24,
            0x23, 0x22, 0x0A, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x0A, 0x23, 0x88, 0x89, 0x83, 0x83, 0x83, 0xC6, 0xC6, 0xC6, 0xC6, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x88,
            0x24, 0x3C, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x36, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x2B, 0x2B, 0x2B, 0x2B, 0x24, 0x23, 0x22, 0x0A, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x0A, 0x0A, 0x0A, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x0A, 0x23,
            0x88, 0x89, 0x83, 0x84, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x84, 0x83, 0x88, 0x24, 0x3C, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0xC6, 0xC6, 0xC6, 0xC6, 0x2B, 0x2B, 0x2B, 0x2B, 0x24,
            0x23, 0x22, 0x0A, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x0A, 0x0A, 0x0A, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x0A, 0x23, 0x88, 0x89, 0x83, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x83, 0x88,
            0x24, 0x3C, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0xC6, 0xC6, 0xC6, 0xC6, 0x2B, 0x2B, 0x2B, 0x2B, 0x24, 0x23, 0x22, 0x0A, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x0A, 0x0A, 0x0A, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x0A, 0x23,
            0x88, 0x89, 0x83, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x83, 0x88, 0x24, 0x3C, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0xC6, 0xC6, 0xC6, 0xC6, 0x2B, 0x2B, 0x2B, 0x2B, 0x24,
            0x23, 0x22, 0x0A, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x0A, 0x0A, 0x0A, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x0A, 0x23, 0x88, 0x89, 0x83, 0x84, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x84, 0x83, 0x88,
            0x24, 0x3C, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0xC6, 0xC6, 0xC6, 0xC6, 0x2B, 0x2B, 0x2B, 0x2B, 0x24, 0x23, 0x22, 0x0A, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x0A, 0x0A, 0x0A, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x0A, 0x23,
            0x88, 0x89, 0x83, 0x83, 0x83, 0xC6, 0xC6, 0xC6, 0xC6, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x88, 0x24, 0x3C, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0xC6, 0xC6, 0xC6, 0xC6, 0x2B, 0x2B, 0x2B, 0x2B, 0x24,
            0x23, 0x22, 0x0A, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x0A, 0x0A, 0x0A, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x0A, 0x23, 0x88, 0x89, 0x83, 0x83, 0x83, 0xC6, 0xC6, 0xC6, 0xC6, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x88,
            0x24, 0x3C, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x36, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x2B, 0x2B, 0x2B, 0x2B, 0x24, 0x23, 0x22, 0x0A, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x0A, 0x0A, 0x0A, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x0A, 0x23,
            0x88, 0x89, 0x83, 0x83, 0x83, 0xC6, 0xC6, 0xC6, 0xC6, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x88, 0x24, 0x3C, 0x2B, 0x2B, 0x2B, 0x2B, 0x36, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x2B, 0x2B, 0x2B, 0x2B, 0x24,
            0x23, 0x22, 0x0A, 0x15, 0xC6, 0xC6, 0xC6, 0x15, 0x0A, 0x0A, 0x0A, 0x15, 0xC6, 0xC6, 0xC6, 0x15, 0x0A, 0x23, 0x88, 0x89, 0x83, 0x83, 0x83, 0xC6, 0xC6, 0xC6, 0xC6, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x88,
            0x24, 0x3C, 0x2B, 0x2B, 0x2B, 0x36, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x2B, 0x2B, 0x2B, 0x2B, 0x24, 0x23, 0x22, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x23,
            0x88, 0x89, 0x83, 0x83, 0x83, 0x84, 0xC6, 0xC6, 0x84, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x88, 0x24, 0x3C, 0x2B, 0x2B, 0x2B, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x36, 0x2B, 0x2B, 0x2B, 0x2B, 0x24,
            0x23, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x88, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x88,
            0x24, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x24, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
            0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24
        };

        for (int i = 0; i < fixH; i++) { // Copy the corrected snippet of the image.
            std::memcpy((data + (i * newW)) + fixW, fixData + (i * fixW), fixW);
        }

        std::free(piDIB->pBmp);
        piDIB->pBmp = data;
        piDIB->width = newW;
    }

    if (checkFileMD5Hash(piDIB->pBmp, size, 0x3AC64358C5499205, 0x606ECC6CCFDB0BD8)) { // "imgVending_arrow_down.bmp"
        for (int i = 0; i < w * h; i++) { // Cambia el indice de algunos pixeles
            if (piDIB->pBmp[i] == 1) {
                piDIB->pBmp[i] = 0;
            }
            if (piDIB->pBmp[i] == 2) {
                piDIB->pBmp[i] = 0;
            }
        }
    }

    if (checkFileMD5Hash(piDIB->pBmp, size, 0x9EC6C8CDCA64AE13, 0xE6ED52BDF3163C75)) { // "menu_button_background.bmp"
        for (int i = 0; i < w * h; i++) { // Cambia el indice de algunos pixeles
            if (piDIB->pBmp[i] >= 3 && piDIB->pBmp[i] <= 33) {
                piDIB->pBmp[i] = 1;
            }
        }
    }
}

void enlargeButtonImage(Image* img) {
    IDIB* piDIB = img->piDIB;
    int w = piDIB->width;
    int h = piDIB->height;
    int size = w * h;

    int newW = 296;
    uint8_t* data = (uint8_t*)std::malloc(newW * h);
    std::memset(data, 0x00, newW * h);

    for (int i = 0; i < h; i++) { // Copy all image data
        std::memcpy(data + (i * newW), piDIB->pBmp + (i * w), w);
    }

    for (int j = 0; j < newW; j+= 4) {
        for (int i = 0; i < h; i++) {
            std::memcpy((data + (i * newW) + j), piDIB->pBmp + (i * w) + 88, 4);
        }
    }

    for (int i = 0; i < h; i++) {
        std::memcpy((data + (i * newW) + 0), piDIB->pBmp + (i * w) + 0, 102);
    }

    for (int i = 0; i < h; i++) {
        std::memcpy((data + (i * newW) + 194), piDIB->pBmp + (i * w) + 102, 102);
    }

    std::free(piDIB->pBmp);
    piDIB->pBmp = data;
    piDIB->width = newW;
    img->width = newW;
}
