#ifndef __PLAYER_H__
#define __PLAYER_H__

#include "Entity.h"
#include "EntityDef.h"
#include "CombatEntity.h"

class Entity;
class EntityDef;
class CombatEntity;
class Text;
class InputStream;
class OutputStream;
class Graphics;
class ScriptThread;

class Player
{
private:

public:
	static constexpr int EXPIRE_DURATION = 5;
	static constexpr int MAX_DISPLAY_BUFFS = 6;
	static constexpr int ICE_FOG_DIST = 1024;
	static constexpr int MAX_NOTEBOOK_INDEXES = 8;
	static constexpr int NUMBER_OF_TARGET_PRACTICE_SHOTS = 8;
	static constexpr int HEAD_SHOT_POINTS = 30;
	static constexpr int BODY_SHOT_POINTS = 20;
	static constexpr int LEG_SHOT_POINTS = 10;
	static constexpr int NUMBER_OF_BITS_PER_VM_TRY = 3;
	static constexpr int BUFF_TURNS = 0;
	static constexpr int BUFF_AMOUNT = 15;
	static constexpr int DEF_STATUS_TURNS = 30;
	static constexpr int ANTI_FIRE_TURNS = 10;
	static constexpr int AGILITY_TURNS = 20;
	static constexpr int PURIFY_TURNS = 10;
	static constexpr int FEAR_TURNS = 6;
	static constexpr int COLD_TURNS = 5;
	static constexpr int BOX_X1 = 17;
	static constexpr int BOX_X2 = 31;
	static constexpr int BOX_X3 = 43;
	static constexpr int BOX_X4 = 55;

	Entity* facingEntity;
	short inventory[26];
	short ammo[9];
	int weapons;
	short inventoryCopy[26];
	short ammoCopy[9];
	int weaponsCopy;
	int goldCopy;
	int currentWeaponCopy;
	bool tookBotsInventory;
	bool botReturnedDueToMonster;
	bool unsetFamiliarOnceOutOfCinematic;
	int disabledWeapons;
	int level;
	int currentXP;
	int nextLevelXP;
	CombatEntity* baseCe;
	CombatEntity* ce;
	EntityDef* activeWeaponDef;
	bool noclip;
	bool god;
	short characterChoice;
	bool isFamiliar;
	short familiarType;
	bool attemptingToSelfDestructFamiliar;
	int chainsawStrengthBonusCount;
	uint8_t lastSkipCode;
	bool inTargetPractice;
	int targetPracticeScore;
	int playTime;
	int totalTime;
	int moves;
	int totalMoves;
	int completedLevels;
	int killedMonstersLevels;
	int foundSecretsLevels;
	int xpGained;
	int currentLevelDeaths;
	int totalDeaths;
	int currentGrades;
	int bestGrades;
	short notebookIndexes[Player::MAX_NOTEBOOK_INDEXES];
	short notebookPositions[Player::MAX_NOTEBOOK_INDEXES];
	uint8_t questComplete;
	uint8_t questFailed;
	int hackedVendingMachines;
	int vendingMachineHackTriesLeft1;
	int vendingMachineHackTriesLeft2;
	int numNotebookIndexes;
	int helpBitmask;
	int invHelpBitmask;
	int ammoHelpBitmask;
	int weaponHelpBitmask;
	int armorHelpBitmask;
	int gamePlayedMask;
	int lastCombatTurn;
	bool inCombat;
	bool enableHelp;
	int turnTime;
	int highestMap;
	int prevWeapon;
	bool noDeathFlag;
	bool noFamiliarRemains;
	int numStatusEffects;
	int numStatusEffectsCopy;
	int statusEffects[54];
	int statusEffectsCopy[54];
	short buffs[30];
	short buffsCopy[30];
	int numbuffs;
	int numbuffsCopy;
	bool gameCompleted;
	int playerEntityCopyIndex;
	int counters[8];
	int monsterStats[2];

	// Constructor
	Player();
	// Destructor
	~Player();

	bool startup();
	bool modifyCollision(Entity* entity);
	void advanceTurn();
	void levelInit();
	void fillMonsterStats();
	void readyWeapon();
	void selectWeapon(int i);
	void selectPrevWeapon();
	void selectNextWeapon();
	int getHealth();
	int modifyStat(int n, int n2);
	bool requireStat(int n, int n2);
	bool requireItem(int n, int n2, int n3, int n4);
	void addXP(int xp);
	void addLevel();
	int calcLevelXP(int n);
	int calcScore();
	bool addHealth(int i);
	bool addHealth(int i, bool b);
	void setStatsAccordingToCharacterChoice();
	void reset();
	int calcDamageDir(int x1, int y1, int angle, int x2, int y2);
	void painEvent(Entity* entity, bool b);
	void pain(int n, Entity* entity, bool b);
	void died();
	void familiarDying(bool familiarSelfDestructed);
	bool fireWeapon(Entity* entity, int n, int n2);
	bool useItem(int n);
	bool give(int n, int n2, int n3);
	bool give(int n, int n2, int n3, bool b);
	bool give(int n, int n2, int n3, bool b, bool b2);
	void giveAmmoWeapon(int n, bool b);
	void updateQuests(short n, int n2);
	void setQuestTile(int n, int n2, int n3);
	bool isQuestDone(int n);
	bool isQuestFailed(int n);
	void formatTime(int n, Text* text);
	void showInvHelp(int n, bool b);
	void showAmmoHelp(int n, bool b);
	bool showHelp(short n, bool b);
	void showWeaponHelp(int n, bool b);
	void drawBuffs(Graphics* graphics);
	void setCharacterChoice(short i);
	bool loadState(InputStream* IS);
	bool saveState(OutputStream* OS);
	void unpause(int n);
	void relink();
	void unlink();
	void link();
	void updateStats();
	void updateStatusEffects();
	void translateStatusEffects();
	void removeStatusEffect(int n);
	bool addStatusEffect(int n, int n2, int n3);
	void drawStatusEffectIcon(Graphics* graphics, int n, int n2, int n3, int n4, int n5);
	void resetCounters();
	Entity* getPlayerEnt();
	void setPickUpWeapon(int n);
	void giveAll();
	void equipForLevel(int highestMap);
	bool addArmor(int n);
	int distFrom(Entity* entity);
	void showAchievementMessage(int n);
	short gradeToString(int n);
	int levelGrade(bool b);
	int finalCurrentGrade();
	int finalBestGrade();
	int getCurrentGrade(int n);
	void setCurrentGrade(int n, int n2);
	int getBestGrade(int n);
	void setBestGrade(int n, int n2);
	bool hasPurifyEffect();
	void setFamiliar(short familiarType);
	short unsetFamiliar(bool b);
	void clearOutFamiliarsStatusEffects();
	void swapStatusEffects();
	void familiarDied();
	void explodeFamiliar(int n, int n2, int n3);
	void familiarReturnsToPlayer(bool b);
	bool stealFamiliarsInventory();
	void handleBotRemains(int n, int n2, int n3);
	void forceFamiliarReturnDueToMonster();
	void attemptToDeploySentryBot();
	void attemptToDiscardFamiliar(int n);
	void startSelfDestructDialog();
	bool vendingMachineIsHacked(int n);
	void setVendingMachineHack(int n);
	int getVendingMachineTriesLeft(int max);
	void removeOneVendingMachineTry(int max);
	bool weaponIsASentryBot(int n);
	bool hasASentryBot();
	void setFamiliarType(short familiarType);
	void calcViewMode();
	void enterTargetPractice(int n, int n2, int n3, ScriptThread* targetPracticeThread);
	void assessTargetPracticeShot(Entity* entity);
	void exitTargetPractice();
	void usedChainsaw(bool b);
	bool hasANanoDrink();
	void stripInventoryForViosBattle();
	void stripInventoryForTargetPractice();
	void restoreInventory();
	void forceRemoveFromScopeZoom();
};

#endif