#ifndef __ENUMS_H__
#define __ENUMS_H__

#include <stdexcept>

class Enums
{
public:
    static constexpr int MAX_ENTITY_DEFS = 200;
    static constexpr int ET_WORLD = 0;
    static constexpr int ET_PLAYER = 1;
    static constexpr int ET_MONSTER = 2;
    static constexpr int ET_NPC = 3;
    static constexpr int ET_PLAYERCLIP = 4;
    static constexpr int ET_DOOR = 5;
    static constexpr int ET_ITEM = 6;
    static constexpr int ET_DECOR = 7;
    static constexpr int ET_ENV_DAMAGE = 8;
    static constexpr int ET_CORPSE = 9;
    static constexpr int ET_ATTACK_INTERACTIVE = 10;
    static constexpr int ET_MONSTERBLOCK_ITEM = 11;
    static constexpr int ET_SPRITEWALL = 12;
    static constexpr int ET_NONOBSTRUCTING_SPRITEWALL = 13;
    static constexpr int ET_DECOR_NOCLIP = 14;
    static constexpr int ET_MAX = 15;
    static constexpr int CONTENTS_ANY = -1;
    static constexpr int CONTENTS_PICKUP = 64;
    static constexpr int CONTENTS_INTERACTIVE = 1068;
    static constexpr int CONTENTS_PLAYERSOLID = 13501;
    static constexpr int CONTENTS_MONSTERSOLID = 15535;
    static constexpr int CONTENTS_WEAPONSOLID = 13997;
    static constexpr int CONTENTS_VIEWSOLID = 5293;
    static constexpr int CONTENTS_MONSTERWPSOLID = 5295;
    static constexpr int CONTENTS_WORLD = 1;
    static constexpr int CONTENTS_SPRITEWALL = 12288;
    static constexpr int CONTENTS_NOFLOAT = 12424;
    static constexpr int CONTENTS_DYNAMITE_SOLID = 13349;
    static constexpr int CONTENTS_ISEMPTY_SCRIPT = 25152;
    static constexpr int CONTENTS_SPLASH_SOLID = 4129;
    static constexpr int CONTENTS_LINE_O_SIGHT = 4131;
    static constexpr int ENV_DAMAGE_SPIKES = 0;
    static constexpr int ENV_DAMAGE_FIRE = 1;
    static constexpr int DECOR_MISC = 0;
    static constexpr int DECOR_EXITHALL = 1;
    static constexpr int DECOR_MIXING = 2;
    static constexpr int DECOR_STATUE = 3;
    static constexpr int DECOR_TOMBSTONE = 5;
    static constexpr int DECOR_DYNAMITE = 6;
    static constexpr int DECOR_WATER_SPOUT = 7;
    static constexpr int DECOR_TREADMILL = 8;
    static constexpr int DECOR_PARAM_NONE = 0;
    static constexpr int DECOR_PARAM_USE = 1;
    static constexpr int DECOR_PARAM_USE_ONCE = 2;
    static constexpr int INTERACT_FURNITURE = 0;
    static constexpr int INTERACT_BARRICADE = 1;
    static constexpr int INTERACT_CRATE = 2;
    static constexpr int INTERACT_PICKUP = 3;
    static constexpr int INTERACT_SHOOT_OVER = 1;
    static constexpr int INTERACT_BARREL_DMG = 40;
    static constexpr int MONSTER_START = 0;
    static constexpr int MONSTER_ZOMBIE = 0;
    static constexpr int MONSTER_LOST_SOUL = 2;
    static constexpr int MONSTER_IMP = 3;
    static constexpr int MONSTER_SAW_GOBLIN = 4;
    static constexpr int MONSTER_PINKY = 5;
    static constexpr int MONSTER_CACODEMON = 6;
    static constexpr int MONSTER_SENTINEL = 7;
    static constexpr int MONSTER_MANCUBUS = 8;
    static constexpr int MONSTER_REVENANT = 9;
    static constexpr int MONSTER_ARCH_VILE = 10;
    static constexpr int MONSTER_SENTRY_BOT = 11;
    static constexpr int FIRSTBOSS = 12;
    static constexpr int BOSS_CYBERDEMON = 12;
    static constexpr int BOSS_PINKY = 13;
    static constexpr int BOSS_MASTERMIND = 14;
    static constexpr int BOSS_VIOS = 15;
    static constexpr int BOSS_VIOS2 = 16;
    static constexpr int LASTBOSS = 16;
    static constexpr int CORPSE_SKELETON = 17;
    static constexpr int MAX_MONSTER_TYPES = 17;
    static constexpr int MONSTER_END = 18;
    static constexpr int EVADING_MONSTERS = 0x4604;
    static constexpr int FEAR_IMMUNE_MONSTERS = 0x1F801;
    static constexpr int MOVE2ATTACK_MONSTERS = 0x180D0;
    static constexpr uint8_t MSOUND_NONE = 255;
    static constexpr int MSOUND_ALERT1 = 0;
    static constexpr int MSOUND_ALERT2 = 1;
    static constexpr int MSOUND_ALERT3 = 2;
    static constexpr int MSOUND_NUM_ALERTS = 3;
    static constexpr int MSOUND_ATTACK1 = 3;
    static constexpr int MSOUND_ATTACK2 = 4;
    static constexpr int MSOUND_IDLE = 5;
    static constexpr int MSOUND_PAIN = 6;
    static constexpr int MSOUND_DEATH = 7;
    static constexpr int MSOUND_TYPES = 8;
    static constexpr int IT_INVENTORY = 0;
    static constexpr int IT_WEAPON = 1;
    static constexpr int IT_AMMO = 2;
    static constexpr int IT_FOOD = 3;
    static constexpr int IT_SACK = 4;
    static constexpr int IT_C_NOTE = 5;
    static constexpr int IT_C_STRING = 6;
    static constexpr int AMMO_NONE = 0;
    static constexpr int AMMO_BULLETS = 1;
    static constexpr int AMMO_SHELLS = 2;
    static constexpr int AMMO_HOLY_WATER = 3;
    static constexpr int AMMO_CELLS = 4;
    static constexpr int AMMO_ROCKETS = 5;
    static constexpr int AMMO_MAX_UNIQUE_ICON = 5;
    static constexpr int AMMO_SOUL_CUBE = 6;
    static constexpr int AMMO_SENTRY_BOT = 7;
    static constexpr int AMMO_ITEM = 8;
    static constexpr int MAX_AMMO = 9;
    static constexpr int AMMO_MAX_COUNT = 100;
    static constexpr int AMMO_MAX_SOULS = 5;
    static constexpr int HOLY_WATER_PISTOL_AMMO_USAGE = 2;
    static constexpr int HOLY_WATER_PISTOL_DRINK_USAGE = 25;
    static constexpr int WP_PROJ_NONE = -1;
    static constexpr int WP_PROJ_BULLET = 0;
    static constexpr int WP_PROJ_MELEE = 1;
    static constexpr int WP_PROJ_WATER = 2;
    static constexpr int WP_PROJ_PLASMA = 3;
    static constexpr int WP_PROJ_ROCKET = 4;
    static constexpr int WP_PROJ_BFG = 5;
    static constexpr int WP_PROJ_FLESH = 6;
    static constexpr int WP_PROJ_FIRE = 7;
    static constexpr int WP_PROJ_CACO_PLASMA = 8;
    static constexpr int WP_PROJ_THORNS = 9;
    static constexpr int WP_PROJ_ACID = 10;
    static constexpr int WP_PROJ_ELECTRIC = 11;
    static constexpr int WP_PROJ_SOUL_CUBE = 12;
    static constexpr int WP_PROJ_ITEM = 13;
    static constexpr int WP_PROJ_INSTANT = 3;
    static constexpr int WP_SHIFT = 1;
    static constexpr int WP_PLAYERMIN = 0;
    static constexpr int WP_ASSAULT_RIFLE = 0;
    static constexpr int WP_CHAINSAW = 1;
    static constexpr int WP_HOLY_WATER_PISTOL = 2;
    static constexpr int WP_SHOOTING_SENTRY_BOT = 3;
    static constexpr int WP_EXPLODING_SENTRY_BOT = 4;
    static constexpr int WP_RED_SHOOTING_SENTRY_BOT = 5;
    static constexpr int WP_RED_EXPLODING_SENTRY_BOT = 6;
    static constexpr int WP_SUPER_SHOTGUN = 7;
    static constexpr int WP_CHAINGUN = 8;
    static constexpr int WP_ASSAULT_RIFLE_WITH_SCOPE = 9;
    static constexpr int WP_PLASMA_GUN = 10;
    static constexpr int WP_ROCKET_LAUNCHER = 11;
    static constexpr int WP_BFG = 12;
    static constexpr int WP_SOUL_CUBE = 13;
    static constexpr int WP_ITEM = 14;
    static constexpr int WP_PLAYERMAX = 15;
    static constexpr int WP_PLAYERMASK = 32767;
    static constexpr int WP_PUNCH_MASK = 0;
    static constexpr int WP_EXPLOSIONMASK = 2048;
    static constexpr int WP_MELEEMASK = 2;
    static constexpr int WP_SNIPERMASK = 512;
    static constexpr int WP_SENTRY_BOT_MASK = 120;
    static constexpr int WP_MUZZLE_FLASH = 385;
    static constexpr int WP_RANGEMASK = 24573;
    static constexpr int WP_NODISTANCECHK = 30719;
    static constexpr int WP_STARTING_WEAPONS = 0;
    static constexpr int WP_NORECOIL = 9222;
    static constexpr int WP_PAINTINGMASK = 0;
    static constexpr int WP_SPRITE_WALL = 2;
    static constexpr int WP_MONSTERMIN = 15;
    static constexpr int WP_M_BITE = 15;
    static constexpr int WP_M_CLAW = 16;
    static constexpr int WP_M_PUNCH = 17;
    static constexpr int WP_M_CHARGE = 18;
    static constexpr int WP_M_FLESH_THROW = 19;
    static constexpr int WP_M_FIREBALL = 20;
    static constexpr int WP_M_PLASMA = 21;
    static constexpr int WP_M_FLOOR_STRIKE = 22;
    static constexpr int WP_M_FIRE = 23;
    static constexpr int WP_M_MACHINE_GUN = 24;
    static constexpr int WP_M_CHAIN_GUN = 25;
    static constexpr int WP_M_ROCKETS = 26;
    static constexpr int WP_M_ACID_SPIT = 27;
    static constexpr int WP_M_PLASMA_GUN = 28;
    static constexpr int WP_M_VIOS_PLASMA = 29;
    static constexpr int WP_M_VIOS_LIGHTNING = 30;
    static constexpr int WP_M_VIOS_POISON = 31;
    static constexpr int WP_MONSTERMAX = 32;
    static constexpr int WP_MAX = 32;
    static constexpr int WP_MONSTERMASK = 0;
    static constexpr int WP_ALL_EASY_DODGE = 2048;
    static constexpr int WP_ANTI_FIRE = 9437184;
    static constexpr int WP_ALL_MELEE = 491522;
    static constexpr int CMASK_NONE = 0;
    static constexpr int CMASK_DESTROYABLE_MELEE = 1;
    static constexpr int CMASK_DESTROYABLE_WINDOW = 2;
    static constexpr int CMASK_DESTROYABLE_BATHROOM = 3;
    static constexpr int ARMOR_NONE = 0;
    static constexpr int ARMOR_HELMET = 1;
    static constexpr int ARMOR_MAX = 2;
    static constexpr int INV_MIN = 0;
    static constexpr int INV_DRINK_MIN = 0;
    static constexpr int INV_DRINK_ENERGY_BLAST = 0;
    static constexpr int INV_DRINK_FOCUS_JUICE = 1;
    static constexpr int INV_DRINK_SUPER_QUENCH = 2;
    static constexpr int INV_DRINK_POWER_PUNCH = 3;
    static constexpr int INV_DRINK_SNAKE_VENOM = 4;
    static constexpr int INV_DRINK_YOUTH_SERUM = 5;
    static constexpr int INV_DRINK_CAFFEINE_BLOCK = 6;
    static constexpr int INV_DRINK_DIET_MIGHT = 7;
    static constexpr int INV_DRINK_SMOOTHIE = 8;
    static constexpr int INV_DRINK_MONSTER_SHOT = 9;
    static constexpr int INV_DRINK_HELL_KNIGHT_SWEAT = 10;
    static constexpr int INV_DRINK_MAX = 11;
    static constexpr int INV_FIRST_MIXABLE = 11;
    static constexpr int INV_ARMOR_MIN = 11;
    static constexpr int INV_ARMOR_LARGE = 11;
    static constexpr int INV_ARMOR_SMALL = 12;
    static constexpr int INV_ARMOR_MAX = 13;
    static constexpr int INV_BOTTLED_WATER = 13;
    static constexpr int INV_HEALTH_MIN = 16;
    static constexpr int INV_HEALTH_RATION_BAR = 16;
    static constexpr int INV_HEALTH_PACK = 17;
    static constexpr int INV_HEALTH_MAX = 18;
    static constexpr int INV_OTHER_MIN = 18;
    static constexpr int INV_OTHER_JOURNAL = 18;
    static constexpr int INV_OTHER_RED_KEY = 19;
    static constexpr int INV_OTHER_BLUE_KEY = 20;
    static constexpr int INV_EMPTY_SYRINGE = 21;
    static constexpr int INV_OTHER_HOLY_WATER = 22;
    static constexpr int INV_OTHER_PACK = 23;
    static constexpr int INV_OTHER_MAX = 24;
    static constexpr int INV_ONE_UAC_CREDIT = 24;
    static constexpr int INV_ONE_HUNDRED_UAC_CREDITS = 25;
    static constexpr int INV_MAX = 26;
    static constexpr int INV_MAX_ITEM_COUNT = 999;
    static constexpr int INV_MAX_CREDITS = 9999;
    static constexpr int WATER_BOTTLE_QUANTITY = 20;
    static constexpr int DOOR_LOCKED = 1;
    static constexpr int DOOR_UNLOCKED = 2;
    static constexpr int DOOR_FLAG_SCIFI = 1;
    static constexpr int DOOR_FLAG_CENTER = 2;
    static constexpr int BACK_RIGHT = 0;
    static constexpr int RIGHT = 1;
    static constexpr int FRONT_RIGHT = 2;
    static constexpr int FRONT = 3;
    static constexpr int FRONT_LEFT = 4;
    static constexpr int LEFT = 5;
    static constexpr int BACK_LEFT = 6;
    static constexpr int BACK = 7;
    static constexpr int FRONT_FACING = 28;
    static constexpr int BACK_FACING = 193;
    static constexpr int ICON_NONE = 127;
    static constexpr int ICON_WEAPON_HAND = 0;
    static constexpr int ICON_WEAPON_BOOT = 1;
    static constexpr int ICON_WEAPON_SNOOPER = 2;
    static constexpr int ICON_WEAPON_PISTOL = 3;
    static constexpr int ICON_WEAPON_STEN = 5;
    static constexpr int ICON_WEAPON_VENOM = 6;
    static constexpr int ICON_WEAPON_MAUSER = 7;
    static constexpr int ICON_WEAPON_DYNAMITE = 8;
    static constexpr int ICON_WEAPON_PANZER = 9;
    static constexpr int ICON_WEAPON_FG42 = 10;
    static constexpr int ICON_WEAPON_THOMPSON = 11;
    static constexpr int ICON_WEAPON_FLAME = 12;
    static constexpr int ICON_WEAPON_TESLA = 13;
    static constexpr int ICON_WEAPON_SPEAR = 14;
    static constexpr int ICON_SYRINGE_EVADE = 19;
    static constexpr int ICON_SYRINGE_DEFENSE = 20;
    static constexpr int ICON_SYRINGE_ADRENALINE = 21;
    static constexpr int ICON_SYRINGE_FOCUS = 22;
    static constexpr int ICON_SYRINGE_ANGER = 23;
    static constexpr int ICON_SYRINGE_FIRE = 24;
    static constexpr int ICON_SYRINGE_ENRAGE = 25;
    static constexpr int ICON_SYRINGE_AGILITY = 26;
    static constexpr int ICON_SYRINGE_FORTITUDE = 27;
    static constexpr int ICON_SYRINGE_REGEN = 28;
    static constexpr int ICON_SYRINGE_PURIFY = 29;
    static constexpr int ICON_SYRINGE_REFLECT = 30;
    static constexpr int ICON_SYRINGE_PROTO = 31;
    static constexpr int ICON_SYRINGE_ELITE = 32;
    static constexpr int ICON_SYRINGE_FEAR = 33;
    static constexpr int ICON_SYRINGE_EMPTY = 34;
    static constexpr int ICON_OTHER_SCOTCH = 35;
    static constexpr int ICON_OTHER_HEALTH_PACK = 36;
    static constexpr int ICON_OTHER_MEAL = 37;
    static constexpr int ICON_OTHER_TORCH = 38;
    static constexpr int ICON_OTHER_PACK = 39;
    static constexpr int ICON_ARMOR_LEATHER = 41;
    static constexpr int SCRIPT_LS_FLAG_ASYNC = 1;
    static constexpr int SCRIPT_LS_FLAG_BLOCK = 2;
    static constexpr int SCRIPT_LS_FLAG_ASYNC_BLOCK = 3;
    static constexpr int SCRIPT_LS_NO_TIME = 4;
    static constexpr int SCRIPT_LS_DEFAULT_Z = 8;
    static constexpr int SCRIPT_LS_FLAG_MAX = 16;

    //Lerp Sprite Flags
    static constexpr int LS_FLAG_ASYNC = 0x1;
    static constexpr int LS_FLAG_ANIMATING_EFFECT = 0x2;
    static constexpr int LS_FLAG_PARABOLA = 0x4;
    static constexpr int LS_FLAG_TRUNC = 0x8;
    static constexpr int LS_FLAG_ENT_NORELINK = 0x10;
    static constexpr int LS_FLAG_S_NORELINK = 0x20;
    static constexpr int LS_FLAG_DOOROPEN = 0x40;
    static constexpr int LS_FLAG_DOORCLOSE = 0x80;
    static constexpr int LS_FLAG_SECRET_OPEN = 0x100;
    static constexpr int LS_FLAG_SECRET_HIDE = 0x200;
    static constexpr int LS_FLAG_CHICKEN_KICK = 0x400;
    static constexpr int LS_FLAG_AUTO_FACE = 0x800;
    static constexpr int LS_MASK_CHICKEN_BOUNCE = (LS_FLAG_CHICKEN_KICK | LS_FLAG_TRUNC);

    static constexpr int STAT_HEALTH = 0;
    static constexpr int STAT_MAX_HEALTH = 1;
    static constexpr int STAT_ARMOR = 2;
    static constexpr int STAT_DEFENSE = 3;
    static constexpr int STAT_STRENGTH = 4;
    static constexpr int STAT_ACCURACY = 5;
    static constexpr int STAT_AGILITY = 6;
    static constexpr int STAT_IQ = 7;
    static constexpr int STAT_MAX = 8;
    static constexpr int INITIAL_DEFENSE_MAJOR = 8;
    static constexpr int INITIAL_STRENGTH_MAJOR = 9;
    static constexpr int INITIAL_ACCURACY_MAJOR = 97;
    static constexpr int INITIAL_AGILITY_MAJOR = 12;
    static constexpr int INITIAL_IQ_MAJOR = 110;
    static constexpr int INITIAL_CREDITS_MAJOR = 30;
    static constexpr int INITIAL_DEFENSE_SARGE = 12;
    static constexpr int INITIAL_STRENGTH_SARGE = 14;
    static constexpr int INITIAL_ACCURACY_SARGE = 92;
    static constexpr int INITIAL_AGILITY_SARGE = 6;
    static constexpr int INITIAL_IQ_SARGE = 100;
    static constexpr int INITIAL_CREDITS_SARGE = 10;
    static constexpr int INITIAL_DEFENSE_SCIENTIST = 8;
    static constexpr int INITIAL_STRENGTH_SCIENTIST = 8;
    static constexpr int INITIAL_ACCURACY_SCIENTIST = 87;
    static constexpr int INITIAL_AGILITY_SCIENTIST = 6;
    static constexpr int INITIAL_IQ_SCIENTIST = 150;
    static constexpr int INITIAL_CREDITS_SCIENTIST = 80;
    static constexpr int MAX_ARMOR = 200;
    static constexpr int MIN_IQ = 100;
    static constexpr int MAX_IQ = 200;
    static constexpr int MAX_OTHER_STATS = 99;
    static constexpr int STRENGTH_OF_A_REAL_MAN = 11;
    static constexpr int CHAINSAW_REPS_FOR_STRENGTH_BONUS = 30;
    static constexpr int CHAINSAW_USE_STRENGTH_BONUS = 2;
    static constexpr int MONSTER_POISON_DAMAGE = 10;
    // Monster Flags monster->flags 16544 // 40A0 - MFLAG_LERP_SHADOW - MFLAG_NOTRACK - MFLAG_NOTHINK
    static constexpr int MFLAG_NONE = 0;
    static constexpr int MFLAG_ABILITY = 0x1;
    static constexpr int MFLAG_TRIGGERONACTIVATE = 0x2;
    static constexpr int MFLAG_NOKILL = 0x4;
    static constexpr int MFLAG_NOACTIVATE = 0x8;
    static constexpr int MFLAG_NORESPAWN = 0x10;
    static constexpr int MFLAG_NOTHINK = 0x20;
    static constexpr int MFLAG_NORAISE = 0x40;
    static constexpr int MFLAG_NOTRACK = 0x80;
    static constexpr int MFLAG_WEAPON_ALT = 0x100;
    static constexpr int MFLAG_SCALED = 0x200;
    static constexpr int MFLAG_ATTACKING = 0x400;
    static constexpr int MFLAG_LOOTED = 0x800;
    static constexpr int MFLAG_KNOCKBACK = 0x1000;
    static constexpr int MFLAG_NPC_CHAT = 0x2000;
    static constexpr int MFLAG_LERP_SHADOW = 0x4000;

    static constexpr int DIR_EAST = 0;
    static constexpr int DIR_NORTHEAST = 1;
    static constexpr int DIR_NORTH = 2;
    static constexpr int DIR_NORTHWEST = 3;
    static constexpr int DIR_WEST = 4;
    static constexpr int DIR_SOUTHWEST = 5;
    static constexpr int DIR_SOUTH = 6;
    static constexpr int DIR_SOUTHEAST = 7;
    static constexpr int DIR_MAX = 8;
    static constexpr int DIR_MASK = 7;
    static constexpr int DIR_HORIZONTAL = 8;
    static constexpr int DIR_VERTICAL = 9;
    static constexpr int INHERIT_PLAYER_DIR = -2;
    static constexpr int INHERIT_PLAYER_PITCH = -2;
    static constexpr int INHERIT_PLAYER_POS = -2;
    static constexpr int SIN_TABLE_SIZE_BITS = 10;
    static constexpr int SIN_TABLE_SIZE = 1024;
    static constexpr int ANGLE_EAST = 0;
    static constexpr int ANGLE_NORTHEAST = 128;
    static constexpr int ANGLE_NORTH = 256;
    static constexpr int ANGLE_NORTHWEST = 384;
    static constexpr int ANGLE_WEST = 512;
    static constexpr int ANGLE_SOUTHWEST = 640;
    static constexpr int ANGLE_SOUTH = 768;
    static constexpr int ANGLE_SOUTHEAST = 896;
    static constexpr int ANGLE_FULL = 1023;
    static constexpr int ANGLE_PI = 512;
    static constexpr int ANGLE_2PI = 1024;
    static constexpr int ANGLE_PI_HALF = 256;
    static constexpr int ANGLE_PI_FOURTH = 128;
    static constexpr int ANGLE_PI_EIGHTH = 64;
    static constexpr int ANGLE_DIR_SHIFT = 7;
    static constexpr int ANGLE_30_DEG = 85;
    static constexpr int ANGLE_MAX_PITCH = 64;
    static constexpr int FX_NONE = 0;
    static constexpr int FX_PANZER = 1;
    static constexpr int FX_FLAME = 2;
    static constexpr int FX_BOOT = 4;
    static constexpr int FX_SLAP = 5;
    static constexpr int EV_EVAL = 0;
    static constexpr int EV_JUMP = 1;
    static constexpr int EV_RETURN = 2;
    static constexpr int LAST_INTERNAL_CMD = 2;
    static constexpr int EV_END = -1;
    static constexpr int EV_FIRST_COMMAND = 3;
    static constexpr int EV_MESSAGE = 3;
    static constexpr int EV_LERPSPRITE = 4;
    static constexpr int EV_STARTCINEMATIC = 5;
    static constexpr int EV_SETSTATE = 6;
    static constexpr int EV_CALL_FUNC = 7;
    static constexpr int EV_ITEM_COUNT = 8;
    static constexpr int EV_TILE_EMPTY = 9;
    static constexpr int EV_WEAPON_EQUIPPED = 10;
    static constexpr int EV_CHANGE_MAP = 11;
    static constexpr int EV_CAMERA_STR = 12;
    static constexpr int EV_DIALOG = 13;
    static constexpr int EV_WAIT = 14;
    static constexpr int EV_GOTO = 15;
    static constexpr int EV_ABORT_MOVE = 16;
    static constexpr int EV_ENTITY_FRAME = 17;
    static constexpr int EV_ADV_CAMERAKEY = 18;
    static constexpr int EV_DAMAGEMONSTER = 19;
    static constexpr int EV_DAMAGEPLAYER = 20;
    static constexpr int EV_DOOROP = 21;
    static constexpr int EV_MONSTERFLAGOP = 22;
    static constexpr int EV_EVENTOP = 23;
    static constexpr int EV_HIDE = 24;
    static constexpr int EV_DROPITEM = 25;
    static constexpr int EV_PREVSTATE = 26;
    static constexpr int EV_NEXTSTATE = 27;
    static constexpr int EV_WAKEMONSTER = 28;
    static constexpr int EV_SHOW_PLAYERATTACK = 29;
    static constexpr int EV_MONSTER_PARTICLES = 30;
    static constexpr int EV_SPAWN_PARTICLES = 31;
    static constexpr int EV_FADEOP = 32;
    static constexpr int EV_GIVEITEM = 33;
    static constexpr int EV_NAMEENTITY = 34;
    static constexpr int EV_DROPMONSTERITEM = 35;
    static constexpr int EV_SETDEATHFUNC = 36;
    static constexpr int EV_PLAYSOUND = 37;
    static constexpr int EV_NPCCHAT = 38;
    static constexpr int EV_STOCKSTATION = 39;
    static constexpr int EV_LERPFLAT = 40;
    static constexpr int EV_GIVELOOT = 41;
    static constexpr int EV_MARKTILE = 42;
    static constexpr int EV_UPDATEJOURNAL = 43;
    static constexpr int EV_BRIBE_ENTITY = 44;
    static constexpr int EV_PLAYER_ADD_STAT = 45;
    static constexpr int EV_PLAYER_ADD_RECIPE = 46;
    static constexpr int EV_RESPAWN_MONSTER = 47;
    static constexpr int EV_SCREEN_SHAKE = 48;
    static constexpr int EV_SPEECHBUBBLE = 49;
    static constexpr int EV_AWARDSECRET = 50;
    static constexpr int EV_AIGOAL = 51;
    static constexpr int EV_ADVANCETURN = 52;
    static constexpr int EV_MINIGAME = 53;
    static constexpr int EV_ENDMINIGAME = 54;
    static constexpr int EV_ENDROUND = 55;
    static constexpr int EV_PLAYERATTACK = 56;
    static constexpr int EV_SET_FOG_COLOR = 57;
    static constexpr int EV_LERP_FOG = 58;
    static constexpr int EV_LERPSPRITEOFFSET = 59;
    static constexpr int EV_DISABLED_WEAPONS = 60;
    static constexpr int EV_LERPSCALE = 61;
    static constexpr int EV_GIVEAWARD = 62;
    static constexpr int EV_STARTMIXING = 65;
    static constexpr int EV_DEBUGPRINT = 66;
    static constexpr int EV_GOTO_MENU = 67;
    static constexpr int EV_START_INTERCINEMATIC = 68;
    static constexpr int EV_TURN_PLAYER = 69;
    static constexpr int EV_STATUS_EFFECT = 70;
    static constexpr int EV_JOURNAL_TILE = 71;
    static constexpr int EV_MAKE_CORPSE = 72;
    static constexpr int EV_INVENTORY_OP = 73;
    static constexpr int EV_END_GAME = 74;
    static constexpr int EV_LERPSPRITEPARABOLA = 75;
    static constexpr int EV_TOGGLE_OVERLAY = 76;
    static constexpr int EV_FOG_AFFECTS_SKYMAP = 77;
    static constexpr int EV_ENABLE_HELP = 78;
    static constexpr int EV_SET_MM_RENDER_HACK = 79;
    static constexpr int EV_START_ARMORREPAIR = 80;
    static constexpr int EV_FORCE_BOT_RETURN = 81;
    static constexpr int EV_UNMARKTILE = 82;
    static constexpr int EV_ASSIGN_LOOTSET = 83;
    static constexpr int EV_START_TARGETPRACTICE = 84;
    static constexpr int EV_GIVE_AUTOMAP = 85;
    static constexpr int EV_ANGER_VIOS = 86;
    static constexpr int EV_UNHIDE_AUTOMAP = 87;
    static constexpr int EV_HIDE_AUTOMAP = 88;
    static constexpr int EV_PORTAL_EVENT = 89;
    static constexpr int EV_PITCH_CONTROL = 90;
    static constexpr int EV_USED_CHAINSAW = 91;
    static constexpr int EV_ENTITY_BREATHES = 92;
    static constexpr int EV_DESTROY_PLAYER = 93;
    static constexpr int EV_START_TREADMILL = 94;
    static constexpr int EV_STOPSOUND = 95;
    static constexpr int EV_LERPSPRITEPARABOLA_SCALE = 96;
    static constexpr int EV_SET_CALDEX_RENDER_HACK = 97;
    static constexpr int SCR_INIT_MAP = 0;
    static constexpr int SCR_END_GAME = 1;
    static constexpr int SCR_BOSS_75 = 2;
    static constexpr int SCR_BOSS_50 = 3;
    static constexpr int SCR_BOSS_25 = 4;
    static constexpr int SCR_BOSS_DEAD = 5;
    static constexpr int SCR_PER_TURN = 6;
    static constexpr int SCR_ATTACK_NPC = 7;
    static constexpr int SCR_MONSTER_DEATH = 8;
    static constexpr int SCR_MONSTER_ACTIVATE = 9;
    static constexpr int SCR_CHICKEN_KICKED = 10;
    static constexpr int SCR_ITEM_PICKUP = 11;
    static constexpr int MAX_BUILT_IN_CMD = 12;
    static constexpr int SCR_NOT_DEFINED = 65535;
    static constexpr int EVAL_VARFLAG = 128;
    static constexpr int EVAL_VARMASK = 127;
    static constexpr int EVAL_CONSTFLAG = 64;
    static constexpr int EVAL_CONSTMASK = 63;
    static constexpr int EVAL_AND = 0;
    static constexpr int EVAL_OR = 1;
    static constexpr int EVAL_LTE = 2;
    static constexpr int EVAL_LT = 3;
    static constexpr int EVAL_EQ = 4;
    static constexpr int EVAL_NEQ = 5;
    static constexpr int EVAL_NOT = 6;
    static constexpr int EVFL_EXEC_ENTER = 1;
    static constexpr int EVFL_EXEC_EXIT = 2;
    static constexpr int EVFL_EXEC_TRIGGER = 4;
    static constexpr int EVFL_EXEC_FACE = 8;
    static constexpr int EVFL_EXEC_MASK = 15;
    static constexpr int EVFL_MOD_SHIFT = 4;
    static constexpr int EVFL_MOD_EAST = 16;
    static constexpr int EVFL_MOD_NORTHEAST = 32;
    static constexpr int EVFL_MOD_NORTH = 64;
    static constexpr int EVFL_MOD_NORTHWEST = 128;
    static constexpr int EVFL_MOD_WEST = 256;
    static constexpr int EVFL_MOD_SOUTHWEST = 512;
    static constexpr int EVFL_MOD_SOUTH = 1024;
    static constexpr int EVFL_MOD_SOUTHEAST = 2048;
    static constexpr int EVFL_MOD_DIR_MASK = 4080;
    static constexpr int EVFL_MOD_MELEE = 4096;
    static constexpr int EVFL_MOD_RANGED = 8192;
    static constexpr int EVFL_MOD_EXPLOSION = 16384;
    static constexpr int EVFL_MOD_ATTACK_MASK = 28672;
    static constexpr int EVFL_FLAG_SHIFT = 16;
    static constexpr int EVFL_FLAG_BLOCKINPUT = 65536;
    static constexpr int EVFL_FLAG_EXIT_GOTO = 131072;
    static constexpr int EVFL_FLAG_SKIP_TURN = 262144;
    static constexpr int EVFL_DISABLE_SHIFT = 19;
    static constexpr int EVFL_FLAG_DISABLE = 524288;
    static constexpr int LERP_FLAG_ASYNC = 1;
    static constexpr int EVFL_OPENDOOR = 0;
    static constexpr int EVFL_CLOSEDOOR = 1;
    static constexpr int EVFL_LOCKDOOR = 2;
    static constexpr int EVFL_UNLOCKDOOR = 3;
    static constexpr int EVFL_MFLAG_ADD = 0;
    static constexpr int EVFL_MFLAG_REMOVE = 1;
    static constexpr int EVFL_MFLAG_SET = 2;
    static constexpr int CHANGEMAP_FADE_BIT = 128;
    static constexpr int CHANGEMAP_SHOWSTAT_SHIFT = 31;
    static constexpr int CHANGEMAP_SHOWSTATS_BIT = 0x80000000;
    static constexpr int STATE_MAX = 8;
    static constexpr char HYPHEN = '-';
    static constexpr char NEWLINE = '|';
    static constexpr int TILENUM_MAX = 512;
    static constexpr int TILENUM_INVALID = -512;
    static constexpr int TILENUM_EMPTY = 0;
    static constexpr int MAP_VERSION = 3;
    static constexpr int MAP_FLAG_NOMONSTERALERTS = 1;
    static constexpr int MANIM_SHIFT = 4;
    static constexpr int MANIM_MASK = 240;
    static constexpr int MANIM_IDLE = 0;
    static constexpr int MANIM_IDLE_BACK = 16;
    static constexpr int MANIM_WALK_FRONT = 32;
    static constexpr int MANIM_WALK_BACK = 48;
    static constexpr int MANIM_ATTACK1 = 64;
    static constexpr int MANIM_ATTACK2 = 80;
    static constexpr int MANIM_PAIN = 96;
    static constexpr int MANIM_DEAD = 112;
    static constexpr int MANIM_SLAP = 128;
    static constexpr int MANIM_DODGE = 144;
    static constexpr int MANIM_NPC_TALK = 160;
    static constexpr int MANIM_NPC_BACK_ACTION = 176;
    static constexpr int MFRAME_MASK = 15;
    static constexpr int MFRAME_FRONT_LEGS1 = 0;
    static constexpr int MFRAME_FRONT_LEGS2 = 1;
    static constexpr int MFRAME_FRONT_TORSO = 2;
    static constexpr int MFRAME_FRONT_HEAD = 3;
    static constexpr int MFRAME_FRONT_MAX = 4;
    static constexpr int MFRAME_BACK_LEGS1 = 4;
    static constexpr int MFRAME_BACK_LEGS2 = 5;
    static constexpr int MFRAME_BACK_TORSO = 6;
    static constexpr int MFRAME_BACK_HEAD = 7;
    static constexpr int MFRAME_IDLE_TO_ATTACK1 = 8;
    static constexpr int MFRAME_ATTACK1 = 9;
    static constexpr int MFRAME_IDLE_TO_ATTACK2 = 10;
    static constexpr int MFRAME_ATTACK2 = 11;
    static constexpr int MFRAME_ATTACKING = 12;
    static constexpr int MFRAME_PAIN = 12;
    static constexpr int MFRAME_DEAD = 13;
    static constexpr int MFRAME_SLAP_TORSO = 14;
    static constexpr int MFRAME_SLAP_HEAD1 = 15;
    static constexpr int MFRAME_SLAP_HEAD2 = 16;
    static constexpr int MFRAME_DODGE = 17;
    static constexpr int MFRAME_MAX = 18;
    static constexpr int MFRAME_AUTO = 255;
    static constexpr int NPCFRAME_FRONT_LEGS1 = 0;
    static constexpr int NPCFRAME_FRONT_LEGS2 = 1;
    static constexpr int NPCFRAME_FRONT_TORSO = 2;
    static constexpr int NPCFRAME_FRONT_HEAD = 3;
    static constexpr int NPCFRAME_FRONT_MAX = 4;
    static constexpr int NPCFRAME_BACK_LEGS1 = 4;
    static constexpr int NPCFRAME_BACK_LEGS2 = 5;
    static constexpr int NPCFRAME_BACK_TORSO = 6;
    static constexpr int NPCFRAME_BACK_HEAD = 7;
    static constexpr int NPCFRAME_MAX = 8;
    static constexpr int NPCFRAME_SLAP_TORSO = 9;
    static constexpr int NPCFRAME_SLAP_HEAD1 = 10;
    static constexpr int DLG_STYLE_NORMAL = 0;
    static constexpr int DLG_STYLE_NPC = 1;
    static constexpr int DLG_STYLE_HELP = 2;
    static constexpr int DLG_STYLE_SCROLL = 3;
    static constexpr int DLG_STYLE_CHEST = 4;
    static constexpr int DLG_STYLE_MONSTER = 5;
    static constexpr int DLG_STYLE_GHOST = 6;
    static constexpr int DLG_STYLE_YELL = 7;
    static constexpr int DLG_STYLE_PLAYER = 8;
    static constexpr int DLG_STYLE_TERMINAL = 9;
    static constexpr int DLG_STYLE_ELEVATOR = 10;
    static constexpr int DLG_STYLE_VIOS = 11;
    static constexpr int DLG_STYLE_SELF_DESTRUCT_CONFIRM = 12;
    static constexpr int DLG_STYLE_ARMOR_REPAIR = 13;
    static constexpr int DLG_STYLE_COMM_LINK = 14;
    static constexpr int DLG_STYLE_SAL = 15;
    static constexpr int DLG_STYLE_SPECIAL = 16;
    static constexpr int DLG_FLAG_NONE = 0;
    static constexpr int DLG_FLAG_YESNO = 1;
    static constexpr int DLG_FLAG_INTERROGATE = 2;
    static constexpr int DLG_FLAG_GAME = 4;
    static constexpr int DLG_FLAG_VIOS = 8;
    static constexpr int DLG_FLAG_VIOS_CHOICE = 10;
    static constexpr int FOOD_LARGE = 0;
    static constexpr int FOOD_BURNT = 2;
    static constexpr int ANIM_FRAME_COUNT = 3;
    static constexpr int ANIM_FRAME_TIME = 200;
    static constexpr int ANIM_DURATION = 600;
    static constexpr int ANIM_FLAG_INUSE = 1;
    static constexpr int ANIM_FLAG_FINISHED = 2;
    static constexpr int ANIM_FLAG_NODAMAGE = 4;
    static constexpr int TILENUM_FIRST_SPRITE = 1;
    static constexpr int TILENUM_FIRST_VIEWWEAPON = 1;
    static constexpr int TILENUM_ASSAULT_RIFLE = 1;
    static constexpr int TILENUM_CHAINSAW = 2;
    static constexpr int TILENUM_HOLY_WATER_PISTOL = 3;
    static constexpr int TILENUM_SENTRY_BOT_SHOOTING = 4;
    static constexpr int TILENUM_SENTRY_BOT_EXPLODING = 5;
    static constexpr int TILENUM_SUPER_SHOTGUN = 6;
    static constexpr int TILENUM_CHAINGUN = 7;
    static constexpr int TILENUM_ASSAULT_RIFLE_WITH_SCOPE = 8;
    static constexpr int TILENUM_PLASMA_GUN = 9;
    static constexpr int TILENUM_ROCKET_LAUNCHER = 10;
    static constexpr int TILENUM_BFG = 11;
    static constexpr int TILENUM_SOUL_CUBE = 12;
    static constexpr int TILENUM_SENTRY_BOT_RED_SHOOTING = 13;
    static constexpr int TILENUM_SENTRY_BOT_RED_EXPLODING = 14;
    static constexpr int TILENUM_LAST_VIEWWEAPON = 14;
    static constexpr int TILENUM_WORLD_WEAPON = 15;
    static constexpr int TILENUM_FIRST_MONSTER = 18;
    static constexpr int TILENUM_MONSTER_RED_SENTRY_BOT = 18;
    static constexpr int TILENUM_MONSTER_SENTRY_BOT = 19;
    static constexpr int TILENUM_MONSTER_ZOMBIE = 20;
    static constexpr int TILENUM_MONSTER_ZOMBIE2 = 21;
    static constexpr int TILENUM_MONSTER_ZOMBIE3 = 22;
    static constexpr int TILENUM_MONSTER_IMP = 23;
    static constexpr int TILENUM_MONSTER_IMP2 = 24;
    static constexpr int TILENUM_MONSTER_IMP3 = 25;
    static constexpr int TILENUM_MONSTER_SAW_GOBLIN = 26;
    static constexpr int TILENUM_MONSTER_SAW_GOBLIN2 = 27;
    static constexpr int TILENUM_MONSTER_SAW_GOBLIN3 = 28;
    static constexpr int TILENUM_MONSTER_LOST_SOUL = 29;
    static constexpr int TILENUM_MONSTER_LOST_SOUL2 = 30;
    static constexpr int TILENUM_MONSTER_LOST_SOUL3 = 31;
    static constexpr int TILENUM_MONSTER_PINKY = 32;
    static constexpr int TILENUM_MONSTER_PINKY2 = 33;
    static constexpr int TILENUM_MONSTER_PINKY3 = 34;
    static constexpr int TILENUM_MONSTER_REVENANT = 35;
    static constexpr int TILENUM_MONSTER_REVENANT2 = 36;
    static constexpr int TILENUM_MONSTER_REVENANT3 = 37;
    static constexpr int TILENUM_MONSTER_MANCUBUS = 38;
    static constexpr int TILENUM_MONSTER_MANCUBUS2 = 39;
    static constexpr int TILENUM_MONSTER_MANCUBUS3 = 40;
    static constexpr int TILENUM_MONSTER_CACODEMON = 41;
    static constexpr int TILENUM_MONSTER_CACODEMON2 = 42;
    static constexpr int TILENUM_MONSTER_CACODEMON3 = 43;
    static constexpr int TILENUM_MONSTER_SENTINEL = 44;
    static constexpr int TILENUM_MONSTER_SENTINEL2 = 45;
    static constexpr int TILENUM_MONSTER_SENTINEL3 = 46;
    static constexpr int TILENUM_MONSTER_ARCH_VILE = 50;
    static constexpr int TILENUM_MONSTER_ARCH_VILE2 = 51;
    static constexpr int TILENUM_MONSTER_ARCH_VILE3 = 52;
    static constexpr int TILENUM_MONSTER_ARACHNOTRON = 53;
    static constexpr int TILENUM_BOSS_CYBERDEMON = 54;
    static constexpr int TILENUM_BOSS_PINKY = 56;
    static constexpr int TILENUM_BOSS_MASTERMIND = 57;
    static constexpr int TILENUM_BOSS_VIOS = 58;
    static constexpr int TILENUM_BOSS_VIOS2 = 59;
    static constexpr int TILENUM_BOSS_VIOS3 = 60;
    static constexpr int TILENUM_BOSS_VIOS4 = 61;
    static constexpr int TILENUM_BOSS_VIOS5 = 62;
    static constexpr int TILENUM_LAST_MONSTER = 63;
    static constexpr int TILENUM_FIRST_NPC = 65;
    static constexpr int TILENUM_NPC_RILEY_OCONNOR = 66;
    static constexpr int TILENUM_NPC_MAJOR = 68;
    static constexpr int TILENUM_NPC_BOB = 69;
    static constexpr int TILENUM_NPC_CIVILIAN = 71;
    static constexpr int TILENUM_NPC_SARGE = 72;
    static constexpr int TILENUM_NPC_FEMALE = 73;
    static constexpr int TILENUM_NPC_EVIL_SCIENTIST = 74;
    static constexpr int TILENUM_NPC_SCIENTIST = 75;
    static constexpr int TILENUM_NPC_RESEARCHER = 76;
    static constexpr int TILENUM_NPC_CIVILIAN2 = 77;
    static constexpr int TILENUM_LAST_NPC = 80;
    static constexpr int TILENUM_FIRST_ITEM = 81;
    static constexpr int TILENUM_AMMO_BULLETS = 85;
    static constexpr int TILENUM_AMMO_SHELLS = 86;
    static constexpr int TILENUM_AMMO_ROCKETS = 88;
    static constexpr int TILENUM_AMMO_CELLS = 89;
    static constexpr int TILENUM_AMMO_HOLY_WATER = 90;
    static constexpr int TILENUM_ONE_UAC_CREDIT = 107;
    static constexpr int TILENUM_KEY_RED = 110;
    static constexpr int TILENUM_KEY_BLUE = 111;
    static constexpr int TILENUM_ARMOR_JACKET = 112;
    static constexpr int TILENUM_SATCHEL = 113;
    static constexpr int TILENUM_PACK_ITEM = 114;
    static constexpr int TILENUM_WORKER_PACK = 115;
    static constexpr int TILENUM_HEALTH_PACK = 116;
    static constexpr int TILENUM_FOOD_PLATE = 117;
    static constexpr int TILENUM_LAST_ITEM = 118;
    static constexpr int TILENUM_ARMOR_SHARD = 119;
    static constexpr int TILENUM_HELL_SEAL = 122;
    static constexpr int TILENUM_TOILET = 123;
    static constexpr int TILENUM_DIRT_DECAL = 124;
    static constexpr int TILENUM_LADDER = 125;
    static constexpr int TILENUM_SINK = 127;
    static constexpr int TILENUM_BLOOD_SPLATTER = 126;
    static constexpr int TILENUM_BARRED_WINDOW = 128;
    static constexpr int TILENUM_HAZARD_BAR = 129;
    static constexpr int TILENUM_WATER_SPOUT = 134;
    static constexpr int TILENUM_OBJ_FIRE = 130;
    static constexpr int TILENUM_TREADMILL_MONITOR = 131;
    static constexpr int TILENUM_TECH_STATION = 133;
    static constexpr int TILENUM_GLAEVENSCOPE = 201;
    static constexpr int TILENUM_SEPTIC_STATION = 147;
    static constexpr int TILENUM_OBJ_TABLE = 121;
    static constexpr int TILENUM_OBJ_CHAIR = 135;
    static constexpr int TILENUM_OBJ_TORCHIERE = 136;
    static constexpr int TILENUM_OBJ_CORPSE = 138;
    static constexpr int TILENUM_OBJ_OTHER_CORPSE = 139;
    static constexpr int TILENUM_OBJ_SCIENTIST_CORPSE = 137;
    static constexpr int TILENUM_DUMMY_START = 140;
    static constexpr int TILENUM_DUMMY_PAIN = 140;
    static constexpr int TILENUM_ATTACK_DUMMY = 141;
    static constexpr int TILENUM_EXIT_DUMMY = 142;
    static constexpr int TILENUM_USE_DUMMY = 143;
    static constexpr int TILENUM_DUMMY_END = 143;
    static constexpr int TILENUM_PRACTICE_TARGET = 149;
    static constexpr int TILENUM_OBJ_PRINTER = 150;
    static constexpr int TILENUM_OBJ_CRATE = 152;
    static constexpr int TILENUM_STONES_AND_SKULLS = 164;
    static constexpr int TILENUM_SENTINEL_SPIKES = 170;
    static constexpr int TILENUM_SENTINEL_SPIKES_DUMMY = 171;
    static constexpr int TILENUM_TECH_DETAIL = 175;
    static constexpr int TILENUM_HELL_SKULLS = 177;
    static constexpr int TILENUM_VENDING_MACHINE = 153;
    static constexpr int TILENUM_ARMOR_REPAIR = 154;
    static constexpr int TILENUM_CLOSED_PORTAL_EYE = 155;
    static constexpr int TILENUM_EYE_PORTAL = 156;
    static constexpr int TILENUM_PORTAL_SOCKET = 157;
    static constexpr int TILENUM_TREADMILL_SIDE = 158;
    static constexpr int TILENUM_TREADMILL_FRONT = 159;
    static constexpr int TILENUM_HELL_HANDS = 161;
    static constexpr int TILENUM_DOORJAMB_DECAL = 162;
    static constexpr int TILENUM_NONOBSTRUCTING_SPRITEWALL = 166;
    static constexpr int TILENUM_NONOBSTRUCTING_SPRITEWALL2 = 168;
    static constexpr int TILENUM_FENCE = 168;
    static constexpr int TILENUM_TERMINAL_TARGET = 179;
    static constexpr int TILENUM_TERMINAL_GENERAL = 180;
    static constexpr int TILENUM_TERMINAL_VIOS = 181;
    static constexpr int TILENUM_TERMINAL_BOT = 182;
    static constexpr int TILENUM_TERMINAL_HACKING = 183;
    static constexpr int TILENUM_ELEVATOR_NUMS = 184;
    static constexpr int TILENUM_FADE = 302;
    static constexpr int TILENUM_SCORCH_MARK = 212;
    static constexpr int TILENUM_SWITCH = 173;
    static constexpr int TILENUM_GLASS = 178;
    static constexpr int TILENUM_BUSH = 187;
    static constexpr int TILENUM_TREE_TOP = 188;
    static constexpr int TILENUM_TREE_TRUNK = 189;
    static constexpr int TILENUM_SFX_LIGHTGLOW1 = 193;
    static constexpr int TILENUM_STATIC_FLAME = 223;
    static constexpr int TILENUM_LAST_SPRITE = 256;
    static constexpr int TILENUM_ANIM_FIRE = 234;
    static constexpr int TILENUM_ANIM_WATER = 235;
    static constexpr int TILENUM_POOF = 241;
    static constexpr int TILENUM_WINDOW3 = 197;
    static constexpr int TILENUM_AIR_VENT = 236;
    static constexpr int TILENUM_PROJ_START = 239;
    static constexpr int TILENUM_SOUL_CUBE_ATTACK = 239;
    static constexpr int TILENUM_ANIM_START = 240;
    static constexpr int TILENUM_WATER_STREAM = 240;
    static constexpr int TILENUM_ENERGY_START = 241;
    static constexpr int TILENUM_CACO_PLASMA = 241;
    static constexpr int TILENUM_FIRE_BALL = 242;
    static constexpr int TILENUM_PLASMA_BALL = 243;
    static constexpr int TILENUM_BFG_BALL = 244;
    static constexpr int TILENUM_ENERGY_END = 244;
    static constexpr int TILENUM_ANIM_END = 244;
    static constexpr int TILENUM_ACID_SPIT = 252;
    static constexpr int TILENUM_FLESH = 227;
    static constexpr int TILENUM_ELECTRIC_SLIDE = 248;
    static constexpr int TILENUM_MONSTER_CLAW = 245;
    static constexpr int TILENUM_MONSTER_BITE = 246;
    static constexpr int TILENUM_MONSTER_BLUNT_TRAUMA = 247;
    static constexpr int TILENUM_PROJ_END = 247;
    static constexpr int TILENUM_FOG_GRAY = 208;
    static constexpr int TILENUM_NPC_CHAT = 254;
    static constexpr int TILENUM_ALERT = 255;
    static constexpr int TILENUM_FEAR_EYE = 251;
    static constexpr int TILENUM_MISSILE_START = 225;
    static constexpr int TILENUM_MISSILE_PLAYER_ROCKET = 225;
    static constexpr int TILENUM_MISSILE_ROCKET = 226;
    static constexpr int TILENUM_MISSILE_END = 231;
    static constexpr int TILENUM_SHADOW = 232;
    static constexpr int TILENUM_FIRST_WALL = 257;
    static constexpr int TILENUM_DOORJAMB = 257;
    static constexpr int TILENUM_FIRST_DOOR = 271;
    static constexpr int TILENUM_RED_DOOR_LOCKED = 271;
    static constexpr int TILENUM_RED_DOOR_UNLOCKED = 272;
    static constexpr int TILENUM_BLUE_DOOR_LOCKED = 273;
    static constexpr int TILENUM_BLUE_DOOR_UNLOCKED = 274;
    static constexpr int TILENUM_DOOR_LOCKED = 275;
    static constexpr int TILENUM_DOOR_UNLOCKED = 276;
    static constexpr int TILENUM_LEVEL_DOOR_LOCKED = 277;
    static constexpr int TILENUM_LEVEL_DOOR_UNLOCKED = 278;
    static constexpr int TILENUM_LAST_DOOR = 281;
    static constexpr int TILENUM_SKY_BOX = 301;
    static constexpr int TILENUM_LAST_WALL = 449;
    static constexpr int TILENUM_FIRST_FLAT = 450;
    static constexpr int TILENUM_FLAT_LAVA = 479;
    static constexpr int TILENUM_FLAT_LAVA2 = 480;
    static constexpr int TILENUM_LAST_FLAT = 512;
    static constexpr int TILENUM_FIRST_COMPILERONLY = 513;
    static constexpr int TILENUM_C_FILL = 513;
    static constexpr int TILENUM_C_SPAWN_NORTH = 514;
    static constexpr int TILENUM_C_SPAWN_EAST = 515;
    static constexpr int TILENUM_C_SPAWN_SOUTH = 516;
    static constexpr int TILENUM_C_SPAWN_WEST = 517;
    static constexpr int TILENUM_C_NO_AUTOMAP = 518;
    static constexpr int TILENUM_C_DOOR_HORZ = 529;
    static constexpr int TILENUM_C_DOOR_VERT = 530;
    static constexpr int TILENUM_C_FIRST_MOVINGBLOCK = 531;
    static constexpr int TILENUM_C_PUSHWALL_HORZ = 531;
    static constexpr int TILENUM_C_PUSHWALL_VERT = 532;
    static constexpr int TILENUM_C_PUSHBLOCK = 533;
    static constexpr int TILENUM_C_SECRETBLOCK_VERT = 534;
    static constexpr int TILENUM_C_SECRETBLOCK_HORZ = 535;
    static constexpr int TILENUM_C_LAST_MOVINGBLOCK = 535;
    static constexpr int TILENUM_C_TEXFLIP = 536;
    static constexpr int TILENUM_C_TRIBEVEL_NW = 545;
    static constexpr int TILENUM_C_TRIBEVEL_NE = 546;
    static constexpr int TILENUM_C_TRIBEVEL_SE = 547;
    static constexpr int TILENUM_C_TRIBEVEL_SW = 548;
    static constexpr int TILENUM_C_SHALLOWBEVEL_SE = 549;
    static constexpr int TILENUM_C_SHALLOWBEVEL_SW = 550;
    static constexpr int TILENUM_C_SHALLOWBEVEL_NW = 551;
    static constexpr int TILENUM_C_SHALLOWBEVEL_NE = 552;
    static constexpr int TILENUM_C_FIRST_DEEPBEVEL = 553;
    static constexpr int TILENUM_C_DEEPBEVEL_NW = 553;
    static constexpr int TILENUM_C_DEEPBEVEL_NE = 554;
    static constexpr int TILENUM_C_DEEPBEVEL_SE = 555;
    static constexpr int TILENUM_C_DEEPBEVEL_SW = 556;
    static constexpr int TILENUM_C_LAST_DEEPBEVEL = 556;
    static constexpr int TILENUM_C_COLUMN = 557;
    static constexpr int TILENUM_C_ENDCAP_N = 558;
    static constexpr int TILENUM_C_ENDCAP_E = 559;
    static constexpr int TILENUM_C_ENDCAP_S = 560;
    static constexpr int TILENUM_C_ENDCAP_W = 561;
    static constexpr int TILENUM_C_FIRST_POST = 562;
    static constexpr int TILENUM_C_CORNERPOST_NW = 562;
    static constexpr int TILENUM_C_CORNERPOST_NE = 563;
    static constexpr int TILENUM_C_CORNERPOST_SE = 564;
    static constexpr int TILENUM_C_CORNERPOST_SW = 565;
    static constexpr int TILENUM_C_LAST_POST = 565;
    static constexpr int TILENUM_C_COLLIDER = 566;
    static constexpr int TILENUM_C_SPWALL_SOUTH = 577;
    static constexpr int TILENUM_C_SPWALL_NORTH = 578;
    static constexpr int TILENUM_C_SPWALL_EAST = 579;
    static constexpr int TILENUM_C_SPWALL_WEST = 580;
    static constexpr int TILENUM_C_NSSPWALL_SOUTH = 581;
    static constexpr int TILENUM_C_NSSPWALL_NORTH = 582;
    static constexpr int TILENUM_C_NSSPWALL_EAST = 583;
    static constexpr int TILENUM_C_NSSPWALL_WEST = 584;
    static constexpr int TILENUM_C_SPWALL_HORIZONTAL = 585;
    static constexpr int TILENUM_C_SPWALL_VERTICAL = 586;
    static constexpr int TILENUM_C_NSSPWALL_HORIZONTAL = 587;
    static constexpr int TILENUM_C_NSSPWALL_VERTICAL = 588;
    static constexpr int TILENUM_OCCLUSION_LINE = 600;
    static constexpr int TILENUM_BSP_LINE = 601;
    static constexpr int TILENUM_CLIP_LINE = 602;
    static constexpr int TILENUM_VIS_LINE = 604;
    static constexpr int TILENUM_MOVE_LINE = 605;
    static constexpr int TILENUM_MAP_LINE = 606;
    static constexpr int TILENUM_CLIP_FACE_LINE = 607;
    static constexpr int EVT_INDEX_MASK = 1023;
    static constexpr int EVT_FUNCTION_SHIFT = 16;
    static constexpr int EVT_FUNCTION_MASK = -65536;
    static constexpr int EFL_NONINTERACTIVE = 1;
    static constexpr int MAX_SCRIPT_STACK = 8;
    static constexpr int SCRIPT_FAILURE = 0;
    static constexpr int SCRIPT_SUCCESS = 1;
    static constexpr int SCRIPT_PAUSED = 2;
    static constexpr int SCRIPT_ABORTED = 3;
    static constexpr int SCRIPT_FLAG_PLAYERFORCED = 1;
    static constexpr int SCRIPT_FLAG_PAUSED = 2;
    static constexpr int SCRIPT_FLAG_NOAUTOUNPAUSE = 4;
    static constexpr uint8_t TBL_COMBAT_MONSTERATTACKS = 0;
    static constexpr uint8_t TBL_COMBAT_WEAPONINFO = 1;
    static constexpr uint8_t TBL_COMBAT_WEAPONDATA = 2;
    static constexpr uint8_t TBL_COMBAT_MONSTERSTATS = 3;
    static constexpr uint8_t TBL_COMBAT_COMBATMASK = 4;
    static constexpr uint8_t TBL_CANVAS_KEYSNUMERIC = 5;
    static constexpr uint8_t TBL_ENUMS_OSC_CYCLE = 6;
    static constexpr uint8_t TBL_GAME_LEVELNAMES = 7;
    static constexpr uint8_t TBL_RENDER_SINETABLE = 8;
    static constexpr uint8_t TBL_ENERGY_DRINK_DATA = 9;
    static constexpr uint8_t TBL_MONSTER_WEAKNESS = 10;
    static constexpr uint8_t TBL_SKYMAP1_PALETTE = 11;
    static constexpr uint8_t TBL_SKYMAP1_TEXELS = 12;
    static constexpr uint8_t TBL_SKYMAP2_PALETTE = 13;
    static constexpr uint8_t TBL_SKYMAP2_TEXELS = 14;
    static constexpr uint8_t TBL_TOTAL = 15;
    static constexpr int MAX_MOVING_LINES = 120;
    static constexpr int ML_NUM_FIELDS = 3;
    static constexpr int ML_NONE = 255;
    static constexpr int OFS_ML_LINE = 0;
    static constexpr int OFS_ML_PREV = 120;
    static constexpr int OFS_ML_NEXT = 240;
    static constexpr uint8_t OFS_SS_EVENT = 0;
    static constexpr uint8_t OFS_SS_TYPEMASK = 8;
    static constexpr uint8_t OFS_SS_CMDINDEX = 16;
    static constexpr uint8_t OFS_SS_FLAGS = 24;
    static constexpr uint8_t NUM_SCRIPT_STACK_FIELDS = 4;
    static constexpr int DEFAULT_VIEWZ = 36;
    static constexpr int DEFAULT_FOVX = 220;
    static constexpr int MIN_FOV_X = 64;
    static constexpr int SNIPER_MIN_FOVX = 80;
    static constexpr int SNIPER_DEFAULT_FOVX = 120;
    static constexpr uint8_t MAX_PARTICLES = 48;
    static constexpr short OFS_PARTICLE_ACTIVE = 0;
    static constexpr short OFS_PARTICLE_X = 48;
    static constexpr short OFS_PARTICLE_Y = 96;
    static constexpr short OFS_PARTICLE_VX = 144;
    static constexpr short OFS_PARTICLE_VY = 192;
    static constexpr short OFS_PARTICLE_SIZE = 240;
    static constexpr uint8_t NUM_PARTICLE_FIELDS = 6;
    static constexpr int CR_HIT = 1;
    static constexpr int CR_CRIT = 2;
    static constexpr int CR_WEAK_HIT = 4;
    static constexpr int CR_AVGDMG = 8;
    static constexpr int CR_IGNORERANGE = 16;
    static constexpr int CR_NOSTRBONUS = 32;
    static constexpr int CR_REQUIRERANGE = 64;
    static constexpr int CR_DODGE = 128;
    static constexpr int CR_IMMUNE = 256;
    static constexpr int CR_SHADOWED = 512;
    static constexpr int CR_OUTOFRANGE = 1024;
    static constexpr int CR_ABILITY = 2048;
    static constexpr int CR_BOMB_STUCK = 4096;
    static constexpr int CR_CRIT_DAMAGE = 8192;
    static constexpr int CR_HITMASK = 4103;
    static constexpr int POS_X = 0;
    static constexpr int POS_Y = 1;
    static constexpr int POS_Z = 2;
    static constexpr int POS_START = 0;
    static constexpr int POS_SX = 0;
    static constexpr int POS_SY = 1;
    static constexpr int POS_SZ = 2;
    static constexpr int POS_DEST = 3;
    static constexpr int POS_DX = 3;
    static constexpr int POS_DY = 4;
    static constexpr int POS_DZ = 5;

    // Actions
    static constexpr int ACTION_BREW_BACK = -1;
    static constexpr int ACTION_NONE = 0;
    static constexpr int ACTION_UP = 1;
    static constexpr int ACTION_DOWN = 2;
    static constexpr int ACTION_LEFT = 3;
    static constexpr int ACTION_RIGHT = 4;
    static constexpr int ACTION_MENU = 5;
    static constexpr int ACTION_FIRE = 6;
    static constexpr int ACTION_AUTOMAP = 7;
    static constexpr int ACTION_STRAFELEFT = 9;
    static constexpr int ACTION_STRAFERIGHT = 10;
    static constexpr int ACTION_PREVWEAPON = 11;
    static constexpr int ACTION_NEXTWEAPON = 12;
    static constexpr int ACTION_PASSTURN = 14;
    static constexpr int ACTION_BACK = 15;
    static constexpr int ACTION_ITEMS = 17; // IOS
    static constexpr int ACTION_ITEMS_DRINKS = 18; // IOS
    static constexpr int ACTION_QUESTLOG = 19; // IOS
    static constexpr int ACTION_MENU_ITEM_INFO = 20; // [GEC]
    static constexpr int ACTION_BOT_DISCARD = 21; // [GEC]
    static constexpr int ACTION_MATRIX_LEFT = 64; // [GEC]
    static constexpr int ACTION_MATRIX_RIGHT = 65; // [GEC]

    static constexpr uint8_t ERR_DEQUEUEHELP = 0;
    static constexpr uint8_t ERR_ADDMOVINGBLOCK = 1;
    static constexpr uint8_t ERR_BADEVENT = 2;
    static constexpr uint8_t ERR_BADLINKWORLD = 3;
    static constexpr uint8_t ERR_BADUNLINKWORLD = 4;
    static constexpr uint8_t ERR_CLEANCORPSE = 5;
    static constexpr uint8_t ERR_DRAWSTRING = 6;
    static constexpr uint8_t ERR_DROPCHESTITEM = 7;
    static constexpr uint8_t ERR_EV_DAMAGEENTITY = 8;
    static constexpr uint8_t ERR_EV_DEACTIVATE = 9;
    static constexpr uint8_t ERR_INTRO_IMAGES = 10;
    static constexpr uint8_t ERR_EV_MONSTERFLAGS = 11;
    static constexpr uint8_t ERR_EV_MONSTERSTAT = 12;
    static constexpr uint8_t ERR_EV_NAMEENTITY = 13;
    static constexpr uint8_t ERR_EV_SHOWCHATBUBBLE = 14;
    static constexpr uint8_t ERR_EV_WAKEMONSTER = 15;
    static constexpr uint8_t ERR_GIVE_ITEM = 16;
    static constexpr uint8_t ERR_IO_CREDITS = 17;
    static constexpr uint8_t ERR_IO_ENTITYDEFS = 18;
    static constexpr uint8_t ERR_IO_LOADENTITYSTATES = 19;
    static constexpr uint8_t ERR_IO_LOADHELPRSRC = 20;
    static constexpr uint8_t ERR_IO_LOADMENUS = 21;
    static constexpr uint8_t ERR_IO_LOADMOVINGBLOCKS = 22;
    static constexpr uint8_t ERR_MISC_SCRIPT = 23;
    static constexpr uint8_t ERR_IO_STORY = 24;
    static constexpr uint8_t ERR_ISNAMEDENTITY = 25;
    static constexpr uint8_t ERR_LINKLINKEDENTITY = 26;
    static constexpr uint8_t ERR_LINKWORLD = 27;
    static constexpr uint8_t ERR_LOADCONFIG = 28;
    static constexpr uint8_t ERR_LOADMENUITEMS = 29;
    static constexpr uint8_t ERR_LOADMOVINGBLOCKS = 30;
    static constexpr uint8_t ERR_LOADPLAYERSTATE = 31;
    static constexpr uint8_t ERR_LOADSTATE = 32;
    static constexpr uint8_t ERR_LOADWORLDSTATE = 33;
    static constexpr uint8_t ERR_MAX_CUSTOMSPRITES = 34;
    static constexpr uint8_t ERR_MAX_ENTITIES = 35;
    static constexpr uint8_t ERR_MAX_LERPSPRITES = 36;
    static constexpr uint8_t ERR_MAX_MONSTERS = 37;
    static constexpr uint8_t ERR_MAX_MOVINGBLOCKS = 38;
    static constexpr uint8_t ERR_MAX_NOTEBOOKINDEXES = 39;
    static constexpr uint8_t ERR_MAX_SCRIPTTHREADS = 40;
    static constexpr uint8_t ERR_MAXHELP = 41;
    static constexpr uint8_t ERR_MOVEBLOCKTO = 42;
    static constexpr uint8_t ERR_SAVECONFIG = 43;
    static constexpr uint8_t ERR_SAVEENTITYSTATES = 44;
    static constexpr uint8_t ERR_SAVEMOVINGBLOCKS = 45;
    static constexpr uint8_t ERR_SAVEPLAYERSTATE = 46;
    static constexpr uint8_t ERR_SAVESNAPSHOT = 47;
    static constexpr uint8_t ERR_SAVESTATE = 48;
    static constexpr uint8_t ERR_SAVEWORLDSTATE = 49;
    static constexpr uint8_t ERR_SPAWNPARTICLES = 50;
    static constexpr uint8_t ERR_STATE = 51;
    static constexpr uint8_t ERR_UNLINKWORLD = 52;
    static constexpr uint8_t ERR_WRAPTEXT = 53;
    static constexpr uint8_t ERR_MAX_SCRIPTSTACK = 54;
    static constexpr uint8_t ERR_CLEARMOVINGBLOCKS = 55;
    static constexpr uint8_t ERR_LOADIMAGE = 56;
    static constexpr uint8_t ERR_STARTUP = 57;
    static constexpr uint8_t ERR_LOADMAPPINGS = 58;
    static constexpr uint8_t ERR_LOADPALETTES = 59;
    static constexpr uint8_t ERR_LOADSHAPES = 60;
    static constexpr uint8_t ERR_LOADSPRITETEXELS = 61;
    static constexpr uint8_t ERR_LOADWALLTEXELS = 62;
    static constexpr uint8_t ERR_INVALIDMEDIA = 63;
    static constexpr uint8_t ERR_MAX_MOVINGLINES = 64;
    static constexpr uint8_t ERR_MAX_TILEREFS = 65;
    static constexpr uint8_t ERR_UPDATEMLFLAGS = 66;
    static constexpr uint8_t ERR_BADMAPSTRINGS = 67;
    static constexpr uint8_t ERR_BADMAPVERSION = 68;
    static constexpr uint8_t ERR_INVALIDBITDEPTH = 69;
    static constexpr uint8_t ERR_MAX_SPRITEMAPPING = 70;
    static constexpr uint8_t ERR_MAX_SPRITEMEDIAMAPPING = 71;
    static constexpr uint8_t ERR_MAX_TEXMAPPING = 72;
    static constexpr uint8_t ERR_MAX_TEXMEDIAMAPPING = 73;
    static constexpr uint8_t ERR_NUMTEXELSOVERFLOW = 74;
    static constexpr uint8_t ERR_SHAPEDATAOVERFLOW = 75;
    static constexpr uint8_t ERR_EV_AIGOAL = 76;
    static constexpr uint8_t ERR_LOADTABLE = 77;
    static constexpr uint8_t ERR_MEMORY = 78;
    static constexpr uint8_t ERR_TEXEL_OVERFLOW = 79;
    static constexpr uint8_t ERR_SND_LOADFILEINDEX = 80;
    static constexpr uint8_t ERR_DELETERECORD = 81;
    static constexpr uint8_t ERR_CLOSERECORD = 82;
    static constexpr uint8_t ERR_SAVERECORD = 83;
    static constexpr uint8_t ERR_LOCALIZE_INVALID_STRING = 84;
    static constexpr uint8_t ERR_LOCALIZE_UNLOADED_TYPE = 85;
    static constexpr uint8_t ERR_LOCALIZE_BAD_ARG = 86;
    static constexpr uint8_t ERR_STRINGTABLE = 87;
    static constexpr uint8_t ERR_LOADSTRINGS = 88;
    static constexpr uint8_t ERR_LOADFILESTRING = 89;
    static constexpr uint8_t ERR_MISSINGLOOTPARAM = 90;
    static constexpr uint8_t ERR_PASSWORDLENGTH = 91;
    static constexpr uint8_t ERR_PASSWORDCHARS = 92;
    static constexpr uint8_t ERR_PASSWORDMISSING = 93;
    static constexpr uint8_t ERR_MAXCAMERAS = 94;
    static constexpr uint8_t ERR_NONSNAPPEDMONSTERS = 95;
    static constexpr uint8_t ERR_INVALIDSPRITENUMBER = 96;
    static constexpr uint8_t ERR_SPRITENUMBERBOUNDS = 97;
    static constexpr uint8_t ERR_NOSUCHSPRITE = 98;
    static constexpr uint8_t ERR_MAXFRAMES = 99;
    static constexpr uint8_t ERR_MAXMENUITEMS = 100;
    static constexpr uint8_t ERR_MAPPINGRANGE = 101;
    static constexpr uint8_t ERR_SCRIPTTHREAD_FREE = 102;
    static constexpr uint8_t ERR_IO_CAMERAS = 103;
    static constexpr uint8_t ERR_FLAT_OUT_OF_ORDER = 104;
    static constexpr uint8_t ERR_IO_TILE_TEXELS = 105;
    static constexpr uint8_t ERR_IO_SPRITE_TEXELS = 106;
    static constexpr uint8_t ERR_RENDER_STRETCH = 107;
    static constexpr uint8_t ERR_MAX_MISSILES = 108;
    static constexpr uint8_t ERR_EV_DROPITEM = 109;
    static constexpr uint8_t ERR_ASSERT = 110;
    static constexpr uint8_t ERR_MAX_DROPPED_DYNAMITE = 111;
    static constexpr uint8_t ERR_COCKTAILMIX = 112;
    static constexpr uint8_t ERR_INV_CARD = 113;
    static constexpr uint8_t ERR_MENU_SET = 114;
    static constexpr uint8_t ERR_CARD_BET = 115;
    static constexpr uint8_t ERR_CAM_KEYS = 116;
    static constexpr uint8_t ERR_ENT_LOOTSET = 117;
    static constexpr uint8_t ERR_READ_uint8_t = 118;
    static constexpr int HELP_NPC = 0;
    static constexpr int HELP_POTIONS = 1;
    static constexpr int HELP_RINGS = 2;
    static constexpr int HELP_RUNELOCKS = 3;
    static constexpr int HELP_BARRICADE = 4;
    static constexpr int HELP_FOOD = 8;
    static constexpr int HELP_MONEY = 9;
    static constexpr int HELP_NOTE = 10;
    static constexpr int HELP_RUBBLE = 11;
    static constexpr int HELP_DWARVENALE = 12;
    static constexpr int HELP_FIREPIT_ON = 13;
    static constexpr int HELP_FIREPIT_OFF = 14;
    static constexpr int HELP_DOORS = 18;
    static constexpr int HELP_CRYSTALS = 19;
    static constexpr int HELP_ARMOUR_LOW = 20;
    static constexpr int HELP_GAYA = 21;
    static constexpr int HELP_GAYA2 = 22;
    static constexpr int HELP_GAYA3 = 23;
    static constexpr int HELP_SECRETSFOUND = 24;
    static constexpr int HELP_MONSTERSKILLED = 25;
    static constexpr int STATUS_EFFECT_NONE = -1;
    static constexpr int STATUS_EFFECT_REFLECT = 0;
    static constexpr int STATUS_EFFECT_PURIFY = 1;
    static constexpr int STATUS_EFFECT_AGILITY = 2;
    static constexpr int STATUS_EFFECT_REGEN = 3;
    static constexpr int STATUS_EFFECT_DEFENSE = 4;
    static constexpr int STATUS_EFFECT_ADRENALINE = 5;
    static constexpr int STATUS_EFFECT_EVADE = 6;
    static constexpr int STATUS_EFFECT_FOCUS = 7;
    static constexpr int STATUS_EFFECT_ANGER = 8;
    static constexpr int STATUS_EFFECT_ANTIFIRE = 9;
    static constexpr int STATUS_EFFECT_FORTITUDE = 10;
    static constexpr int STATUS_EFFECT_FEAR = 11;
    static constexpr int STATUS_EFFECT_WP_POISON = 12;
    static constexpr int STATUS_EFFECT_FIRE = 13;
    static constexpr int STATUS_EFFECT_DISEASE = 14;
    static constexpr int STATUS_EFFECT_DRUNK = 15;
    static constexpr int STATUS_EFFECT_DIZZY = 16;
    static constexpr int STATUS_EFFECT_COLD = 17;
    static constexpr int MAX_STATUS_EFFECTS = 18;
    static constexpr int STATUS_EFFECT_ALL = 18;
    static constexpr int OFS_STATUSEFFECT_TURNS = 0;
    static constexpr int OFS_STATUSEFFECT_AMOUNT = 18;
    static constexpr int OFS_STATUSEFFECT_COUNT = 36;
    static constexpr int BUFF_AMT_NOT_DRAWN = 14855;
    static constexpr int BUFF_REFLECT = 0;
    static constexpr int BUFF_PURIFY = 1;
    static constexpr int BUFF_HASTE = 2;
    static constexpr int BUFF_REGEN = 3;
    static constexpr int BUFF_DEFENSE = 4;
    static constexpr int BUFF_STRENGTH = 5;
    static constexpr int BUFF_AGILITY = 6;
    static constexpr int BUFF_FOCUS = 7;
    static constexpr int BUFF_ANGER = 8;
    static constexpr int BUFF_ANTIFIRE = 9;
    static constexpr int BUFF_FORTITUDE = 10;
    static constexpr int BUFF_FEAR = 11;
    static constexpr int BUFF_WP_POISON = 12;
    static constexpr int BUFF_FIRE = 13;
    static constexpr int BUFF_DISEASE = 14;
    static constexpr int BUFF_MAX = 15;
    static constexpr int BUFF_NO_AMOUNT = 6663;
    static constexpr int BUFF_WARNING_TIME = 10;
    static constexpr int LINE_TYPE_LINE = 0;
    static constexpr int LINE_TYPE_BSP = 1;
    static constexpr int LINE_TYPE_CLIP = 2;
    static constexpr int LINE_TYPE_VIS = 4;
    static constexpr int LINE_TYPE_MOVE = 5;
    static constexpr int LINE_TYPE_MAP = 6;
    static constexpr int LINE_TYPE_CLIP_FACE = 7;
    static constexpr int LINE_TYPE_MASK = 7;
    static constexpr int LINE_FLAG_AUTOMAP = 8;
    static constexpr int NODE_OFFSET_LEAF = 65535;
    static constexpr int SPRITE_SHIFT_FRAMENUMBER = 8;
    static constexpr int SPRITE_SHIFT_FLAGS = 16;
    static constexpr int SPRITE_MASK_SPRITENUMBER = 255;
    static constexpr int SPRITE_MASK_FRAMENUMBER = 65280;
    static constexpr int SPRITE_MASK_GFX = 65535;
    static constexpr int SPRITE_MASK_LOFLAGS = 16711680;
    static constexpr int SPRITE_MASK_HIFLAGS = -16777216;
    static constexpr int SPRITE_SHIFT_HIDDEN = 16;
    static constexpr int SPRITE_SHIFT_FLIP_HORIZONTAL = 17;
    static constexpr int SPRITE_SHIFT_FLIP_VERTICAL = 18;
    static constexpr int SPRITE_SHIFT_AUTO_ANIMATE = 19;
    static constexpr int SPRITE_SHIFT_TWO_SIDED = 20;
    static constexpr int SPRITE_SHIFT_AUTOMAP_VISIBLE = 21;
    static constexpr int SPRITE_SHIFT_TILE = 22;
    static constexpr int SPRITE_SHIFT_SOLIDSIDE = 23;
    static constexpr int SPRITE_SHIFT_NORTH = 24;
    static constexpr int SPRITE_SHIFT_SOUTH = 25;
    static constexpr int SPRITE_SHIFT_EAST = 26;
    static constexpr int SPRITE_SHIFT_WEST = 27;
    static constexpr int SPRITE_SHIFT_DECAL = 28;
    static constexpr int SPRITE_SHIFT_FLAT = 29;
    static constexpr int SPRITE_SHIFT_CLIPZ = 30;
    static constexpr int SPRITE_SHIFT_DOORLERP = 31;

    // Sprite flags
    static constexpr int SPRITE_FLAG_HIDDEN = 0x10000;
    static constexpr int SPRITE_FLAG_FLIP_HORIZONTAL = 0x20000;
    static constexpr int SPRITE_FLAG_FLIP_VERTICAL = 0x40000;
    static constexpr int SPRITE_FLAG_AUTO_ANIMATE = 0x80000;
    static constexpr int SPRITE_FLAG_TWO_SIDED = 0x100000;
    static constexpr int SPRITE_FLAG_AUTOMAP_VISIBLE = 0x200000;
    static constexpr int SPRITE_FLAG_NOENTITY = 0x200000;
    static constexpr int SPRITE_FLAG_TILE = 0x400000;
    static constexpr int SPRITE_FLAG_SOLIDSIDE = 0x800000;
    static constexpr int SPRITE_FLAG_NORTH = 0x1000000;
    static constexpr int SPRITE_FLAG_SOUTH = 0x2000000;
    static constexpr int SPRITE_FLAG_EAST = 0x4000000;
    static constexpr int SPRITE_FLAG_WEST = 0x8000000;
    static constexpr int SPRITE_FLAG_DECAL = 0x10000000;
    static constexpr int SPRITE_FLAG_FLAT = 0x20000000;
    static constexpr int SPRITE_FLAG_CLIPZ = 0x40000000;
    static constexpr int SPRITE_FLAG_DOORLERP = 0x80000000;
    static constexpr int SPRITE_FLAGS_ORIENTED = 0xF000000;
    static constexpr int SPRITE_FLAGS_HORIZONTAL = 0x3000000;
    static constexpr int SPRITE_FLAGS_VERTICAL = 0xC000000;

    static constexpr int COUNTER_TREASURE = 0;
    static constexpr int COUNTER_MAXDAMAGE = 1;
    static constexpr int COUNTER_TOTALDAMAGE = 2;
    static constexpr int COUNTER_TURNSDRUNK = 3;
    static constexpr int COUNTER_CORPSESGIBBED = 4;
    static constexpr int COUNTER_XP = 5;
    static constexpr int COUNTER_NUMSHOTS = 6;
    static constexpr int COUNTER_NUMMISSED = 7;
    static constexpr int COUNTERS_TOTAL = 8;
    static constexpr int BAR_HEIGHT = 37;
    static constexpr int SOFTKEY_HEIGHT = 48;
    static constexpr int HUD_HEIGHT = 49;
    static constexpr int MAP_NONE = 0;
    static constexpr int MAP_M01 = 1;
    static constexpr int MAP_M02 = 2;
    static constexpr int MAP_M03 = 3;
    static constexpr int MAP_M04 = 4;
    static constexpr int MAP_M05 = 5;
    static constexpr int MAP_M06 = 6;
    static constexpr int MAP_M07 = 7;
    static constexpr int MAP_M08 = 8;
    static constexpr int MAP_M09 = 9;
    static constexpr int MAP_LAST_RELEASE = 9;
    static constexpr int MAP_M10 = 10;
    static constexpr int MAP_LAST_SAVE = 10;
    static constexpr int MAP_MAX = 11;
    static constexpr int CODEVAR_DRUNK = 0;
    static constexpr int CODEVAR_HEALTH = 1;
    static constexpr int CODEVAR_PLAYER_X = 2;
    static constexpr int CODEVAR_PLAYER_Y = 3;
    static constexpr int CODEVAR_DIALOG_CHOICE = 4;
    static constexpr int CODEVAR_DRAW_SKYMAP = 5;
    static constexpr int CODEVAR_OSCILLATE_FOV = 6;
    static constexpr int CODEVAR_COMMMAND_RETURN = 7;
    static constexpr int CODEVAR_PLAYER_GOLD = 8;
    static constexpr int CODEVAR_PINKINATOR_X = 9;
    static constexpr int CODEVAR_PINKINATOR_Y = 10;
    static constexpr int CODEVAR_PICKUP_ITEM_TILE = 11;
    static constexpr int CODEVAR_DIFFICULTY = 12;
    static constexpr int CODEVAR_KICKING_TURN = 13;
    static constexpr int CODEVAR_CHARACTER_CHOICE = 14;
    static constexpr int CODEVAR_LAST_LEVEL_LOAD = 15;
    static constexpr int CODEVAR_IS_SENTRY_BOT = 16;
    static constexpr int NUM_CODEVARS = 17;
    static constexpr int PLAYER_FMARINE = 1;
    static constexpr int PLAYER_MMARINE = 2;
    static constexpr int PLAYER_SCIENTIST = 3;
    static constexpr int NUMBER_OF_CHARACTER_CHOICES = 3;
    static constexpr short PLAYER_NO_BOT = 0;
    static constexpr short PLAYER_SHOOTING_SENTRY_BOT = 1;
    static constexpr short PLAYER_EXPLODING_SENTRY_BOT = 2;
    static constexpr short PLAYER_RED_SHOOTING_SENTRY_BOT = 3;
    static constexpr short PLAYER_RED_EXPLODING_SENTRY_BOT = 4;
    static constexpr short REGULAR_BOT = 0;
    static constexpr short RED_BOT = 1;
    static constexpr short YES = 1;
    static constexpr short NO = 0;
    static constexpr int LOAD_FROM_PREVIOUS_LEVEL = 0;
    static constexpr int LOAD_FROM_SAME_LEVEL = 1;
    static constexpr int LOAD_FROM_NEXT_LEVEL = 2;
    static constexpr int MARKTILE_MONSTER_CLIP = 1;
    static constexpr int MARKTILE_LADDER = 2;
    static constexpr int MARKTILE_DEPLOY_BOT_CLIP = 4;
    static constexpr int MARKTILE_DISCARD_BOT_CLIP = 8;
    static constexpr int MARKTILE_EXIT = 16;
    static constexpr int MARKTILE_ENTRANCE = 32;
    static constexpr int MARKTILE_MASK = 63;
    static constexpr int GIVE_ITEM_FAIL = 1;
    static constexpr int GIVE_ITEM_SUCCESS = 0;
    static constexpr int PROMPT_YES = 0;
    static constexpr int PROMPT_NO = 1;
    static constexpr int PROMPT_MAX = 2;
    static constexpr int GAME_EXIT = 0;
    static constexpr int GAME_PLAY = 1;
    static constexpr int POLY_FLAG_VERTS_OFFSET = 2;
    static constexpr int POLY_FLAG_VERTS_MASK = 7;
    static constexpr int POLY_MAX_VERTS = 9;
    static constexpr int POLY_FLAG_AXIS_SHIFT = 3;
    static constexpr int POLY_FLAG_AXIS_X = 0;
    static constexpr int POLY_FLAG_AXIS_Y = 8;
    static constexpr int POLY_FLAG_AXIS_Z = 16;
    static constexpr int POLY_FLAG_AXIS_NONE = 24;
    static constexpr int POLY_FLAG_AXIS_MASK = 24;
    static constexpr int POLY_FLAG_WALL_TEXTURE = 32;
    static constexpr int POLY_FLAG_SWAPXY = 64;
    static constexpr int POLY_FLAG_UV_DELTAX = 128;
    static constexpr int GAME_SENTRY_BOT = 0;
    static constexpr int GAME_CHICKEN = 1;
    static constexpr int GAME_HACK = 2;
    static constexpr int GAME_WAR = 3;
    static constexpr int GAME_VENDING_MACHINE = 4;
    static constexpr int RANDOM_PUZZLE = 0;
    static constexpr int LOAD_PUZZLE = 1;
    static constexpr int HACKING_MAX_COLUMNS = 6;
    static constexpr int HACKING_MIN_COLUMNS = 3;
    static constexpr int PLAYER_LOST = 0;
    static constexpr int PLAYER_WON = 1;
    static constexpr int PLAYER_QUIT = 2;
    static constexpr int MINIGAME_IQ_BONUS = 2;
    static constexpr int VENDING_MACHINES_PER_MAP = 2;
    static constexpr int NUMBER_OF_MAPS = 9;
    static constexpr int SET_CONTROL = 0;
    static constexpr int FREE_CONTROL = 1;
    static constexpr int SETUP_FOR_VIOS_BATTLE = 0;
    static constexpr int SETUP_FOR_TARGET_PRACTICE = 1;
    static constexpr int RESTORE = 2;
    static constexpr int ACHIEVEMENT_ITEMS = 0;
    static constexpr int ACHIEVEMENT_SECRETS = 1;
    static constexpr int ACHIEVEMENT_ENEMIES = 2;
    static constexpr int ACHIEVEMENT_DESTROYED = 3;
    static constexpr int DEBUG_PRINT_STR = 0;
    static constexpr int DEBUG_PRINT_STATE = 1;
    static constexpr int COLOR_WHITE = -1;
    static constexpr int COLOR_BLACK = -16777216;
    static constexpr int COLOR_MAP_LINE = -14010793;
    static constexpr int COLOR_MAP_ENTRANCE = -16711936;
    static constexpr int COLOR_MAP_EXIT = -65536;
    static constexpr int COLOR_MAP_LADDER = -256;
    static constexpr int COLOR_MAP_FLOOR = -7292441;
    static constexpr int COLOR_MAP_DOOR1 = -16727809;
    static constexpr int COLOR_MAP_DOOR2 = -31744;
    static constexpr int COLOR_MAP_DOOR3 = -12752669;
    static constexpr int COLOR_MAP_SPRWALL = -7503768;
    static constexpr int COLOR_MAP_NPC = -16776961;
    static constexpr int COLOR_MAP_INTER = -8388353;
    static constexpr int COLOR_MAP_MONSTER1 = -16776961;
    static constexpr int COLOR_MAP_MONSTER2 = -32768;
    static constexpr int COLOR_MAP_DECOR = -7503768;
    static constexpr int COLOR_MAP_BOOKS = -16711702;
    static constexpr int COLOR_MAP_FOOD = -16711702;
    static constexpr int COLOR_KICKING_GREEN = -15244544;
    static constexpr int SPEECH_MONSTER = 0;
    static constexpr int SPEECH_NPC = 1;
    static constexpr int SPEECH_PLAYER = 2;
    static constexpr int SPEECH_ELEVATOR = 3;
    static constexpr int SPEECH_SAL = 4;
    static constexpr int MAX_CORPSE_LOOT = 3;
    static constexpr int MAX_CORPSE_PER_TILE = 3;
    static constexpr int POST_PROCESS_NONE = 0;
    static constexpr int POST_PROCESS_GREEN_INTERLACE = 1;
    static constexpr int POST_PROCESS_RED_INTERLACE = 2;
    static constexpr int POST_PROCESS_MAX = 3;
    static constexpr int GRADE_INCOMPLETE = 0;
    static constexpr int GRADE_A_PLUS = 6;
    static constexpr int GRADE_A = 5;
    static constexpr int GRADE_B = 4;
    static constexpr int GRADE_C = 3;
    static constexpr int GRADE_D = 2;
    static constexpr int GRADE_F = 1;
    static constexpr int GRADE_MAX = 6;
    static constexpr int GRADE_MASK = 7;
    static constexpr int GRADE_SHIFT = 3;
    static constexpr int NO_CURRENT_PRESS = -1;
};

#endif