#ifndef __CANVAS_H__
#define __CANVAS_H__

#include "Graphics.h"
#include "SDL_ttf.h"

class Image;
class Text;
class Entity;
class EntityDef;
class ScriptThread;
class Graphics;

class fmButtonContainer;
class fmScrollButton;
class fmButton;
class fmSwipeArea;

class Canvas
{
private:
    void updateDialogLines(int dialogStyle, int dialogFlags);
    void updatePrologueLines(Text* text);
    void updateLootLines();
    void updateScrolling();
    int numLines;
public:
	static constexpr int KNOCKBACK_HEIGHT = 10;
	static constexpr int FALLDOWNDEATHTIME = 750;
	static constexpr int DEATHFADETIME = 2000;
	static constexpr int TOTALDEATHTIME = 2750;
	static constexpr int FALLDOWNDEATHTIME_FAMILIAR = 750;
	static constexpr int DEATHFADETIME_FAMILIAR = 750;
	static constexpr int TOTALDEATHTIME_FAMILIAR = 1500;
	static constexpr int LOOTING_CROUCH_TIME = 500;
	static constexpr int SPD_RENDER = 0;
	static constexpr int SPD_BSP = 1;
	static constexpr int SPD_HUD = 2;
	static constexpr int SPD_WEAPON = 3;
	static constexpr int SPD_BLIT = 4;
	static constexpr int SPD_FLUSH = 5;
	static constexpr int SPD_PAUSED = 6;
	static constexpr int SPD_LOOP = 7;
	static constexpr int SPD_TOTAL = 8;
	static constexpr int SPD_DEBUG = 9;
	static constexpr int SPD_NUM_FIELDS = 13;
	static constexpr int MAX_EVENTS = 4;
	static constexpr int MAX_STATE_VARS = 9;
	static constexpr int HELPMSG_TYPE_ITEM = 1;
	static constexpr int HELPMSG_TYPE_CODESTRING = 2;
	static constexpr int HELPMSG_TYPE_ACHIEVEMENT = 3;

	static constexpr int FADE_FLAG_NONE = 0;
	static constexpr int FADE_FLAG_FADEOUT = 1;
	static constexpr int FADE_FLAG_FADEIN = 2;

	static constexpr int ST_MENU = 1;
	static constexpr int ST_INTRO_MOVIE = 2;
	static constexpr int ST_PLAYING = 3;
	static constexpr int ST_INTER_CAMERA = 4; // Wolf -> ST_DRIVING
	static constexpr int ST_COMBAT = 5;
	static constexpr int ST_AUTOMAP = 6;
	static constexpr int ST_LOADING = 7;
	static constexpr int ST_DIALOG = 8;
	static constexpr int ST_INTRO = 9;
	static constexpr int ST_BENCHMARK = 10;
	static constexpr int ST_BENCHMARKDONE = 11;
	static constexpr int ST_MINI_GAME = 12;
	static constexpr int ST_DYING = 13;
	static constexpr int ST_EPILOGUE = 14;
	static constexpr int ST_CREDITS = 15;
	static constexpr int ST_SAVING = 16;
	static constexpr int ST_CAMERA = 18;
	static constexpr int ST_ERROR = 17;
	static constexpr int ST_TAF = 19;
	static constexpr int ST_MIXING = 20; // ? change
	static constexpr int ST_TRAVELMAP = 21;
	static constexpr int ST_CHARACTER_SELECTION = 22;
	static constexpr int ST_LOOTING = 23;
	static constexpr int ST_TREADMILL = 24;
	static constexpr int ST_BOT_DYING = 25;
	static constexpr int ST_LOGO = 26;

	static constexpr int CROSS_HAIR_CORDS[] = { 64, 33, 60, 45, 60, 56, 110, 52, 38, 85, 83, 125, 61, 45, 72, 44, 67, 49 };
	static constexpr int UAC_BUILDING_LOCATION_ON_EARTH[] = { 82, 48 };
	static constexpr int moonCoords[] = { 137, 216 };
	static constexpr int earthCoords[] = { 123, 150, 113, 140};
	static constexpr int hellCoords[] = { 150, 11 };
	static constexpr int LOCATOR_BOX_CORDS[] = { 86, -15, 106, 16, 106, 48, 136, 22, 136, 65, 136, 109, 90, 8, 100, 33, 92, 57 };
	static constexpr int moonNameCoords[] = { 124, 255, 165, 64};
	static constexpr int moonPathCoords[] = { 200, 202 };
	static constexpr int earthNameCoords[] = { 126, 160, 40, 226};
	static constexpr int earthPathCoords[] = { 167, 206 };
	static constexpr int hellNameCoords[] = { 184, 23 };
	static constexpr int hellPathCoords[] = { 137, 52 };

	static constexpr int viewStepValues[] = { 64, 0, 64, -64, 0, -64, -64, -64, -64, 0, -64, 64, 0, 64, 64, 64 };

	static constexpr int NPC_DLG_COLOR = 0xFF002864;
	static constexpr int MONSTER_DLG_COLOR = 0xFF800000;
	static constexpr int PLAYER_DLG_COLOR = 0xFF005617; // Old -> 0xFF4F5617
	static constexpr int CHEST_DLG_COLOR = 0xFF005A00;
	static constexpr int CHEST_OFFER_DLG_COLOR = 0xFFB18A01;
	static constexpr int MEDAL_DLG_COLOR = 0xFF000066;
	static constexpr int TERMINAL_DLG_COLOR = 0xFF000000;
	static constexpr int ELEVATOR_DLG_COLOR = 0xFF2E0854;
	static constexpr int CONFIRMATION_DLG_COLOR = 0xFFB18A01;
	static constexpr int VIOS_DLG_COLOR = 0xFF800000;
	static constexpr int SAL_DLG_COLOR = 0xFFFF9600;

	static constexpr int REPAINT_CLEAR = 1;
	static constexpr int REPAINT_SOFTKEYS = 2;
	static constexpr int REPAINT_MENU = 4;
	static constexpr int REPAINT_STARTUP_LOGO = 8;
	static constexpr int REPAINT_HUD = 16;
	static constexpr int REPAINT_PARTICLES = 32;
	static constexpr int REPAINT_VIEW3D = 64;
	static constexpr int REPAINT_LOADING_BAR = 128;

	static bool isLoaded;

	int8_t* OSC_CYCLE;
	int sysSoundDelayTime;
	int sysSoundTime;
	int8_t* keys_numeric;
	int lastBacklightRefresh;
	int blockInputTime;
	bool changeMapStarted;
	int storyX;
	int storyY;
	int storyPage;
	int storyTotalPages;
	int storyIndexes[4];
	int fontRenderMode;
    TTF_Font *ttfFont;
    Image* imgFont_16p_Light;
	Image* imgFont_16p_Dark;
	Image* imgFont_18p_Light;
	Image* imgWarFont;
	Image* imgFont;
	Image* imgUIImages;
	Image* imgMapCursor;
	Image* imgLoadingFire;
	Image* imgIcons_Buffs;
	Image* imgFabricBG;
	Image* imgDialogScroll;
	Image* imgEndOfLevelStatsBG;
	Image* imgGameHelpBG;
	Image* imgInventoryBG;
	Image* imgBootL;
	Image* imgBootR;
	Image* imgStartupLogo;
	Image* imgProlog;
	Image* imgMagGlass;
	Image* imgTravelBG;
	Image* imgTravelPath;
	Image* imgNameHighlight;
	Image* imgSpaceShip;
	Image* imgTierCloseUp;
	Image* imgEarthCloseUp;
	Image* imgStarField;
	Image* imgMapHorzGridLines;
	Image* imgMapVertGridLines;
	Image* imgScientistMugs;
	Image* imgCharacter_upperbar;
	Image* imgMajorMugs;
	Image* imgSargeMugs;
	Image* imgCharacterSelectionAssets;
	Image* imgCharSelectionBG;
	Image* imgCharacter_select_stat_bar;
	Image* imgCharacter_select_stat_header;
	Image* imgTopBarFill;
	Image* imgMajor_legs;
	Image* imgMajor_torso;
	Image* imgRiley_legs;
	Image* imgRiley_torso;
	Image* imgSarge_legs;
	Image* imgSarge_torso;
	bool m_controlButtonIsTouched;
	fmButton* m_controlButton;
	int m_controlButtonTime;
	bool abortMove;
	int SCR_CX;
	int SCR_CY;
	int saveX;
	int saveY;
	int saveZ;
	int saveAngle;
	int savePitch;
	short saveCeilingHeight;
	int viewX;
	int viewY;
	int viewZ;
	int viewAngle;
	int viewPitch;
	int viewRoll;
	int destX;
	int destY;
	int destZ;
	int destAngle;
	int destPitch;
	int destRoll;
	int zStep;
	int pitchStep;
	int prevX;
	int prevY;
	int viewSin;
	int viewCos;
	int viewStepX;
	int viewStepY;
	int viewRightStepX;
	int viewRightStepY;
	int knockbackX;
	int knockbackY;
	int knockbackDist;
	int knockbackStart;
	int knockbackWorldDist;
	int animFrames;
	int animPos;
	int animAngle;
	bool automapDrawn;
	int automapTime;
	int specialLootIcon;
	bool showSpeeds;
	bool showLocation;
	bool showFreeHeap;
	bool tellAFriend;
	bool showMoreGames;
	bool combatDone;
	int scrollWithBarMaxChars;
	int scrollMaxChars;
	int dialogMaxChars;
	int dialogWithBarMaxChars;
	int menuHelpMaxChars;
	int subtitleMaxChars;
	int menuScrollWithBarMaxChars;
	int ingameScrollWithBarMaxChars;
	int state;
	int oldState;
	bool stateChanged;
	int loadMapID;
	short loadMapStringID;
	int lastMapID;
	int startupMap;
	int loadType;
	int saveType;
	bool renderOnly;
	bool skipIntro;
	bool vibrateEnabled;
	int vibrateTime;
	bool recentBriefSave;
	int shakeTime;
	int shakeIntensity;
	int shakeX;
	int shakeY;
	short dialogIndexes[1024];
	Text* dialogBuffer;
	EntityDef* dialogItem;
	int dialogViewLines;
	int dialogLineStartTime;
	int dialogStartTime;
	int dialogTypeLineIdx;
	int dialogStyle;
	int dialogType;
	int dialogFlags;
	bool dialogResumeScriptAfterClosed;
	bool dialogResumeMenu;
	bool dialogClosing;
	ScriptThread* dialogThread;
	int numDialogLines;
	int currentDialogLine;
	bool showingLoot;
	ScriptThread* armorRepairThread;
	bool repairingArmor;
	ScriptThread* targetPracticeThread;
	ScriptThread* gotoThread;
	int beforeRender;
	int afterRender;
	int flushTime;
	int loopStart;
	int loopEnd;
	int pauseTime;
	int lastPacifierUpdate;
	int lastRenderTime;
	int lastFrameTime;
	int debugTime;
	int deathTime;
	int familiarDeathTime;
	bool familiarSelfDestructed;
	int scrollingTextStart;
	int scrollingTextEnd;
	int scrollingTextMSLine;
	int scrollingTextLines;
	int scrollingTextSpacing;
	bool scrollingTextDone;
	int scrollingTextFontHeight;
	int scrollingTextSpacingHeight;
	int lootingTime;
	bool crouchingForLoot;
	bool field_0xac5_;
	int st_fields[Canvas::SPD_NUM_FIELDS];
	bool st_enabled;
	int st_count;
	int events[Canvas::MAX_EVENTS];
	int numEvents;
	int stateVars[Canvas::MAX_STATE_VARS];
	int pacifierX;
	int automapBlinkTime;
	bool automapBlinkState;
	bool endingGame;
	bool running;
	bool displaySoftKeys;
	int readyWeaponSound;
	int displayRect[4];
	int screenRect[4];
	int viewRect[4];
	int hudRect[4];
	int menuRect[4];
	int cinRect[4];
	int softKeyY;
	int softKeyLeftID;
	int softKeyRightID;
	int helpMessageTypes[16];
	int helpMessageInts[16];
	void* helpMessageObjs[16];
	char helpMessageThreads[16];
	int numHelpMessages;
	int renderSceneCount;
	int staleTime;
	bool staleView;
	int keyPressedTime;
	int lastKeyPressedTime;
	bool pushedWall;
	int pushedTime;
	int lootSource;
	Text* errorBuffer;
	Graphics graphics;
	float blendSpecialAlpha;
	int repaintFlags;
	char updateChar;
	int totalFrameTime;
	int ignoreFrameInput;
	bool forcePump;
	bool updateFacingEntity;
	bool touched;
	int m_controlMode;
	bool isFlipControls;
	int m_controlGraphic;
	int m_controlLayout;
	int m_controlAlpha;
	Image* imgDpad_default;
	Image* imgDpad_up_press;
	Image* imgDpad_down_press;
	Image* imgDpad_left_press;
	Image* imgDpad_right_press;
	Image* imgArrows[16];
	Image* imgPageUP_Icon;
	Image* imgPageDOWN_Icon;
	Image* imgPageOK_Icon;
	Image* imgSniperScope_Dial;
	Image* imgSniperScope_Knob;
	fmButtonContainer* m_controlButtons[6];
	fmButtonContainer* m_sniperScopeButtons;
	fmScrollButton* m_sniperScopeDialScrollButton;
	fmButtonContainer* m_dialogButtons;
	fmButtonContainer* m_characterButtons;
	fmButtonContainer* m_softKeyButtons;
	fmButtonContainer* m_mixingButtons;
	fmButtonContainer* m_storyButtons;
	fmButtonContainer* m_treadmillButtons;
	fmSwipeArea* m_swipeArea[2];

	int headShotTime;
	int bodyShotTime;
	int legShotTime;
	bool keyDown;
	bool keyDownCausedMove;
	bool mediaLoading;
	bool areSoundsAllowed;
	bool inInitMap;
	int pacLogoTime;
	int dialogRect[4];
	bool selfDestructScreenShakeStarted;
	int CAMERAVIEW_BAR_HEIGHT;
	int loadingFlags;
	short loadingStringID;
	short loadingStringType;
	bool isZoomedIn;
	int zoomFOV;
	int zoomDestFOV;
	int zoomMinFOVPercent;
	int zoomCurFOVPercent;
	int zoomTime;
	int zoomAngle;
	int zoomPitch;
	int zoomStateTime;
	int zoomAccuracy;
	int zoomMaxAngle;
	int zoomCollisionX;
	int zoomCollisionY;
	int zoomCollisionZ;
	int zoomTurn;
	Image* imgFlak;
	Image* imgFire;
	int32_t* movieEffects;
	int* fadeRect;
	int fadeFlags;
	int fadeTime;
	int fadeDuration;
	int fadeColor;
	short lootPoolIndices[18];
	int lootPool[9];
	int lootPoolCredits;
	int numPoolItems;
	int numLootItems;
	Text* lootText;
	int lootLineNum;
	int lootingCachedPitch;
	int treadmillNumSteps;
	int treadmillLastStep;
	int treadmillReturnCode;
	int treadmillLastStepTime;
	short TM_LastLevelId;
	short TM_LoadLevelId;
	bool TM_NewGame;
	int totalTMTimeInPastAnimations;
	int targetX;
	int targetY;
	int xDiff;
	int yDiff;
	int mapWidth;
	int mapHeight;
	int _field_0xf20;
	int _field_0xf24;
	int _field_0xf28;
	int _field_0xf2c;
	int miniGameHelpScrollPosition;
	int helpTextNumberOfLines;

	// Constructor
	Canvas();
	// Destructor
	~Canvas();

	bool startup();
	void flushGraphics();
	void backPaint(Graphics* graphics);
	void run();
	void clearEvents(int ignoreFrameInput);
	void loadRuntimeData();
	void freeRuntimeData();
	void startShake(int i, int i2, int i3);
	void setState(int state);
	void setAnimFrames(int animFrames);
	void checkFacingEntity();
	void finishMovement();
	int flagForWeapon(int i);
	int flagForFacingDir(int i);
	void startRotation(bool b);
	void finishRotation(bool b);
	int getKeyAction(int state);
	bool attemptMove(int n, int n2);
	void loadState(int loadType, short n, short n2);
	void saveState(int saveType, short n, short n2);
	void loadMap(int loadMapID, bool b, bool tm_NewGame);
	void loadPrologueText();
	void loadEpilogueText();
	void setupCharacterSelection();
	void disposeIntro();
	void disposeEpilogue();
	void drawScroll(Graphics* graphics, int n, int n2, int n3, int n4);
	void initScrollingText(short i, short i2, bool dehyphenate, int spacingHeight, int numLines, int textMSLine);
	void drawCredits(Graphics* graphics);
	void drawScrollingText(Graphics* graphics);
	void handleDialogEvents(int key);
	bool handlePlayingEvents(int key, int action);
	bool handleCinematicInput(int action);
	bool shouldFakeCombat(int n, int n2, int n3);
	bool endOfHandlePlayingEvent(int action, bool b);
	bool handleEvent(int state);
	void runInputEvents();
	bool loadMedia();
	void combatState();
	void dialogState(Graphics* graphics);
	void automapState();
	void renderOnlyState();
	void playingState();
	void menuState();
	void dyingState();
	void familiarDyingState();
	void logoState();
	void drawScrollBar(Graphics* graphics, int i, int i2, int i3, int i4, int i5, int i6, int i7);
	void uncoverAutomap();
	void drawAutomap(Graphics* graphics, bool b);
	void closeDialog(bool skipDialog);
	void prepareDialog(Text* text, int dialogStyle, int dialogFlags);
	void startDialog(ScriptThread* scriptThread, short n, int n2, int n3);
	void startDialog(ScriptThread* scriptThread, short n, short n2, int n3, int n4, bool b);
	void startDialog(ScriptThread* scriptThread, Text* text, int n, int n2);
	void startDialog(ScriptThread* dialogThread, Text* text, int n, int n2, bool dialogResumeScriptAfterClosed);
	void renderScene(int viewX, int viewY, int viewZ, int viewAngle, int viewPitch, int viewRoll, int viewFov);
	void startSpeedTest(bool b);
	void backToMain(bool b);
	void drawPlayingSoftKeys();
	void changeStoryPage(int i);
	void drawStory(Graphics* graphics);
	int getCharacterConstantByOrder(int i);
	void drawCharacterSelection(Graphics* graphics);
	void drawCharacterSelectionAvatar(int i, int x, int y, Graphics* graphics);
	void drawCharacterSelectionStats(int i, Text* text, int x, int y, Graphics* graphics);
	void dequeueHelpDialog();
	void dequeueHelpDialog(bool b);
	void enqueueHelpDialog(short n);
	bool enqueueHelpDialog(short n, short n2, uint8_t b);
	bool enqueueHelpDialog(Text* text);
	bool enqueueHelpDialog(Text* text, int n);
	void enqueueHelpDialog(EntityDef* entityDef);
	void updateView();
	void clearSoftKeys();
	void clearLeftSoftKey();
	void clearRightSoftKey();
	void setLeftSoftKey(short i, short i2);
	void setRightSoftKey(short i, short i2);
	void setSoftKeys(short n, short n2, short n3, short n4);
	void checkHudEvents();
	void drawSoftKeys(Graphics* graphics);
	void setLoadingBarText(short loadingStringID, short loadingStringType);
	void updateLoadingBar(bool b);
	void drawLoadingBar(Graphics* graphics);
	void unloadMedia();
	void invalidateRect();
	int getRecentLoadType();
	void initZoom();
	void zoomOut();
	bool handleZoomEvents(int key, int action);
	bool handleZoomEvents(int key, int action, bool b);
	void handleCharacterSelectionInput(int key, int action);
	void handleStoryInput(int key, int action);
	void lootingState();
	void handleLootingEvents(int action);
	void drawLootingMenu(Graphics* graphics);
	void poolLoot(int* array);
	void giveLootPool();
	bool handleTreadmillEvents(int action);
	void treadmillState();
	bool treadmillFall();
	void drawTreadmillReadout(Graphics* graphics);
	void drawTargetPracticeScore(Graphics* graphics);
	void drawTravelMap(Graphics* graphics);
	bool newLevelSamePlanet();
	void drawAppropriateCloseup(Graphics* graphics, int n, bool b);
	bool drawDottedLine(Graphics* graphics, int n);
	bool drawDottedLine(Graphics* graphics);
	bool drawMarsToMoonLinePlusSpaceShip(Graphics* graphics, int n);
	int yCoordOfSpaceShip(int n);
	bool drawMoonToEarthLine(Graphics* graphics, int n, bool b);
	bool drawEarthToHellLine(Graphics* graphics, int n, bool b);
	void drawLocatorBoxAndName(Graphics* graphics, bool b, int n, Text* text);
	void drawGridLines(Graphics* graphics, int i);
	bool onMoon(int n);
	bool onEarth(int n);
	bool inHell(int n);
	void handleTravelMapInput(int key, int action);
	void finishTravelMapAndLoadLevel();
	bool drawLocatorLines(Graphics* graphics, int n, bool b, bool b2);
	void initTravelMap();
	void disposeTravelMap();
	void drawStarFieldPage(Graphics* graphics);
	void drawStarField(Graphics* graphics, int x, int y);
	void runStarFieldFrame();
	

	void loadMiniGameImages();
	void playIntroMovie(Graphics* graphics);
	void exitIntroMovie(bool b);

	void setMenuDimentions(int x, int y, int w, int h);
	void setBlendSpecialAlpha(float alpha);
	void touchStart(int pressX, int pressY);
	void touchMove(int pressX, int pressY);
	void touchEnd(int pressX, int pressY);
	void touchEndUnhighlight();

	
	void initMiniGameHelpScreen();
	void drawMiniGameHelpScreen(Graphics* graphics, int i, int i2, Image* image);
	void drawMiniGameHelpText(Graphics* graphics, int i, int i2);
	void handleMiniGameHelpScreenScroll(int i);

	
	
	void disposeCharacterSelection();

	bool pitchIsControlled(int n, int n2, int n3);
	int touchToKey_Play(int pressX, int pressY);
	bool startArmorRepair(ScriptThread* armorRepairThread);
	void endArmorRepair();
	
	void drawTouchSoftkeyBar(Graphics* graphics, bool highlighted_Left, bool highlighted_Right);
	void touchSwipe(int swDir);

	
	void turnEntityIntoWaterSpout(Entity* entity);
	void flipControls();
	void setControlLayout();
	void evaluateMiniGameResults(int n);
	void addEvents(int event); // [GEC]
};

#endif