# Unofficial ports of Doom 1,2 and Wolfenstein RPG for Android
This is an Android ports of Doom 1,2 and Wolfenstein RPG projects found here:

https://github.com/Erick194/DoomRPG-RE

https://github.com/Erick194/DoomIIRPG-RE

https://github.com/Erick194/WolfensteinRPG-RE

# System Requirements

This port for Android has the following system requirements:
### Minimum
* Operating system: Android 7.0 or later
* Graphics: videocard, which supports GLES 3.2 render
* Memory: 1GB system RAM

### Recommended
* Operating system: Android 12 or later (I tested it mostly on my phone with Android 12)

## Controllers Support
This Android ports support controllers

## Doom RPG Default Controllers controls

| Action           | Button      	|
| ---------------  | ------------- 	|
| Move Forward     | D-pad up    	|
| Move Backward    | D-pad down  	|
| Turn Left        | D-pad left  	|
| Turn Right       | D-pad right 	|
| Attack/Talk/Use  | A           	|
| Next Weapon      | Right trigger  |
| Prev Weapon      | Left trigger   |
| Pass Turn        | X           	|
| Automap          | Select      	|
| Menu Open/Back   | Start       	|

## Doom 2 RPG Default Controllers controls

| Action           | Button         |
| ---------------  | -------------  |
| Move Forward     | D-pad up       |
| Move Backward    | D-pad down     |
| Turn Left        | D-pad left     |
| Turn Right       | D-pad right    |
| Attack/Talk/Use  | A              |
| Next Weapon      | Right trigger  |
| Prev Weapon      | Left trigger   |
| Pass Turn        | X              |
| Automap          | Select         |
| Menu Open/Back   | Start          |
| Menu Open/Back   | Start          |
| Items Info       | Left shoulder  |
| Drinks           | Right shoulder |
| Pda              | B				|
| Bot Dis          | Y				|

## Wolfenstein RPG Default Controllers controls

| Action           | Button         |
| ---------------  | -------------  |
| Move Forward     | D-pad up       |
| Move Backward    | D-pad down     |
| Turn Left        | D-pad left     |
| Turn Right       | D-pad right    |
| Attack/Talk/Use  | A              |
| Next Weapon      | Right trigger  |
| Prev Weapon      | Left trigger   |
| Pass Turn        | X              |
| Automap          | Select         |
| Menu Open/Back   | Start          |
| Menu Open/Back   | Start          |
| Items Info       | Left shoulder  |
| Syringes         | Right shoulder |
| Journal          | Y   			|

## Keyboard and Mouse Support
This Android ports support keyboard and mouse

## Building

To build the APK file, clone this repository, open the `doom-wolf-rpg-android-port ` directory in Android Studio and run the project.

## Download

To download a working APK file, either do it from F-Droid [here](https://f-droid.org/packages/com.mobilerpgpack.phone/), or in the [Releases Section](https://github.com/sandstranger/doom-wolf-rpg-android-port/releases/latest).

# How to run this engines
1. For running Wolfenstein rpg get wolfenstein rpg ipa file.

   Copy this ipa file to your device.

   Run this android port and specify path to this file in launcher

2. For running Doom1 rpg get doom1 rpg brew file

   get BarToZip exe from this PC release build https://github.com/Erick194/DoomRPG-RE/releases/tag/v.0.2.2 

   and follow this instructions https://www.doomworld.com/forum/topic/129997-doom-rpg-port-reverse-engineering-update-version-022-source-code-release/

   to get DoomRPG.zip file. Copy DoomRPG.zip to your device.

   Run this android port and specify path to this file in launcher.

4.  For running Doom2 rpg get Doom2 rpg ipa.

   Copy this ipa file to your device.
   
   Run this android port and specify path to this file in launcher

## Credits
This port using

NG-GL4ES android openmw fork: https://github.com/Sisah2/NG-GL4ES

openal: https://github.com/kcat/openal-soft

SDL2: https://github.com/libsdl-org/SDL/tree/SDL2

SDL2_mixer: https://github.com/libsdl-org/SDL_mixer

SDL2_TTF: https://github.com/libsdl-org/SDL_ttf

fluidsynth: https://github.com/FluidSynth/fluidsynth

CTranslate2: https://github.com/OpenNMT/CTranslate2

sentencepiece: https://github.com/google/sentencepiece
