# NoorUlHuda [![Download](https://img.shields.io/github/v/release/mirfatif/NoorUlHuda?label="Download")](https://github.com/mirfatif/NoorUlHuda/releases/latest)
A simple, open source Quran reader app with extras, completely free forever

<a href="https://f-droid.org/packages/com.mirfatif.noorulhuda"><img alt="Get it on F-Droid" src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" height="100"></a>
<a href="https://play.google.com/store/apps/details?id=com.mirfatif.noorulhuda"><img alt="Get it on Google Play" src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png" height="100"></a>
<a href="https://apt.izzysoft.de/fdroid/index/apk/com.mirfatif.noorulhuda"><img alt="Get it on F-Droid" src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png" height="100"></a>

## Features
Customize your reading experience the way you want:

* Choose from different Arabic <b>fonts</b>, adjust font contrast and <b>size</b>
* Set comfortable <b>background tone</b> and screen brightness
* Choose from <b>Page Mode</b> or continuous reading
* <b>Dark theme</b> and multiple theme colors supported

Make Quran reading more profitable:

* <b>Translations</b> in different languages.
* Quickly take notes by creating <b>Tags</b> with Title and Description.
* Conveniently tag Āyahs by long pressing.
* <b>Search</b> in Quranic text or translations.
* <b>Share</b> or copy Āyahs (with translation) by long pressing.

Easy navigation:

* <b>Bookmark</b> Āyahs by long pressing.
* Go to desired page, Surah, Juz or Manzil.

More:

* Quranic and Masnoon Supplications (<b>Duas</b>), general and for special occasions.
* <b>Prayer Time</b> notifications and Adhan, and <b>Qibla</b> direction for set location.
* <b>Backup and Restore</b> preferences, Tags and Bookmarks.

## Required Permissions

* **INTERNET** permission is required to check for updates, download Quranic texts and translations, fonts and Adhan audio file, and for (reverse) geocoding.

  If you do not use any of these features, NUH makes no connection to internet, ever. Once a required resource is downloaded (with your approval), the app functions completely offline. The domains NUH may connect to include https://github.com, https://api.github.com and https://www.geonames.org.
* **FOREGROUND_SERVICE** permission is required to show persistent widget notification and play Adhan.
* **WAKE_LOCK** is required to play Adhan alarm.
* **RECEIVE_BOOT_COMPLETED** is required to reset alarms (for Prayer notifications and Adhan) when device is restarted.

## Privacy Policy

https://mirfatif.github.io/NoorUlHuda/privacy_policy.html

## Screenshots

<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/1.jpg" width="250"> <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/2.jpg" width="250"> <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/3.jpg" width="250">
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/4.jpg" width="250"> <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/5.jpg" width="250"> <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/6.jpg" width="250">
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/7.jpg" width="250">

## Translations [![Crowdin](https://badges.crowdin.net/nuh/localized.svg)](https://crowdin.com/project/nuh)
[Crowdin](https://crowdin.com/project/nuh)

## Third-Party Resources

**Libraries:**

* https://github.com/androidx/androidx
* https://github.com/material-components/material-components-android
* https://github.com/batoulapps/adhan-java
* https://github.com/MenoData/Time4A
* https://github.com/saket/Better-Link-Movement-Method
* https://github.com/square/leakcanary
* https://github.com/sherter/google-java-format-gradle-plugin

**Quranic Texts and Translations:**

Noor Ul Huda uses Quranic texts and translations provided by <a href="https://tanzil.net/download">Tanzil Project</a>. To know about the accuracy of the Quranic text and keep track of any changes, and for help on text types, pause marks and other topics, please visit https://tanzil.net/docs/.

**Fonts:**

Noor Ul Huda uses Arabic fonts created by:
      
* <a href="https://fonts.qurancomplex.gov.sa">King Fahd Quran Complex</a>
* <a href="https://pakdata.com/products/arabicfont">Pakistan Data Management Services</a>
* <a href="https://software.sil.org/arabicfonts">SIL International</a>
* <a href="https://www.noorehidayat.org">Noor-e-Hidayat</a>
* <a href="https://github.com/icikiwir/me_quran">Meor Ridzuan</a>
* <a href="https://github.com/quranacademy/kitab-font">Quran Academy</a>

## License [![License](https://img.shields.io/github/license/mirfatif/NoorUlHuda?label="License")](https://github.com/mirfatif/NoorUlHuda/blob/master/LICENSE)

You **CANNOT** use and distribute the app icon in anyway, except for **Noor Ul Huda** (`com.mirfatif.noorulhuda`) app.

    Noor Ul Huda is free software: you can redistribute it and/or modify
    it under the terms of the Affero GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    Affero GNU General Public License for more details.

    You should have received a copy of the Affero GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

## Contact Us

**Telegram:** [https://t.me/NoorUlHudaApp](https://t.me/NoorUlHudaApp)  
**Email:** [mirfatif@gmail.com](mailto:mirfatif@gmail.com)
