import com.github.jk1.license.filter.LicenseBundleNormalizer
import java.io.ByteArrayInputStream
import java.util.Properties

plugins {
    id("com.android.application")
    id("org.jetbrains.kotlin.android")
    id("com.google.devtools.ksp")
    id("org.jetbrains.kotlin.plugin.parcelize")
    id("com.google.dagger.hilt.android")
    id("androidx.navigation.safeargs.kotlin")

    id("com.github.jk1.dependency-license-report")
    id("io.gitlab.arturbosch.detekt")
}

android {
    compileSdk = Versions.COMPILE_SDK

    buildFeatures {
        buildConfig = true
        viewBinding = true
    }

    compileOptions {
        isCoreLibraryDesugaringEnabled = true
    }

    defaultConfig {
        minSdk = Versions.MIN_SDK
        targetSdk = Versions.TARGET_SDK

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
        testInstrumentationRunnerArguments["clearPackageData"] = "true"
    }

    lint {
        warningsAsErrors = true
        checkDependencies = true
    }

    buildTypes {
        debug {
            versionNameSuffix = "-debug"
        }
        release {
            ndk {
                debugSymbolLevel = "SYMBOL_TABLE"
            }
            isMinifyEnabled = true
            isShrinkResources = true
            proguardFiles(getDefaultProguardFile("proguard-android-optimize.txt"), "proguard-rules.pro")

        }

        flavorDimensions += "variant"
        productFlavors {
            create("foss") {
                dimension = "variant"
            }
            create("play") {
                dimension = "variant"
            }
        }
    }

    testOptions {
        unitTests {
            isIncludeAndroidResources = true
        }
        execution = "ANDROIDX_TEST_ORCHESTRATOR"
    }
}

kotlin {
    jvmToolchain(Versions.JAVA)
    compilerOptions {
        allWarningsAsErrors = true
        freeCompilerArgs.add("-Xannotation-default-target=param-property")
    }
}

ksp {
    arg("room.schemaLocation", "$projectDir/schemas")
}

licenseReport {
    outputDir = "$rootDir/docs/licenses"
    configurations = arrayOf("playReleaseRuntimeClasspath")
    filters = arrayOf(LicenseBundleNormalizer())
}

dependencies {
    coreLibraryDesugaring(libs.libDesugarJdkLibs)
    debugImplementation(libs.libLeakCanary)

    implementation(platform(libs.libKotlinBom))
    implementation(libs.libRoomKtx)
    implementation(libs.libHiltAndroid)

    ksp(libs.libRoomCompiler)
    ksp(libs.libHiltCompiler)
}
