package com.mhss.app.presentation

import androidx.compose.foundation.layout.*
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.OutlinedTextField
import androidx.compose.material3.Text
import androidx.compose.runtime.*
import androidx.compose.runtime.saveable.rememberSaveable
import androidx.compose.ui.Modifier
import androidx.compose.ui.focus.FocusRequester
import androidx.compose.ui.focus.focusRequester
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import androidx.navigation.NavHostController
import com.mhss.app.ui.R
import com.mhss.app.ui.navigation.Screen
import org.koin.androidx.compose.koinViewModel

@Composable
fun DiarySearchScreen(
    navController: NavHostController,
    viewModel: DiaryViewModel = koinViewModel()
) {
    val state = viewModel.uiState
    Column(
        modifier = Modifier
            .fillMaxSize()
            .padding(WindowInsets.statusBars.asPaddingValues()),
        ) {
        var query by rememberSaveable {
            mutableStateOf("")
        }
        LaunchedEffect(query) { viewModel.onEvent(DiaryEvent.SearchEntries(query)) }
        val focusRequester = remember { FocusRequester() }
        LaunchedEffect(true) { focusRequester.requestFocus() }
        OutlinedTextField(
            value = query,
            onValueChange = { query = it },
            label = { Text(stringResource(R.string.search_diary)) },
            shape = RoundedCornerShape(15.dp),
            modifier = Modifier
                .fillMaxWidth()
                .padding(16.dp)
                .focusRequester(focusRequester)
        )
        LazyColumn(
            verticalArrangement = Arrangement.spacedBy(8.dp),
            contentPadding = PaddingValues(12.dp)
        ) {
            items(state.searchEntries, key = { it.id }) { entry ->
                DiaryEntryItem(
                    entry = entry,
                    onClick = {
                        navController.navigate(
                            Screen.DiaryDetailScreen(
                                entry.id
                            )
                        )
                    }
                )
            }
        }
    }
}