<p align="center">
  <img alt="Stars" src="https://img.shields.io/github/stars/mhss1/mybrain?style=social" />
  <a href="https://www.gnu.org/licenses/gpl-3.0"><img alt="License: GPL v3" src="https://img.shields.io/badge/License-GPLv3-blue.svg" /></a>
  <a href="https://crowdin.com/project/my-brain-app"><img alt="Crowdin" src="https://badges.crowdin.net/my-brain-app/localized.svg" /></a>
</p>


<h1 align="center">
  <a href="https://github.com/mhss1/MyBrain">
    <img alt="My Brain" src="https://github.com/user-attachments/assets/3a33b973-0686-4ac5-b987-41bfb081ba81" width="180" />
  </a>
  <br>
  My Brain
</h1>
  
<h3 align="center">All-in-one productivity app and AI assistant with Tasks, Notes, Calendar, Diary and Bookmarks.</h3>

![MyBrain banner](https://github.com/user-attachments/assets/4dabc54e-5925-4fd5-a940-fef4b2741787)

[screenshots made by previewed](https://previewed.app/template/00CBF3F6)

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
    alt="Get it on F-Droid"
    height="80">](https://f-droid.org/packages/com.mhss.app.mybrain)
[<img src="https://github.com/mhss1/MyBrain/assets/58703865/94cbf557-b1a9-4339-b6b4-def21dde3c11"
     alt="Get it on GitHub"
     height="80">](https://github.com/mhss1/MyBrain/releases/latest)
      
## Features
- Local and Private with no data collection at all.
- Create tasks with priority, sub-tasks, due date and reminders.
- Create Notes that supports markdown which enables you to use Headers, lists, links etc..
- Record your mood daily and view your mood summary with beautiful graphs.
- Save bookmarks for later by using the share menu from any other app.
- View your calendar events in a modern list and monthly views with a beautiful home screen widget.
- Dashboard screen to see your tasks, calendar events, and more to see your day at a glance.
- AI assistant and Agent to help you with your daily workflow. You can chat and attach objects and also ask the AI to create and find items for you.

## Technologies
- 100% Kotlin.
- Multi-module project.
- Made Using Jetpack Compose.
- Widgets made with Jetpack Glance.
- Following Clean Architecture approach. 
- MVI Design Pattern.
- Room DB
- Koin
- Ktor
- Preferences DataStore
- Kotlin coroutines
- Kotlin Flows
- Alarm Manager
- Content Provider
- Biometric Authentication
- Koog

## Translation
Project localisation is managed via [Crowdin](https://crowdin.com/project/my-brain-app)
[![Crowdin](https://badges.crowdin.net/my-brain-app/localized.svg)](https://crowdin.com/project/my-brain-app)

## Contributing
To get started, take a look at [CONTRIBUTING.md](CONTRIBUTING.md).

---
Icons Attribution:
<a href="https://www.flaticon.com/free-icons/document" title="document icons">Document icons created by Freepik - Flaticon</a>
<a href="https://www.flaticon.com/free-icons/list" title="list icons">List icons created by Freepik - Flaticon</a>
<a href="https://www.flaticon.com/free-icons/3d-calendar" title="3d calendar icons">3d calendar icons created by Freepik - Flaticon</a>
<a href="https://www.flaticon.com/free-icons/bookmark" title="bookmark icons">Bookmark icons created by Freepik - Flaticon</a>
<a href="https://www.flaticon.com/free-icons/book" title="book icons">Book icons created by Freepik - Flaticon</a>
<a href="https://www.flaticon.com/free-icons/chatbot" title="chatbot icons">Chatbot icons created by HideMaru - Flaticon</a>
