/*
 * Copyright 2025 Blocker
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.merxury.blocker.core.testing.controller

import android.content.pm.PackageManager
import com.merxury.blocker.core.controllers.IController
import com.merxury.blocker.core.exception.RootUnavailableException
import com.merxury.blocker.core.model.data.ComponentInfo

class FakeController(private val rootGranted: Boolean = false) : IController {
    override suspend fun switchComponent(
        component: ComponentInfo,
        state: Int,
    ): Boolean {
        if (rootGranted) {
            return true
        } else {
            throw RootUnavailableException()
        }
    }

    override suspend fun enable(component: ComponentInfo): Boolean = switchComponent(component, PackageManager.COMPONENT_ENABLED_STATE_ENABLED)

    override suspend fun disable(component: ComponentInfo): Boolean = switchComponent(component, PackageManager.COMPONENT_ENABLED_STATE_DISABLED)

    override suspend fun batchEnable(
        componentList: List<ComponentInfo>,
        action: suspend (info: ComponentInfo) -> Unit,
    ): Int {
        if (rootGranted) {
            return componentList.size
        } else {
            throw RootUnavailableException()
        }
    }

    override suspend fun batchDisable(
        componentList: List<ComponentInfo>,
        action: suspend (info: ComponentInfo) -> Unit,
    ): Int {
        if (rootGranted) {
            return componentList.size
        } else {
            throw RootUnavailableException()
        }
    }

    override suspend fun checkComponentEnableState(
        packageName: String,
        componentName: String,
    ): Boolean = true
}
