/*
 * Copyright 2025 Blocker
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.merxury.blocker.core.designsystem.theme

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.compositeOver
import androidx.compose.ui.graphics.luminance
import kotlin.math.max
import kotlin.math.min

/**
 * Blocker colors.
 */

internal val md_theme_light_primary = Color(0xFF006D3B)
internal val md_theme_light_onPrimary = Color(0xFFFFFFFF)
internal val md_theme_light_primaryContainer = Color(0xFF66FEA2)
internal val md_theme_light_onPrimaryContainer = Color(0xFF00210E)
internal val md_theme_light_secondary = Color(0xFF4F6353)
internal val md_theme_light_onSecondary = Color(0xFFFFFFFF)
internal val md_theme_light_secondaryContainer = Color(0xFFD2E8D4)
internal val md_theme_light_onSecondaryContainer = Color(0xFF0D1F13)
internal val md_theme_light_tertiary = Color(0xFF3A646F)
internal val md_theme_light_onTertiary = Color(0xFFFFFFFF)
internal val md_theme_light_tertiaryContainer = Color(0xFFBEEAF6)
internal val md_theme_light_onTertiaryContainer = Color(0xFF001F26)
internal val md_theme_light_error = Color(0xFFBA1A1A)
internal val md_theme_light_errorContainer = Color(0xFFFFDAD6)
internal val md_theme_light_onError = Color(0xFFFFFFFF)
internal val md_theme_light_onErrorContainer = Color(0xFF410002)
internal val md_theme_light_background = Color(0xFFFBFDF8)
internal val md_theme_light_onBackground = Color(0xFF191C19)
internal val md_theme_light_surface = Color(0xFFFBFDF8)
internal val md_theme_light_onSurface = Color(0xFF191C19)
internal val md_theme_light_surfaceVariant = Color(0xFFDDE5DB)
internal val md_theme_light_onSurfaceVariant = Color(0xFF414942)
internal val md_theme_light_outline = Color(0xFF717971)
internal val md_theme_light_inverseOnSurface = Color(0xFFF0F1EC)
internal val md_theme_light_inverseSurface = Color(0xFF2E312E)
internal val md_theme_light_inversePrimary = Color(0xFF43E188)
internal val md_theme_light_surfaceTint = Color(0xFF006D3B)
internal val md_theme_light_outlineVariant = Color(0xFFC1C9BF)
internal val md_theme_light_scrim = Color(0xFF000000)
internal val md_theme_dark_primary = Color(0xFF43E188)
internal val md_theme_dark_onPrimary = Color(0xFF00391C)
internal val md_theme_dark_primaryContainer = Color(0xFF00522B)
internal val md_theme_dark_onPrimaryContainer = Color(0xFF66FEA2)
internal val md_theme_dark_secondary = Color(0xFFB6CCB8)
internal val md_theme_dark_onSecondary = Color(0xFF223527)
internal val md_theme_dark_secondaryContainer = Color(0xFF384B3C)
internal val md_theme_dark_onSecondaryContainer = Color(0xFFD2E8D4)
internal val md_theme_dark_tertiary = Color(0xFFA2CEDA)
internal val md_theme_dark_onTertiary = Color(0xFF023640)
internal val md_theme_dark_tertiaryContainer = Color(0xFF214C57)
internal val md_theme_dark_onTertiaryContainer = Color(0xFFBEEAF6)
internal val md_theme_dark_error = Color(0xFFFFB4AB)
internal val md_theme_dark_errorContainer = Color(0xFF93000A)
internal val md_theme_dark_onError = Color(0xFF690005)
internal val md_theme_dark_onErrorContainer = Color(0xFFFFDAD6)
internal val md_theme_dark_background = Color(0xFF191C19)
internal val md_theme_dark_onBackground = Color(0xFFE1E3DE)
internal val md_theme_dark_surface = Color(0xFF191C19)
internal val md_theme_dark_onSurface = Color(0xFFE1E3DE)
internal val md_theme_dark_surfaceVariant = Color(0xFF414942)
internal val md_theme_dark_onSurfaceVariant = Color(0xFFC1C9BF)
internal val md_theme_dark_outline = Color(0xFF8B938A)
internal val md_theme_dark_inverseOnSurface = Color(0xFF191C19)
internal val md_theme_dark_inverseSurface = Color(0xFFE1E3DE)
internal val md_theme_dark_inversePrimary = Color(0xFF006D3B)
internal val md_theme_dark_surfaceTint = Color(0xFF43E188)
internal val md_theme_dark_outlineVariant = Color(0xFF414942)
internal val md_theme_dark_scrim = Color(0xFF000000)

fun Color.contrastAgainst(background: Color): Float {
    val fg = if (alpha < 1f) compositeOver(background) else this

    val fgLuminance = fg.luminance() + 0.05f
    val bgLuminance = background.luminance() + 0.05f

    return max(fgLuminance, bgLuminance) / min(fgLuminance, bgLuminance)
}
