package com.mcsnowflake.worktimer.ui.views.dashboard

import androidx.compose.ui.text.AnnotatedString
import androidx.compose.ui.text.input.OffsetMapping
import androidx.compose.ui.text.input.TransformedText
import androidx.compose.ui.text.input.VisualTransformation

class SuffixTransformation(private val suffix: String) : VisualTransformation {

    override fun filter(text: AnnotatedString) = TransformedText(
        AnnotatedString(text.text + suffix),
        object : OffsetMapping {
            override fun originalToTransformed(offset: Int) = offset
            override fun transformedToOriginal(offset: Int) =
                if (offset < text.text.length) offset
                else maxOf(text.text.length, offset - suffix.length)
        }
    )
}
