@file:OptIn(ExperimentalTime::class)

package com.mcsnowflake.worktimer.ui.views.dashboard

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.mcsnowflake.worktimer.R
import com.mcsnowflake.worktimer.configuration.ConfigurationStore
import com.mcsnowflake.worktimer.configuration.Preference
import com.mcsnowflake.worktimer.notifications.NotificationAction.MORE
import com.mcsnowflake.worktimer.notifications.NotificationAction.PAUSE
import com.mcsnowflake.worktimer.notifications.NotificationAction.RESUME
import com.mcsnowflake.worktimer.notifications.NotificationAction.WORK
import com.mcsnowflake.worktimer.state.SessionData
import com.mcsnowflake.worktimer.state.SessionData.Type.LONG_BREAK
import com.mcsnowflake.worktimer.state.SessionData.Type.SHORT_BREAK
import com.mcsnowflake.worktimer.state.SessionData.Type.WORK_SESSION
import com.mcsnowflake.worktimer.state.TimerState
import com.mcsnowflake.worktimer.state.TimerState.Session.Finished
import com.mcsnowflake.worktimer.state.TimerState.Session.Running
import kotlin.time.Clock.System.now
import kotlin.time.ExperimentalTime
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.SharingStarted.Companion.Lazily
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.distinctUntilChanged
import kotlinx.coroutines.flow.filterIsInstance
import kotlinx.coroutines.flow.map
import kotlinx.coroutines.flow.stateIn

class DashBoardViewModel(
    val configuration: ConfigurationStore,
    val timerState: StateFlow<TimerState>
) : ViewModel() {

    val sessionState = timerState.filterIsInstance<TimerState.Session>().map { it.session }

    val isRunning = timerState.map { it is TimerState.Session }.stateIn(viewModelScope, Lazily, false)

    val currentSessionData: StateFlow<SessionData> = sessionState.stateIn(
        viewModelScope,
        Lazily,
        SessionData.newSession(now(), now())
    )
    //
    // val headerText: StateFlow<String> = timerState
    //     .map {
    //         when (it) {
    //             is TimerState.Session -> getTitle(getApplication(), it)
    //             is TimerState.Stopped -> getApplication<Application>().getString(R.string.welcome_text)
    //         }
    //     }
    //     .stateIn(viewModelScope, Lazily, "")

    // button labels
    val nextButtonLabel: StateFlow<Int> = timerState.map {
        when (it) {
            is Running -> when (it.session.type) {
                WORK_SESSION -> PAUSE.getActionTitle()
                LONG_BREAK, SHORT_BREAK -> WORK.getActionTitle()
            }

            is Finished -> RESUME.getActionTitle()
            else -> 0
        }
    }.distinctUntilChanged().stateIn(viewModelScope, Lazily, 0)
    val moreButtonLabel: StateFlow<Int> = timerState.map {
        when (it) {
            is Running -> R.string.more_time_button_label
            is Finished -> MORE.getActionTitle()
            else -> 0
        }
    }.distinctUntilChanged().stateIn(viewModelScope, Lazily, 0)
    val showMoreButton: StateFlow<Boolean> = timerState.getMapped {
        when (it) {
            is TimerState.Session -> configuration[Preference.OVERTIME_MODE]
            is TimerState.Stopped -> false
        }
    }
    val showNextButton: StateFlow<Boolean> = nextButtonLabel.getMapped { it != 0 }

    val showStatsIcon: StateFlow<Boolean> = configuration.getAsStateFlow(Preference.STATISTICS_ON, viewModelScope)

    private fun <T> Flow<T>.getMapped(transform: suspend (value: T) -> Boolean) = map(transform).distinctUntilChanged().stateIn(
        viewModelScope,
        Lazily,
        false
    )
}
