package com.mcsnowflake.worktimer.ui.views.about

import androidx.compose.foundation.border
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.layout.wrapContentWidth
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.text.font.FontFamily
import androidx.compose.ui.unit.dp

@Composable
fun Header(
    title: String,
    icon: ImageVector,
    modifier: Modifier
) = Row(
    modifier.fillMaxWidth(),
    horizontalArrangement = Arrangement.spacedBy(16.dp, Alignment.CenterHorizontally),
    verticalAlignment = Alignment.CenterVertically
) {
    Icon(icon, null, Modifier.size(64.dp))
    Text(
        modifier = Modifier
            .border(1.dp, Color.Blue),
        text = title,
        color = MaterialTheme.colorScheme.primary,
        fontFamily = FontFamily.Serif,
        style = MaterialTheme.typography.headlineMedium
    )
}
