package com.mcsnowflake.worktimer.ui.views.about

import androidx.compose.animation.AnimatedContent
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxHeight
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.widthIn
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.rounded.ArrowBack
import androidx.compose.material3.Icon
import androidx.compose.material3.IconButton
import androidx.compose.material3.ProvideTextStyle
import androidx.compose.material3.Scaffold
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalWindowInfo
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.text.font.FontFamily
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import androidx.navigation.NavHostController
import com.mcsnowflake.worktimer.R
import com.mcsnowflake.worktimer.ui.components.appbar.AppBar
import com.mcsnowflake.worktimer.ui.views.about.Page.FEATURES
import com.mcsnowflake.worktimer.ui.views.about.Page.GREETER
import com.mcsnowflake.worktimer.ui.views.about.Page.MANUAL
import com.mcsnowflake.worktimer.ui.views.about.Page.POMODORO
import com.mcsnowflake.worktimer.ui.views.about.content.Features
import com.mcsnowflake.worktimer.ui.views.about.content.Greeter
import com.mcsnowflake.worktimer.ui.views.about.content.Manual
import com.mcsnowflake.worktimer.ui.views.about.content.Pomodoro
import com.mcsnowflake.worktimer.ui.views.dashboard.DASHBOARD

const val SHOW_APP_BAR = "showAppBar"
const val ABOUT_SCREEN = "about/$SHOW_APP_BAR={$SHOW_APP_BAR}"
fun String.showAppBar(show: Boolean) = replace("{$SHOW_APP_BAR}", show.toString())
const val HEADER_WEIGHT = 2f
const val TEXT_WEIGHT = 7f

@Composable
fun AboutScreen(
    navController: NavHostController,
    showAppBar: Boolean = false
) {
    var page by remember { mutableStateOf(GREETER) }
    Scaffold(
        modifier = Modifier,
        topBar = {
            if (showAppBar) {
                AppBar(
                    title = stringResource(id = R.string.about_screen_title),
                    navigation = {
                        IconButton({ navController.popBackStack() }) { Icon(Icons.AutoMirrored.Rounded.ArrowBack, "Back") }
                    }
                )
            }
        },
        bottomBar = {
            BottomButtons(
                page = page,
                onNext = { page = page.next() },
                onClose = { navController.navigate(DASHBOARD) { popUpTo(ABOUT_SCREEN) { inclusive = true } } }
            )
        }
    ) { innerPadding ->

        ProvideTextStyle(
            TextStyle(
                fontFamily = FontFamily.Serif,
                fontWeight = FontWeight.Normal,
                textAlign = TextAlign.Justify,
                fontSize = when {
                    (LocalWindowInfo.current.containerSize.width <= 330) -> 16.sp
                    (LocalWindowInfo.current.containerSize.width <= 390) -> 18.sp
                    else -> 20.sp
                }
            )
        ) {

            AnimatedContent(page) {
                Box(
                    modifier = Modifier.fillMaxSize(),
                    contentAlignment = Alignment.Center
                ) {
                    Column(
                        modifier = Modifier
                            .fillMaxHeight()
                            .widthIn(max = 600.dp)
                            .padding(innerPadding)
                            .padding(horizontal = 16.dp),
                        verticalArrangement = Arrangement.Top,
                        horizontalAlignment = Alignment.CenterHorizontally
                    ) {
                        when (it) {
                            GREETER -> Greeter(HEADER_WEIGHT, TEXT_WEIGHT)
                            POMODORO -> Pomodoro(HEADER_WEIGHT, TEXT_WEIGHT)
                            MANUAL -> Manual(HEADER_WEIGHT, TEXT_WEIGHT)
                            FEATURES -> Features(HEADER_WEIGHT, TEXT_WEIGHT)
                        }
                    }
                }
            }
        }
    }
}

