package com.mcsnowflake.worktimer.ui.components.timer

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.widthIn
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import com.mcsnowflake.worktimer.state.TimerState
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow

@Composable
fun Timer(
    timerState: StateFlow<TimerState> = MutableStateFlow(TimerState.Stopped)
) {
    val state = timerState.collectAsState()

    Column(
        modifier = Modifier
            .height(150.dp)
            .widthIn(max = 400.dp)
            .fillMaxWidth()
            .padding(horizontal = 32.dp),
        verticalArrangement = Arrangement.Center,
        horizontalAlignment = Alignment.CenterHorizontally
    ) {
        UpperBar(timerState = state)
        MiddleBar(timerState = state)
        LowerBar(timerState = state)
    }
}
