package com.mcsnowflake.worktimer.ui.components.screenLock

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.mcsnowflake.worktimer.configuration.ConfigurationStore
import com.mcsnowflake.worktimer.configuration.Preference
import com.mcsnowflake.worktimer.state.TimerState
import kotlinx.coroutines.flow.StateFlow

class KeepScreenOnViewModel(
    configuration: ConfigurationStore,
    val timerState: StateFlow<TimerState>
) : ViewModel() {

    val enabled: StateFlow<Boolean> = configuration.getAsStateFlow(Preference.KEEP_SCREEN_ON, viewModelScope)
}
