package com.mcsnowflake.worktimer.ui.components.screenLock

import android.app.Activity
import android.util.Log
import android.view.Window
import android.view.WindowManager
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.remember
import androidx.compose.ui.platform.LocalContext
import com.mcsnowflake.worktimer.state.TimerState
import kotlinx.coroutines.flow.combine
import kotlinx.coroutines.flow.distinctUntilChanged
import org.koin.androidx.compose.koinViewModel

@Composable
fun KeepScreenOn(
    viewModel: KeepScreenOnViewModel = koinViewModel<KeepScreenOnViewModel>()
) {
    val context = LocalContext.current
    remember(context) { (context as? Activity)?.window }
        ?.run {
            LaunchedEffect(context) {
                viewModel.enabled.combine(viewModel.timerState) { enabled, state ->
                    enabled && state is TimerState.Session
                }
                    .distinctUntilChanged()
                    .collect {
                        if (it) activateScreenOnLock()
                        else deactivateScreenOnLock()
                    }
            }
        }
}

private fun Window.deactivateScreenOnLock() {
    Log.d("ScreenLock", "deactivateScreenOnLock")
    clearFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON)
}

private fun Window.activateScreenOnLock() {
    Log.d("ScreenLock", "activateScreenOnLock")
    addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON)
}
