package com.mcsnowflake.worktimer.ui.components.appbar

import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Text
import androidx.compose.material3.TopAppBar
import androidx.compose.runtime.Composable

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun AppBar(
    title: String,
    navigation: @Composable () -> Unit,
    actionIcons: @Composable () -> Unit = {},
    menu: @Composable () -> Unit = {},
) {
    TopAppBar(
        title = { Text(title) },
        actions = {
            actionIcons()
            menu()
        },
        navigationIcon = navigation,
    )
}
