package com.mcsnowflake.worktimer.configuration

import androidx.datastore.preferences.core.Preferences
import androidx.datastore.preferences.core.booleanPreferencesKey

enum class Preference(
    override val key: Preferences.Key<Boolean>,
    override val default: Boolean
) : Configuration<Boolean> {
    STATISTICS_ON(booleanPreferencesKey("statistics_on"), false),
    OVERTIME_MODE(booleanPreferencesKey("overtime_mode"), false),
    DND_MODE(booleanPreferencesKey("dnd_mode"), false),
    HYDRATION_MODE(booleanPreferencesKey("hydrate_mode"), false),
    AUTO_SWITCH_MODE(booleanPreferencesKey("auto_switch_mode"), false),
    DYNAMIC_COLOR_ON(booleanPreferencesKey("dynamic_color_on"), false),
    KEEP_SCREEN_ON(booleanPreferencesKey("screen_awake_mode"), false),
    NOTIFICATIONS_ON(booleanPreferencesKey("notifications_on"), true)
}
