package com.mcsnowflake.worktimer.ui.views.settings

import androidx.compose.runtime.Composable
import androidx.compose.runtime.State
import androidx.compose.runtime.collectAsState
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.mcsnowflake.worktimer.configuration.Configuration
import com.mcsnowflake.worktimer.configuration.ConfigurationStore
import kotlinx.coroutines.launch

class SettingsViewModel(
    private val configuration: ConfigurationStore
) : ViewModel() {

    @Composable
    operator fun <T> get(preference: Configuration<T>): State<T> = configuration.getAsFlow(preference).collectAsState(preference.default)
    operator fun <T> set(preference: Configuration<T>, value: T) {
        viewModelScope.launch { configuration[preference] = value }
    }
}
